/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Random;

public class GUID
implements Serializable {
    private byte[] bytes;
    private static Random m_randomNumber = null;
    private static InetAddress m_netAddress = null;

    public GUID() {
        ByteArrayOutputStream theBytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(theBytes);
        try {
            if (m_randomNumber == null) {
                m_randomNumber = new Random();
            }
            data.writeInt(m_randomNumber.nextInt());
            Date currentTime = new Date();
            long test = currentTime.getTime();
            data.writeLong(currentTime.getTime());
            try {
                if (m_netAddress == null) {
                    m_netAddress = InetAddress.getLocalHost();
                }
                data.write(m_netAddress.getAddress());
            }
            catch (UnknownHostException ex) {
                data.writeInt(m_randomNumber.nextInt());
            }
            this.bytes = theBytes.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GUID(String str) {
        this.bytes = GUID.StringToGUIDData(str);
    }

    public GUID(byte[] dt) {
        this.bytes = dt;
    }

    public boolean isValid() {
        return this.bytes != null && this.bytes.length == 16;
    }

    public static GUID StringToGUID(String str) {
        return new GUID(str);
    }

    public byte[] bytes() {
        return this.bytes;
    }

    private static byte CharToByte(char theChar) {
        byte theByte = 0;
        switch (theChar) {
            case '0': {
                theByte = 0;
                break;
            }
            case '1': {
                theByte = 1;
                break;
            }
            case '2': {
                theByte = 2;
                break;
            }
            case '3': {
                theByte = 3;
                break;
            }
            case '4': {
                theByte = 4;
                break;
            }
            case '5': {
                theByte = 5;
                break;
            }
            case '6': {
                theByte = 6;
                break;
            }
            case '7': {
                theByte = 7;
                break;
            }
            case '8': {
                theByte = 8;
                break;
            }
            case '9': {
                theByte = 9;
                break;
            }
            case 'A': {
                theByte = 10;
                break;
            }
            case 'B': {
                theByte = 11;
                break;
            }
            case 'C': {
                theByte = 12;
                break;
            }
            case 'D': {
                theByte = 13;
                break;
            }
            case 'E': {
                theByte = 14;
                break;
            }
            case 'F': {
                theByte = 15;
            }
        }
        return theByte;
    }

    private static byte[] StringToGUIDData(String s) {
        int i;
        if (s.length() != 38) {
            return null;
        }
        if (s.charAt(0) != '{' || s.charAt(37) != '}') {
            return null;
        }
        byte[] byteSet = new byte[16];
        int theCount = 0;
        for (i = 1; i < 9; ++i) {
            byteSet[theCount] = (byte)(GUID.CharToByte(s.charAt(i)) * 16 + GUID.CharToByte(s.charAt(++i)));
            ++theCount;
        }
        for (i = 10; i < 14; ++i) {
            byteSet[theCount] = (byte)(GUID.CharToByte(s.charAt(i)) * 16 + GUID.CharToByte(s.charAt(++i)));
            ++theCount;
        }
        for (i = 15; i < 19; ++i) {
            byteSet[theCount] = (byte)(GUID.CharToByte(s.charAt(i)) * 16 + GUID.CharToByte(s.charAt(++i)));
            ++theCount;
        }
        for (i = 20; i < 24; ++i) {
            byteSet[theCount] = (byte)(GUID.CharToByte(s.charAt(i)) * 16 + GUID.CharToByte(s.charAt(++i)));
            ++theCount;
        }
        for (i = 25; i < 37; ++i) {
            byteSet[theCount] = (byte)(GUID.CharToByte(s.charAt(i)) * 16 + GUID.CharToByte(s.charAt(++i)));
            ++theCount;
        }
        return byteSet;
    }

    private String dwordAsHexString(int dword) {
        long lng = dword < 0 ? (long)dword + 0x100000000L : (long)dword;
        String x = Long.toString(lng, 16);
        return new String("00000000").substring(0, 8 - x.length()) + x;
    }

    private String wordAsHexString(int word) {
        long lng = word < 0 ? (long)word + 65536L : (long)word;
        String x = Long.toString(lng, 16);
        return new String("0000").substring(0, 4 - x.length()) + x;
    }

    public static String byteAsHexString(int bt) {
        if (bt == 0) {
            return "00";
        }
        long lng = bt < 0 ? (long)bt + 256L : (long)bt;
        String s = Long.toString(lng, 16).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public static byte[] HexStringAsByte(String str) {
        byte[] byteSet = new byte[str.length() / 2];
        int theCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            byteSet[theCount] = (byte)(GUID.CharToByte(str.charAt(i)) * 16 + GUID.CharToByte(str.charAt(++i)));
            ++theCount;
        }
        return byteSet;
    }

    public boolean equals(GUID g) {
        if (!this.isValid() || !g.isValid()) {
            return false;
        }
        for (int j = 0; j < this.bytes.length; ++j) {
            if (this.bytes[j] == g.bytes()[j]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int i;
        if (this.bytes == null) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer("{");
        for (i = 0; i < 4 && i < this.bytes.length; ++i) {
            sb.append(GUID.byteAsHexString(this.bytes[i]));
        }
        sb.append("-");
        for (i = 4; i < 6 && i < this.bytes.length; ++i) {
            sb.append(GUID.byteAsHexString(this.bytes[i]));
        }
        sb.append("-");
        for (i = 6; i < 8 && i < this.bytes.length; ++i) {
            sb.append(GUID.byteAsHexString(this.bytes[i]));
        }
        sb.append("-");
        for (i = 8; i < 16 && i < this.bytes.length; ++i) {
            sb.append(GUID.byteAsHexString(this.bytes[i]));
            if (i != 9) continue;
            sb.append("-");
        }
        sb.append("}");
        return sb.toString().toUpperCase();
    }

    public String toShortString() {
        if (this.bytes == null) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 2; i < 12 && i < this.bytes.length; ++i) {
            sb.append(GUID.byteAsHexString(this.bytes[i]));
        }
        return sb.toString().toUpperCase();
    }
}

