/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.configManager;

import com.novell.nps.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NPSVersion
implements Serializable {
    private static final int NPS_CURRENT_MAJOR = 4;
    private static final int NPS_CURRENT_MINOR = 2;
    private static final int NPS_CURRENT_REVISION = 1;
    private static final String NPS_CURRENT_INFO = "20031218";
    private static final NPSVersion sm_currentVersion = new NPSVersion(4, 2, 1, "20031218");
    public static final int PORTAL_TYPE_FULL = 1;
    public static final int PORTAL_TYPE_EVAL = 2;
    public static final int PORTAL_TYPE_SP = 3;
    public static final int PORTAL_TYPE_RUNTIME = 4;
    public static final int PORTAL_TYPE_SDK = 5;
    private static final String ZIP_ENTRY_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String KEY_MODULE_VERSION = "Implementation-Version";
    private static final String MAJOR_VERSION_DELIMITERS = ".";
    private static final String MINOR_VERSION_DELIMITERS = ".";
    private static final String REVISION_VERSION_DELIMITERS = "._- ";
    int m_iMajor;
    int m_iMinor;
    int m_iRevision;
    String m_sInfo;

    public static void main(String[] args) {
        NPSVersion npsVersion = NPSVersion.getPortalVersion();
        System.out.print("Version: " + npsVersion.toString());
    }

    public NPSVersion(int iMajor, int iMinor, int iRevision, String sInfo) {
        this.construct(iMajor, iMinor, iRevision, sInfo);
    }

    public NPSVersion(String sVer) {
        this.construct(sVer);
    }

    public NPSVersion(InputStream inputstream) {
        this.construct(inputstream);
    }

    public NPSVersion(ZipFile zipFile) throws IOException {
        this.construct(zipFile);
    }

    public NPSVersion(File file) throws IOException {
        this.construct(file);
    }

    public NPSVersion(ZipFile zipFile, ZipEntry zeResource) throws IOException {
        this.construct(zipFile, zeResource);
    }

    private void construct(int iMajor, int iMinor, int iRevision, String sInfo) {
        this.m_iMajor = iMajor;
        this.m_iMinor = iMinor;
        this.m_iRevision = iRevision;
        this.m_sInfo = sInfo;
    }

    private void construct(String sMajor, String sMinor, String sRevision, String sInfo) {
        int iMajor = 0;
        int iMinor = 0;
        int iRevision = 0;
        try {
            iMajor = Integer.parseInt(sMajor);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            iMinor = Integer.parseInt(sMinor);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            iRevision = Integer.parseInt(sRevision);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.construct(iMajor, iMinor, iRevision, sInfo);
    }

    private void construct(String sVer) {
        String sMajor = "";
        String sMinor = "";
        String sRevision = "";
        String sInfo = "";
        try {
            StringTokenizer parser = new StringTokenizer(sVer.trim(), "");
            try {
                sMajor = parser.nextToken(".");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                sMinor = parser.nextToken(".");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                sRevision = parser.nextToken(REVISION_VERSION_DELIMITERS);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                sInfo = parser.nextToken("\uffff").substring(1);
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            // empty catch block
        }
        this.construct(sMajor, sMinor, sRevision, sInfo);
    }

    private void construct(InputStream inputstream) {
        String sVer = new String();
        try {
            byte[] buf = new byte[4096];
            int i = inputstream.read(buf);
            while (i != -1) {
                sVer = sVer + new String(buf);
                i = inputstream.read(buf);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.construct(sVer);
    }

    private void construct(ZipFile zipFile) throws IOException {
        Properties properties = new Properties();
        properties.load(zipFile.getInputStream(zipFile.getEntry(ZIP_ENTRY_MANIFEST)));
        this.construct(properties.getProperty(KEY_MODULE_VERSION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void construct(File file) throws IOException {
        if (file.canRead()) {
            ZipFile zipFile = new ZipFile(file);
            try {
                this.construct(zipFile);
            }
            finally {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void construct(ZipFile zipFile, ZipEntry zeResource) throws IOException {
        String sSuffix;
        String sPrefix;
        String sName = zeResource.getName();
        int iIndex = sName.lastIndexOf(47);
        if (-1 != iIndex) {
            sName = sName.substring(iIndex + 1);
        }
        if (-1 != (iIndex = sName.lastIndexOf(46))) {
            sPrefix = sName.substring(0, iIndex);
            sSuffix = sName.substring(iIndex);
        } else {
            sPrefix = sName;
            sSuffix = "";
        }
        File fTemp = File.createTempFile(sPrefix, sSuffix);
        ZipUtils.extractFile(zipFile, zeResource, fTemp);
        try {
            this.construct(fTemp);
        }
        finally {
            if (!fTemp.delete()) {
                fTemp.deleteOnExit();
            }
        }
    }

    public static NPSVersion getPortalVersion() {
        return sm_currentVersion;
    }

    public int getMajor() {
        return this.m_iMajor;
    }

    public void setMajor(int iMajor) {
        this.m_iMajor = iMajor;
    }

    public int getMinor() {
        return this.m_iMinor;
    }

    public void setMinor(int iMinor) {
        this.m_iMinor = iMinor;
    }

    public int getRevision() {
        return this.m_iRevision;
    }

    public void setRevision(int iRevision) {
        this.m_iRevision = iRevision;
    }

    public String getInformation() {
        return this.m_sInfo;
    }

    public void setInformation(String sInfo) {
        this.m_sInfo = sInfo;
    }

    public String getNumericVersion() {
        return Integer.toString(this.m_iMajor) + ".".charAt(0) + Integer.toString(this.m_iMinor) + ".".charAt(0) + Integer.toString(this.m_iRevision);
    }

    public static int getPortalType() {
        return 0;
    }

    public boolean equals(String sVer) {
        return this.equals(new NPSVersion(sVer));
    }

    public boolean equals(Object npsVer) {
        boolean rcode = false;
        if (npsVer.getClass().getName().equals(this.getClass().getName())) {
            rcode = this.m_iMajor == ((NPSVersion)npsVer).getMajor() && this.m_iMinor == ((NPSVersion)npsVer).getMinor() && this.m_iRevision == ((NPSVersion)npsVer).getRevision();
        }
        return rcode;
    }

    public int compareTo(String sVer) {
        return this.compareTo(new NPSVersion(sVer));
    }

    public int compareTo(InputStream inputstream) {
        return this.compareTo(new NPSVersion(inputstream));
    }

    public int compareTo(ZipFile zipFile) throws IOException {
        return this.compareTo(new NPSVersion(zipFile));
    }

    public int compareTo(File file) throws IOException {
        return this.compareTo(new NPSVersion(file));
    }

    public int compareTo(NPSVersion npsVer) {
        int rcode = 0;
        if (this.m_iMajor != npsVer.getMajor()) {
            rcode = npsVer.getMajor() - this.m_iMajor;
        } else if (this.m_iMinor != npsVer.getMinor()) {
            rcode = npsVer.getMinor() - this.m_iMinor;
        } else if (this.m_iRevision != npsVer.getRevision()) {
            rcode = npsVer.getRevision() - this.m_iRevision;
        }
        return rcode;
    }

    public boolean isEmpty() {
        boolean rcode = false;
        if (0 == this.getMajor() && 0 == this.getMinor() && 0 == this.getRevision() && 0 == this.getInformation().length()) {
            rcode = true;
        }
        return rcode;
    }

    public String toString() {
        String sVersion = this.getNumericVersion();
        if (null != this.m_sInfo && 0 < this.m_sInfo.length()) {
            sVersion = sVersion + " " + this.m_sInfo;
        }
        return sVersion;
    }
}

