/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.event;

import com.novell.nps.debug.Debug;
import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventListener;
import com.novell.nps.event.PortalEventManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import sun.misc.BASE64Encoder;

public class PortalEventDispatcher
extends Thread {
    static final String DT = "PortalEventDispatcher";
    private PortalEventManager portalEventMgr;
    private static BASE64Encoder encoder = new BASE64Encoder();

    public PortalEventDispatcher(PortalEventManager portalEventManager) {
        super(DT);
        this.portalEventMgr = portalEventManager;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            LinkedList eventList = PortalEventManager.getEventList();
            PortalEvent event = null;
            LinkedList linkedList = eventList;
            synchronized (linkedList) {
                while (eventList.isEmpty()) {
                    try {
                        eventList.wait();
                    }
                    catch (InterruptedException e) {}
                }
                try {
                    event = (PortalEvent)eventList.removeFirst();
                }
                catch (NoSuchElementException e) {
                    Debug.log(DT, 1, e);
                }
            }
            if (event == null) continue;
            try {
                this.dispatchEvent(event);
                continue;
            }
            catch (Exception e) {
                Debug.log(DT, 1, e.getLocalizedMessage());
                Debug.log(DT, 2, e);
                continue;
            }
            break;
        }
    }

    void dispatchEvent(PortalEvent event) {
        this.sendToLocalListeners(event);
    }

    void sendToLocalListeners(PortalEvent event) {
        Hashtable events = PortalEventManager.getEvents();
        HashSet listeners = null;
        if (events != null) {
            listeners = (HashSet)events.get(event.getClass().getName());
        }
        if (listeners != null) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                PortalEventListener listener = (PortalEventListener)i.next();
                try {
                    listener.onPortalEvent(event);
                }
                catch (Exception e) {
                    Debug.log(DT, 1, e);
                }
            }
        }
    }

    String encodePortalEvent(PortalEvent event) throws InvalidClassException, NotSerializableException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(event);
            baos.close();
            String encodedPortalEvent = encoder.encode(baos.toByteArray());
            return encodedPortalEvent;
        }
        catch (IOException e) {
            Debug.log(DT, 1, e);
            return null;
        }
    }
}

