/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.MTaskWrapper;
import com.novell.emframe.fw.RunnableManager;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.legacySupport.LegacyTask;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.emframe.fw.servlet.FwSession;
import com.novell.emframe.fw.util.FwTaskUtils;
import com.novell.nps.PortalException;
import com.novell.nps.WebappUtil;
import com.novell.nps.authentication.AuthenticationEventListener;
import com.novell.nps.authentication.AuthenticationManager;
import com.novell.nps.authentication.SecretStoreGadget;
import com.novell.nps.configManager.ConfigData;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.configManager.GadgetAssignment;
import com.novell.nps.configManager.NPSVersion;
import com.novell.nps.configManager.Setting;
import com.novell.nps.configManager.SettingValue;
import com.novell.nps.event.GadgetHitGadgetEvent;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.gadgetManager.DefaultGadgetImpl;
import com.novell.nps.gadgetManager.DeviceUnsupportedException;
import com.novell.nps.gadgetManager.ErrorGadget;
import com.novell.nps.gadgetManager.Gadget;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceActionIcon;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.gadgetManager.JobGadget;
import com.novell.nps.gadgetManager.RequestServletManager;
import com.novell.nps.gadgetManager.ResourceEntry;
import com.novell.nps.gadgetManager.ResourceSet;
import com.novell.nps.gadgetManager.ResourceSetMap;
import com.novell.nps.gadgetManager.StringArrayComparator;
import com.novell.nps.gadgetManager.StylesheetSet;
import com.novell.nps.gadgetManager.StylesheetSetMap;
import com.novell.nps.gadgetManager.XmlUtil;
import com.novell.nps.i18n.ResourceFileManager;
import com.novell.nps.i18n.ResourceFileMap;
import com.novell.nps.rendering.JaxpRendererImpl;
import com.novell.nps.rendering.NxslRendererImpl;
import com.novell.nps.rendering.Renderer;
import com.novell.nps.serviceProviders.NPSMacroParser;
import com.novell.nps.sessionManager.PortalSession;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class GadgetManager
implements AuthenticationEventListener {
    private static final String JOB_ASSIGNMENT_PREFIX = "Job-";
    private static final String SESSION_JOBS_TABLE = "System.JobsTable";
    public static final String directHttpPort_PROPERTY = "com.novell.nps.directHttpPort";
    public static final String instanceID_PROPERTY = "com.novell.nps.instanceID";
    public static final String instanceIP_PROPERTY = "com.novell.nps.instanceIP";
    public static final String CUSTOM_CONTENT_TYPE = "CUSTOM_CONTENT_TYPE";
    public static final String XML_HEADER_START = "<?xml version=\"1.0\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"";
    public static final String XML_HEADER_FINISH = "\"?>";
    public static final String XML_DOCTYPE_START = "<!DOCTYPE PortalData SYSTEM \"";
    public static final String XML_DOCTYPE_END = "\">";
    public static final String XML_DOCTYPE_FILENAME = "PortalData.dtd";
    public static final String XSL_FILE_HEADER = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:output indent=\"no\"/>";
    public static final String XSL_FILE_MAIN_TEMPLATE = "<xsl:template match=\"PortalData\"><xsl:apply-templates select=\"Gadget\"/></xsl:template>";
    public static final String XSL_FILE_FOOTER = "</xsl:stylesheet>";
    public static final String NormalServletStartTag_STRING = "<Normal>";
    public static final String NormalServlet_STRING = "/servlet/portalservice?";
    public static final String NormalServletAndEndTag_STRING = "/servlet/portalservice?</Normal>";
    public static final String NormalFullpageServlet_STRING = "/servlet/normalfullpageservice?";
    public static final String NormalFullpageServletAndEndTag_STRING = "/servlet/normalfullpageservice?</Normal>";
    public static final String FullPageServletStartTag_STRING = "<FullPage>";
    public static final String FullPageServlet_STRING = "/servlet/fullpageservice?";
    public static final String FullPageServletAndTag_STRING = "/servlet/fullpageservice?</FullPage>";
    public static final String CustomContentServletStartTag_STRING = "<CustomContent>";
    public static final String CustomContentServlet_STRING = "/servlet/customcontentservice?";
    public static final String CustomContentServletAndEndTag_STRING = "/servlet/customcontentservice?</CustomContent>";
    public static final String FullFrameServletStartTag_STRING = "<FullFrame>";
    public static final String FullFrameServlet_STRING = "/servlet/frameservice?";
    public static final String FullFrameServletAndEndTag_STRING = "/servlet/frameservice?</FullFrame>";
    public static String Servlets_STRING;
    public static final String XmlNormalServletStartTag_STRING = "<Normal>";
    public static final String XmlNormalServlet_STRING = "/servlet/xmlportalservice?";
    public static final String XmlNormalServletAndEndTag_STRING = "/servlet/xmlportalservice?</Normal>";
    public static final String XmlNormalFullpageServlet_STRING = "/servlet/xmlnormalfullpageservice?";
    public static final String XmlNormalFullpageServletAndEndTag_STRING = "/servlet/xmlnormalfullpageservice?</Normal>";
    public static final String XmlFullPageServletStartTag_STRING = "<FullPage>";
    public static final String XmlFullPageServlet_STRING = "/servlet/xmlfullpageservice?";
    public static final String XmlFullPageServletAndEndTag_STRING = "/servlet/xmlfullpageservice?</FullPage>";
    public static final String XmlFullFrameServletStartTag_STRING = "<FullFrame>";
    public static final String XmlFullFrameServlet_STRING = "/servlet/xmlframeservice?";
    public static final String XmlFullFrameServletAndEndTag_STRING = "/servlet/xmlframeservice?</FullFrame>";
    public static String XmlServlets_STRING;
    public static String PortalServlets_STRING;
    public static String NormalFullpageServlets_STRING;
    public static String XmlPortalServlets_STRING;
    public static String XmlNormalFullpageServlets_STRING;
    public static final String ResourcesStartTag_STRING = "<ResourcePath>";
    public static final String ResourcesPathAndEndTag_STRING = "/portal</ResourcePath>";
    public static String Resources_STRING;
    public static final String GADGETS_BASE_PATH = "/gadgets";
    public static final String STYLESHEETS_BASE_PATH = "/stylesheets";
    public static final String WORKING_STYLESHEETS_BASE_PATH = "/work";
    public static final String PUBLISHED_RESOURCE_PATH_RELATIVE_TO_CX = "/portal";
    public static final String RENDER_OFF = "off";
    public static final String RENDER_ON = "on";
    public static final String RENDER_CLEAR = "clear";
    public static final String RENDER = "render";
    public static final String RENDER_GLOBAL_OVERRIDE = "render_override";
    public static final String CONFIG_PARAM_NAME = "NPConfig";
    public static final String NPACTION = "NPAction";
    public static final String NPSERVICE = "NPService";
    public static final String NPFULLPAGE = "NPFullpage";
    public static final String NPPAGE = "NPPage";
    public static final String NPUSERNAME = "NPUser";
    public static final String NPPASSWORD = "NPPassword";
    public static final String HELP_SUPPORT_PARAM_NAME = "NPHelp";
    public static final String NPPOST_REQUEST_ACTIONS_ATTR = "NPPostRequestActions";
    public static final String SERVICE_NOT_FOUND_PARAM = "ServiceNotFound";
    public static final String TASKID = "taskId";
    public static final String FRAME_SERVICE_REQUEST = "FrameServiceRequest";
    public static final String IMANAGER_SERVICE_REQUEST = "iManagerServiceRequest";
    public static final String NPSERVLETMANAGER = "NPServletManager";
    public static final String PORTAL_SERVICE_DATA_TYPE = "NPServiceDataType";
    public static final String PORTAL_SERVICE_PORTAL_DATA = "PortalData";
    public static final String CLIENT_PROPERTIES = "ClientProperties";
    public static final String PORTAL_SERVICE_AS_GADGET_DATA = "ServiceAsData";
    public static final String Custom_Session_Data = "Custom Session Data";
    public static final String GADGET_TIMEOUT_PARAMETER = "Gadget Timeout";
    public static final int DEFAULT_GADGET_TIMEOUT_VALUE = 8000;
    public static final String SESSION_GADGET_INSTANCES = "fw_SessionTaskInstances";
    private static final String SESSION_TOTAL_GADGET_INSTANCES = "System.SessionTotalGadgetInstances";
    public static final String SESSION_AUTH_SERVICE_REDIRECT = "System.AuthServiceRedirect";
    public static final String SESSION_NO_SYSTEM_STYLESHEETS = "System.DontUseSystemStylesheets";
    public static final String SESSION_PREV_NO_SYSTEM_STYLESHEETS = "System.PreviousDontUseSystemStylesheets";
    public static final String SESSION_INCLUDE_GLOBAL_VARIABLES = "System.IncludeGlobalVariables";
    public static final String SESSION_KEEP_MAINPAGE_INSTANCE = "System.KeepMainpageInstance";
    public static final String DELEGATING_ATTRIBUTE = "System.Delegating";
    private static final String SESSION_DELEGATE_GADGET_POOLS = "System.DelegatesPools";
    public static final String CUSTOM_BACKEND_RENDERER_PORTAL_LOCATION = "Custom Backend Renderer Portal Location";
    public static final String DISPLAY_RENDERING_TIMES = "Display Rendering Times";
    private static final String DT = "GadgetManager";
    public static final String USE_CLASS_NAME_IN_ID = "System.UseGadgetInstanceClassNameInInstanceIDs";
    private static final String SESSION_CONFIG_LAST_CHANGE_TIME = "System.ConfigLastChangeTime";
    private static Vector systemStylesheets;
    private static Vector globalStylesheets;
    private static final String[] systemStylesheetsArray;
    private static final String[] globalStylesheetsArray;
    private static StylesheetSet systemStylesheetSet;
    private static StylesheetSet globalStylesheetSet;
    private static String sm_sCustomSessionData;
    private static Renderer m_renderer;
    private static Hashtable m_gadgets;
    private static Gadget sm_defaultGadget;
    public static final String MAIN_PAGE_GADGET_INSTANCE_ARGS_PROPERTY = "System.GadgetManagerMainPageGadgetInstanceArgs";
    public static final String INHERITABLE_AREA_GADGET_INSTANCE_CLASS_PROPERTY = "System.GadgetManagerInheritableAreaGadgetInstanceClass";
    public static final String INHERITABLE_AREA_GADGET_INSTANCE_ARGS_PROPERTY = "System.GadgetManagerInheritableAreaGadgetInstanceArgs";
    public static final String INHERITABLE_AREA_SERVICE_NAME = "System.InheritableArea";
    public static final String LOGGEDOUT_INHERITABLE_AREA_SERVICE_NAME = "System.LoggedOutInheritableArea";
    public static final String INHERITABLE_AREA_GADGET_INSTANCE_CLASS = "com.novell.nps.gadgetManager.InheritableAreaGadget";
    public static final String SESSION_MAIN_PAGE_GADGET_INSTANCE_PROPERTY = "System.MainPageGadgetInstance";
    public static final String SESSION_PREV_MAIN_PAGE_GADGET_INSTANCE_PROPERTY = "System.PrevMainPageGadgetInstance";
    public static final String OBJECT_SCHEME_GADGET_INSTANCE_CLASS_PROPERTY = "System.ObjectSchemeGadgetInstanceClass";
    public static final String OBJECT_SCHEME_GADGET_INSTANCE_ARGS_PROPERTY = "System.ObjectSchemeGadgetInstanceArgs";
    public static final String OBJECT_SCHEME_GADGET_INSTANCE_CLASS = "com.novell.nps.gadgetManager.ObjectSchemeGadget";
    public static final String SESSION_STYLESHEETS = "System.SessionStylesheets";
    static final String MAIN_PAGE_GADGET_INSTANCE_CLASS_PROPERTY = "System.GadgetManagerMainPageGadgetInstanceClass";
    static final String MAIN_PAGE_GADGET_INSTANCE_CLASS = "com.novell.emframe.fw.Startup";
    private static final String SESSION_RESOURCES_ATTRIB = "System.Resources";
    private static TreeMap sm_stylesheetTree;
    private static int sm_iStyleSheetNameCounter;
    private static String sm_sAbsoluteServletContext;
    private static final NPSVersion sm_version;
    private static final String sm_sVersion;
    private static final String sm_sMajorVersion;
    private static final String sm_sMinorVersion;

    public static void registerGadget(GadgetInstance gadget, String gadgetDN) {
        m_gadgets.put(gadgetDN, gadget);
    }

    public static Gadget getGadget(String gadgetDN) {
        return (Gadget)m_gadgets.get(gadgetDN);
    }

    public static GadgetInstance getGadgetInstance(HttpServletRequest req, PortalSession session) {
        String gadgetInstanceID = GadgetManager.getGadgetInstanceID(req);
        return GadgetManager.getGadgetInstance(gadgetInstanceID, session);
    }

    public static void overrideFullpageRequest(HttpServletRequest req) {
        RequestServletManager rsManager = (RequestServletManager)req.getAttribute(NPSERVLETMANAGER);
        if (null != rsManager) {
            rsManager.overrideFullpageRequest(req);
        } else {
            req.removeAttribute(NPFULLPAGE);
        }
    }

    public static GadgetAssignment getServiceAssignment(HttpServletRequest req, PortalSession session, String serviceName) {
        return GadgetManager.getServiceAssignment(session, serviceName);
    }

    public static GadgetAssignment getServiceAssignment(PortalSession session, String serviceName) {
        return RunnableManager.getGadgetAssignment((String)serviceName, (HttpSession)session);
    }

    public static String getPageID(HttpServletRequest req) {
        return ((FwRequest)req).getParameter(NPPAGE, true);
    }

    private static GadgetInstance getMainPageGadgetInstance(PortalSession session) {
        GadgetInstance mainPageGadgetInstance = (GadgetInstance)session.getAttribute(SESSION_MAIN_PAGE_GADGET_INSTANCE_PROPERTY);
        if (null == mainPageGadgetInstance) {
            GadgetAssignment mainPageGadgetAssign = new GadgetAssignment();
            String portalTitle = new String("Novell iManager");
            mainPageGadgetAssign.setAssignmentName(portalTitle);
            mainPageGadgetAssign.setGadgetDN(MAIN_PAGE_GADGET_INSTANCE_CLASS_PROPERTY);
            mainPageGadgetAssign.setColumn("Column 1");
            mainPageGadgetAssign.setLocation("Body");
            mainPageGadgetAssign.setPriority("0");
            mainPageGadgetInstance = GadgetManager.createGadgetInstance(mainPageGadgetAssign, session);
            session.setAttribute(SESSION_MAIN_PAGE_GADGET_INSTANCE_PROPERTY, mainPageGadgetInstance);
            session.setAttribute(SESSION_NO_SYSTEM_STYLESHEETS, "true");
            session.setAttribute(SESSION_KEEP_MAINPAGE_INSTANCE, "true");
            FwUtils.setSkin((HttpSession)session, (String)"default");
            session.setAttribute("SkinSwitcher.SkinOverride", "true");
            String skinOverride = (String)session.getAttribute("SkinSwitcher.SkinOverride");
            if (skinOverride == null) {
                FwUtils.setSkin((HttpSession)session, (String)"default");
            }
        }
        if (mainPageGadgetInstance instanceof MTaskWrapper) {
            FwTaskUtils.setMTaskWrapper((MTaskWrapper)((MTaskWrapper)mainPageGadgetInstance));
        }
        return mainPageGadgetInstance;
    }

    public static GadgetInstance getGadgetInstance(String gadgetInstanceID, PortalSession session) {
        GadgetInstance gadgetInstance = null;
        if (null == gadgetInstanceID) {
            gadgetInstance = GadgetManager.getMainPageGadgetInstance(session);
        } else {
            GadgetAssignment serviceAssignment;
            Hashtable gadgetInstances = (Hashtable)session.getAttribute(SESSION_GADGET_INSTANCES);
            if (null != gadgetInstances && (gadgetInstance = (GadgetInstance)gadgetInstances.get(gadgetInstanceID)) instanceof MTaskWrapper) {
                FwTaskUtils.setMTaskWrapper((MTaskWrapper)((MTaskWrapper)gadgetInstance));
            }
            if (null == gadgetInstance && (serviceAssignment = GadgetManager.getServiceAssignment(session, gadgetInstanceID)) != null) {
                gadgetInstance = GadgetManager.createGadgetInstance(serviceAssignment, session);
            }
        }
        return gadgetInstance;
    }

    public static GadgetInstance getExactGadgetInstance(String gadgetInstanceID, PortalSession session) {
        GadgetAssignment serviceAssignment;
        GadgetInstance gadgetInstance = GadgetManager.getExistingGadgetInstance(gadgetInstanceID, session);
        if (null == gadgetInstance && (serviceAssignment = GadgetManager.getServiceAssignment(session, gadgetInstanceID)) != null) {
            gadgetInstance = GadgetManager.createGadgetInstance(serviceAssignment, session);
        }
        return gadgetInstance;
    }

    public static GadgetInstance getExistingGadgetInstance(String gadgetInstanceID, PortalSession session) {
        GadgetInstance gadgetInstance = null;
        Hashtable gadgetInstances = (Hashtable)session.getAttribute(SESSION_GADGET_INSTANCES);
        if (null != gadgetInstances) {
            gadgetInstance = (GadgetInstance)gadgetInstances.get(gadgetInstanceID);
        }
        return gadgetInstance;
    }

    public static GadgetInstance createGadgetInstance(GadgetAssignment gadgetAssignment, PortalSession session) {
        GadgetInstance gadgetInstance = null;
        if (gadgetAssignment != null) {
            Gadget gadgetFactory = sm_defaultGadget;
            List chainedGadgets = gadgetAssignment.getChainedServices();
            if (chainedGadgets != null && GadgetManager.needsJobAssignment(gadgetAssignment, session)) {
                gadgetAssignment = GadgetManager.createJobAssignment(gadgetAssignment, session);
            }
            if (null != (gadgetInstance = gadgetFactory.createGadgetInstance(gadgetAssignment, session))) {
                GadgetManager.registerGadgetInstance(gadgetInstance, session);
                if (!gadgetAssignment.getMinimized()) {
                    gadgetInstance.setWindowState("max");
                } else {
                    gadgetInstance.setWindowState("min");
                }
            }
        }
        return gadgetInstance;
    }

    private static boolean needsJobAssignment(GadgetAssignment initiatorGadgetAssignment, PortalSession session) {
        HashMap jobsTable = (HashMap)session.getAttribute(SESSION_JOBS_TABLE);
        if (jobsTable != null) {
            GadgetAssignment jobGA = (GadgetAssignment)jobsTable.get(JOB_ASSIGNMENT_PREFIX + initiatorGadgetAssignment.getServiceName());
            if (jobGA == null) {
                return true;
            }
            if (jobGA == initiatorGadgetAssignment.getJobAssignment()) {
                return false;
            }
            GadgetManager.releaseFromJobsTable(initiatorGadgetAssignment, session);
            return true;
        }
        return true;
    }

    private static GadgetAssignment createJobAssignment(GadgetAssignment gadgetAssignment, PortalSession session) {
        GadgetAssignment jobGadgetAssignment = gadgetAssignment.copy();
        jobGadgetAssignment.setServiceName(JOB_ASSIGNMENT_PREFIX + gadgetAssignment.getServiceName());
        jobGadgetAssignment.setChainedServices(null);
        jobGadgetAssignment.setGadgetInstanceClass("com.novell.nps.gadgetManager.JobGadget");
        jobGadgetAssignment.setJobInitiatorAssignment(gadgetAssignment);
        GadgetManager.addToJobTable(jobGadgetAssignment, session);
        return jobGadgetAssignment;
    }

    private static void addToJobTable(GadgetAssignment jobGadgetAssignment, PortalSession session) {
        HashMap jobsTable = GadgetManager.getJobsTable(session);
        jobsTable.put(jobGadgetAssignment.getServiceName(), jobGadgetAssignment);
    }

    private static void releaseFromJobsTable(GadgetAssignment initiatorGadgetAssignment, PortalSession session) {
        HashMap jobsTable = GadgetManager.getJobsTable(session);
        jobsTable.remove(JOB_ASSIGNMENT_PREFIX + initiatorGadgetAssignment.getServiceName());
    }

    private static HashMap getJobsTable(PortalSession session) {
        HashMap jobsTable = (HashMap)session.getAttribute(SESSION_JOBS_TABLE);
        if (jobsTable == null) {
            jobsTable = new HashMap();
            session.setAttribute(SESSION_JOBS_TABLE, jobsTable);
        }
        return jobsTable;
    }

    public static JobGadget getJobForGadget(GadgetInstance gadget) {
        GadgetInstance instance = null;
        JobGadget jobInstance = null;
        GadgetAssignment assn = gadget.getGadgetAssignment();
        GadgetAssignment JobAssn = assn.getJobAssignment();
        if (JobAssn != null && (instance = GadgetManager.getExistingGadgetInstance(JobAssn.getServiceName(), gadget.getSession())) instanceof JobGadget) {
            jobInstance = (JobGadget)((Object)instance);
        }
        return jobInstance;
    }

    public static String getGadgetInstanceID(HttpServletRequest req) {
        return FwUtils.getTaskInstanceId((HttpServletRequest)req);
    }

    public static boolean isFullBranding(HttpServletRequest req, PortalSession session) {
        String fullPageMode = GadgetManager.getFullPageMode(req, session);
        return "branding".equalsIgnoreCase(fullPageMode);
    }

    public static boolean isFullData(HttpServletRequest req, PortalSession session) {
        String fullPageMode = GadgetManager.getFullPageMode(req, session);
        return "data".equalsIgnoreCase(fullPageMode) || "y".equalsIgnoreCase(fullPageMode);
    }

    public static boolean isFullPage(HttpServletRequest req, PortalSession session) {
        return GadgetManager.isFullData(req, session);
    }

    public static boolean isServiceReq(HttpServletRequest req) {
        String gadgetCode = ((FwRequest)req).getParameter(NPSERVICE, true);
        return gadgetCode != null && gadgetCode.length() > 0;
    }

    private static String getFullPageMode(HttpServletRequest req, PortalSession session) {
        GadgetInstance gadgetInstance;
        String fullPageMode = ((FwRequest)req).getParameter("FULLPAGE", true);
        if (fullPageMode == null && (gadgetInstance = GadgetManager.getGadgetInstance(req, session)) != null) {
            fullPageMode = gadgetInstance.getFullPageMode(req);
        }
        return fullPageMode;
    }

    public static String getProxyServer() {
        String proxy = ConfigManager.getSingleSetting("ProxyServer");
        if (null != proxy && proxy.length() > 0) {
            return proxy;
        }
        return "";
    }

    public static String getPortalHostname(PortalSession session) {
        return ConfigManager.getSingleSetting("ProxyServer", (String)session.getAttribute("PORTAL_HOST_NAME"));
    }

    public static int getCookieTimeout() {
        int timeout = ConfigManager.getSingleIntSetting("Cookie Expire Time", 0);
        if (timeout > 0) {
            timeout = timeout * 24 * 60 * 60;
        }
        return timeout;
    }

    public static void setXSLSupport(HttpServletRequest req, PortalSession session) {
    }

    public static String getClientProperty(PortalSession session, String propertyName) {
        Hashtable ht = (Hashtable)session.getAttribute(CLIENT_PROPERTIES);
        if (ht != null) {
            return (String)ht.get(propertyName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance;
        GadgetInstance gadgetInstance2 = gadgetInstance = this.authenticationAndGetService(req, resp, session);
        synchronized (gadgetInstance2) {
            GadgetManager.setXSLSupport(req, session);
            FwRequest theRequest = (FwRequest)req;
            try {
                this.postGadgetHitEvent(req, gadgetInstance, session);
                if (this.customContentType(req)) {
                    gadgetInstance.processRequest((HttpServletRequest)theRequest, resp);
                    return;
                }
                String action = GadgetManager.getAction(req, session);
                gadgetInstance.handleAction(action, (HttpServletRequest)theRequest);
                if (null != theRequest.getAttribute(NPPOST_REQUEST_ACTIONS_ATTR) && this.handlePostRequestActions(gadgetInstance, (HttpServletRequest)theRequest, resp, session)) {
                    return;
                }
                if (GadgetManager.isServiceReq(req) && !GadgetManager.isPortalServiceDataReq(req) && !GadgetManager.isServiceAsGadgetReg(req)) {
                    GadgetManager.getServiceResponse(req, resp, session, gadgetInstance);
                } else {
                    this.buildPage(req, resp, session);
                }
            }
            catch (PortalException e) {
                D.log((Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                D.log((Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session, boolean bCloseResponse) throws ServletException {
        GadgetInstance gadgetInstance = this.authenticationAndGetService(req, resp, session);
        if (FwAttr.getFwRequestAttribute((String)SESSION_NO_SYSTEM_STYLESHEETS, (HttpServletRequest)req) == null) {
            resp.setHeader("Cache-Control", "no-cache");
        }
        GadgetInstance gadgetInstance2 = gadgetInstance;
        synchronized (gadgetInstance2) {
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            resp.setContentType(FwUtils.getContentType((HttpSession)session));
            GadgetInstance gadget = gadgetInstance.getRedirectionOrSelf();
            if (FwAttr.getFwRequestAttribute((String)FRAME_SERVICE_REQUEST, (HttpServletRequest)req) != null && gadget.getPreferredDataType().equals("text/html")) {
                this.buildUnrenderedHTMLResponse(gadget, req, resp, session, bCloseResponse);
            } else {
                this.buildRenderedResponse(req, resp, gadget, session, bCloseResponse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXMLServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance;
        GadgetInstance gadgetInstance2 = gadgetInstance = this.authenticationAndGetService(req, resp, session);
        synchronized (gadgetInstance2) {
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            gadgetInstance = gadgetInstance.getRedirectionOrSelf();
            this.buildUnrenderedXMLResponse(gadgetInstance, req, resp, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPortalServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance = this.authenticationAndGetService(req, resp, session);
        resp.setHeader("Cache-Control", "no-cache");
        GadgetInstance gadgetInstance2 = gadgetInstance;
        synchronized (gadgetInstance2) {
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            resp.setContentType(FwUtils.getContentType((HttpSession)session));
            gadgetInstance = GadgetManager.getMainPageGadgetInstance(session);
            this.buildRenderedResponse(req, resp, gadgetInstance, session, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXMLPortalServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance;
        GadgetInstance gadgetInstance2 = gadgetInstance = this.authenticationAndGetService(req, resp, session);
        synchronized (gadgetInstance2) {
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            gadgetInstance = GadgetManager.getMainPageGadgetInstance(session);
            this.buildUnrenderedXMLResponse(gadgetInstance, req, resp, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFullpageServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance = this.authenticationAndGetService(req, resp, session);
        resp.setHeader("Cache-Control", "no-cache");
        GadgetInstance gadgetInstance2 = gadgetInstance;
        synchronized (gadgetInstance2) {
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            GadgetInstance dataGadgetInstance = gadgetInstance.getRedirectionOrSelf();
            resp.setContentType(FwUtils.getContentType((HttpSession)session));
            this.buildRenderedResponse(req, resp, dataGadgetInstance, session, true);
        }
    }

    public void processMTaskRequest(HttpServletRequest req, HttpServletResponse response, PortalSession session) throws ServletException {
        MTaskWrapper mtaskWrapper = (MTaskWrapper)GadgetManager.getGadgetInstance(req, session);
        try {
            MTaskWrapper.processRequestImpl((MTaskWrapper)mtaskWrapper, (HttpServletRequest)req);
        }
        catch (Throwable e) {
            D.log((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXMLFullpageServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance;
        GadgetInstance gadgetInstance2 = gadgetInstance = this.authenticationAndGetService(req, resp, session);
        synchronized (gadgetInstance2) {
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            GadgetInstance dataGadgetInstance = gadgetInstance.getRedirectionOrSelf();
            this.buildUnrenderedXMLResponse(dataGadgetInstance, req, resp, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNormalFullpageServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance = this.authenticationAndGetService(req, resp, session);
        resp.setHeader("Cache-Control", "no-cache");
        GadgetInstance gadgetInstance2 = gadgetInstance;
        synchronized (gadgetInstance2) {
            GadgetInstance dataGadgetInstance;
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            resp.setContentType(FwUtils.getContentType((HttpSession)session));
            if (null == gadgetInstance.getFullPageMode(req)) {
                dataGadgetInstance = GadgetManager.getMainPageGadgetInstance(session);
                req.removeAttribute(NPFULLPAGE);
            } else {
                dataGadgetInstance = gadgetInstance.getRedirectionOrSelf();
            }
            this.buildRenderedResponse(req, resp, dataGadgetInstance, session, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXMLNormalFullpageServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance;
        GadgetInstance gadgetInstance2 = gadgetInstance = this.authenticationAndGetService(req, resp, session);
        synchronized (gadgetInstance2) {
            GadgetInstance dataGadgetInstance;
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            if (null == gadgetInstance.getFullPageMode(req)) {
                dataGadgetInstance = GadgetManager.getMainPageGadgetInstance(session);
                req.removeAttribute(NPFULLPAGE);
            } else {
                dataGadgetInstance = gadgetInstance.getRedirectionOrSelf();
            }
            this.buildUnrenderedXMLResponse(dataGadgetInstance, req, resp, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPageServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance = this.authenticationAndGetService(req, resp, session);
        resp.setHeader("Cache-Control", "no-cache");
        GadgetInstance gadgetInstance2 = gadgetInstance;
        synchronized (gadgetInstance2) {
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            resp.setContentType(FwUtils.getContentType((HttpSession)session));
            GadgetInstance pageGadgetInstance = null;
            if (pageGadgetInstance == null) {
                pageGadgetInstance = gadgetInstance.getParentInstance();
            }
            if (pageGadgetInstance == null) {
                pageGadgetInstance = gadgetInstance;
            }
            this.buildRenderedResponse(req, resp, pageGadgetInstance, session, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXMLPageServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance;
        GadgetInstance gadgetInstance2 = gadgetInstance = this.authenticationAndGetService(req, resp, session);
        synchronized (gadgetInstance2) {
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            GadgetInstance pageGadgetInstance = null;
            if (pageGadgetInstance == null) {
                pageGadgetInstance = gadgetInstance.getParentInstance();
            }
            if (pageGadgetInstance == null) {
                pageGadgetInstance = gadgetInstance;
            }
            this.buildUnrenderedXMLResponse(pageGadgetInstance, req, resp, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXMLDataServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance;
        GadgetInstance gadgetInstance2 = gadgetInstance = this.authenticationAndGetService(req, resp, session);
        synchronized (gadgetInstance2) {
            if (this.processInstanceRequest(req, resp, gadgetInstance, session)) {
                return;
            }
            resp.setContentType("text/xml; charset=UTF-8");
            try {
                BufferedWriter out = new BufferedWriter(resp.getWriter());
                GadgetManager.callGetData(gadgetInstance, req, out, null);
                out.close();
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
            catch (PortalException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCustomContentServiceRequest(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        GadgetInstance gadgetInstance = this.authenticationAndGetService(req, resp, session);
        if (gadgetInstance.getAllowProcessRequestAsync()) {
            this.callCustomContentServiceGadget(req, gadgetInstance, session, resp);
        } else {
            GadgetInstance gadgetInstance2 = gadgetInstance;
            synchronized (gadgetInstance2) {
                this.callCustomContentServiceGadget(req, gadgetInstance, session, resp);
            }
        }
    }

    private void callCustomContentServiceGadget(HttpServletRequest req, GadgetInstance gadgetInstance, PortalSession session, HttpServletResponse resp) throws ServletException {
        try {
            this.postGadgetHitEvent(req, gadgetInstance, session);
            gadgetInstance.processRequest(req, resp);
        }
        catch (PortalException e) {
            throw new ServletException(e.getMessage());
        }
    }

    public boolean handlePostRequestActions(GadgetInstance service, HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        try {
            return service.handlePostRequestActions(req, resp);
        }
        catch (PortalException e) {
            throw new ServletException(e.getMessage());
        }
    }

    private GadgetInstance authenticationAndGetService(HttpServletRequest req, HttpServletResponse resp, PortalSession session) {
        GadgetInstance gadgetInstance = GadgetManager.getGadgetInstance(req, session);
        if (gadgetInstance == null) {
            String taskId = GadgetManager.getGadgetInstanceID(req);
            GadgetInstance task = GadgetManager.createGadgetInstance(GadgetManager.getServiceAssignment(session, "dev.Empty"), session);
            FwUtils.setBGI((HttpServletRequest)req, (LegacyTask)((LegacyTask)task));
            MContext context = FwUtils.getMContext((HttpServletRequest)req);
            String title = eMFrameUtils.getLocalizedString((String)"DevResources", (String)"GeneralMsg.MsgTitleDefault", (MContext)context);
            String body = eMFrameUtils.getLocalizedString((String)"com.novell.nps.configManager.ConfigManagerRes", (String)"Service_Not_Found", (MContext)context) + "[" + taskId + "]";
            eMFrameUtils.setMessage((String)"error", (String)title, (String)body, (MContext)context);
            D.log((String)("Could not find task:" + taskId));
            return task;
        }
        return gadgetInstance;
    }

    private boolean processInstanceRequest(HttpServletRequest req, HttpServletResponse resp, GadgetInstance gadgetInstance, PortalSession session) throws ServletException {
        FwRequest theRequest = (FwRequest)req;
        try {
            this.postGadgetHitEvent(req, gadgetInstance, session);
            String action = GadgetManager.getAction(req, session);
            gadgetInstance.handleAction(action, (HttpServletRequest)theRequest);
        }
        catch (PortalException e) {
            throw new ServletException(e.getMessage());
        }
        if (null != theRequest.getAttribute(NPPOST_REQUEST_ACTIONS_ATTR)) {
            return this.handlePostRequestActions(gadgetInstance, (HttpServletRequest)theRequest, resp, session);
        }
        return false;
    }

    protected static boolean shouldAuthenticate(HttpServletRequest req, PortalSession session) {
        boolean needsAuth = false;
        if (AuthenticationManager.getAuthenticationState(session).equals("StateLoggedOut")) {
            if (!needsAuth && session.getAttribute("NETIDENTITY_CREDENTIAL") != null) {
                needsAuth = true;
                return needsAuth;
            }
            if (((FwRequest)req).getParameter(NPUSERNAME, true) != null && ((FwRequest)req).getParameter(NPPASSWORD, true) != null) {
                needsAuth = true;
            }
            String sBasic = null;
            sBasic = req.getHeader("Authorization");
            if (null != sBasic && sBasic.indexOf("Basic") != -1) {
                needsAuth = true;
                return needsAuth;
            }
            if (GadgetManager.getGadgetInstanceID(req) != null || GadgetManager.getCookieTimeout() <= 0) {
                return needsAuth;
            }
            String sCookieName = ConfigManager.getSingleSetting("Cookie Name", "NPS");
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equalsIgnoreCase(sCookieName)) continue;
                    needsAuth = true;
                    break;
                }
            }
        }
        return needsAuth;
    }

    protected static void authenticate(HttpServletRequest req, HttpServletResponse resp, PortalSession session) {
    }

    public static GadgetInstance getAuthService(HttpServletRequest req, PortalSession session) {
        return GadgetManager.getAuthService(session);
    }

    public static GadgetInstance getAuthService(PortalSession session) {
        return GadgetManager.getExactGadgetInstance("AuthenticationService", session);
    }

    public static GadgetInstance getErrorService(HttpServletRequest req, PortalSession session) {
        return GadgetManager.getErrorService(session, null);
    }

    public static GadgetInstance getErrorService(PortalSession session) {
        session.removeAttribute(ErrorGadget.ERROR_GADGET_BAD_INSTANCE_ID);
        return GadgetManager.getExactGadgetInstance("ErrorService", session);
    }

    public static GadgetInstance getErrorService(PortalSession session, String sGadgetInstanceId) {
        if (sGadgetInstanceId != null && sGadgetInstanceId.length() != 0) {
            session.setAttribute(ErrorGadget.ERROR_GADGET_BAD_INSTANCE_ID, sGadgetInstanceId);
        } else {
            session.removeAttribute(ErrorGadget.ERROR_GADGET_BAD_INSTANCE_ID);
        }
        return GadgetManager.getExactGadgetInstance("ErrorService", session);
    }

    protected static boolean isPortalServiceDataReq(HttpServletRequest req) {
        String dataType = GadgetManager.getServiceDataTypeParam(req);
        return PORTAL_SERVICE_PORTAL_DATA.equals(dataType);
    }

    protected static String getServiceDataTypeParam(HttpServletRequest req) {
        String dataType = ((FwRequest)req).getParameter(PORTAL_SERVICE_DATA_TYPE, true);
        return dataType;
    }

    protected static String getAction(HttpServletRequest req, PortalSession session) {
        GadgetInstance gadgetInstance;
        String action = ((FwRequest)req).getParameter(NPACTION, true);
        if (action == null && (gadgetInstance = GadgetManager.getGadgetInstance(req, session)) != null) {
            action = gadgetInstance.getAction(req);
        }
        return action;
    }

    private void postGadgetHitEvent(HttpServletRequest req, GadgetInstance gadgetInstance, PortalSession session) {
        if (GadgetManager.getGadgetInstanceID(req) != null) {
            String action = GadgetManager.getAction(req, session);
            if (null == action) {
                action = req.getQueryString();
                action = action != null ? action.replace('&', ' ') : "Unknown";
            }
            if (session != null && gadgetInstance != null) {
                PortalEventManager.postEvent(new GadgetHitGadgetEvent(FwAuthUtils.getUserFullId((HttpServletRequest)req), gadgetInstance.getGadgetAssignment(), action));
            } else {
                if (session == null) {
                    D.log((String)"Session is null in postGadgetHitEvent");
                }
                if (gadgetInstance == null) {
                    D.log((String)"gadgetInstance is null in postGadgetHitEvent");
                }
            }
        }
    }

    public static void getServiceResponse(HttpServletRequest req, HttpServletResponse resp, PortalSession session, GadgetInstance gadgetInstance) throws PortalException {
        try {
            resp.setContentType("text/xml");
            PrintWriter pw = resp.getWriter();
            BufferedWriter out = new BufferedWriter(pw);
            GadgetManager.callGetData(gadgetInstance, req, out, null);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            D.log((Throwable)e);
            throw new PortalException(e.getMessage());
        }
        catch (GadgetInstanceException e) {
            throw new PortalException(e.getMessage());
        }
    }

    private void buildPage(HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws PortalException {
        try {
            StringWriter pw = null;
            resp.setContentType(FwUtils.getContentType((HttpSession)session));
            resp.setHeader("Cache-Control", "no-cache");
            pw = new StringWriter();
            BufferedWriter out = new BufferedWriter(pw);
            GadgetInstance gadgetInstance = null;
            gadgetInstance = !GadgetManager.isFullData(req, session) && !GadgetManager.isFullBranding(req, session) ? GadgetManager.getMainPageGadgetInstance(session) : GadgetManager.getGadgetInstance(req, session);
            gadgetInstance.setRequestedDataType("text/xml");
            String xslURI = this.getFullBrandingStylesheetURI(gadgetInstance, req, session);
            out.write(XML_HEADER_START);
            out.write(req.getContextPath() + xslURI);
            out.write(XML_HEADER_FINISH);
            if (!GadgetManager.isFullData(req, session)) {
                out.write("<PortalData version=\"");
                out.write(sm_sVersion);
                out.write("\" major-ver=\"");
                out.write(sm_sMajorVersion);
                out.write("\" minor-ver=\"");
                out.write(sm_sMinorVersion);
                out.write(XML_DOCTYPE_END);
                this.writeResources(req, session, out);
                out.write("<modulesPath>" + session.getAttribute("ModulesPath") + "</modulesPath>");
                out.write("<isDebugEnabled>" + D.isDebugEnabled() + "</isDebugEnabled>");
                GadgetManager.writeSessionInfo(req, session, out);
                out.write(GadgetManager.createGadgetXMLStartTag(gadgetInstance, req, session));
                String sCustomAssignmentConfig = GadgetManager.createCustomAssignmentConfigTags(gadgetInstance);
                if (sCustomAssignmentConfig != null && sCustomAssignmentConfig.length() != 0) {
                    out.write(sCustomAssignmentConfig);
                }
            }
            GadgetManager.callGetData(gadgetInstance, req, out, null);
            if (!GadgetManager.isFullData(req, session)) {
                out.write("</Gadget>");
                out.write("</PortalData>");
            }
            out.flush();
            StringWriter sw = pw;
            m_renderer.applyStyleSheet(sw.toString(), xslURI, this.getAbsoluteServletContext(req), (OutputStream)resp.getOutputStream(), session, req);
            out.close();
        }
        catch (IOException e) {
            D.log((Throwable)e);
            throw new PortalException(e.getMessage());
        }
        catch (GadgetInstanceException e) {
            throw new PortalException(e.getMessage());
        }
    }

    private void buildRenderedResponse(HttpServletRequest req, HttpServletResponse resp, GadgetInstance gadgetInstance, PortalSession session, boolean bCloseResponse) throws ServletException {
        try {
            gadgetInstance.setRequestedDataType("text/xml");
            gadgetInstance.prepare(req, resp);
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)resp.getOutputStream());
            StringWriter sw = new StringWriter();
            BufferedWriter dataBuffer = new BufferedWriter(sw);
            String xslURI = this.buildXMLResponse(gadgetInstance, req, session, dataBuffer);
            dataBuffer.flush();
            m_renderer.applyStyleSheet(sw.toString(), xslURI, this.getAbsoluteServletContext(req), out, session, req);
            if (bCloseResponse) {
                out.close();
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void buildUnrenderedHTMLResponse(GadgetInstance gadgetInstance, HttpServletRequest req, HttpServletResponse resp, PortalSession session, boolean bCloseResponse) throws ServletException {
        try {
            gadgetInstance.setRequestedDataType("text/html");
            gadgetInstance.prepare(req, resp);
            BufferedWriter out = new BufferedWriter(resp.getWriter());
            GadgetManager.callGetData(gadgetInstance, req, out, null);
            if (bCloseResponse) {
                out.close();
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (PortalException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void buildUnrenderedXMLResponse(GadgetInstance gadgetInstance, HttpServletRequest req, HttpServletResponse resp, PortalSession session) throws ServletException {
        resp.setContentType("text/xml; charset=UTF-8");
        try {
            gadgetInstance.setRequestedDataType("text/xml");
            gadgetInstance.prepare(req, resp);
            BufferedWriter out = new BufferedWriter(resp.getWriter());
            this.buildXMLResponse(gadgetInstance, req, session, out);
            out.close();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (PortalException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String buildXMLResponse(GadgetInstance gadgetInstance, HttpServletRequest req, PortalSession session, BufferedWriter out) throws PortalException, IOException {
        String actionIconsData;
        out.write(XML_HEADER_START);
        String xslURI = this.getFullBrandingStylesheetURI(gadgetInstance, req, session);
        out.write(req.getContextPath() + xslURI);
        out.write(XML_HEADER_FINISH);
        out.write("<PortalData version=\"");
        out.write(sm_sVersion);
        out.write("\" major-ver=\"");
        out.write(sm_sMajorVersion);
        out.write("\" minor-ver=\"");
        out.write(sm_sMinorVersion);
        out.write(XML_DOCTYPE_END);
        this.writeResources(req, session, out);
        GadgetManager.writeSessionInfo(req, session, out);
        out.write("<modulesPath>" + session.getAttribute("ModulesPath") + "</modulesPath>");
        out.write("<isDebugEnabled>" + D.isDebugEnabled() + "</isDebugEnabled>");
        out.write(GadgetManager.createGadgetXMLStartTag(gadgetInstance, req, session));
        String sCustomAssignmentConfig = GadgetManager.createCustomAssignmentConfigTags(gadgetInstance);
        if (sCustomAssignmentConfig != null && sCustomAssignmentConfig.length() != 0) {
            out.write(sCustomAssignmentConfig);
        }
        if ((actionIconsData = GadgetManager.getGadgetInstanceActionIconsXML(req, gadgetInstance)) != null) {
            out.write(actionIconsData);
        }
        GadgetManager.callGetData(gadgetInstance, req, out, null);
        out.write("</Gadget>");
        out.write("</PortalData>");
        return xslURI;
    }

    private String getAbsoluteServletContext(HttpServletRequest req) {
        if (sm_sAbsoluteServletContext == null) {
            sm_sAbsoluteServletContext = ConfigManager.getPortalSetting(CUSTOM_BACKEND_RENDERER_PORTAL_LOCATION, "file:///" + WebappUtil.getRealPath("/"));
            if (sm_sAbsoluteServletContext != null) {
                return sm_sAbsoluteServletContext;
            }
            StringBuffer urlStringBuffer = req.getRequestURL();
            String tempAbsoluteServletContext = new String(urlStringBuffer);
            int servletPathLoc = tempAbsoluteServletContext.lastIndexOf(req.getServletPath());
            if (servletPathLoc >= 0) {
                tempAbsoluteServletContext = tempAbsoluteServletContext.substring(0, servletPathLoc);
            } else {
                String tempServletPath = req.getServletPath();
                servletPathLoc = tempAbsoluteServletContext.indexOf("/servlet/");
                if (servletPathLoc >= 0) {
                    tempAbsoluteServletContext = tempAbsoluteServletContext.substring(0, servletPathLoc);
                } else {
                    int pathElementEndLocation;
                    int pathElementStartLocation = tempServletPath.indexOf(47);
                    if (pathElementStartLocation == 0) {
                        pathElementStartLocation = 1;
                        pathElementEndLocation = tempServletPath.indexOf(47, pathElementStartLocation);
                    } else if (pathElementStartLocation > 0) {
                        pathElementEndLocation = pathElementStartLocation;
                        pathElementStartLocation = 0;
                    } else {
                        pathElementStartLocation = 0;
                        pathElementEndLocation = tempServletPath.length();
                    }
                    String tempServletPathElement = tempServletPath.substring(pathElementStartLocation, pathElementEndLocation);
                    servletPathLoc = tempAbsoluteServletContext.lastIndexOf(tempServletPathElement) - 1;
                    if (servletPathLoc >= 1) {
                        tempAbsoluteServletContext = tempAbsoluteServletContext.substring(0, --servletPathLoc);
                    } else {
                        D.log((String)"Unable to determine the absolute servlet context from the request for use in determining the default Backend Rendering Location.  Please assign Custom backend renderer location for the portal.", (int)1);
                        D.log((String)("req.ServletPath:  " + req.getServletPath() + "  urlString: " + urlStringBuffer.toString()), (int)1);
                    }
                }
            }
            sm_sAbsoluteServletContext = tempAbsoluteServletContext;
        }
        return sm_sAbsoluteServletContext;
    }

    protected static boolean isServiceAsGadgetReg(HttpServletRequest req) {
        return GadgetManager.isServiceReq(req) && PORTAL_SERVICE_AS_GADGET_DATA.equals(((FwRequest)req).getParameter(PORTAL_SERVICE_DATA_TYPE, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callGetData(GadgetInstance gInst, HttpServletRequest req, BufferedWriter out, Document dom) throws GadgetInstanceException {
        FwRequest theRequest = (FwRequest)req;
        GadgetInstance gadgetInstance = gInst;
        synchronized (gadgetInstance) {
            gInst.callGetData(gInst, (HttpServletRequest)theRequest, out, dom);
        }
    }

    public static void callGetDataNoLock(GadgetInstance gInst, HttpServletRequest req, BufferedWriter out, Document dom) throws GadgetInstanceException {
        FwRequest theRequest = (FwRequest)req;
        gInst.callGetData(gInst, (HttpServletRequest)theRequest, out, dom);
    }

    public static String getState(GadgetInstance gInst, HttpServletRequest req) {
        String sReqID = GadgetManager.getGadgetInstanceID(req);
        if (gInst.getGadgetInstanceID().equals(sReqID) || gInst.getRootDelegator().equalsIgnoreCase(sReqID)) {
            return GadgetManager.getState(req);
        }
        return null;
    }

    public static String getState(HttpServletRequest req) {
        return ((FwRequest)req).getParameter("NPState", true);
    }

    protected static Method getGetDataMethod(GadgetInstance gInst, String state) {
        Method method = null;
        String methodName = "get" + state + "Data";
        Class[] args = new Class[3];
        try {
            args[0] = Class.forName("javax.servlet.http.HttpServletRequest");
            args[1] = Class.forName("java.io.BufferedWriter");
            args[2] = Class.forName("org.w3c.dom.Document");
            method = gInst.getClass().getMethod(methodName, args);
        }
        catch (Exception e) {
            D.log((String)("GadgetManager: Couldn't get " + methodName + " for " + gInst.getGadgetAssignment().getAssignmentName() + "because of excecption:" + e.getLocalizedMessage()));
            D.log((Throwable)e);
        }
        return method;
    }

    public static String getPublishedResourcePathRelToCX() {
        return PUBLISHED_RESOURCE_PATH_RELATIVE_TO_CX;
    }

    public static String getAbsolutePublishedResourcePathRelToDomain(HttpServletRequest req) {
        return req.getContextPath() + GadgetManager.getPublishedResourcePathRelToCX();
    }

    private static void setSystemStylesheets(String[] stylesheets) {
        systemStylesheets.addAll(Arrays.asList(stylesheets));
    }

    private static void setGlobalStylesheets(String[] stylesheets) {
        globalStylesheets.addAll(Arrays.asList(stylesheets));
    }

    public String getFullBrandingStylesheetURI(GadgetInstance gadInst, HttpServletRequest req, PortalSession session) {
        StylesheetSetMap containedStylesheetSets = new StylesheetSetMap();
        ResourceSetMap resourceSetMap = new ResourceSetMap();
        if (null == session.getAttribute(SESSION_NO_SYSTEM_STYLESHEETS) && null == FwAttr.getFwRequestAttribute((String)SESSION_NO_SYSTEM_STYLESHEETS, (HttpServletRequest)req)) {
            containedStylesheetSets.put((StylesheetSet)systemStylesheetSet.clone());
        } else {
            boolean bSupportsFullFrame = true;
            boolean bFullFrameRequest = false;
            if (FwAttr.getFwRequestAttribute((String)FRAME_SERVICE_REQUEST, (HttpServletRequest)req) != null) {
                GadgetAssignment ga;
                bFullFrameRequest = true;
                if (gadInst != null && (ga = gadInst.getGadgetAssignment()) != null) {
                    bSupportsFullFrame = ga.getSupportsFullFrame();
                }
            }
            if (bFullFrameRequest && !bSupportsFullFrame) {
                containedStylesheetSets.put((StylesheetSet)systemStylesheetSet.clone());
            } else if (null != session.getAttribute(SESSION_INCLUDE_GLOBAL_VARIABLES) || null != FwAttr.getFwRequestAttribute((String)SESSION_INCLUDE_GLOBAL_VARIABLES, (HttpServletRequest)req)) {
                containedStylesheetSets.put((StylesheetSet)globalStylesheetSet.clone());
            }
        }
        gadInst.getStylesheetAndResourceSets(req, containedStylesheetSets, resourceSetMap);
        this.getAndSaveLocalizedResourceSets(resourceSetMap, req, session);
        HashSet localizedStylesheets = this.getLocalizedStylesheetsForSets(containedStylesheetSets, session);
        String stylesheetURI = GadgetManager.getStyleSheetForContainedSet(localizedStylesheets, req);
        return stylesheetURI;
    }

    private void getAndSaveLocalizedResourceSets(ResourceSetMap resourceSetMap, HttpServletRequest req, PortalSession session) {
        if (!resourceSetMap.isEmpty()) {
            Iterator iter = resourceSetMap.values().iterator();
            StringBuffer sbResources = new StringBuffer(resourceSetMap.size() * 25);
            while (iter.hasNext()) {
                ResourceSet rs = (ResourceSet)iter.next();
                if (null == rs) continue;
                ResourceFileMap rfm = ResourceFileManager.getResourceFileMap(rs.getLocator());
                Iterator iterRE = rs.iterator();
                block5: while (iterRE.hasNext()) {
                    ResourceEntry re = (ResourceEntry)iterRE.next();
                    if (null == re) continue;
                    switch (re.getType()) {
                        case 1: 
                        case 2: {
                            String locPath = rfm.getLocalizedPath(re.getValue(), session, rs.getLocale());
                            sbResources.append(this.writeFileResource(req, locPath, re));
                            continue block5;
                        }
                        case 0: {
                            sbResources.append(this.writeOtherResource(re));
                            continue block5;
                        }
                    }
                    sbResources.append(this.writeTextResource(re));
                }
            }
            session.setAttribute(SESSION_RESOURCES_ATTRIB, sbResources.toString());
        }
    }

    private String writeFileResource(HttpServletRequest req, String locPath, ResourceEntry re) {
        StringBuffer sb = new StringBuffer(60 + req.getContextPath().length());
        sb.append("<Resource ");
        sb.append("type=\"");
        sb.append(re.getType() == 2 ? "css" : "js");
        sb.append("\" href=\"");
        if (locPath.length() > 0 && locPath.charAt(0) == '/') {
            sb.append(req.getContextPath());
        }
        sb.append(XmlUtils.xmlEncode((String)locPath));
        if (re.getPriority() > 0) {
            sb.append("\" priority=\"");
            sb.append(String.valueOf(re.getPriority()));
        }
        sb.append("\"/>");
        return sb.toString();
    }

    private String writeTextResource(ResourceEntry re) {
        StringBuffer sb = new StringBuffer(60 + re.getValue().length());
        sb.append("<Resource ");
        sb.append("type=\"text");
        if (re.getPriority() > 0) {
            sb.append("\" priority=\"");
            sb.append(String.valueOf(re.getPriority()));
        }
        sb.append(XML_DOCTYPE_END);
        sb.append(re.getValue());
        sb.append("</Resource>");
        return sb.toString();
    }

    private String writeOtherResource(ResourceEntry re) {
        StringBuffer sb = new StringBuffer(60 + re.getValue().length());
        sb.append("<Resource ");
        sb.append("type=\"other\" other-type=\"");
        sb.append(XmlUtils.xmlEncode((String)re.getOtherType()));
        if (re.getPriority() > 0) {
            sb.append("\" priority=\"");
            sb.append(String.valueOf(re.getPriority()));
        }
        sb.append(XML_DOCTYPE_END);
        sb.append(re.getValue());
        sb.append("</Resource>");
        return sb.toString();
    }

    private HashSet getLocalizedStylesheetsForSets(StylesheetSetMap stylesheetSets, PortalSession session) {
        HashSet localizedStylesheets = new HashSet();
        Iterator iter = stylesheetSets.values().iterator();
        while (iter.hasNext()) {
            StylesheetSet currentSet = (StylesheetSet)iter.next();
            HashSet currentLocalizedSet = this.getLocalizedStylesheetsForSet(currentSet, session);
            localizedStylesheets.addAll(currentLocalizedSet);
        }
        return localizedStylesheets;
    }

    private HashSet getLocalizedStylesheetsForSet(StylesheetSet stylesheetSet, PortalSession session) {
        HashSet<String> localizedStylesheets = new HashSet<String>();
        ResourceFileMap rfm = ResourceFileManager.getResourceFileMap(stylesheetSet.getLocator());
        if (null == rfm) {
            D.log((String)("No Resource File Map found for StylesheetSet: " + stylesheetSet.getLocator()), (int)1);
            return localizedStylesheets;
        }
        Iterator iter = stylesheetSet.iterator();
        while (iter.hasNext()) {
            String stylesheet = (String)iter.next();
            if (null != stylesheet) {
                String locStylesheet = rfm.getLocalizedPath(stylesheet, session, stylesheetSet.getLocale(), stylesheetSet.getSkin());
                if (null != locStylesheet) {
                    localizedStylesheets.add(locStylesheet);
                    continue;
                }
                D.log((String)("Could not find resource file mapping for stylesheet: " + stylesheet), (int)1);
                continue;
            }
            D.log((String)("Null stylesheet found in set for: " + stylesheetSet.getLocator()), (int)1);
        }
        return localizedStylesheets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetStylesheetSet() {
        TreeMap treeMap = sm_stylesheetTree;
        synchronized (treeMap) {
            sm_stylesheetTree.clear();
            sm_iStyleSheetNameCounter = 0;
            GadgetManager.getRenderer().clearStylesheetCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getStyleSheetForContainedSet(HashSet stylesheetSet, HttpServletRequest req) {
        String stylesheetURI = null;
        Object[] stylesheetArray = new String[stylesheetSet.size()];
        stylesheetArray = stylesheetSet.toArray(stylesheetArray);
        Arrays.sort(stylesheetArray);
        TreeMap treeMap = sm_stylesheetTree;
        synchronized (treeMap) {
            stylesheetURI = (String)sm_stylesheetTree.get(stylesheetArray);
            if (null == stylesheetURI) {
                stylesheetURI = GadgetManager.createStylesheet((String[])stylesheetArray, req);
                sm_stylesheetTree.put(stylesheetArray, stylesheetURI);
            }
        }
        return stylesheetURI;
    }

    public static String getStylesheetURIForFile(String fileName) {
        String stylesheetURI = null;
        stylesheetURI = GadgetManager.getPublishedResourcePathRelToCX() + WORKING_STYLESHEETS_BASE_PATH + "/" + System.getProperty(instanceID_PROPERTY, System.getProperty(instanceIP_PROPERTY, "")) + System.getProperty(directHttpPort_PROPERTY, "") + fileName;
        return stylesheetURI;
    }

    protected static String createStylesheet(String[] stylesheetArray, HttpServletRequest req) {
        String fileName = Integer.toString(sm_iStyleSheetNameCounter++) + ".xsl";
        String portalBasePath = WebappUtil.getRealPath(GadgetManager.getPublishedResourcePathRelToCX());
        try {
            OutputStreamWriter fw;
            File file = new File(portalBasePath + WORKING_STYLESHEETS_BASE_PATH + "/" + System.getProperty(instanceID_PROPERTY, System.getProperty(instanceIP_PROPERTY, "")) + System.getProperty(directHttpPort_PROPERTY, "") + fileName);
            if (!file.createNewFile()) {
                file.delete();
                file.createNewFile();
            }
            if (null != (fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"))) {
                fw.write(XSL_FILE_HEADER);
                fw.flush();
                for (int i = 0; i < stylesheetArray.length; ++i) {
                    fw.write("<xsl:include href=\"");
                    String stylesheet = stylesheetArray[i];
                    if (stylesheet.length() > 0 && stylesheet.charAt(0) == '/') {
                        fw.write("file:///" + WebappUtil.getRealPath("/"));
                    }
                    fw.write(stylesheet);
                    fw.write("\"/>");
                }
                fw.write(XSL_FILE_MAIN_TEMPLATE);
                fw.write(XSL_FILE_FOOTER);
                fw.flush();
                fw.close();
            } else {
                D.log((String)"Couldn't open the main stylesheet!", (int)1);
            }
        }
        catch (IOException e) {
            D.log((Throwable)e);
        }
        return GadgetManager.getStylesheetURIForFile(fileName);
    }

    protected boolean customContentType(HttpServletRequest req) {
        String obj = req.getParameter(CUSTOM_CONTENT_TYPE);
        return obj != null;
    }

    public static String createGadgetXMLStartTag(GadgetInstance gadgetInstance, HttpServletRequest req, PortalSession session) {
        GadgetAssignment gadgetAssignment = gadgetInstance.getGadgetAssignment();
        StringBuffer gadgetTag = new StringBuffer(255);
        gadgetTag.append("<Gadget title=\"");
        gadgetTag.append(gadgetAssignment.getProcessedAssignmentName((FwSession)session));
        gadgetTag.append("\" id=\"");
        gadgetTag.append(gadgetInstance.getRootDelegator());
        gadgetTag.append("\" container=\"");
        gadgetTag.append("n\" ");
        gadgetTag.append("top=\"y\" ");
        gadgetTag.append("position=\"");
        String position = gadgetAssignment.getLocation();
        if (null != position) {
            if (position.equals("Body")) {
                position = gadgetAssignment.getColumn();
            }
        } else {
            return null;
        }
        gadgetTag.append(position);
        gadgetTag.append("\" priority=\"");
        gadgetTag.append(gadgetAssignment.getPriority());
        if (gadgetAssignment.hasFrame()) {
            gadgetTag.append("\" hasframe=\"y\"");
        } else {
            gadgetTag.append("\" hasframe=\"n\"");
        }
        gadgetTag.append(" state=\"");
        gadgetTag.append(gadgetInstance.getWindowState());
        gadgetTag.append("\"");
        if (gadgetInstance instanceof SecretStoreGadget && ((SecretStoreGadget)gadgetInstance).usesSecretStore()) {
            gadgetTag.append(" ssGad=\"y\"");
        }
        if (gadgetInstance.hasHelp()) {
            try {
                String helpURL = gadgetInstance.getLocHelpURL(req);
                if (null != helpURL) {
                    gadgetTag.append(" ");
                    gadgetTag.append(HELP_SUPPORT_PARAM_NAME);
                    gadgetTag.append("=\"");
                    gadgetTag.append(req.getContextPath());
                    gadgetTag.append(helpURL);
                    gadgetTag.append("\"");
                }
            }
            catch (Exception e) {
                D.log((String)("Error getting help url for gadget:" + gadgetInstance.getGadgetAssignment().getAssignmentName()), (int)1);
                D.log((Throwable)e);
            }
        }
        if (gadgetAssignment.getIsUserConfigurable((FwSession)session)) {
            gadgetTag.append(" ");
            gadgetTag.append(CONFIG_PARAM_NAME);
            gadgetTag.append("=\"y\"");
        }
        gadgetTag.append(" allowClose=\"");
        if (gadgetAssignment.isAssignmentOverwriteable()) {
            gadgetTag.append("y");
        } else {
            gadgetTag.append("n");
        }
        if (gadgetAssignment.allowTearaway()) {
            gadgetTag.append("\" allowTearaway=\"y");
            gadgetTag.append("\" tearawayWidth=\"");
            gadgetTag.append(String.valueOf(gadgetAssignment.getTearawayWidth()));
            gadgetTag.append("\" tearawayHeight=\"");
            gadgetTag.append(String.valueOf(gadgetAssignment.getTearawayHeight()));
        }
        gadgetTag.append("\"");
        gadgetTag.append(">");
        return gadgetTag.toString();
    }

    public static String createCustomAssignmentConfigTags(GadgetInstance gadgetInstance) {
        Collection co;
        GadgetAssignment gadgetAssignment = gadgetInstance.getGadgetAssignment();
        ConfigData cd = gadgetAssignment.getCustomAssignmentConfig();
        if (cd != null && !cd.isEmpty() && (co = cd.getSettingsCollection()) != null) {
            StringBuffer sbCustomConfigTags = new StringBuffer(30 + 100 * co.size());
            sbCustomConfigTags.append("<CustomConfig>");
            Iterator iter = co.iterator();
            Setting tempSetting = null;
            Vector vValues = null;
            SettingValue tempSV = null;
            while (iter.hasNext()) {
                tempSetting = (Setting)iter.next();
                vValues = tempSetting.getValues();
                if (vValues == null || vValues.size() == 0) continue;
                sbCustomConfigTags.append("<Setting>");
                sbCustomConfigTags.append("<Name>");
                sbCustomConfigTags.append("<![CDATA[");
                sbCustomConfigTags.append(tempSetting.getName());
                sbCustomConfigTags.append("]]>");
                sbCustomConfigTags.append("</Name>");
                Enumeration eValues = vValues.elements();
                while (eValues.hasMoreElements()) {
                    tempSV = (SettingValue)eValues.nextElement();
                    sbCustomConfigTags.append("<Value>");
                    sbCustomConfigTags.append("<![CDATA[");
                    sbCustomConfigTags.append(tempSV.getValue());
                    sbCustomConfigTags.append("]]>");
                    sbCustomConfigTags.append("</Value>");
                }
                sbCustomConfigTags.append("</Setting>");
            }
            sbCustomConfigTags.append("</CustomConfig>");
            return sbCustomConfigTags.toString();
        }
        return null;
    }

    private void writeResources(HttpServletRequest req, PortalSession session, BufferedWriter out) throws IOException {
        String resources = (String)session.getAttribute(SESSION_RESOURCES_ATTRIB);
        if (resources != null) {
            out.write("<Resources>");
            out.write(resources);
            out.write("</Resources>");
        }
    }

    protected static void writeSessionInfo(HttpServletRequest req, PortalSession session, BufferedWriter out) throws IOException {
        out.write("<SessionInfo>");
        XmlUtil.writeTag("BrowserXSLSupport", String.valueOf(false), out);
        XmlUtil.writeCDataTag("DeviceType", FwUtils.getDeviceType((HttpSession)session), out);
        XmlUtil.writeCDataTag("UserAgent", FwUtils.getBrowserId((HttpSession)session), out);
        out.write("<CurrentLocale>");
        out.write((String)session.getAttribute("ClientLocale"));
        out.write("</CurrentLocale>");
        out.write("<User>");
        String userDN = "Unknown";
        String userCN = "Unknown";
        userDN = session.getUserDN();
        userCN = session.getUserCN();
        XmlUtil.writeCDataTag("CN", userCN, out);
        XmlUtil.writeCDataTag("DN", userDN, out);
        out.write("</User>");
        out.write("<Custom>");
        GadgetManager.writeCustomData(session, out);
        out.write("</Custom>");
        out.write("<AuthInfo><State><![CDATA[");
        out.write(AuthenticationManager.getAuthenticationState(session));
        out.write("]]></State></AuthInfo>");
        GadgetManager.writeWebAppInfo(req, session, out);
        out.write("</SessionInfo>");
    }

    protected static void writeCustomData(PortalSession session, BufferedWriter out) throws IOException {
        if (null != sm_sCustomSessionData && sm_sCustomSessionData.length() > 0) {
            String settings;
            String parsedSettings;
            String customSessionDataSettings = (String)session.getAttribute(Custom_Session_Data);
            if (null == customSessionDataSettings && (customSessionDataSettings = (parsedSettings = NPSMacroParser.parseMacroString(settings = sm_sCustomSessionData, session, false))).indexOf("systemtime") == -1) {
                session.setAttribute(Custom_Session_Data, customSessionDataSettings);
            }
            out.write(customSessionDataSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeWebAppInfo(HttpServletRequest req, PortalSession session, BufferedWriter out) throws IOException {
        block14: {
            try {
                out.write("<WebAppInfo>");
                RequestServletManager provider = (RequestServletManager)req.getAttribute("ServletManager");
                if (null != provider) {
                    provider.writeWebAppInfo(req, session, out);
                    break block14;
                }
                try {
                    out.write("<Servlets>");
                    if (null != FwAttr.getFwRequestAttribute((String)NPSERVICE, (HttpServletRequest)req)) {
                        StringBuffer sb = new StringBuffer(90 + 5 * req.getContextPath().length());
                        sb.append("<Normal>");
                        sb.append(req.getContextPath());
                        sb.append(req.getServletPath());
                        sb.append("?</Normal>");
                        sb.append("<FullPage>");
                        sb.append(req.getContextPath());
                        sb.append(FullPageServletAndTag_STRING);
                        sb.append(CustomContentServletStartTag_STRING);
                        sb.append(req.getContextPath());
                        sb.append(CustomContentServletAndEndTag_STRING);
                        sb.append("<FullFrame>");
                        sb.append(req.getContextPath());
                        sb.append(FullFrameServletAndEndTag_STRING);
                        out.write(sb.toString());
                    } else if (null != req.getAttribute(NPFULLPAGE)) {
                        if (null == NormalFullpageServlets_STRING) {
                            StringBuffer sb = new StringBuffer(90 + 4 * req.getContextPath().length());
                            sb.append("<Normal>");
                            sb.append(req.getContextPath());
                            sb.append(NormalFullpageServletAndEndTag_STRING);
                            sb.append("<FullPage>");
                            sb.append(req.getContextPath());
                            sb.append(FullPageServletAndTag_STRING);
                            sb.append(CustomContentServletStartTag_STRING);
                            sb.append(req.getContextPath());
                            sb.append(CustomContentServletAndEndTag_STRING);
                            sb.append("<FullFrame>");
                            sb.append(req.getContextPath());
                            sb.append(FullFrameServletAndEndTag_STRING);
                            NormalFullpageServlets_STRING = sb.toString();
                        }
                        out.write(NormalFullpageServlets_STRING);
                    } else {
                        if (null == PortalServlets_STRING) {
                            StringBuffer sb = new StringBuffer(90 + 4 * req.getContextPath().length());
                            sb.append("<Normal>");
                            sb.append(req.getContextPath());
                            sb.append(NormalServletAndEndTag_STRING);
                            sb.append("<FullPage>");
                            sb.append(req.getContextPath());
                            sb.append(FullPageServletAndTag_STRING);
                            sb.append(CustomContentServletStartTag_STRING);
                            sb.append(req.getContextPath());
                            sb.append(CustomContentServletAndEndTag_STRING);
                            sb.append("<FullFrame>");
                            sb.append(req.getContextPath());
                            sb.append(FullFrameServletAndEndTag_STRING);
                            PortalServlets_STRING = sb.toString();
                        }
                        out.write(PortalServlets_STRING);
                    }
                }
                finally {
                    out.write("</Servlets>");
                }
                if (null == Resources_STRING) {
                    Resources_STRING = ConfigManager.getPortalSetting("Resource String", ResourcesStartTag_STRING + WebappUtil.getContext() + ResourcesPathAndEndTag_STRING);
                }
                out.write(Resources_STRING);
            }
            finally {
                out.write("</WebAppInfo>");
            }
        }
    }

    public String getNormalServletReference(HttpServletRequest req, PortalSession session) {
        RequestServletManager rsManager = (RequestServletManager)req.getAttribute(NPSERVLETMANAGER);
        if (null != rsManager) {
            return rsManager.getNormalServletReference(req, session);
        }
        if (null != FwAttr.getFwRequestAttribute((String)NPSERVICE, (HttpServletRequest)req)) {
            return this.getServiceServletReference(req);
        }
        if (null != req.getAttribute(NPFULLPAGE)) {
            return this.getNormalFullpageServletReference(req);
        }
        return this.getNormalServletReference(req);
    }

    public static String getFullPageServletReference(HttpServletRequest req, PortalSession session) {
        RequestServletManager rsManager = (RequestServletManager)req.getAttribute(NPSERVLETMANAGER);
        if (null != rsManager) {
            return rsManager.getFullPageServletReference(req, session);
        }
        return GadgetManager.getFullpageServletReference(req);
    }

    public static String getCustomContentServletReference(HttpServletRequest req, PortalSession session) {
        RequestServletManager rsManager = (RequestServletManager)req.getAttribute(NPSERVLETMANAGER);
        if (null != rsManager) {
            return rsManager.getCustomContentServletReference(req, session);
        }
        return GadgetManager.getCustomContentServletReference(req);
    }

    private String getServiceServletReference(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(req.getContextPath().length() + req.getServletPath().length() + 1);
        sb.append(req.getContextPath());
        sb.append(req.getServletPath());
        return sb.toString();
    }

    private String getNormalServletReference(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(req.getContextPath().length() + NormalServlet_STRING.length() + 1);
        sb.append(req.getContextPath());
        sb.append(NormalServlet_STRING);
        return sb.toString();
    }

    private String getNormalFullpageServletReference(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(req.getContextPath().length() + NormalFullpageServlet_STRING.length() + 1);
        sb.append(req.getContextPath());
        sb.append(NormalFullpageServlet_STRING);
        return sb.toString();
    }

    private static String getFullpageServletReference(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(req.getContextPath().length() + FullPageServlet_STRING.length() + 1);
        sb.append(req.getContextPath());
        sb.append(FullPageServlet_STRING);
        return sb.toString();
    }

    private static String getCustomContentServletReference(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(req.getContextPath().length() + CustomContentServlet_STRING.length() + 1);
        sb.append(req.getContextPath());
        sb.append(CustomContentServlet_STRING);
        return sb.toString();
    }

    public void init() {
        AuthenticationManager.addAuthenticationListener(this);
        String sUseJAXP = ConfigManager.getPortalSetting("System.renderer.UseJAXP", "false");
        m_renderer = "true".equalsIgnoreCase(sUseJAXP) ? new JaxpRendererImpl() : new NxslRendererImpl();
        m_renderer.resetCacheStylesheets();
        m_renderer.setPrintTimes(D.isDebugEnabled((int)3) || "true".equalsIgnoreCase(ConfigManager.getPortalSetting(DISPLAY_RENDERING_TIMES)));
        GadgetManager.getAndValidateCustomSessionData();
    }

    public static void refreshPortalSettingDependencies() {
        m_renderer.resetCacheStylesheets();
        m_renderer.setPrintTimes(D.isDebugEnabled((int)3) || "true".equalsIgnoreCase(ConfigManager.getPortalSetting(DISPLAY_RENDERING_TIMES)));
        sm_sAbsoluteServletContext = null;
        GadgetManager.getAndValidateCustomSessionData();
    }

    private static void getAndValidateCustomSessionData() {
        String[] saCustSessData = ConfigManager.getPortalSettings(Custom_Session_Data);
        if (saCustSessData != null && saCustSessData.length > 0) {
            StringBuffer sbNewSessData = new StringBuffer(saCustSessData.length * 50);
            for (int i = 0; i < saCustSessData.length; ++i) {
                String setting = saCustSessData[i];
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    ByteArrayInputStream ba = new ByteArrayInputStream(setting.getBytes("utf8"));
                    builder.parse(ba);
                    continue;
                }
                catch (Exception e) {
                    D.log((String)("Invalid CustomSessionData value:  " + setting), (int)1);
                    D.log((Throwable)e);
                    return;
                }
            }
            sm_sCustomSessionData = sbNewSessData.toString();
        }
    }

    public GadgetInstance createGadget(String gadgetClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> newClass = null;
        try {
            newClass = Class.forName(gadgetClass);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException(gadgetClass);
        }
        return (GadgetInstance)newClass.newInstance();
    }

    public static void registerGadgetInstance(GadgetInstance gadgetInstance, PortalSession session) {
        if (null != gadgetInstance) {
            String gadgetInstanceID = gadgetInstance.getGadgetInstanceID();
            if (gadgetInstanceID == null || gadgetInstanceID.length() == 0) {
                gadgetInstanceID = GadgetManager.createGadgetInstanceID(gadgetInstance, session);
                gadgetInstance.setGadgetInstanceID(gadgetInstanceID);
            }
            GadgetManager.registerGadgetInstance(gadgetInstance, gadgetInstanceID, session);
        } else {
            D.log((String)"GadgetManager.registerGadgetInstance(GadgetInstance, PortalSession) passed null GadgetInstance!", (int)1);
        }
    }

    protected static void registerGadgetInstance(GadgetInstance gadgetInstance, String gadgetInstanceID, PortalSession session) {
        if (null != gadgetInstance) {
            Hashtable<String, GadgetInstance> gadgetInstances = (Hashtable<String, GadgetInstance>)session.getAttribute(SESSION_GADGET_INSTANCES);
            if (null == gadgetInstances) {
                gadgetInstances = new Hashtable<String, GadgetInstance>();
            }
            gadgetInstances.put(gadgetInstanceID, gadgetInstance);
            session.setAttribute(SESSION_GADGET_INSTANCES, gadgetInstances);
        } else {
            D.log((String)"GadgetManager.registerGadgetInstance(GadgetInstance, PortalSession) passed null GadgetInstance!", (int)2);
        }
    }

    public static String createGadgetInstanceID(GadgetInstance gadgetInstance, PortalSession session) {
        String gadgetInstanceID = gadgetInstance.getGadgetAssignment().getServiceName();
        if (null == gadgetInstanceID) {
            int totalGadgetInstances = 0;
            Integer totalGadgetInstancesInteger = (Integer)session.getAttribute(SESSION_TOTAL_GADGET_INSTANCES);
            if (null != totalGadgetInstancesInteger) {
                totalGadgetInstances = totalGadgetInstancesInteger;
            }
            session.setAttribute(SESSION_TOTAL_GADGET_INSTANCES, new Integer(++totalGadgetInstances));
            String useClassNames = ConfigManager.getSingleSetting(USE_CLASS_NAME_IN_ID, "false");
            if (useClassNames.equalsIgnoreCase("true")) {
                String giClassName = gadgetInstance.getClass().getName();
                int lastDot = giClassName.lastIndexOf(46);
                if (lastDot != -1) {
                    giClassName = giClassName.substring(lastDot);
                }
                gadgetInstanceID = giClassName + String.valueOf(totalGadgetInstances);
            } else {
                gadgetInstanceID = String.valueOf(totalGadgetInstances);
            }
        }
        return gadgetInstanceID;
    }

    public static String getSystemStyleSheetPath() {
        return GadgetManager.getPublishedResourcePathRelToCX() + STYLESHEETS_BASE_PATH + "/";
    }

    public void loginEvent(PortalSession session) {
        this.releaseAllGadgets(session);
        session.removeAttribute(SESSION_TOTAL_GADGET_INSTANCES);
        session.removeAttribute(Custom_Session_Data);
    }

    public void preLogoutEvent(PortalSession session) {
    }

    public void postLogoutEvent(PortalSession session) {
        this.releaseAllGadgets(session);
        session.removeAttribute(SESSION_TOTAL_GADGET_INSTANCES);
        session.removeAttribute(Custom_Session_Data);
    }

    private void releaseAllGadgets(PortalSession session) {
        Hashtable gadgetInstances = (Hashtable)session.getAttribute(SESSION_GADGET_INSTANCES);
        if (null != gadgetInstances) {
            String sServiceName = null;
            GadgetInstance gadgetInstance = null;
            GadgetInstance giMainPage = null;
            if (null == session.getAttribute(SESSION_KEEP_MAINPAGE_INSTANCE)) {
                session.removeAttribute(SESSION_MAIN_PAGE_GADGET_INSTANCE_PROPERTY);
            } else {
                giMainPage = GadgetManager.getMainPageGadgetInstance(session);
                if (giMainPage != null && D.isDebugEnabled((int)3)) {
                    D.log((String)("Preserving MainPageID: " + giMainPage.getGadgetInstanceID()));
                }
            }
            Set set = gadgetInstances.keySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                sServiceName = (String)it.next();
                if (sServiceName == null) continue;
                gadgetInstance = (GadgetInstance)gadgetInstances.get(sServiceName);
                if (D.isDebugEnabled((int)3)) {
                    D.log((String)("Releasing ID: " + gadgetInstance.getGadgetInstanceID()));
                }
                gadgetInstance.release();
            }
            gadgetInstances.clear();
            if (giMainPage != null) {
                gadgetInstances.put(giMainPage.getGadgetInstanceID(), giMainPage);
            }
            session.setAttribute(SESSION_GADGET_INSTANCES, gadgetInstances);
        }
    }

    public static void releaseGadgets(PortalSession session, String sKey) {
        Hashtable giHash = (Hashtable)session.getAttribute(SESSION_GADGET_INSTANCES);
        if (null != giHash) {
            Set set = giHash.keySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                GadgetInstance gi;
                String sRegKey;
                String sServiceName = (String)it.next();
                if (sServiceName == null || ((sRegKey = (gi = (GadgetInstance)giHash.get(sServiceName)).getGadgetAssignment().getRegistrationKey()) != null || sKey != null) && (sRegKey == null || sKey == null || !sKey.equalsIgnoreCase(sRegKey))) continue;
                if (D.isDebugEnabled((int)3)) {
                    D.log((String)("Releasing ID: " + gi.getGadgetInstanceID()));
                }
                gi.release();
            }
        }
    }

    public static String getGadgetInstanceActionIconsXML(HttpServletRequest req, GadgetInstance gadgetInstance) {
        GadgetInstanceActionIcon[] gadgetActionIcons = gadgetInstance.getActionIcons(req);
        if (gadgetActionIcons != null && gadgetActionIcons.length > 0) {
            StringBuffer buffer = new StringBuffer(15 + gadgetActionIcons.length * 50);
            buffer.append("<Icons>");
            for (int i = 0; i < gadgetActionIcons.length; ++i) {
                GadgetInstanceActionIcon actionIcon = gadgetActionIcons[i];
                if (actionIcon == null) continue;
                buffer.append(actionIcon.toXML());
            }
            buffer.append("</Icons>");
            return buffer.toString();
        }
        return null;
    }

    public static Renderer getRenderer() {
        return m_renderer;
    }

    public static void setRenderer(Renderer newRenderer) {
        m_renderer = newRenderer;
    }

    public static ResourceFileMap getSystemResourceFileMap() {
        return ResourceFileManager.getSystemResourceFileMap();
    }

    public static ResourceFileMap getGadgetResourceFileMap(GadgetInstance gadgetInstance) {
        ResourceFileMap rfm = null;
        if (gadgetInstance != null) {
            Class<?> gadget = gadgetInstance.getClass();
            rfm = GadgetManager.getGadgetResourceFileMap(gadget.getName());
        }
        return rfm;
    }

    public static ResourceFileMap getGadgetResourceFileMap(String gadgetInstanceClassName) {
        return ResourceFileManager.getResourceFileMap(gadgetInstanceClassName);
    }

    public static String getModulesUrl(HttpServletRequest req) {
        String webappName = req.getContextPath();
        return webappName + "/portal/modules";
    }

    public static String locateUrl(String moduleAndFileName, HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(128);
        int slashIndex = moduleAndFileName.indexOf(47);
        if (slashIndex != -1) {
            String file;
            String module = moduleAndFileName.substring(0, slashIndex);
            try {
                file = moduleAndFileName.substring(slashIndex + 1);
            }
            catch (IndexOutOfBoundsException e) {
                file = "";
            }
            sb.append("/portal/modules/").append(module).append("/skins/default/devices/default/").append(file);
        }
        return sb.toString();
    }

    public static GadgetInstance delegateToGadget(GadgetInstance delegator, PortalSession session, HttpServletRequest req, String delegateServiceName, int delegationType) throws PortalException {
        GadgetInstance delegate = GadgetManager.getDelegateGadgetInstance(delegateServiceName, session, req, delegationType);
        FwUtils.resetBGI((LegacyTask)((LegacyTask)delegate), (HttpServletRequest)req);
        req.setAttribute(DELEGATING_ATTRIBUTE, (Object)Boolean.TRUE.toString());
        GadgetManager.switchGadgetInstanceInTableAndAddToDelegatorStack(delegator, delegate, session);
        delegate.processRequest(req);
        delegate.setLaunchType(2);
        return delegate;
    }

    public static void returnToDelegator(GadgetInstance secondary, String status, Object results, HttpServletRequest req) {
        GadgetManager.returnToDelegator(secondary, status, results, req, false);
    }

    public static void returnToDelegator(GadgetInstance secondary, String status, Object results, HttpServletRequest req, boolean skipProcessResults) {
        GadgetManager.endSecondaryGadgetLifecycle(secondary, (PortalSession)req.getSession());
        GadgetInstance primary = GadgetManager.getPrimaryForSecondary(secondary, (PortalSession)req.getSession());
        secondary.setRedirectionOrSelf(primary);
        primary.setRedirectionOrSelf(primary);
        if (primary != null) {
            GadgetManager.restoreGadgetInstanceInTableandRemoveDelegatorFromStack(primary, secondary, (PortalSession)req.getSession());
            if (!skipProcessResults) {
                primary.processSecondaryGadgetResults(req, secondary, status, results);
            }
        }
    }

    public static GadgetInstance launchGadget(GadgetInstance launcher, PortalSession session, HttpServletRequest req, String launchServiceName, int delegationType) throws PortalException {
        GadgetInstance launchedGadget = GadgetManager.getDelegateGadgetInstance(launchServiceName, session, req, delegationType);
        launchedGadget.setPrimary(launcher);
        launchedGadget.processRequest(req);
        launchedGadget.setLaunchType(1);
        return launchedGadget;
    }

    public static void returnToLauncher(GadgetInstance secondary, String status, Object results, HttpServletRequest req) {
        GadgetManager.endSecondaryGadgetLifecycle(secondary, (PortalSession)req.getSession());
        GadgetInstance primary = GadgetManager.getPrimaryForSecondary(secondary, (PortalSession)req.getSession());
        if (primary != null) {
            primary.processSecondaryGadgetResults(req, secondary, status, results);
            secondary.setRedirectionOrSelf(primary);
        }
    }

    private static GadgetInstance getPrimaryForSecondary(GadgetInstance secondary, PortalSession session) {
        return secondary.getPrimary();
    }

    private static void endSecondaryGadgetLifecycle(GadgetInstance secondary, PortalSession session) {
        int lifecycleType = secondary.getLifeCycleType();
        switch (lifecycleType) {
            case 1: {
                GadgetManager.releaseGadgetInstance(secondary, session);
            }
            case 2: {
                secondary.reset();
                GadgetManager.returnGadgetInstanceToPool(secondary, session);
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                GadgetManager.releaseGadgetInstance(secondary, session);
            }
        }
    }

    public static GadgetInstance getDelegateGadgetInstance(String delegateServiceName, PortalSession session, HttpServletRequest req, int delegationType) throws PortalException {
        GadgetInstance delegateGadget = null;
        switch (delegationType) {
            case 2: {
                delegateGadget = GadgetManager.getResetGadgetInstanceFromPool(delegateServiceName, session);
                break;
            }
            case 1: {
                delegateGadget = GadgetManager.createNewGadgetInstanceFromServiceAssignment(delegateServiceName, session);
                break;
            }
            case 3: 
            case 4: {
                delegateGadget = GadgetManager.getExactGadgetInstance(delegateServiceName, session);
                if (delegationType != 3) break;
                delegateGadget.reset();
                break;
            }
            case 5: {
                delegateGadget = GadgetManager.getExistingGadgetInstance(delegateServiceName, session);
                if (delegateGadget != null) {
                    GadgetManager.releaseGadgetInstance(delegateGadget, session);
                }
                delegateGadget = GadgetManager.getExactGadgetInstance(delegateServiceName, session);
                break;
            }
            default: {
                String msg = "Unsupported Deletation type:  " + delegationType;
                D.log((String)msg, (int)1);
                throw new PortalException(msg);
            }
        }
        if (delegateGadget == null) {
            delegateGadget = GadgetManager.getErrorService(session, delegateServiceName);
        } else {
            delegateGadget.setLifeCycleType(delegationType);
        }
        return delegateGadget;
    }

    private static GadgetInstance createNewGadgetInstanceFromServiceAssignment(String delegateServiceName, PortalSession session) {
        GadgetAssignment assn = GadgetManager.getServiceAssignment(session, delegateServiceName);
        GadgetInstance gadget = null;
        assn = assn.copy();
        Random rnd = new Random();
        boolean done = false;
        String newServiceName = null;
        while (!done) {
            newServiceName = assn.getServiceName() + "~" + rnd.nextInt(40);
            gadget = GadgetManager.getExistingGadgetInstance(newServiceName, session);
            if (gadget != null) continue;
            done = true;
        }
        assn.setServiceName(newServiceName);
        assn.setOriginalServiceName(delegateServiceName);
        return GadgetManager.createGadgetInstance(assn, session);
    }

    private static GadgetInstance getResetGadgetInstanceFromPool(String delegateServiceName, PortalSession session) {
        List instancePool;
        GadgetInstance gadget = null;
        Hashtable pools = (Hashtable)session.getAttribute(SESSION_DELEGATE_GADGET_POOLS);
        if (pools == null) {
            pools = new Hashtable();
            session.setAttribute(SESSION_DELEGATE_GADGET_POOLS, pools);
        }
        gadget = (instancePool = (List)pools.get(delegateServiceName)) != null ? (!instancePool.isEmpty() ? (GadgetInstance)instancePool.remove(0) : GadgetManager.createNewGadgetInstanceFromServiceAssignment(delegateServiceName, session)) : GadgetManager.createNewGadgetInstanceFromServiceAssignment(delegateServiceName, session);
        return gadget;
    }

    private static void returnGadgetInstanceToPool(GadgetInstance gadgetInstance, PortalSession session) {
        LinkedList<GadgetInstance> instancePool;
        gadgetInstance.reset();
        Hashtable<String, LinkedList<GadgetInstance>> pools = (Hashtable<String, LinkedList<GadgetInstance>>)session.getAttribute(SESSION_DELEGATE_GADGET_POOLS);
        String instanceID = gadgetInstance.getGadgetInstanceID();
        String serviceName = instanceID.substring(instanceID.length() - 4);
        if (pools == null) {
            pools = new Hashtable<String, LinkedList<GadgetInstance>>();
            session.setAttribute(SESSION_DELEGATE_GADGET_POOLS, pools);
        }
        if ((instancePool = (LinkedList<GadgetInstance>)pools.get(serviceName)) == null) {
            instancePool = new LinkedList<GadgetInstance>();
            pools.put(serviceName, instancePool);
        }
        instancePool.add(gadgetInstance);
    }

    private static void releaseGadgetInstance(GadgetInstance delegateGadget, PortalSession session) {
        Hashtable gadgetInstances;
        GadgetInstance gadget;
        if (delegateGadget == null) {
            return;
        }
        if (D.isDebugEnabled((int)3)) {
            D.log((String)("Releasing ID: " + delegateGadget.getGadgetInstanceID()));
        }
        if ((gadget = (GadgetInstance)(gadgetInstances = (Hashtable)session.getAttribute(SESSION_GADGET_INSTANCES)).remove(delegateGadget.getGadgetInstanceID())) != null) {
            gadget.release();
            if (gadget.getGadgetAssignment().getChainedServices() != null) {
                GadgetManager.releaseFromJobsTable(gadget.getGadgetAssignment(), session);
            }
        }
    }

    private static void switchGadgetInstanceInTableAndAddToDelegatorStack(GadgetInstance delegator, GadgetInstance delegate, PortalSession session) {
        String rootDelegatorID = GadgetManager.getRootDelegatorID(delegator, session);
        delegate.setRootDelegator(rootDelegatorID);
        delegate.setPrimary(delegator);
        if (delegate.getRedirectionOrSelf() == delegator) {
            delegate.setRedirectionOrSelf(null);
        }
        delegator.setRedirectionOrSelf(delegate);
        Hashtable gadgetInstances = (Hashtable)session.getAttribute(SESSION_GADGET_INSTANCES);
        if (gadgetInstances != null) {
            gadgetInstances.remove(rootDelegatorID);
            gadgetInstances.put(rootDelegatorID, delegate);
        }
    }

    private static void restoreGadgetInstanceInTableandRemoveDelegatorFromStack(GadgetInstance delegator, GadgetInstance delegate, PortalSession session) {
        String rootDelegatorID = delegate.getRootDelegator();
        Hashtable gadgetInstances = (Hashtable)session.getAttribute(SESSION_GADGET_INSTANCES);
        if (gadgetInstances != null) {
            gadgetInstances.remove(rootDelegatorID);
            gadgetInstances.put(rootDelegatorID, delegator);
        }
    }

    private static String getRootDelegatorID(GadgetInstance delegator, PortalSession session) {
        String rootDelegatorID = delegator.getRootDelegator();
        return rootDelegatorID;
    }

    public static String getOriginalServiceNameFromId(String gadgetInstanceID, PortalSession session) {
        return FwUtils.getTaskId((String)gadgetInstanceID);
    }

    public static void supportsDeviceCharacteristics(HttpServletRequest req, String sServiceName) throws Exception {
        PortalSession session = (PortalSession)req.getSession();
        GadgetAssignment tempGA = GadgetManager.getServiceAssignment(session, sServiceName);
        if (tempGA != null) {
            String sDeviceType;
            ArrayList al = tempGA.getSupportedDevices();
            if (al != null && al.size() != 0 && (sDeviceType = FwUtils.getDeviceType((HttpSession)session)) != null) {
                String sSupportedType = null;
                boolean bFoundDeviceType = false;
                for (int i = 0; i < al.size(); ++i) {
                    sSupportedType = (String)al.get(i);
                    if (!sDeviceType.equalsIgnoreCase(sSupportedType)) continue;
                    bFoundDeviceType = true;
                    break;
                }
                if (!bFoundDeviceType) {
                    String sExceptionMessage = null;
                    try {
                        Locale locale = FwUtils.getCurrentLocale((HttpSession)session);
                        ResourceBundle rb = ResourceBundle.getBundle("FwResources", locale);
                        if (rb != null) {
                            sExceptionMessage = rb.getString("PluginError.DeviceNotSupported");
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (sExceptionMessage != null && sExceptionMessage.length() != 0) {
                        throw new DeviceUnsupportedException(sExceptionMessage);
                    }
                    throw new DeviceUnsupportedException();
                }
            }
        } else {
            String sExceptionMessage = null;
            try {
                ResourceBundle res = ConfigManager.getUserResourceBundle(session);
                if (res != null) {
                    sExceptionMessage = res.getString("Service_Not_Found");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (sExceptionMessage != null && sExceptionMessage.length() != 0) {
                throw new DeviceUnsupportedException(sExceptionMessage);
            }
            throw new DeviceUnsupportedException();
        }
    }

    public static ManagementServiceSet getManagementServiceSet(PortalSession session) {
        return AuthenticationManager.getManagementServiceSet(session, 3);
    }

    static {
        systemStylesheets = new Vector();
        globalStylesheets = new Vector();
        systemStylesheetsArray = new String[]{"main.xsl", "main_lang.xsl"};
        globalStylesheetsArray = new String[]{"globalvariables.xsl", "SystemMessages.xsl", "main_lang.xsl"};
        GadgetManager.setSystemStylesheets(systemStylesheetsArray);
        GadgetManager.setGlobalStylesheets(globalStylesheetsArray);
        systemStylesheetSet = new StylesheetSet("System.ResourceFileMap", systemStylesheets);
        globalStylesheetSet = new StylesheetSet("System.ResourceFileMap", globalStylesheets);
        m_gadgets = new Hashtable();
        sm_defaultGadget = new DefaultGadgetImpl();
        sm_stylesheetTree = new TreeMap(new StringArrayComparator());
        sm_iStyleSheetNameCounter = 0;
        sm_version = NPSVersion.getPortalVersion();
        sm_sVersion = sm_version.toString();
        sm_sMajorVersion = String.valueOf(sm_version.getMajor());
        sm_sMinorVersion = String.valueOf(sm_version.getMinor());
    }
}

