/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.nps.configManager.GUID;
import com.novell.nps.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class NPCookie
implements Serializable {
    private String username = null;
    private String key = null;

    public NPCookie(String username, String key) {
        this.username = username;
        this.key = key;
    }

    public static NPCookie getNewObject(String cookie) {
        byte[] ba = GUID.HexStringAsByte(cookie);
        NPCookie newObject = null;
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(ba);
            ObjectInputStream p = new ObjectInputStream(istream);
            newObject = (NPCookie)p.readObject();
            p.close();
            istream.close();
            return newObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getUserDN() {
        return this.username;
    }

    public String getKey() {
        return this.key;
    }

    public String getObjectAsString() {
        byte[] byteCredentials = null;
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            p.writeObject(this);
            byteCredentials = ostream.toByteArray();
            p.flush();
            ostream.close();
            String temp = "";
            for (int i = 0; i < byteCredentials.length; ++i) {
                temp = temp + GUID.byteAsHexString(byteCredentials[i]);
            }
            return temp;
        }
        catch (Exception e) {
            Debug.log("NPCookie", 1, e);
            return null;
        }
    }
}

