/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.gadgetManager;

import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.BaseGadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.i18n.ResourceFileManager;
import com.novell.nps.i18n.ResourceFileMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;

public class SkinSwitcher
extends BaseGadgetInstance {
    public static final String DT = "SkinSwitcher";
    public static final String PARAM_SKIN_NAME = "name";
    public static final String ACTION_SET_SKIN = "setSkin";
    public static final String STATE_NORMAL = "normal";
    public static final String SESSION_SKIN_OVERRIDE = "SkinSwitcher.SkinOverride";

    public void init(String[] initArgs) {
        this.setState(STATE_NORMAL);
        this.addActionListener(this, ACTION_SET_SKIN);
    }

    public void getNormalData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        this.getData(req, out, domDocument);
    }

    public void getnormalData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        this.getData(req, out, domDocument);
    }

    public void getData(HttpServletRequest req, BufferedWriter out, Document domDocument) throws GadgetInstanceException {
        try {
            this.writeGadgetXMLStartTagWithState(out);
            this.writeGadgetXMLEndTag(out);
        }
        catch (IOException e) {
            throw new GadgetInstanceException(e.getLocalizedMessage());
        }
    }

    public void writeGadgetXMLStartTagWithState(BufferedWriter out) throws IOException {
        StringBuffer xmlTag = new StringBuffer(60);
        xmlTag.append("<");
        xmlTag.append(this.getClass().getName());
        String state = this.getState();
        if (state != null) {
            xmlTag.append(" state=\"");
            xmlTag.append(state);
            xmlTag.append("\"");
        }
        xmlTag.append(">");
        out.write(xmlTag.toString());
    }

    public void onSetSkin(HttpServletRequest req) throws GadgetInstanceException {
        String skinName = req.getParameter(PARAM_SKIN_NAME);
        if (skinName != null && this.isValidSkin(skinName)) {
            this.session.setSkin(skinName);
            this.session.setAttribute(SESSION_SKIN_OVERRIDE, "true");
        } else if (Debug.isLoggable(1)) {
            Debug.log(DT, "The skin specified (" + skinName + ") is not a valid skin available to the portal.");
        }
    }

    public void processRequest(HttpServletRequest req) throws GadgetInstanceException {
        this.onSetSkin(req);
    }

    private boolean isValidSkin(String skinName) {
        Collection systemSkins;
        ResourceFileMap rfm = ResourceFileManager.getSystemResourceFileMap();
        return rfm != null && (systemSkins = rfm.getAvailableSkins()) != null && systemSkins.contains(skinName);
    }
}

