/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.i18n;

import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ResourceFileFilter
implements FileFilter {
    public static final String DT = "ResourceFileFilter";
    public static final String CONFIG_RESOURCE_EXCLUSION_PREFIX = "ResourceExclusion";
    private static final String DEFAULT_EXCLUSION_EXPRESSION = ".*portal(\\\\|/)modules(\\\\|/)[a-z0-9 ]*(\\\\|/)(help|install|images|plugins|javascripts|errors).*";
    private static Pattern excludePattern = null;

    public ResourceFileFilter() {
        Properties portalProperties = ConfigManager.getPortalProperties();
        this.addPatterns(portalProperties);
    }

    public boolean accept(File pathname) {
        boolean bAccept = true;
        bAccept = !this.exclude(pathname.getAbsolutePath());
        return bAccept;
    }

    private boolean exclude(String filePath) {
        boolean bMatches = false;
        Matcher matcher = excludePattern.matcher(filePath);
        bMatches = matcher.matches();
        return bMatches;
    }

    private void addPatterns(Properties properties) {
        StringBuffer sb = new StringBuffer();
        sb.append(DEFAULT_EXCLUSION_EXPRESSION);
        if (properties != null) {
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(CONFIG_RESOURCE_EXCLUSION_PREFIX)) continue;
                String regExp = properties.getProperty(name);
                sb.append("|");
                sb.append(regExp);
            }
        }
        try {
            excludePattern = Pattern.compile(sb.toString());
            if (Debug.isLoggable(3)) {
                Debug.log(3, DT, "Exclude pattern: " + excludePattern.pattern());
            }
        }
        catch (PatternSyntaxException e) {
            Debug.log(DT, e);
        }
    }
}

