/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.i18n;

import com.novell.emframe.fw.FwUtils;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.i18n.ResourceFileFilter;
import com.novell.nps.i18n.ResourceFilePath;
import com.novell.nps.i18n.ResourceFileSearchStrategy;
import com.novell.nps.i18n.SkinPrioritySearchStrategy;
import com.novell.nps.sessionManager.PortalSession;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class ResourceFileMap {
    private static final String DT = "com.novell.nps.i18n.ResourceFileMap";
    protected String basePath = null;
    protected HashMap resourceFiles = new HashMap();
    private static ResourceFileFilter resourceFileFilter = new ResourceFileFilter();
    private static ResourceFileSearchStrategy searchStrategy = new SkinPrioritySearchStrategy();
    public static final String DEFAULT_LANGUAGE = "en";
    protected HashSet availableBaseFiles = new HashSet();
    protected HashSet availableSkins = new HashSet();
    protected HashSet availableDevices = new HashSet();
    protected HashSet availableLocales = new HashSet();
    protected HashMap realResourceFiles = new HashMap();
    public static final String SKINS_DIRECTORY = "skins";
    public static final String DEVICES_DIRECTORY = "devices";
    public static final String DEFAULT_SKIN = "default";
    public static final String DEFAULT_DEVICE = "default";

    public ResourceFileMap() {
        this.init();
    }

    public ResourceFileMap(String basePath) {
        this.basePath = basePath;
        this.init();
    }

    protected void init() {
        this.availableDevices.add("default");
        this.availableSkins.add("default");
    }

    public void refresh() throws FileNotFoundException {
        this.resourceFiles.clear();
        this.realResourceFiles.clear();
        if (this.basePath != null) {
            File basePathFile = new File(this.basePath);
            if (basePathFile.isDirectory()) {
                this.recurseDirectories(basePathFile);
            } else {
                throw new FileNotFoundException("The base path \"" + this.basePath + "\" does not point to a valid directory for a gadget resource path.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deriveReplacement(ResourceFilePath path) {
        if (searchStrategy != null) {
            String hashString;
            HashSet<String> intermediateKeys = new HashSet<String>();
            String originalHashString = path.toHashString();
            intermediateKeys.add(originalHashString);
            ResourceFilePath intermediatePath = (ResourceFilePath)path.clone();
            String relativePath = null;
            do {
                searchStrategy.modifyToNextDefault(path, intermediatePath, this);
                hashString = intermediatePath.toHashString();
                if (intermediateKeys.contains(hashString)) break;
                intermediateKeys.add(hashString);
            } while ((relativePath = (String)this.realResourceFiles.get(hashString)) == null);
            if (relativePath != null) {
                HashMap hashMap = this.resourceFiles;
                synchronized (hashMap) {
                    this.resourceFiles.put(originalHashString, relativePath);
                }
                return true;
            }
        }
        return false;
    }

    private void recurseDirectories(File dirPath) {
        File[] containedFiles;
        if (dirPath != null && dirPath.isDirectory() && (containedFiles = dirPath.listFiles(resourceFileFilter)) != null) {
            for (int i = 0; i < containedFiles.length; ++i) {
                if (containedFiles[i].isDirectory()) {
                    this.recurseDirectories(containedFiles[i]);
                    continue;
                }
                String relativePath = this.getRelativePath(containedFiles[i]);
                if (relativePath == null) continue;
                ResourceFilePath resourceFilePath = new ResourceFilePath(relativePath);
                String hashValue = resourceFilePath.toHashString();
                this.resourceFiles.put(hashValue, relativePath);
                this.realResourceFiles.put(hashValue, relativePath);
                this.updateAvailableLists(resourceFilePath);
            }
        }
    }

    private void updateAvailableLists(ResourceFilePath rfp) {
        Locale newLocale;
        if (rfp.getBaseFile() != null) {
            this.availableBaseFiles.add(rfp.getBaseFile());
        }
        if (rfp.getLanguage() != null && (newLocale = this.createLocale(rfp)) != null) {
            this.availableLocales.add(newLocale);
        }
        if (rfp.getSkin() != null) {
            this.availableSkins.add(rfp.getSkin());
        }
        if (rfp.getDevice() != null) {
            this.availableDevices.add(rfp.getDevice());
        }
    }

    private Locale createLocale(ResourceFilePath rfp) {
        Locale locale = null;
        String language = rfp.getLanguageCode();
        String country = rfp.getCountryCode();
        locale = new Locale(language, country);
        return locale;
    }

    protected String getRelativePath(File resourceFile) {
        String relativePath = null;
        relativePath = resourceFile.getPath();
        int npsPortalPos = (relativePath = relativePath.replace('\\', '/')).indexOf("/portal/gadgets");
        if (npsPortalPos > 0) {
            int prevSlashPos = relativePath.lastIndexOf(47, npsPortalPos - 1);
            relativePath = relativePath.substring(npsPortalPos);
        } else {
            int npsPortalModulesPos = relativePath.indexOf("/portal/modules");
            if (npsPortalModulesPos > 0) {
                int prevSlashPos = relativePath.lastIndexOf(47, npsPortalModulesPos - 1);
                relativePath = relativePath.substring(npsPortalModulesPos);
            }
        }
        return relativePath;
    }

    public Collection getAvailableLocales() {
        return this.availableLocales;
    }

    public Collection getAvailableBaseFiles() {
        return this.availableBaseFiles;
    }

    public Collection getAvailableSkins() {
        return this.availableSkins;
    }

    public Collection getAvailableDevices() {
        return this.availableDevices;
    }

    public String getLocalizedPath(String baseFileName, PortalSession session, Locale locale) {
        if (baseFileName == null || baseFileName.length() == 0) {
            return null;
        }
        if (locale == null) {
            locale = FwUtils.getCurrentLocale((HttpSession)session);
        }
        String skinName = FwUtils.getSkin((HttpSession)session);
        String deviceName = FwUtils.getDeviceType((HttpSession)session);
        return this.getLocalizedPath(baseFileName, locale, skinName, deviceName);
    }

    public String getLocalizedPath(String baseFileName, PortalSession session, Locale locale, String skinName) {
        if (baseFileName == null || baseFileName.length() == 0) {
            return null;
        }
        if (locale == null) {
            locale = FwUtils.getCurrentLocale((HttpSession)session);
        }
        if (null == skinName) {
            skinName = FwUtils.getSkin((HttpSession)session);
        }
        String deviceName = FwUtils.getDeviceType((HttpSession)session);
        return this.getLocalizedPath(baseFileName, locale, skinName, deviceName);
    }

    public String getLocalizedPath(String baseFileName, PortalSession session, GadgetInstance gadgetInstance) {
        if (baseFileName == null || baseFileName.length() == 0) {
            return null;
        }
        Locale gadgetLocale = null;
        gadgetLocale = gadgetInstance != null ? gadgetInstance.getLocale() : FwUtils.getCurrentLocale((HttpSession)session);
        String skinName = FwUtils.getSkin((HttpSession)session);
        String deviceName = FwUtils.getDeviceType((HttpSession)session);
        return this.getLocalizedPath(baseFileName, gadgetLocale, skinName, deviceName);
    }

    private String getLocalizedPath(String baseFileName, Locale gadgetLocale, String skinName, String deviceName) {
        String localizedPath = null;
        if (baseFileName.indexOf(58) != -1) {
            return baseFileName;
        }
        baseFileName = baseFileName.replace('\\', '/');
        ResourceFilePath rfp = new ResourceFilePath(baseFileName);
        rfp.setBaseFile(baseFileName);
        if (gadgetLocale != null) {
            rfp.setLanguage(new Locale(gadgetLocale.getLanguage(), ""));
        } else {
            rfp.setLanguage(new Locale(ConfigManager.getSystemLocale().getLanguage(), ""));
        }
        if (deviceName != null && deviceName.length() > 0) {
            rfp.setDevice(deviceName);
        } else {
            rfp.setDevice("default");
        }
        if (skinName != null && skinName.length() > 0) {
            rfp.setSkin(skinName);
        } else {
            rfp.setSkin("default");
        }
        String hashString = rfp.toHashString();
        localizedPath = (String)this.resourceFiles.get(hashString);
        if (localizedPath == null && this.deriveReplacement(rfp)) {
            localizedPath = (String)this.resourceFiles.get(hashString);
        }
        return localizedPath;
    }

    public ResourceFileSearchStrategy getSearchStrategy() {
        return searchStrategy;
    }

    public void setSearchStrategy(ResourceFileSearchStrategy sStrategy) {
        searchStrategy = sStrategy;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            ResourceFileMap.testPath(args[0]);
        } else {
            System.err.println("Syntax:\n\tResourceFileMap <Gadget Base Path>");
        }
    }

    private static void testPath(String path) {
        ResourceFileMap rfm = new ResourceFileMap(path);
        rfm.availableSkins.add("base");
        rfm.availableLocales.add(new Locale("fr", ""));
        try {
            long start = System.currentTimeMillis();
            rfm.refresh();
            long finish = System.currentTimeMillis();
            System.out.println("Time to build ResourceFileMap: " + String.valueOf(finish - start) + "ms");
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        System.out.println(rfm.toString());
        String foundPath = rfm.getLocalizedPath("main.xsl", new Locale("de", ""), "finance", "default");
        System.out.println("main.xsl+de+finance+default = " + foundPath);
        foundPath = rfm.getLocalizedPath("main_lang.xsl", new Locale("de", ""), "finance", "default");
        System.out.println("main_lang.xsl+de+finance+default = " + foundPath);
    }

    public String toString() {
        Object item;
        StringBuffer sb = new StringBuffer();
        sb.append("Available Base Files:\n");
        Iterator iter = this.getAvailableBaseFiles().iterator();
        while (iter.hasNext()) {
            item = (String)iter.next();
            sb.append("\t");
            sb.append((String)item);
            sb.append("\n");
        }
        sb.append("Available Locales:\n");
        iter = this.getAvailableLocales().iterator();
        while (iter.hasNext()) {
            item = (Locale)iter.next();
            sb.append("\t");
            sb.append(((Locale)item).toString());
            sb.append("\n");
        }
        sb.append("Available Skins:\n");
        iter = this.getAvailableSkins().iterator();
        while (iter.hasNext()) {
            item = (String)iter.next();
            sb.append("\t");
            sb.append((String)item);
            sb.append("\n");
        }
        sb.append("Available Devices:\n");
        iter = this.getAvailableDevices().iterator();
        while (iter.hasNext()) {
            item = (String)iter.next();
            sb.append("\t");
            sb.append((String)item);
            sb.append("\n");
        }
        sb.append("Resource Files Map:\n");
        Set set = this.resourceFiles.keySet();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            String value;
            String key = (String)i.next();
            if (key == null || (value = (String)this.resourceFiles.get(key)) == null) continue;
            sb.append("\t");
            sb.append(key);
            sb.append(" = ");
            sb.append(value);
            sb.append("\n");
        }
        return sb.toString();
    }
}

