/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.i18n;

import com.novell.nps.i18n.ResourceFileMap;
import com.novell.nps.i18n.ResourceFilePath;
import com.novell.nps.i18n.ResourceFileSearchStrategy;
import java.util.Iterator;
import java.util.Vector;

public class SkinPrioritySearchStrategy
implements ResourceFileSearchStrategy {
    public void modifyToNextDefault(ResourceFilePath originalFilePath, ResourceFilePath currentFilePath, ResourceFileMap resourceFileMap) {
        if (originalFilePath != null && currentFilePath != null) {
            String defaultLang = "en";
            String lang = currentFilePath.getLanguage();
            String skin = currentFilePath.getSkin();
            String device = currentFilePath.getDevice();
            if (device != null && !device.equalsIgnoreCase("default")) {
                currentFilePath.setDevice("default");
            } else if (lang != null && !lang.equalsIgnoreCase(defaultLang)) {
                String countryStr = currentFilePath.getCountryCode();
                boolean bUseDefaultSkin = false;
                if (countryStr != null && countryStr.length() > 0) {
                    currentFilePath.setLanguage(originalFilePath.getLanguageCode());
                } else if (skin.equalsIgnoreCase("default")) {
                    currentFilePath.setLanguage(defaultLang);
                    currentFilePath.setSkin(originalFilePath.getSkin());
                    currentFilePath.setDevice(originalFilePath.getDevice());
                } else {
                    currentFilePath.setLanguage(originalFilePath.getLanguage());
                    bUseDefaultSkin = true;
                }
                if (device.equalsIgnoreCase("default") && skin.equalsIgnoreCase("default")) {
                    currentFilePath.setDevice(originalFilePath.getDevice());
                } else {
                    if (bUseDefaultSkin) {
                        currentFilePath.setSkin("default");
                    } else {
                        currentFilePath.setSkin(originalFilePath.getSkin());
                    }
                    currentFilePath.setDevice(originalFilePath.getDevice());
                }
            } else if (skin != null && !skin.equalsIgnoreCase("default")) {
                currentFilePath.setSkin("default");
                currentFilePath.setDevice(originalFilePath.getDevice());
                currentFilePath.setLanguage("en");
            }
        }
    }

    public static void main(String[] args) {
        SkinPrioritySearchStrategy searchStrategy = new SkinPrioritySearchStrategy();
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/testing/skins/classic1/devices/pocketpc/myfile_fi_FI.xsl");
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/testing/skins/classic1/devices/default/myfile_fi_FI.xsl");
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/testing/skins/default/devices/pocketpc/myfile_fi_FI.xsl");
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/testing/skins/classic1/devices/pocketpc/myfile.xsl");
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/testing/myfile.xsl");
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/testing/skins/clinic/devices/default/main.xsl");
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/testing/skins/clinic/devices/default/main_ja.xsl");
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/testing/skins/default/devices/default/main_ja.xsl");
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/gadget/skins/classic/devices/ie5/main_ja_JP.xsl");
        SkinPrioritySearchStrategy.testPath(searchStrategy, "/gadget/skins/base/devices/default/main_fr.xsl");
    }

    private static void testPath(ResourceFileSearchStrategy searchStrategy, String pathStr) {
        ResourceFilePath path = new ResourceFilePath(pathStr);
        Vector<String> intermediateKeys = new Vector<String>();
        intermediateKeys.add(path.toHashString());
        ResourceFilePath intermediatePath = (ResourceFilePath)path.clone();
        Object relativePath = null;
        while (true) {
            searchStrategy.modifyToNextDefault(path, intermediatePath, null);
            String hashString = intermediatePath.toHashString();
            if (intermediateKeys.contains(hashString)) break;
            intermediateKeys.add(hashString);
        }
        System.out.println("Original path: \n\t" + path.toHashString());
        System.out.println("Intermediate Paths:");
        Iterator iter = intermediateKeys.iterator();
        while (iter.hasNext()) {
            String item = (String)iter.next();
            System.out.println("\t" + item);
        }
    }
}

