/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.logging.logBeans;

import com.novell.nps.PortalBean;
import com.novell.nps.WebappUtil;
import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import javax.servlet.ServletContext;

public class PortalLogBean
implements PortalEventListener,
Serializable,
PortalBean {
    private static transient Hashtable printWriters = null;
    public static final String LOGFILE_FOR_BEANS_PCO = "LoggerBeansLogFile";
    public static final String LOGFILE_FOR_BEANS_PROPERTIES = "Logger.LoggerBeansLogFile";
    private static long portalStartupTime = 0L;
    protected String logFile = "portallog.xml";

    public PortalLogBean() {
        this.init();
    }

    public PortalLogBean(String logFile) {
        this.logFile = logFile;
    }

    public void init() {
        String logFile = ConfigManager.getProperty(LOGFILE_FOR_BEANS_PROPERTIES);
        if (logFile == null) {
            logFile = ConfigManager.getSingleSetting(LOGFILE_FOR_BEANS_PCO, "portallog.xml");
        }
        this.logFile = logFile;
    }

    public void shutdown() {
    }

    public void refreshSettings() {
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public static PrintWriter getPrintWriter(String logFile) {
        PrintWriter pw;
        ServletContext sc = WebappUtil.getStaticServletContext();
        String sPath = null;
        sPath = sc != null ? WebappUtil.getRealPath("/WEB-INF") + File.separator + logFile : logFile;
        if (printWriters == null) {
            printWriters = new Hashtable();
        }
        if ((pw = (PrintWriter)printWriters.get(sPath)) == null) {
            try {
                FileWriter fLog = new FileWriter(sPath, true);
                pw = new PrintWriter(fLog);
                File fLtest = new File(sPath);
                if (fLtest.length() == 0L) {
                    pw.println("<?xml version=\"1.0\"?>");
                    pw.println("<PortalLog>");
                }
            }
            catch (IOException ioe) {
                Debug.log("PortalLogBean", 2, ioe);
                return null;
            }
            printWriters.put(sPath, pw);
        }
        return pw;
    }

    public static synchronized void writeToPrintWriter(PrintWriter pw, String output) {
        pw.println(output);
    }

    public synchronized long getPortalUptime() {
        if (portalStartupTime == 0L) {
            Debug.log("PortalLogBean", 2, "The Portal Startup Time is not available.");
            return 0L;
        }
        return System.currentTimeMillis() - portalStartupTime;
    }

    public void onPortalEvent(PortalEvent event) {
    }
}

