/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.rendering;

import com.novell.nps.configManager.ConfigManager;
import com.novell.nps.debug.Debug;
import com.novell.nps.rendering.Renderer;
import com.novell.nps.sessionManager.PortalSession;
import com.novell.xml.parser.SAXParserImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xsl.DefaultErrorHandler;
import com.novell.xsl.DefaultMessageHandler;
import com.novell.xsl.ErrorHandler;
import com.novell.xsl.MessageHandler;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.util.Timer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NxslRendererImpl
implements Renderer {
    private static final int TIMES_SOURCE_PARSE = 0;
    private static final int TIMES_XSL_PARSE = 1;
    private static final int TIMES_COMPILE = 2;
    private static final int TIMES_PROCESS = 3;
    private static final int TIMES_TOTAL = 4;
    private static final int TIMES_ARRAY_SIZE = 5;
    private static final String DONT_CACHE_STYLESHEETS = "System.renderer.DontCacheStylesheets";
    private boolean dontCacheStylesheets = false;
    private static final String STYLESHEET_REQUIRED = "e1";
    private static final String PARSE_ERRORS = "e2";
    private static final String TIMER_HEADER = "tm1";
    private static final String TIMER_PARSE = "tm2";
    private static final String TIMER_COMPILE = "tm3";
    private static final String TIMER_PROCESS = "tm4";
    private static final String TIMER_TOTAL = "tm5";
    private static XMLParser xmlParser = new SAXParserImpl();
    private static XMLParser xmlStylesheetParser = new SAXParserImpl();
    long[] times = new long[5];
    Timer timer;
    boolean printTimes = true;
    boolean alreadyStripped = false;
    static Hashtable stylesheets = new Hashtable();

    public void resetCacheStylesheets() {
        String dontCacheStylesheetsSetting = ConfigManager.getProperty(DONT_CACHE_STYLESHEETS, "false");
        this.dontCacheStylesheets = "true".equalsIgnoreCase(dontCacheStylesheetsSetting);
    }

    public void setPrintTimes(boolean printTimes) {
        this.printTimes = printTimes;
    }

    public void clearStylesheetCache() {
        stylesheets.clear();
    }

    public Stylesheet getStylesheet(String xslFileRelPath, String servletContext) throws XSLException, IOException {
        Stylesheet stylesheet = (Stylesheet)stylesheets.get(xslFileRelPath);
        if (null == stylesheet) {
            stylesheet = this.constructStylesheet(xslFileRelPath, servletContext);
        }
        return stylesheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyStyleSheet(String xmlBuffer, String stylesheetRelPath, String servletContext, OutputStream out, PortalSession session, HttpServletRequest req) {
        String stylesheetURI = servletContext + stylesheetRelPath;
        try {
            Document xmlDoc;
            this.alreadyStripped = false;
            if (this.printTimes) {
                for (int i = 0; i < this.times.length; ++i) {
                    this.times[i] = 0L;
                }
                this.timer = new Timer();
            }
            Stylesheet stylesheet = this.getStylesheet(stylesheetRelPath, servletContext);
            StringReader xmlReader = new StringReader(xmlBuffer);
            XMLParser xMLParser = xmlParser;
            synchronized (xMLParser) {
                xmlDoc = xmlParser.parse((Reader)xmlReader);
            }
            if (this.printTimes) {
                this.times[0] = this.timer.getLapTime();
            }
            if (xmlParser.anyErrors()) {
                NxslRendererImpl.showError(PARSE_ERRORS, "XML Data Stream");
                xmlParser.reportErrorMsgs((OutputStream)System.err);
            }
            xMLParser = stylesheet;
            synchronized (xMLParser) {
                stylesheet.setSerializerStream(out);
                stylesheet.process((Node)xmlDoc, new URL(stylesheetURI), this.alreadyStripped);
            }
            if (this.printTimes) {
                this.times[3] = this.timer.getLapTime();
                this.times[4] = this.timer.getTotalTime();
                NxslRendererImpl.showMessage(TIMER_HEADER, null);
                NxslRendererImpl.showMessage(TIMER_PARSE, new String[]{this.timer.millisToString(this.times[0]), "XML data Stream"});
                NxslRendererImpl.showMessage(TIMER_PARSE, new String[]{this.timer.millisToString(this.times[1]), "XSL file: " + stylesheetURI});
                NxslRendererImpl.showMessage(TIMER_COMPILE, new String[]{this.timer.millisToString(this.times[2])});
                NxslRendererImpl.showMessage(TIMER_PROCESS, new String[]{this.timer.millisToString(this.times[3])});
                NxslRendererImpl.showMessage(TIMER_TOTAL, new String[]{this.timer.millisToString(this.times[4])});
            }
        }
        catch (IOException e) {
            Debug.log("Rendering IO Error:", 1, e);
        }
        catch (XSLException e) {
            Debug.log("Rendering XSL Error:", 1, (Exception)((Object)e));
        }
    }

    public void applyStyleSheet(Reader xml, Reader xsl, Writer out) {
    }

    private synchronized Stylesheet constructStylesheet(String xslFileRelPath, String servletContext) throws XSLException, IOException {
        Stylesheet stylesheet = (Stylesheet)stylesheets.get(xslFileRelPath);
        if (null == stylesheet) {
            Document xslDoc = xmlStylesheetParser.parse(servletContext + xslFileRelPath);
            if (this.printTimes) {
                this.times[1] = this.timer.getLapTime();
            }
            if (xmlStylesheetParser.anyErrors()) {
                NxslRendererImpl.showError(PARSE_ERRORS, xslFileRelPath);
                xmlStylesheetParser.reportErrorMsgs((OutputStream)System.out);
            }
            DefaultErrorHandler errorHandler = new DefaultErrorHandler();
            errorHandler.setLogErrors(true);
            errorHandler.setLogWarnings(true);
            DefaultMessageHandler messageHandler = new DefaultMessageHandler();
            stylesheet = new Stylesheet();
            stylesheet.setErrorHandler((ErrorHandler)errorHandler);
            stylesheet.setMessageHandler((MessageHandler)messageHandler);
            if (xslDoc != null) {
                stylesheet.setBaseURI(servletContext + xslFileRelPath);
                stylesheet.load(xslDoc);
                if (!this.dontCacheStylesheets) {
                    stylesheets.put(xslFileRelPath, stylesheet);
                }
            }
            if (this.printTimes) {
                this.times[2] = this.timer.getLapTime();
            }
        }
        return stylesheet;
    }

    public static void showError(String key) {
        System.err.println(NxslRendererImpl.constructMessage(key, null));
    }

    public static void showError(String key, String parm0) {
        System.err.println(NxslRendererImpl.constructMessage(key, new String[]{parm0}));
    }

    public static void showMessage(String key, Object[] parms) {
        Debug.log("Renderer", 3, NxslRendererImpl.constructMessage(key, parms));
    }

    public static String constructMessage(String key, Object[] parms) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.novell.xsl.nxsl_messages");
        try {
            key = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        return parms == null ? key : MessageFormat.format(key, parms);
    }
}

