/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.rendering;

import com.novell.nps.debug.Debug;
import com.novell.nps.gadgetManager.BaseGadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.gadgetManager.GadgetManager;
import com.novell.nps.rendering.Renderer;
import com.novell.nps.serviceProviders.web.PortalURL;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TransformService
extends BaseGadgetInstance {
    public static final String DT = "Transform Service";
    public static final String TRANSFORM_ACTION = "Transform";
    String currentAction = "Transform";
    public static final String FILE_URL_PARAM = "FileURL";
    public static final String STYLESHEET_URL_PARAM = "StylesheetURL";

    public String getAction(HttpServletRequest req) {
        return this.currentAction;
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        String fileURL = req.getParameter(FILE_URL_PARAM);
        if (fileURL == null || fileURL.length() < 1) {
            try {
                resp.sendError(-1, "No File specified");
            }
            catch (IOException e) {
                Debug.log(DT, 1, e);
                throw new GadgetInstanceException(e.getLocalizedMessage());
            }
        }
        if (this.session.isXSLSupported()) {
            try {
                resp.sendRedirect(fileURL);
            }
            catch (IOException e) {
                Debug.log(DT, 1, e);
                throw new GadgetInstanceException(e.getLocalizedMessage());
            }
        }
        String stylesheetURL = req.getParameter(STYLESHEET_URL_PARAM);
        Renderer renderer = GadgetManager.getRenderer();
        try {
            PortalURL filePortalURL = new PortalURL(this.session, fileURL);
            InputStream xmlInputStream = filePortalURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bin = new BufferedInputStream(xmlInputStream);
            byte[] b = new byte[1024];
            int bytesRead = bin.read(b, 0, 1024);
            while (bytesRead > 0) {
                baos.write(b, 0, bytesRead);
                bytesRead = bin.read(b, 0, 1024);
            }
            String xml = baos.toString("UTF-8");
            resp.setContentType("text/html");
            renderer.applyStyleSheet(xml, stylesheetURL, "", (OutputStream)resp.getOutputStream(), this.session, req);
        }
        catch (IOException e) {
            Debug.log(DT, 1, e);
            throw new GadgetInstanceException(e.getLocalizedMessage());
        }
    }
}

