/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import com.novell.emframe.dev.D;
import com.novell.emframe.fw.AuditLog;
import com.novell.emframe.fw.config.ModuleInfo;
import com.novell.emframe.fw.config.ModuleManager;
import com.novell.nps.WebappUtil;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.ModuleConfig;
import com.novell.nps.configManager.NPSVersion;
import com.novell.nps.configManager.PCO;
import com.novell.nps.configManager.Setting;
import com.novell.nps.configManager.SettingValue;
import com.novell.nps.serviceProviders.FwZipOps;
import com.novell.nps.serviceProviders.PortalModuleInstallManager;
import com.novell.nps.serviceProviders.PortalModuleInstaller;
import com.novell.nps.serviceProviders.PortalModuleUI;
import com.novell.nps.serviceProviders.ShellCommand;
import com.novell.nps.serviceProviders.UnZipGadget;
import com.novell.nps.utils.DOMUtil;
import com.novell.nps.utils.NPSClassLoader;
import com.novell.nps.utils.ZipUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortalModule {
    public static final String FOLDER_ADDITIONAL_FILES = "currentwebapp/";
    public static final String FOLDER_MODULE_FILES = "currentmodule/";
    public static final String FOLDER_PRECOMPILED_JSP = "jsp/";
    public static final String FILE_MODULE_PROPERTIES = "module";
    public static final String FILE_EXT_PROPERTIES = ".properties";
    public static final String FILE_EXT_GADGET = ".npg";
    public static final String FILE_EXT_PORTAL_MODULE = ".npm";
    private static final String DEFAULT_FILE_XSL = "main.xsl";
    private static final String FOLDER_PORTAL = "portal";
    private static final String FOLDER_MODULES = "modules";
    private static final String FOLDER_META_INF = "META-INF/";
    private static final String META_INF = "META-INF";
    private static final String FILE_MANIFEST = "MANIFEST.MF";
    private static final String FOLDER_SCHEMA = "schema";
    private static final String FILENAME_GADGET_SETUP = "GadgetSetup.xml";
    private static final String TAG_OPEN_GADGET_CLASS_NAME = "<GADGETCODE>";
    private static final String TAG_CLOSE_GADGET_CLASS_NAME = "</GADGETCODE>";
    private static final String MARKER_HREF = "href";
    private static final String MARKER_INCLUDE = "xsl:include";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String KEY_MANIFEST_VERSION = "Manifest-Version";
    private static final String KEY_MODULE_INSTALLER = "Main-Class";
    private static final String KEY_MODULE_TITLE = "Implementation-Title";
    private static final String KEY_MODULE_VERSION = "Implementation-Version";
    private static final String KEY_MODULE_DESCRIPTION = "Implementation-Description";
    private static final String KEY_MODULE_VENDOR = "Implementation-Vendor";
    private static final String KEY_MODULE_ID = "Module-ID";
    private static final String WEBINF_DIRECTORY = "WEB-INF";
    private static final String PSP_DIRECTORY = File.separator + "WEB-INF";
    private static final String SERVLET_PROPERTIES_FILE_NAME = "PortalServlet.properties";
    private static final String NPMCOMMAND_SYMBOLICLINKS = "currentwebcommand/symboliclinks.txt";
    private static final String NPMCOMMAND_PERMISSIONS = "currentwebcommand/permissions.txt";
    private static final String NPMCOMMAND_DELETEFILES = "currentwebcommand/deletefiles.txt";
    private static String[] NPNCOMMANDFILEARR = new String[]{"currentwebcommand/deletefiles.txt", "currentwebcommand/symboliclinks.txt", "currentwebcommand/permissions.txt"};
    private static final String NPMCOMMAND_DEFAULTPLATFORMS = "aix hpux linux netware solaris windows";
    private static final String NPMCOMMAND_CTRLPLATFORM = "Platform:";
    private static final char NPMCOMMAND_COMMENTCHAR = '#';
    private static final String ENTRY_RESOURCES = "Resources";
    private static final String SYS_PROPERTY_TMP_DIR = "java.io.tmpdir";
    private static final Object[][] ZIP_ENTRIES = new Object[][]{{new Integer(258), "Resources/EULA.html"}, {new Integer(257), "Resources/Layout.xml"}, {new Integer(259), "Resources/PortalServlet.properties"}};
    private static final String DT = "PortalModule";
    private JarFile m_jarFile = null;
    private File m_fArchiveFile = null;
    private File m_fDestFolder = null;
    private File m_fJSPPath = null;
    private String m_sModuleTitle = null;
    private String m_sModuleDescription = null;
    private String m_sModuleVersion = null;
    private String m_sModuleID = null;
    private boolean m_bInstall = true;
    private Manifest m_manifest = null;
    private PortalModuleInstaller m_installer = null;
    public static final String os_unknown = "unknown";
    public static final String os_aix = "aix";
    public static final String os_hpux = "hpux";
    public static final String os_linux = "linux";
    public static final String os_netware = "netware";
    public static final String os_solaris = "solaris";
    public static final String os_windows = "windows";
    public static final String os_oes_linux = "oes-linux";
    private static String osName = null;

    PortalModule(PortalConnection portalConn, String sPCODN, String sWebServerAddress, File fDestFolder, PortalModuleDescriptor descriptor) throws IOException {
        this(fDestFolder, descriptor.m_fArchiveFile);
    }

    PortalModule(PortalConnection portalConn, PCO pco, String sWebServerAddress, File fDestFolder, PortalModuleDescriptor descriptor) throws IOException {
        this(fDestFolder, descriptor.m_fArchiveFile);
    }

    PortalModule(PortalConnection portalConn, PCO pco, String sWebServerAddress, File fDestFolder, File fArchiveFile) throws IOException {
        this(fDestFolder, fArchiveFile);
    }

    PortalModule(PortalConnection portalConn, String sPCODN, String sWebServerAddress, File fDestFolder, File fArchiveFile, String sModuleCN) throws IOException {
        this(fDestFolder, fArchiveFile);
    }

    PortalModule(File fDestFolder, File fArchiveFile) throws IOException {
        if (fArchiveFile.exists() && fArchiveFile.isFile() && fArchiveFile.canRead()) {
            this.m_fDestFolder = fDestFolder;
            this.m_fArchiveFile = fArchiveFile;
            if (this.m_fArchiveFile.canRead()) {
                this.m_jarFile = new JarFile(this.m_fArchiveFile);
            }
            try {
                ZipEntry entry = this.m_jarFile.getEntry(MANIFEST);
                InputStream inputStream = this.m_jarFile.getInputStream(entry);
                BufferedInputStream bufInputStream = new BufferedInputStream(inputStream);
                ByteArrayOutputStream baOutputStream = new ByteArrayOutputStream();
                BufferedOutputStream bufBaOutputStream = new BufferedOutputStream(baOutputStream);
                int data = bufInputStream.read();
                while (data != -1) {
                    bufBaOutputStream.write(data);
                    if (data == 58) {
                        data = bufInputStream.read();
                        if (data != 32) {
                            bufBaOutputStream.write(32);
                            continue;
                        }
                        bufBaOutputStream.write(data);
                    }
                    data = bufInputStream.read();
                }
                bufBaOutputStream.write("\r\n".getBytes());
                bufInputStream.close();
                bufBaOutputStream.close();
                byte[] baBuff = baOutputStream.toByteArray();
                ByteArrayInputStream baInputStream = new ByteArrayInputStream(baBuff);
                this.m_manifest = new Manifest(baInputStream);
            }
            catch (Throwable t1) {
                D.log((String)"Could not get manifest information");
            }
            if (null != this.m_manifest) {
                this.m_sModuleTitle = this.m_manifest.getMainAttributes().getValue(KEY_MODULE_TITLE);
            }
            if (null == this.m_sModuleTitle) {
                this.m_sModuleTitle = this.m_fArchiveFile.getName().substring(0, this.m_fArchiveFile.getName().length() - FILE_EXT_PORTAL_MODULE.length());
            }
            if (null != this.m_manifest) {
                this.m_sModuleDescription = this.m_manifest.getMainAttributes().getValue(KEY_MODULE_DESCRIPTION);
            }
            if (null != this.m_manifest) {
                this.m_sModuleVersion = this.m_manifest.getMainAttributes().getValue(KEY_MODULE_VERSION);
            }
            if (null != this.m_manifest) {
                this.m_sModuleID = this.m_manifest.getMainAttributes().getValue(KEY_MODULE_ID).trim();
                if (null == this.m_sModuleID) {
                    String sVendor = this.m_manifest.getMainAttributes().getValue(KEY_MODULE_VENDOR);
                    String sTitle = this.m_manifest.getMainAttributes().getValue(KEY_MODULE_TITLE);
                    if (null != sVendor && null != sTitle) {
                        this.m_sModuleID = sVendor + ": " + sTitle;
                    }
                }
            }
            this.loadInstaller();
            try {
                String sVersion;
                ModuleInfo moduleConfig = ModuleManager.getModule((String)this.m_sModuleID);
                if (null != moduleConfig && null != (sVersion = moduleConfig.getModuleVersion()) && 0 > new NPSVersion(sVersion).compareTo(this.getModuleVersion())) {
                    D.log((String)("Do Not install:" + this.getModuleTitle() + ": " + this.getModuleDescription()));
                    D.log((String)("Version: " + this.getModuleVersion()));
                    D.log((String)("Already installed Version: " + sVersion));
                    this.m_bInstall = false;
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
    }

    PortalModule(PortalConnection portalConn, PCO pco, String sWebServerAddress, File fDestFolder, File fArchiveFile, String sModuleCN) throws IOException {
        this(fDestFolder, fArchiveFile);
    }

    public void setJSPPath(File fJSPPath) {
        this.m_fJSPPath = fJSPPath;
    }

    public String getModuleTitle() {
        return this.m_sModuleTitle;
    }

    public String getModuleDescription() {
        return this.m_sModuleDescription;
    }

    public String getModuleVersion() {
        return this.m_sModuleVersion;
    }

    public String getModuleID() {
        return this.m_sModuleID;
    }

    public boolean getInstallStatus() {
        return this.m_bInstall;
    }

    public InputStream getStream(int iStreamIndex, Locale locale) {
        InputStream rcode = null;
        try {
            ZipEntry ze;
            if (null != this.m_installer) {
                rcode = (InputStream)this.m_installer.getData(iStreamIndex, locale);
            }
            if (null == rcode && null != (ze = this.getLocalizedEntry(this.getZipEntry(iStreamIndex), locale))) {
                rcode = this.m_jarFile.getInputStream(ze);
            }
        }
        catch (Throwable t) {
            D.log((String)("Error getting Stream from module" + t));
        }
        return rcode;
    }

    public boolean hasUI(PCO pco) {
        boolean bRet = false;
        if (null != this.m_installer && this.m_installer instanceof PortalModuleUI) {
            bRet = true;
        }
        return bRet;
    }

    public String getData(HttpServletRequest request) {
        String sRet = null;
        if (this.m_installer instanceof PortalModuleUI && null != (sRet = ((PortalModuleUI)((Object)this.m_installer)).getData(request))) {
            sRet = this.getOutput(sRet, request.getLocale());
        }
        return sRet;
    }

    private String getOutput(String sXML, Locale locale) {
        String sRet = sXML;
        try {
            Document domXSL = this.getXSL(sXML, locale);
            if (null != domXSL) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(new DOMSource(domXSL));
                Properties transformProperties = new Properties();
                transformProperties.put("method", "xml");
                transformProperties.put("encoding", "UTF-8");
                transformProperties.put("indent", "yes");
                transformer.setOutputProperties(transformProperties);
                CharArrayWriter writer = new CharArrayWriter();
                transformer.transform(new StreamSource(new StringReader(sXML)), new StreamResult(writer));
                sRet = writer.toString();
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
        return sRet;
    }

    public String install(String sHost, String sWebAppContextPath, PCO pco, boolean isAdmin) throws PortalDirectoryException {
        return this.install(sHost, sWebAppContextPath);
    }

    public String install(String sHost, String sWebAppContextPath, PCO pco, boolean isAdmin, boolean bWriteLocation) throws PortalDirectoryException {
        return this.install(sHost, sWebAppContextPath);
    }

    public String install(String sHost, String sWebAppContextPath) throws PortalDirectoryException {
        String sRet = "";
        ModuleConfig moduleConfig = null;
        if (this.m_bInstall) {
            block84: {
                AuditLog.logModuleInstall((String)this.m_sModuleTitle, (String)this.m_fArchiveFile.getName());
                moduleConfig = new ModuleConfig();
                moduleConfig.setID(this.getModuleID());
                this.setModuleConfigInfo(moduleConfig);
                try {
                    if (null != this.m_installer) {
                        this.m_installer.setData(1, null);
                    }
                }
                catch (Throwable t) {
                    D.log((String)"installer threw when called \"setData(MODULE_DN)\"");
                }
                try {
                    if (null != this.m_installer) {
                        this.m_installer.preInstall();
                    }
                }
                catch (Throwable t) {
                    D.log((Throwable)t);
                    try {
                        if (null != this.m_installer) {
                            this.m_installer.errorInstall(new Exception(t));
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                try {
                    if (null != this.m_installer) {
                        this.m_installer.preFilesInstall();
                    }
                }
                catch (Throwable t) {
                    D.log((Throwable)t);
                    try {
                        if (null != this.m_installer) {
                            this.m_installer.errorInstall(new Exception(t));
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                try {
                    block83: {
                        ZipUtils.extract((ZipFile)this.m_jarFile, FOLDER_ADDITIONAL_FILES, this.m_fDestFolder);
                        File fManifest = new File(this.m_fDestFolder, WEBINF_DIRECTORY + File.separator + FOLDER_MODULES + File.separator + this.m_sModuleID + File.separator + META_INF + File.separator + FILE_MANIFEST);
                        ZipUtils.extract((ZipFile)this.m_jarFile, MANIFEST, fManifest);
                        try {
                            Object oTempDir;
                            if (null != this.m_fJSPPath) {
                                oTempDir = this.m_fJSPPath;
                            } else {
                                ServletContext servletContext = null;
                                try {
                                    servletContext = WebappUtil.getStaticServletContext();
                                }
                                catch (Throwable ignore) {
                                    // empty catch block
                                }
                                if (null != servletContext) {
                                    oTempDir = servletContext.getAttribute("javax.servlet.context.tempdir");
                                } else {
                                    oTempDir = null;
                                    D.log((String)"Path for precompiled JSPs was not specified!!!");
                                }
                            }
                            if (null == oTempDir || !(oTempDir instanceof File)) break block83;
                            try {
                                ZipUtils.extract((ZipFile)this.m_jarFile, "compiledjsps/nps/", (File)oTempDir);
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            ZipUtils.extract((ZipFile)this.m_jarFile, "currentmodule/jsp/", (File)oTempDir);
                        }
                        catch (Throwable t) {
                            D.log((Throwable)t);
                        }
                    }
                    if (null != this.m_installer) {
                        this.m_installer.postFilesInstall();
                    }
                }
                catch (Exception e) {
                    D.log((Throwable)e);
                    try {
                        if (null != this.m_installer) {
                            this.m_installer.errorFilesInstall(e);
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new PortalDirectoryException(e.getLocalizedMessage());
                }
                catch (Throwable t) {
                    D.log((Throwable)t);
                    try {
                        if (null != this.m_installer) {
                            this.m_installer.errorFilesInstall(new Exception(t));
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    throw new PortalDirectoryException(t.getLocalizedMessage());
                }
                String[] saModules = this.getModuleNames();
                if (0 < saModules.length) {
                    try {
                        File[] faModules = new File[saModules.length];
                        for (int i = 0; i < saModules.length; ++i) {
                            faModules[i] = ZipUtils.extractFile((ZipFile)this.m_jarFile, "packages/" + saModules[i], new File(System.getProperty(SYS_PROPERTY_TMP_DIR), saModules[i]));
                        }
                        PortalModuleInstallManager installManager = new PortalModuleInstallManager(faModules, this.m_fDestFolder);
                        installManager.getData(null);
                        installManager.install(sHost, sWebAppContextPath);
                    }
                    catch (Throwable t) {
                        D.log((Throwable)t);
                    }
                }
                try {
                    String sContextPath;
                    String[] saGadgets = this.getGadgetNames();
                    if (null == sHost) {
                        sContextPath = sWebAppContextPath;
                    } else {
                        int iIndex = sHost.indexOf("//");
                        sContextPath = 0 <= iIndex ? sHost.substring(iIndex + "//".length()) : sHost;
                        sContextPath = sContextPath + sWebAppContextPath;
                    }
                    for (int i = 0; i < saGadgets.length; ++i) {
                        File fGadgetPackage = ZipUtils.extractFile((ZipFile)this.m_jarFile, "packages/" + saGadgets[i], new File(System.getProperty(SYS_PROPERTY_TMP_DIR), saGadgets[i]));
                        try {
                            if (null != this.m_installer) {
                                this.m_installer.preGadgetInstall(fGadgetPackage, sContextPath, null);
                            }
                        }
                        catch (Throwable t) {
                            D.log((Throwable)t);
                            try {
                                if (null != this.m_installer) {
                                    this.m_installer.errorInstall(new Exception(t));
                                }
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        try {
                            boolean bInstalled = this.installGadget(fGadgetPackage, this.m_fDestFolder, sContextPath);
                            if (bInstalled && null != this.m_installer) {
                                this.m_installer.postGadgetInstall(fGadgetPackage, sContextPath, null);
                            }
                        }
                        catch (Throwable t) {
                            D.log((Throwable)t);
                            try {
                                if (null != this.m_installer) {
                                    this.m_installer.errorGadgetInstall(new Exception(t), fGadgetPackage, sContextPath, null);
                                }
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                        try {
                            if (fGadgetPackage.delete()) continue;
                            fGadgetPackage.deleteOnExit();
                            continue;
                        }
                        catch (Throwable t) {
                            D.log((Throwable)t);
                            try {
                                if (null == this.m_installer) continue;
                                this.m_installer.errorInstall(new Exception(t));
                                continue;
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    D.log((Throwable)t);
                    try {
                        if (null != this.m_installer) {
                            this.m_installer.errorInstall(new Exception(t));
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                try {
                    InputStream isPortalServletProperties = this.getStream(259, null);
                    if (isPortalServletProperties == null) break block84;
                    Properties properties = new Properties();
                    properties.load(isPortalServletProperties);
                    isPortalServletProperties.close();
                    File fileProperties = new File(this.m_fDestFolder + PSP_DIRECTORY, SERVLET_PROPERTIES_FILE_NAME);
                    if (fileProperties.exists()) {
                        try {
                            FileInputStream inputStream = new FileInputStream(fileProperties);
                            properties.load(inputStream);
                            inputStream.close();
                        }
                        catch (Throwable t) {
                            D.log((String)("Couldn't add settings to PortalServlet.properties" + t));
                        }
                    }
                    try {
                        properties.store(new FileOutputStream(fileProperties), "eXtend");
                    }
                    catch (Throwable t) {
                        D.log((String)("Could store PortalServlet.properties" + t));
                    }
                }
                catch (Throwable t) {
                    D.log((Throwable)t);
                    try {
                        if (null != this.m_installer) {
                            this.m_installer.errorInstall(new Exception(t));
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
            }
            try {
                if (null != this.m_installer) {
                    this.m_installer.postInstall();
                }
            }
            catch (Throwable t) {
                D.log((Throwable)t);
                try {
                    if (null != this.m_installer) {
                        this.m_installer.errorInstall(new Exception(t));
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        if (this.m_jarFile != null) {
            try {
                this.m_jarFile.close();
                this.m_jarFile = null;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return sRet;
    }

    public void releaseResources() {
        if (this.m_jarFile != null) {
            try {
                this.m_jarFile.close();
                this.m_jarFile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setModuleConfigInfo(ModuleConfig moduleConfig) {
        ZipEntry zeModuleProperties;
        moduleConfig.setVersion(this.getModuleVersion());
        moduleConfig.setName(this.getModuleTitle());
        moduleConfig.setDescription(this.getModuleDescription());
        ConfigSettings configSettings = moduleConfig.getModuleObjectSettings();
        if (null != this.m_manifest) {
            Attributes attributes = this.m_manifest.getMainAttributes();
            Object[] oaKeys = attributes.keySet().toArray();
            for (int i = 0; i < oaKeys.length; ++i) {
                configSettings.addSettingValue(oaKeys[i].toString(), attributes.getValue(oaKeys[i].toString()));
            }
        }
        if (null != (zeModuleProperties = this.m_jarFile.getEntry("currentmodule/module.properties"))) {
            try {
                Properties propModule = new Properties();
                InputStream inputStream = this.m_jarFile.getInputStream(zeModuleProperties);
                propModule.load(inputStream);
                inputStream.close();
                Enumeration<Object> e = propModule.keys();
                while (e.hasMoreElements()) {
                    String sKey = (String)e.nextElement();
                    String sActualValue = propModule.getProperty(sKey);
                    Setting settingTemp = new Setting();
                    settingTemp.setTranslatableValues(true);
                    settingTemp.setName(sKey);
                    HashMap hmTranslations = new HashMap();
                    SettingValue value = new SettingValue(sActualValue, hmTranslations);
                    Vector<SettingValue> v = new Vector<SettingValue>();
                    v.add(value);
                    settingTemp.setValues(v);
                    configSettings.setSingleSettingObject(settingTemp);
                }
                Vector vLocales = this.getModulePropertiesLocales();
                Enumeration enumLocales = vLocales.elements();
                while (enumLocales.hasMoreElements()) {
                    String sLocale = (String)enumLocales.nextElement();
                    zeModuleProperties = this.m_jarFile.getEntry("currentmodule/module_" + sLocale + FILE_EXT_PROPERTIES);
                    if (null == zeModuleProperties) continue;
                    propModule = new Properties();
                    InputStream inputStreamProp = this.m_jarFile.getInputStream(zeModuleProperties);
                    propModule.load(inputStreamProp);
                    inputStreamProp.close();
                    Enumeration<Object> e2 = propModule.keys();
                    while (e2.hasMoreElements()) {
                        String sKey = (String)e2.nextElement();
                        Setting setting = configSettings.getSingleSettingObject(sKey);
                        if (null == setting) continue;
                        Vector v = setting.getValues();
                        SettingValue settingValue = (SettingValue)v.elementAt(0);
                        HashMap hmTranslations = settingValue.getDisplayValueMap();
                        hmTranslations.put(sLocale, propModule.getProperty(sKey));
                    }
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
        moduleConfig.setModuleObjectSettings(configSettings);
    }

    private Vector getModulePropertiesLocales() {
        Vector<String> vRet = new Vector<String>();
        vRet.add("en");
        vRet.add("pt");
        vRet.add("fr");
        vRet.add("it");
        vRet.add("de");
        vRet.add("es");
        vRet.add("ja");
        return vRet;
    }

    public static String getPackageClassName(File fGadgetPackage) {
        String sRet = null;
        try {
            if (fGadgetPackage.canRead()) {
                ZipFile zipFile = new ZipFile(fGadgetPackage);
                ZipEntry zeGadgetSetup = zipFile.getEntry(FILENAME_GADGET_SETUP);
                StringBuffer sb = new StringBuffer();
                InputStream inputStream = zipFile.getInputStream(zeGadgetSetup);
                byte[] buf = new byte[4096];
                int i = inputStream.read(buf);
                while (i != -1) {
                    sb.append(new String(buf));
                    i = inputStream.read(buf);
                }
                String sGadgetSetup = sb.toString();
                int iBegin = sGadgetSetup.indexOf(TAG_OPEN_GADGET_CLASS_NAME) + TAG_OPEN_GADGET_CLASS_NAME.length();
                int iEnd = sGadgetSetup.indexOf(TAG_CLOSE_GADGET_CLASS_NAME);
                sRet = sGadgetSetup.substring(iBegin, iEnd);
                inputStream.close();
                zipFile.close();
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
        return sRet;
    }

    private InputStream findI18NEntry(String sFileName, Locale locale) {
        String sFileExt;
        String sFileBase;
        InputStream inputstreamRet = null;
        int iIndex = sFileName.lastIndexOf(46);
        if (-1 == iIndex) {
            sFileBase = sFileName;
            sFileExt = "";
        } else {
            sFileBase = sFileName.substring(0, iIndex);
            sFileExt = sFileName.substring(iIndex);
        }
        try {
            ZipEntry entry = null;
            entry = this.m_jarFile.getEntry("Resources/" + sFileBase + "_" + locale.toString() + sFileExt);
            if (null == entry && null == (entry = this.m_jarFile.getEntry("Resources/" + sFileBase + "_" + locale.getLanguage() + sFileExt))) {
                entry = this.m_jarFile.getEntry("Resources/" + sFileName);
            }
            if (null != entry) {
                inputstreamRet = this.m_jarFile.getInputStream(entry);
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
        return inputstreamRet;
    }

    private ZipEntry getLocalizedEntry(String sEntryName, Locale locale) {
        ZipEntry rcode = null;
        if (null == locale) {
            locale = Locale.getDefault();
        }
        try {
            String sExtension;
            String sEntryNameLessExt;
            int iIndexExtension = sEntryName.lastIndexOf(46);
            int iIndexSeparator = sEntryName.lastIndexOf(47);
            if (iIndexExtension > iIndexSeparator) {
                sEntryNameLessExt = sEntryName.substring(0, iIndexExtension);
                sExtension = sEntryName.substring(iIndexExtension);
            } else {
                sEntryNameLessExt = sEntryName;
                sExtension = "";
            }
            rcode = this.m_jarFile.getEntry(sEntryNameLessExt + "_" + locale.toString() + sExtension);
            if (null == rcode && null == (rcode = this.m_jarFile.getEntry(sEntryNameLessExt + "_" + locale.getLanguage() + sExtension))) {
                rcode = this.m_jarFile.getEntry(sEntryName);
            }
        }
        catch (Throwable t) {
            D.log((Throwable)t);
        }
        return rcode;
    }

    private String[] getGadgetNames() {
        ZipEntry[] zeaGadgets = this.getGadgetEntries();
        String[] rcode = new String[zeaGadgets.length];
        for (int i = 0; i < zeaGadgets.length; ++i) {
            rcode[i] = zeaGadgets[i].getName().substring("packages/".length());
        }
        return rcode;
    }

    private String[] getModuleNames() {
        ZipEntry[] zeaModules = this.getModuleEntries();
        String[] rcode = new String[zeaModules.length];
        for (int i = 0; i < zeaModules.length; ++i) {
            rcode[i] = zeaModules[i].getName().substring("packages/".length());
        }
        return rcode;
    }

    private String getZipEntry(int iIndex) {
        String sRet = null;
        for (int i = 0; i < ZIP_ENTRIES.length; ++i) {
            if ((Integer)ZIP_ENTRIES[i][0] != iIndex) continue;
            sRet = (String)ZIP_ENTRIES[i][1];
            break;
        }
        return sRet;
    }

    private ZipEntry[] getGadgetEntries() {
        Vector<ZipEntry> v = new Vector<ZipEntry>();
        Enumeration<JarEntry> e = this.m_jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = e.nextElement();
            if (!zipEntry.getName().startsWith("packages/") || !zipEntry.getName().endsWith(FILE_EXT_GADGET)) continue;
            v.add(zipEntry);
        }
        return v.toArray(new ZipEntry[0]);
    }

    private ZipEntry[] getModuleEntries() {
        Vector<ZipEntry> v = new Vector<ZipEntry>();
        Enumeration<JarEntry> e = this.m_jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = e.nextElement();
            if (!zipEntry.getName().startsWith("packages/") || !zipEntry.getName().endsWith(FILE_EXT_PORTAL_MODULE)) continue;
            v.add(zipEntry);
        }
        return v.toArray(new ZipEntry[0]);
    }

    private void loadInstaller() {
        String sPortalModuleInstaller;
        if (null != this.m_manifest && null != (sPortalModuleInstaller = this.m_manifest.getMainAttributes().getValue(KEY_MODULE_INSTALLER))) {
            try {
                NPSClassLoader loader = new NPSClassLoader(this.m_jarFile.getName(), this.getClass().getClassLoader());
                Class<?> newClass = loader.loadClass(sPortalModuleInstaller);
                this.m_installer = (PortalModuleInstaller)newClass.newInstance();
                if (null != this.m_installer) {
                    this.m_installer.init(null);
                    this.m_installer.setData(513, this.m_fArchiveFile);
                    this.m_installer.setData(2, null);
                    this.m_installer.setData(514, this.m_fDestFolder);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean installGadget(File fGadgetPackage, File fDestFolder, String sContextPath) {
        boolean bInstalled = false;
        try {
            UnZipGadget npgPackageInstaller = new UnZipGadget(fGadgetPackage.getAbsolutePath());
            bInstalled = npgPackageInstaller.installGadget(fDestFolder.getAbsolutePath(), sContextPath);
        }
        catch (Throwable t) {
            D.log((String)("Error installing gadget: " + fGadgetPackage.getName() + " (" + fGadgetPackage.getAbsolutePath() + ")" + t));
        }
        return bInstalled;
    }

    private Document getXSL(String sXML, Locale locale) {
        Document domRet = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMResult resultDOM = new DOMResult();
            transformer.transform(new StreamSource(new StringReader(sXML)), resultDOM);
            Node node = resultDOM.getNode();
            NodeList nodelist = node.getChildNodes();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                InputStream inputstreamXSL;
                Node nodeChild = nodelist.item(i);
                if (7 != nodeChild.getNodeType()) continue;
                String sValue = nodeChild.getNodeValue();
                int iIndexBegin = sValue.indexOf(MARKER_HREF);
                if (0 <= iIndexBegin) {
                    int iIndexEnd = sValue.indexOf(34, iIndexBegin += MARKER_HREF.length() + 2);
                    inputstreamXSL = this.findI18NEntry(sValue.substring(iIndexBegin, iIndexEnd), locale);
                } else {
                    inputstreamXSL = this.findI18NEntry(DEFAULT_FILE_XSL, locale);
                }
                if (null != inputstreamXSL) {
                    resultDOM = new DOMResult();
                    transformer.transform(new StreamSource(inputstreamXSL), resultDOM);
                    Node nodeDOM = resultDOM.getNode();
                    if (9 == nodeDOM.getNodeType()) {
                        NodeList nodelistDOM = nodeDOM.getFirstChild().getChildNodes();
                        for (int j = 0; j < nodelistDOM.getLength(); ++j) {
                            Node nodeSubChild = nodelistDOM.item(j);
                            if (!MARKER_INCLUDE.equalsIgnoreCase(nodeSubChild.getNodeName())) continue;
                            String sInclude = nodeSubChild.getAttributes().getNamedItem(MARKER_HREF).getNodeValue();
                            InputStream inputstreamInclude = this.findI18NEntry(sInclude, locale);
                            Document domInclude = DOMUtil.XMLToDOM(inputstreamInclude, "UTF-8");
                            DOMUtil.replaceNode(nodeSubChild, domInclude);
                            inputstreamInclude.close();
                        }
                        domRet = (Document)nodeDOM;
                    }
                    inputstreamXSL.close();
                }
                break;
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
        return domRet;
    }

    public String uninstallAnyWhere(String sWebAppContextPath, String npmPath, boolean isiManagerRunning) throws PortalDirectoryException {
        String sRet;
        block12: {
            sRet = "";
            try {
                if (isiManagerRunning) {
                    D.log((String)("Entering uninstall FwZipOps: npmPath: " + npmPath + "   webAppRoot: " + sWebAppContextPath));
                } else {
                    System.out.println("Entering uninstall FwZipOps: npmPath: " + npmPath + "   webAppRoot: " + sWebAppContextPath);
                }
                File npmFile = new File(npmPath);
                if (npmFile.exists()) {
                    FwZipOps.uninstallModuleSync(npmPath, sWebAppContextPath);
                    this.processNPMCommandFiles(this.m_jarFile, sWebAppContextPath, isiManagerRunning, false);
                    if (isiManagerRunning) {
                        D.log((String)("Exiting uninstall FwZipOps with no exceptions: npmPath: " + npmPath + "   webAppRoot: " + sWebAppContextPath));
                    } else {
                        System.out.println("Exiting uninstall FwZipOps with no exceptions: npmPath: " + npmPath + "   webAppRoot: " + sWebAppContextPath);
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof NullPointerException) break block12;
                if (isiManagerRunning) {
                    D.log((String)("uninstaller threw when called uninstallAnyWhere():" + t));
                } else {
                    System.out.println("uninstaller threw when called uninstallAnyWhere(): " + t);
                }
                t.printStackTrace();
            }
        }
        if (this.m_jarFile != null) {
            try {
                this.m_jarFile.close();
                this.m_jarFile = null;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return sRet;
    }

    public String installAnyWhere(String sWebAppContextPath, File jspPath, boolean isiManagerRunning) throws PortalDirectoryException {
        String sRet;
        block108: {
            sRet = "";
            ModuleConfig moduleConfig = null;
            if (this.m_bInstall) {
                block107: {
                    if (isiManagerRunning) {
                        AuditLog.logModuleInstall((String)this.m_sModuleTitle, (String)this.m_fArchiveFile.getName());
                    } else {
                        System.out.println("m_sModuleTitle: " + this.m_fArchiveFile.getName());
                    }
                    moduleConfig = new ModuleConfig();
                    moduleConfig.setID(this.getModuleID());
                    this.setModuleConfigInfo(moduleConfig);
                    try {
                        if (null != this.m_installer) {
                            this.m_installer.setData(1, null);
                        }
                    }
                    catch (Throwable t) {
                        if (isiManagerRunning) {
                            D.log((String)("installer threw when called \"setData(MODULE_DN)\"" + t));
                        }
                        System.out.println("installer threw when called installAnyWhere()");
                    }
                    try {
                        if (null != this.m_installer) {
                            this.m_installer.preInstall();
                        }
                    }
                    catch (Throwable t) {
                        if (isiManagerRunning) {
                            D.log((Throwable)t);
                            try {
                                if (null != this.m_installer) {
                                    this.m_installer.errorInstall(new Exception(t));
                                }
                            }
                            catch (Throwable ignore) {}
                        }
                        System.out.println(t);
                    }
                    try {
                        if (null != this.m_installer) {
                            this.m_installer.preFilesInstall();
                        }
                    }
                    catch (Throwable t) {
                        if (isiManagerRunning) {
                            D.log((Throwable)t);
                            try {
                                if (null != this.m_installer) {
                                    this.m_installer.errorInstall(new Exception(t));
                                }
                            }
                            catch (Throwable ignore) {}
                        }
                        System.out.println(t);
                    }
                    try {
                        block104: {
                            Hashtable<String, String> htInstallAnyWhere = new Hashtable<String, String>();
                            htInstallAnyWhere.put(FOLDER_ADDITIONAL_FILES, this.m_fDestFolder.getAbsolutePath());
                            File fMetaInf = new File(this.m_fDestFolder, WEBINF_DIRECTORY + File.separator + FOLDER_MODULES + File.separator + this.m_sModuleID + File.separator + META_INF);
                            htInstallAnyWhere.put(FOLDER_META_INF, fMetaInf.getAbsolutePath());
                            try {
                                File oTempDir = null;
                                if (null != jspPath) {
                                    oTempDir = jspPath;
                                }
                                if (null == oTempDir || !(oTempDir instanceof File)) break block104;
                                try {
                                    htInstallAnyWhere.put("compiledjsps/nps/", ((Object)oTempDir).toString());
                                }
                                catch (Throwable ignore) {
                                    // empty catch block
                                }
                                htInstallAnyWhere.put("currentmodule/jsp/", ((Object)oTempDir).toString());
                                if (isiManagerRunning) {
                                    D.log((String)("Entering install FwZipOps: npmPath: " + this.m_jarFile.getName() + "    hash: " + htInstallAnyWhere.toString() + "   webAppRoot: " + sWebAppContextPath));
                                } else {
                                    System.out.println("Entering install FwZipOps: npmPath: " + this.m_jarFile.getName() + "   webAppRoot: " + sWebAppContextPath);
                                }
                                boolean moduleInstalled = FwZipOps.installModuleSync(this.m_jarFile.getName(), htInstallAnyWhere, sWebAppContextPath);
                                if (moduleInstalled) {
                                    this.processNPMCommandFiles(this.m_jarFile, sWebAppContextPath, isiManagerRunning, true);
                                    this.updateSchema(isiManagerRunning);
                                } else {
                                    Exception e = new Exception("Cannot install the npm as it is incompatible with this version of iManager");
                                    if (isiManagerRunning) {
                                        D.log((Throwable)e);
                                    } else {
                                        System.out.println(e);
                                    }
                                }
                                if (isiManagerRunning) {
                                    D.log((String)("Exiting install FwZipOps: npmPath: " + this.m_jarFile.getName() + "    hash: " + htInstallAnyWhere.toString() + "   webAppRoot: " + sWebAppContextPath));
                                } else {
                                    System.out.println("Exiting install FwZipOps: npmPath: " + this.m_jarFile.getName() + "   webAppRoot: " + sWebAppContextPath);
                                }
                            }
                            catch (Throwable t) {
                                if (isiManagerRunning) {
                                    D.log((Throwable)t);
                                }
                                System.out.println(t);
                            }
                        }
                        if (null != this.m_installer) {
                            this.m_installer.postFilesInstall();
                        }
                    }
                    catch (Exception e) {
                        if (isiManagerRunning) {
                            D.log((Throwable)e);
                            try {
                                if (null != this.m_installer) {
                                    this.m_installer.errorFilesInstall(e);
                                }
                            }
                            catch (Exception ignore) {}
                        } else {
                            System.out.println(e);
                        }
                        throw new PortalDirectoryException(e.getLocalizedMessage());
                    }
                    catch (Throwable t) {
                        if (isiManagerRunning) {
                            D.log((Throwable)t);
                            try {
                                if (null != this.m_installer) {
                                    this.m_installer.errorFilesInstall(new Exception(t));
                                }
                            }
                            catch (Throwable ignore) {}
                        } else {
                            System.out.println(t);
                        }
                        throw new PortalDirectoryException(t.getLocalizedMessage());
                    }
                    String[] saModules = this.getModuleNames();
                    if (0 < saModules.length) {
                        try {
                            File[] faModules = new File[saModules.length];
                            for (int i = 0; i < saModules.length; ++i) {
                                faModules[i] = FwZipOps.extractFile((ZipFile)this.m_jarFile, "packages/" + saModules[i], new File(ModuleManager.getPackagesDir().getAbsolutePath(), saModules[i]));
                            }
                            PortalModuleInstallManager installManager = new PortalModuleInstallManager(faModules, this.m_fDestFolder);
                            installManager.getData(null);
                            installManager.install(sWebAppContextPath, jspPath.getAbsolutePath());
                        }
                        catch (Throwable t) {
                            if (isiManagerRunning) {
                                D.log((Throwable)t);
                            }
                            System.out.println(t);
                        }
                    }
                    try {
                        String[] saGadgets = this.getGadgetNames();
                        for (int i = 0; i < saGadgets.length; ++i) {
                            File fGadgetPackage = FwZipOps.extractFile((ZipFile)this.m_jarFile, "packages/" + saGadgets[i], new File(System.getProperty(SYS_PROPERTY_TMP_DIR), saGadgets[i]));
                            try {
                                if (null != this.m_installer) {
                                    this.m_installer.preGadgetInstall(fGadgetPackage, sWebAppContextPath, null);
                                }
                            }
                            catch (Throwable t) {
                                if (isiManagerRunning) {
                                    D.log((Throwable)t);
                                    try {
                                        if (null != this.m_installer) {
                                            this.m_installer.errorInstall(new Exception(t));
                                        }
                                    }
                                    catch (Throwable ignore) {}
                                }
                                System.out.println(t);
                            }
                            try {
                                boolean bInstalled = this.installGadget(fGadgetPackage, this.m_fDestFolder, sWebAppContextPath);
                                if (bInstalled && null != this.m_installer) {
                                    this.m_installer.postGadgetInstall(fGadgetPackage, sWebAppContextPath, null);
                                }
                            }
                            catch (Throwable t) {
                                if (isiManagerRunning) {
                                    D.log((Throwable)t);
                                    try {
                                        if (null != this.m_installer) {
                                            this.m_installer.errorGadgetInstall(new Exception(t), fGadgetPackage, sWebAppContextPath, null);
                                        }
                                    }
                                    catch (Throwable ignore) {}
                                }
                                System.out.println(t);
                            }
                            try {
                                if (fGadgetPackage.delete()) continue;
                                fGadgetPackage.deleteOnExit();
                                continue;
                            }
                            catch (Throwable t) {
                                if (isiManagerRunning) {
                                    D.log((Throwable)t);
                                    try {
                                        if (null == this.m_installer) continue;
                                        this.m_installer.errorInstall(new Exception(t));
                                    }
                                    catch (Throwable ignore) {}
                                    continue;
                                }
                                System.out.println(t);
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (isiManagerRunning) {
                            D.log((Throwable)t);
                            try {
                                if (null != this.m_installer) {
                                    this.m_installer.errorInstall(new Exception(t));
                                }
                            }
                            catch (Throwable ignore) {}
                        }
                        System.out.println(t);
                    }
                    try {
                        InputStream isPortalServletProperties = this.getStream(259, null);
                        if (isPortalServletProperties == null) break block107;
                        Properties properties = new Properties();
                        properties.load(isPortalServletProperties);
                        isPortalServletProperties.close();
                        File fileProperties = new File(this.m_fDestFolder + PSP_DIRECTORY, SERVLET_PROPERTIES_FILE_NAME);
                        if (fileProperties.exists()) {
                            try {
                                FileInputStream inputStream = new FileInputStream(fileProperties);
                                properties.load(inputStream);
                                inputStream.close();
                            }
                            catch (Throwable t) {
                                if (isiManagerRunning) {
                                    D.log((String)("Couldn't add settings to PortalServlet.properties" + t));
                                }
                                System.out.println("Couldn't add settings to PortalServlet.properties");
                            }
                        }
                        try {
                            properties.store(new FileOutputStream(fileProperties), "eXtend");
                        }
                        catch (Throwable t) {
                            if (isiManagerRunning) {
                                D.log((String)("Could store PortalServlet.properties" + t));
                                break block107;
                            }
                            System.out.println("Could store PortalServlet.properties");
                        }
                    }
                    catch (Throwable t) {
                        if (isiManagerRunning) {
                            D.log((Throwable)t);
                            try {
                                if (null != this.m_installer) {
                                    this.m_installer.errorInstall(new Exception(t));
                                }
                            }
                            catch (Throwable ignore) {}
                        }
                        System.out.println(t);
                    }
                }
                try {
                    if (null != this.m_installer) {
                        this.m_installer.postInstall();
                    }
                }
                catch (Throwable t) {
                    if (isiManagerRunning) {
                        D.log((Throwable)t);
                        try {
                            if (null != this.m_installer) {
                                this.m_installer.errorInstall(new Exception(t));
                            }
                            break block108;
                        }
                        catch (Throwable ignore) {}
                        break block108;
                    }
                    System.out.println(t);
                }
            } else {
                System.out.println("This NPM cannot be installed:  " + this.m_fArchiveFile.getName() + "  Check the required version in the manifest file.");
                sRet = "The " + this.m_fArchiveFile.getName() + " cannot be installed in this version of iManager." + "  The required version in the manifest file does not allow this plugin to be installed.";
            }
        }
        if (this.m_jarFile != null) {
            try {
                this.m_jarFile.close();
                this.m_jarFile = null;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return sRet;
    }

    private String isSchemaExtensionRequired() {
        String[] fnames;
        File schemaFileFolderPath = new File(this.m_fDestFolder.getAbsolutePath() + File.separatorChar + FOLDER_PORTAL + File.separatorChar + FOLDER_MODULES + File.separatorChar + this.m_sModuleID + File.separatorChar + FOLDER_SCHEMA);
        String schemaFile = "";
        if (schemaFileFolderPath.exists() && schemaFileFolderPath.isDirectory() && (fnames = schemaFileFolderPath.list()).length == 1) {
            schemaFile = fnames[0];
        }
        return schemaFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSchema(boolean isiManagerRunning) throws Exception {
        try {
            String schemaFile = this.isSchemaExtensionRequired();
            if (schemaFile.equals("")) {
                if (isiManagerRunning) {
                    D.log((String)"No Schema or multiple schema files provided,so not extending schema");
                    return;
                } else {
                    System.out.println("No Schema or multiple schema files provided,so not extending schema");
                }
                return;
            }
            String protocol = "";
            if (schemaFile.toLowerCase().indexOf(".sch") != -1) {
                protocol = "SCH";
            } else if (schemaFile.toLowerCase().indexOf(".ldif") != -1) {
                protocol = "LDIF";
            }
            if (protocol.equals("")) {
                if (isiManagerRunning) {
                    D.log((String)"Wrong extension of schema files,no protocol to use exiting");
                    return;
                } else {
                    System.out.println("Wrong extension of schema files,no protocol to use exiting");
                }
                return;
            }
            Vector schemaparams = PortalModuleInstallManager.getSchemaDetails();
            if (schemaparams.size() > 0) {
                String certpath = "";
                File schemaFileFolderPath = new File(this.m_fDestFolder.getAbsolutePath() + File.separatorChar + FOLDER_PORTAL + File.separatorChar + FOLDER_MODULES + File.separatorChar + this.m_sModuleID + File.separatorChar + FOLDER_SCHEMA);
                schemaFile = schemaFileFolderPath.getAbsolutePath() + File.separatorChar + schemaFile;
                String logFileName = this.m_fDestFolder.getAbsolutePath() + File.separatorChar + WEBINF_DIRECTORY + File.separatorChar + "logs" + File.separatorChar + "ice.log";
                File logFile = new File(logFileName);
                if (((Boolean)schemaparams.get(3)).booleanValue()) {
                    String certfilename = this.m_fDestFolder.getAbsolutePath() + File.separatorChar + WEBINF_DIRECTORY + File.separatorChar + "ServerCert.der";
                    File certfile = new File(certfilename);
                    if (!certfile.exists()) throw new Exception("Required Certificate not available,so cannoe execute ICE through SSL");
                    certpath = " -L" + certfilename;
                }
                String endcommand = " -l" + logFileName + " -C -a -S" + protocol + " -f" + schemaFile + " -DLDAP" + " -s" + (String)schemaparams.get(0) + " -p" + schemaparams.get(4) + " -d" + (String)schemaparams.get(1) + " -w" + (String)schemaparams.get(2) + certpath;
                String startcommand = this.m_fDestFolder.getAbsolutePath() + File.separatorChar + WEBINF_DIRECTORY + File.separatorChar + "bin" + File.separatorChar;
                String OSname = System.getProperty("os.name");
                String command = "";
                if (OSname.toLowerCase().startsWith(os_linux) || OSname.toLowerCase().startsWith(os_windows)) {
                    File eDirExtendedfile = new File(this.m_fDestFolder.getAbsolutePath() + File.separatorChar + WEBINF_DIRECTORY + File.separatorChar + FOLDER_MODULES + File.separatorChar + "eDirExtended");
                    if (!eDirExtendedfile.exists()) throw new Exception("eDirExtended plugin is required for schema extension to work,eDir extended plugin is not available");
                    if (OSname.toLowerCase().startsWith(os_linux)) {
                        command = startcommand + os_linux + File.separatorChar + "ice" + endcommand;
                    } else if (OSname.toLowerCase().startsWith(os_windows)) {
                        command = startcommand + os_windows + File.separatorChar + "ice.exe" + endcommand;
                    }
                } else if (OSname.toLowerCase().startsWith(os_netware)) {
                    command = "ice -b" + endcommand;
                }
                try {
                    Runtime.getRuntime().exec(command);
                    if (isiManagerRunning) {
                        D.log((String)"Schema Extended successfully");
                        return;
                    } else {
                        System.out.println("Schema Extended successfully");
                    }
                    return;
                }
                catch (IOException e) {
                    throw new Exception("Executing ICE command failed ");
                }
            }
            if (isiManagerRunning) {
                D.log((String)"ICE parameters not available ,so cannot execute ICE");
                return;
            } else {
                System.out.println("ICE parameters not available ,so cannot execute ICE");
            }
            return;
        }
        catch (Exception e) {
            if (isiManagerRunning) {
                D.log((String)e.getMessage());
                return;
            }
            System.out.println(e.getMessage());
        }
    }

    private void pmout(String tmessage, Throwable te, boolean isiManagerRunning) {
        if (isiManagerRunning) {
            D.log((Throwable)te);
        } else {
            System.out.println(tmessage);
            if (te != null) {
                te.printStackTrace();
            }
        }
    }

    private void processNPMCommandFiles(JarFile currentNPMJar, String iManWebAppContextPath, boolean isiManagerRunning, boolean isInstall) {
        String fullWepAppDir = null;
        for (int nca = 0; nca < NPNCOMMANDFILEARR.length; ++nca) {
            String npmCommandFile = NPNCOMMANDFILEARR[nca];
            ZipEntry commandZipEntry = currentNPMJar.getEntry(npmCommandFile);
            if (commandZipEntry == null) continue;
            try {
                if (fullWepAppDir == null) {
                    fullWepAppDir = iManWebAppContextPath.endsWith(File.separator) ? iManWebAppContextPath : iManWebAppContextPath + File.separator;
                }
                String platformCheck = NPMCOMMAND_DEFAULTPLATFORMS;
                InputStream comInputStream = currentNPMJar.getInputStream(commandZipEntry);
                BufferedReader bufReader = new BufferedReader(new InputStreamReader(comInputStream));
                String comLine = bufReader.readLine();
                while (comLine != null) {
                    if (comLine.length() != 0 && comLine.charAt(0) != '#') {
                        if (comLine.regionMatches(true, 0, NPMCOMMAND_CTRLPLATFORM, 0, NPMCOMMAND_CTRLPLATFORM.length())) {
                            platformCheck = comLine.toLowerCase();
                        } else if (platformCheck.indexOf(PortalModule.getPlatform()) != -1) {
                            try {
                                String[] params = this.parseCommandFileLine(comLine);
                                if (npmCommandFile == NPMCOMMAND_SYMBOLICLINKS) {
                                    this.processSymbolicLinkLine(params, fullWepAppDir, isiManagerRunning, isInstall);
                                } else if (npmCommandFile == NPMCOMMAND_PERMISSIONS) {
                                    this.processPermissionLine(params, fullWepAppDir, isiManagerRunning, isInstall);
                                } else if (npmCommandFile == NPMCOMMAND_DELETEFILES) {
                                    this.processDeleteFileLine(params, fullWepAppDir, isiManagerRunning, isInstall, platformCheck);
                                }
                            }
                            catch (Exception e) {
                                String tmess = "Error processing line (" + comLine + "): " + e.toString();
                                this.pmout(tmess, null, isiManagerRunning);
                            }
                        }
                    }
                    comLine = bufReader.readLine();
                }
                bufReader.close();
                continue;
            }
            catch (Throwable terr) {
                String tmess = "Error processing command file (" + npmCommandFile + "): " + terr.toString();
                this.pmout(tmess, null, isiManagerRunning);
            }
        }
    }

    private String[] parseCommandFileLine(String comLine) throws Exception {
        ArrayList<String> paramList = new ArrayList<String>(3);
        int llen = comLine.length();
        int cpos = 0;
        while (cpos < llen) {
            while (cpos < llen && Character.isWhitespace(comLine.charAt(cpos))) {
                ++cpos;
            }
            int pStart = cpos;
            while (cpos < llen && !Character.isWhitespace(comLine.charAt(cpos))) {
                if (comLine.charAt(cpos) == ';') {
                    throw new Exception("semicolon ';' not allowed in paramaters");
                }
                ++cpos;
            }
            if (cpos <= pStart) continue;
            paramList.add(comLine.substring(pStart, cpos));
        }
        String[] sParam = new String[paramList.size()];
        sParam = paramList.toArray(sParam);
        return sParam;
    }

    private void processSymbolicLinkLine(String[] symParams, String fullWebAppDir, boolean isiManagerRunning, boolean isInstall) throws Exception {
        if (symParams.length < 2) {
            throw new Exception("Invalid Line");
        }
        if (!PortalModule.getPlatform().equals(os_windows) && !PortalModule.getPlatform().equals(os_netware)) {
            String symLinkName = symParams[0].replace('\\', File.separatorChar);
            String symTarget = symParams[1].replace('\\', File.separatorChar);
            if (isInstall) {
                String rmcommand = "rm -f " + fullWebAppDir + symLinkName;
                this.pmLaunchExec(rmcommand, isiManagerRunning);
                String lncommand = "ln -sf " + symTarget + " " + fullWebAppDir + symLinkName;
                this.pmLaunchExec(lncommand, isiManagerRunning);
            } else {
                String rmcommand = "rm -f " + fullWebAppDir + symLinkName;
                this.pmLaunchExec(rmcommand, isiManagerRunning);
            }
        }
    }

    private void processPermissionLine(String[] symParams, String fullWebAppDir, boolean isiManagerRunning, boolean isInstall) throws Exception {
        if (symParams.length < 2) {
            throw new Exception("Invalid Line");
        }
        if (isInstall && !PortalModule.getPlatform().equals(os_windows) && !PortalModule.getPlatform().equals(os_netware)) {
            String fileName = symParams[0].replace('\\', File.separatorChar);
            String filePermissions = symParams[1];
            String command = "chmod " + filePermissions + " " + fullWebAppDir + fileName;
            this.pmLaunchExec(command, isiManagerRunning);
        }
    }

    private String[] processDeleteFileLine(String[] symParams, String fullWebAppDir, boolean isiManagerRunning, boolean isInstall, String platformCheck) throws Exception {
        if (symParams.length < 1) {
            throw new Exception("Invalid Line");
        }
        if (isInstall) {
            String platform = platformCheck.substring(platformCheck.indexOf(":") + 1, platformCheck.length());
            if ((platform = platform.trim()).indexOf(os_linux) != -1 && platform.equals(PortalModule.getPlatform())) {
                File f;
                String symLinkName = symParams[0].replace('\\', File.separatorChar);
                String rmcommand = "rm -f " + fullWebAppDir + symLinkName;
                int retCode = this.pmLaunchExec(rmcommand, isiManagerRunning);
                if (retCode != 0 && (f = new File(fullWebAppDir + symLinkName)).exists() && !f.delete()) {
                    f.deleteOnExit();
                }
                if (isiManagerRunning) {
                    D.log((String)(rmcommand + " executed successfully"));
                } else {
                    System.out.println(rmcommand + " executed successfully");
                }
            } else if (PortalModule.getPlatform().equals(os_windows) || PortalModule.getPlatform().equals(os_netware)) {
                String symLinkName = symParams[0].replace('/', File.separatorChar);
                symLinkName = symLinkName.replace('\\', File.separatorChar);
                File f = new File(fullWebAppDir + symLinkName);
                if (f.exists() && !f.delete()) {
                    f.deleteOnExit();
                }
                if (isiManagerRunning) {
                    D.log((String)"Delete file task executed successfully");
                } else {
                    System.out.println("Delete file task executed successfully");
                }
            }
        }
        return new String[]{""};
    }

    private int pmLaunchExec(String command, boolean isiManagerRunning) {
        String returnString = "";
        int retCode = -1;
        try {
            System.out.println("launchExec command: " + command);
            ShellCommand cmd = new ShellCommand(command);
            cmd.eatOutput();
            cmd.eatErrorOutput();
            cmd.stdin.close();
            cmd.waitFor();
            retCode = cmd.exitValue();
            if (retCode != 0) {
                String rMsg = "launchExec: " + command + " failed. Return code = " + retCode;
                System.out.println(rMsg);
                this.pmout(rMsg, null, isiManagerRunning);
            }
        }
        catch (Throwable t) {
            String rMsg = "launchExec: " + command + " failed.";
            System.out.println(rMsg);
            this.pmout(rMsg, t, isiManagerRunning);
        }
        return retCode;
    }

    public static String getPlatform() {
        if (osName == null) {
            String ostmp = System.getProperty("os.name");
            if (ostmp.startsWith("Linux")) {
                osName = os_linux;
                if (PortalModule.checkOES()) {
                    osName = os_oes_linux;
                }
            } else {
                osName = ostmp.startsWith("Windows") ? os_windows : (ostmp.startsWith("Solaris") || ostmp.startsWith("SunOS") ? os_solaris : (ostmp.startsWith("NetWare") ? os_netware : (ostmp.startsWith("HP-UX") ? os_hpux : (ostmp.startsWith("AIX") ? os_aix : os_unknown))));
            }
        }
        return osName;
    }

    private static boolean checkOES() {
        boolean isOES = false;
        if (System.getProperty("os.name").toLowerCase().indexOf(os_linux) != -1) {
            File testFile = new File("/etc/novell-release");
            isOES = testFile.exists() ? PortalModule.isInstalled("oes-release") : PortalModule.isInstalled("novell-oes-install");
        }
        return isOES;
    }

    private static boolean isInstalled(String packageName) {
        return PortalModule.runCommand("rpm -q " + packageName);
    }

    private static boolean runCommand(String command) {
        try {
            ShellCommand cmd = new ShellCommand("sh");
            cmd.feedInput(command);
            cmd.stdin.close();
            cmd.waitFor();
            if (cmd.exitValue() != 0) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static class PortalModuleDescriptor {
        File m_fArchiveFile;
        String m_sModuleCN;

        PortalModuleDescriptor(File fArchiveFile, String sModuleCN) {
            this.m_fArchiveFile = fArchiveFile;
            this.m_sModuleCN = sModuleCN;
        }
    }
}

