/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders;

import com.novell.emframe.dev.D;
import com.novell.emframe.fw.AuditLog;
import com.novell.emframe.fw.config.ModuleManager;
import com.novell.nps.WebappUtil;
import com.novell.nps.authentication.PortalConnection;
import com.novell.nps.configManager.NPSVersion;
import com.novell.nps.configManager.PCO;
import com.novell.nps.serviceProviders.PortalModule;
import com.novell.nps.utils.ParameterFilteredRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortalModuleInstallManager
extends HttpServlet {
    public static final String HEADER_MODULE_RESULT = "ModuleResult";
    private static final String PARAMETER_MODULE = PortalModuleInstallManager.class.getName() + "_MODULE";
    private static final String HTML_TAG_FORM = "form";
    private static final String HTML_TAG_FORM_ATTRIBUTE_ACTION = "action";
    private static final String HTML_TAG_INPUT = "input";
    private static final String HTML_TAG_INPUT_TYPE = "type";
    private static final String HTML_TAG_INPUT_TYPE_HIDDEN = "hidden";
    private static final String HTML_TAG_INPUT_NAME = "name";
    private static final String HTML_TAG_INPUT_VALUE = "value";
    private static final String PARAMETER_MODULE_PATH = "MODULE_PATH";
    private static final String PARAMETER_MODULE_FILE = "MODULE_FILE";
    private static final String PARAMETER_ADMIN_DN = "DN";
    private static final String PARAMETER_ADMIN_PASSWORD = "PASSWORD";
    private static final String KEY_LDAP_SERVER = "System.DirectoryAddress";
    private static final String KEY_LDAP_SSL = "System.DirectorySSL";
    private static final String KEY_PCODN = "System.PortalConfigurationObjectDN";
    private static final String SERVLET_PROPERTIES_FILE_PATH = "/WEB-INF/PortalServlet.properties";
    private static final String HEADER_SERVER_HOST = "host";
    private static final String SYSTEM_PROPERTY_TEMP_FOLDER = "java.io.tmpdir";
    private static final String DT = "PortalModuleInstallManager";
    private static Vector schemaDetails = new Vector();
    private ServletContext m_context;
    private boolean m_isInsideiManager;
    PortalModule[] m_modules;
    PortalModule m_module;
    private static final String TAG_TYPE_MULTIPART_FORM = "multipart/form-data";
    private static final String TAG_MULTIPART_FORM_DATA_BOUNDARY = "boundary=";
    private static final String TAG_ENTRY_NAME = "name=\"";
    private static final String TAG_FILE_NAME = "filename=\"";

    public PortalModuleInstallManager() {
        this.m_context = null;
        this.m_isInsideiManager = true;
        this.m_modules = null;
        this.m_module = null;
    }

    PortalModuleInstallManager(PortalModule[] modules) {
        this.m_context = null;
        this.m_isInsideiManager = true;
        this.m_modules = null;
        this.m_module = null;
        this.m_modules = modules;
    }

    public PortalModuleInstallManager(PortalModule.PortalModuleDescriptor[] portalModuleDescriptors, PortalConnection portalConn, PCO pco, String sWebServerAddress, File fInstallFolder) {
        this(PortalModuleInstallManager.getModules(portalModuleDescriptors, fInstallFolder));
    }

    public PortalModuleInstallManager(PortalModule.PortalModuleDescriptor[] portalModuleDescriptors, File fInstallFolder) {
        this(PortalModuleInstallManager.getModules(portalModuleDescriptors, fInstallFolder));
    }

    public PortalModuleInstallManager(File[] faModules, PortalConnection portalConn, PCO pco, String sWebServerAddress, File fInstallFolder) {
        this(faModules, fInstallFolder);
    }

    public PortalModuleInstallManager(File[] faModules, File fInstallFolder) {
        this(PortalModuleInstallManager.getPortalModuleDescriptors(faModules), fInstallFolder);
    }

    public PortalModuleInstallManager(File fFile, String sModuleCN, PortalConnection portalConn, PCO pco, String sWebServerAddress, File fInstallFolder) {
        this(fFile, fInstallFolder);
    }

    public PortalModuleInstallManager(File fFile, File fInstallFolder) {
        this(new PortalModule.PortalModuleDescriptor[]{new PortalModule.PortalModuleDescriptor(fFile, null)}, fInstallFolder);
    }

    public PortalModuleInstallManager(String sFile, String sModuleCN, PortalConnection portalConn, PCO pco, String sWebServerAddress, File fInstallFolder) {
        this(sFile, fInstallFolder);
    }

    public PortalModuleInstallManager(String sFile, File fInstallFolder) {
        this(new File(sFile), fInstallFolder);
    }

    public PortalModuleInstallManager(File fFile, PortalConnection portalConn, PCO pco, String sWebServerAddress, File fInstallFolder) {
        File[] fileArray;
        if (fFile.isDirectory()) {
            fileArray = fFile.listFiles(new PortalModuleFilenameFilter());
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = fFile;
        }
        this(fileArray, fInstallFolder);
    }

    public PortalModuleInstallManager(File fFile, PortalConnection portalConn, String sPCODN, String sWebServerAddress, File fInstallFolder) {
        this(PortalModuleInstallManager.getModules(PortalModuleInstallManager.getPortalModuleDescriptors(fFile.listFiles(new PortalModuleFilenameFilter())), fInstallFolder));
    }

    private static PortalModule.PortalModuleDescriptor[] getPortalModuleDescriptors(File[] faModules) {
        Vector<PortalModule.PortalModuleDescriptor> vModules = new Vector<PortalModule.PortalModuleDescriptor>();
        for (int i = 0; i < faModules.length; ++i) {
            try {
                vModules.add(new PortalModule.PortalModuleDescriptor(faModules[i], null));
                continue;
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
        return vModules.toArray(new PortalModule.PortalModuleDescriptor[0]);
    }

    private static PortalModule[] getModules(PortalModule.PortalModuleDescriptor[] portalModuleDescriptors, File fInstallFolder) {
        Vector<PortalModule> vModules = new Vector<PortalModule>();
        for (int i = 0; i < portalModuleDescriptors.length; ++i) {
            try {
                vModules.add(new PortalModule(fInstallFolder, portalModuleDescriptors[i].m_fArchiveFile));
                continue;
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
        return vModules.toArray(new PortalModule[0]);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_context = config.getServletContext();
        if (null == WebappUtil.getPortalServlet()) {
            WebappUtil.init(this);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int iError = 417;
        try {
            String sModule;
            if (this.isMultiPart(request)) {
                HashMap mapParameters = this.getMultiPartParameters(request);
                String sAdminDN = (String)mapParameters.get(PARAMETER_ADMIN_DN);
                String sAdminPassword = (String)mapParameters.get(PARAMETER_ADMIN_PASSWORD);
                sModule = (String)mapParameters.get(PARAMETER_MODULE_FILE);
            } else {
                String sAdminDN = request.getParameter(PARAMETER_ADMIN_DN);
                String sAdminPassword = request.getParameter(PARAMETER_ADMIN_PASSWORD);
                sModule = request.getParameter(PARAMETER_MODULE_PATH);
            }
            File fModule = new File(sModule);
            if (fModule.isFile()) {
                File fPackagesFolder = new File(WebappUtil.getRealPath("/packages"));
                File fDst = new File(fPackagesFolder, fModule.getName());
                if (!fDst.exists() || 0 >= new NPSVersion(fModule).compareTo(fDst)) {
                    if (!fDst.equals(fModule)) {
                        PortalModuleInstallManager.copyFile(fModule, fDst);
                    }
                    ModuleManager.readModulesToInstall();
                    iError = 200;
                } else {
                    iError = 409;
                }
            } else {
                iError = 400;
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
        response.addIntHeader(HEADER_MODULE_RESULT, iError);
        if (200 == iError || 409 == iError) {
            response.setStatus(200);
        } else {
            response.sendError(iError);
        }
    }

    public String getData(HttpServletRequest request) {
        return this.getData(request, null);
    }

    public String getData(HttpServletRequest request, String sAction) {
        String sRet = null;
        if (null != request) {
            String sModule = request.getParameter(PARAMETER_MODULE);
            if (null == sModule) {
                request = new ParameterFilteredRequest(request);
            }
            PortalModule module = this.getModule(sModule);
            while (null != module && null == (sRet = module.getData(request))) {
                if (!(request instanceof ParameterFilteredRequest)) {
                    request = new ParameterFilteredRequest(request);
                }
                module = this.getNextModule(module);
            }
            if (null != sRet) {
                sRet = PortalModuleInstallManager.setFormModule(sRet, module.getModuleTitle(), sAction);
            }
        } else {
            PortalModule module = this.getModule(null);
            while (null != module) {
                module.getData(null);
                module = this.getNextModule(module);
            }
        }
        return sRet;
    }

    public String[] install(HttpServletRequest request, PCO pco) {
        return this.install(null, request.getContextPath());
    }

    public String[] install(String sHost, String sWebAppContextPath, PCO pco) {
        return this.install(sHost, sWebAppContextPath);
    }

    public String[] install(String sHost, String sWebAppContextPath, PCO pco, boolean isAdmin) {
        return this.install(sHost, sWebAppContextPath);
    }

    public String[] install(String sHost, String sWebAppContextPath, PCO pco, boolean isAdmin, boolean bWriteLocation) {
        return this.install(sHost, sWebAppContextPath);
    }

    public String[] install(String sWebAppContextPath, String jspPath) {
        Vector<String> vRet = new Vector<String>();
        this.m_module = this.getModule(null);
        while (null != this.m_module) {
            block6: {
                try {
                    if (this.m_isInsideiManager) {
                        D.log((String)("Installing Module: " + this.m_module.getModuleTitle()));
                    }
                    String sSummary = this.m_module.installAnyWhere(sWebAppContextPath, new File(jspPath), this.m_isInsideiManager);
                    if (this.m_isInsideiManager) {
                        D.log((String)("Done installing: " + this.m_module.getModuleTitle()));
                    }
                    if (null != sSummary && 0 < sSummary.length()) {
                        vRet.add(sSummary);
                    }
                }
                catch (Exception e) {
                    if (!this.m_isInsideiManager) break block6;
                    D.log((Throwable)e);
                    AuditLog.logModuleInstallFailed((String)this.m_module.getModuleTitle(), (String)jspPath);
                }
            }
            this.m_module = this.getNextModule(this.m_module);
        }
        this.m_module = null;
        return vRet.toArray(new String[0]);
    }

    public String[] uninstall(String sWebAppContextPath, String npmName) {
        Vector<String> vRet = new Vector<String>();
        this.m_module = this.getModule(null);
        while (null != this.m_module) {
            try {
                if (this.m_isInsideiManager) {
                    D.log((String)("Uninstalling Module: " + this.m_module.getModuleTitle()));
                }
                String sSummary = this.m_module.uninstallAnyWhere(sWebAppContextPath, npmName, this.m_isInsideiManager);
                if (this.m_isInsideiManager) {
                    D.log((String)("Done Uninstalling: " + this.m_module.getModuleTitle()));
                }
                if (null != sSummary && 0 < sSummary.length()) {
                    vRet.add(sSummary);
                } else {
                    vRet.add(this.m_module.getModuleTitle());
                }
            }
            catch (Exception e) {
                if (this.m_isInsideiManager) {
                    D.log((Throwable)e);
                }
                vRet.add(this.m_module.getModuleTitle() + ":" + e.getLocalizedMessage());
            }
            this.m_module = this.getNextModule(this.m_module);
        }
        this.m_module = null;
        return vRet.toArray(new String[0]);
    }

    public PortalModule[] getModules() {
        return this.m_modules;
    }

    public void setInsideiManager(boolean flag) {
        this.m_isInsideiManager = flag;
    }

    public PortalModule getCurrentModule() {
        PortalModule pmRet = this.m_module;
        if (null == pmRet && null != this.m_modules && 0 != this.m_modules.length) {
            pmRet = this.m_modules[0];
        }
        return pmRet;
    }

    private PortalModule getModule(String sModuleTitle) {
        PortalModule moduleRet;
        block2: {
            block1: {
                moduleRet = null;
                if (null != sModuleTitle) break block1;
                if (0 >= this.m_modules.length) break block2;
                moduleRet = this.m_modules[0];
                break block2;
            }
            for (int i = 0; i < this.m_modules.length; ++i) {
                if (!this.m_modules[i].getModuleTitle().equals(sModuleTitle)) continue;
                moduleRet = this.m_modules[i];
                break;
            }
        }
        return moduleRet;
    }

    private PortalModule getNextModule(PortalModule moduleLast) {
        PortalModule moduleRet = null;
        if (null == moduleLast) {
            moduleRet = this.m_modules[0];
        } else {
            for (int i = 0; i < this.m_modules.length - 1; ++i) {
                if (!this.m_modules[i].equals(moduleLast)) continue;
                moduleRet = this.m_modules[i + 1];
                break;
            }
        }
        return moduleRet;
    }

    private static String setFormModule(String sHTML, String sModuleTitle, String sAction) {
        String sRet = sHTML;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document domHTML = builder.parse(new ByteArrayInputStream(sHTML.getBytes("UTF-8")));
            PortalModuleInstallManager.setFormModule(domHTML, sModuleTitle, sAction);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Properties transformProperties = new Properties();
            transformProperties.put("method", "xml");
            transformProperties.put("encoding", "UTF-8");
            transformProperties.put("indent", "yes");
            transformer.setOutputProperties(transformProperties);
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(domHTML), new StreamResult(writer));
            sRet = writer.toString();
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
        return sRet;
    }

    private static Node setFormModule(Node node, String sModuleTitle, String sAction) {
        block3: {
            block2: {
                if (!HTML_TAG_FORM.equalsIgnoreCase(node.getNodeName())) break block2;
                Document domXSL = node.getOwnerDocument();
                if (null == domXSL && node instanceof Document) {
                    domXSL = (Document)node;
                }
                if (null == domXSL) break block3;
                Element nodeModule = domXSL.createElement(HTML_TAG_INPUT);
                nodeModule.setAttribute(HTML_TAG_INPUT_TYPE, HTML_TAG_INPUT_TYPE_HIDDEN);
                nodeModule.setAttribute(HTML_TAG_INPUT_NAME, PARAMETER_MODULE);
                nodeModule.setAttribute(HTML_TAG_INPUT_VALUE, sModuleTitle);
                node.appendChild(nodeModule);
                if (null == sAction) break block3;
                ((Element)node).setAttribute(HTML_TAG_FORM_ATTRIBUTE_ACTION, sAction);
                break block3;
            }
            NodeList nodelist = node.getChildNodes();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                PortalModuleInstallManager.setFormModule(nodelist.item(i), sModuleTitle, sAction);
            }
        }
        return node;
    }

    private static void copyFile(File fSrc, File fDst) throws IOException {
        int i;
        FileInputStream inputstream = new FileInputStream(fSrc);
        if (fDst.isDirectory()) {
            fDst = new File(fDst, fSrc.getName());
        }
        FileOutputStream outputstream = new FileOutputStream(fDst);
        byte[] baBuf = new byte[4096];
        while (-1 != (i = ((InputStream)inputstream).read(baBuf))) {
            ((OutputStream)outputstream).write(baBuf, 0, i);
        }
        outputstream.flush();
        ((OutputStream)outputstream).close();
        ((InputStream)inputstream).close();
        fDst.setLastModified(fSrc.lastModified());
    }

    private boolean isMultiPart(HttpServletRequest request) {
        boolean bRet = false;
        String sContentType = request.getContentType();
        if (null != sContentType && sContentType.toLowerCase().startsWith(TAG_TYPE_MULTIPART_FORM)) {
            bRet = true;
        }
        return bRet;
    }

    private HashMap getMultiPartParameters(HttpServletRequest request) throws IOException {
        HashMap mapParameters = new HashMap();
        String sBoundary = this.getMultiPartParameterBoundary(request);
        int iMajorVersion = this.m_context.getMajorVersion();
        int iMinorVersion = this.m_context.getMinorVersion();
        String sEnc = 2 < iMajorVersion || 2 == iMajorVersion && 3 <= iMinorVersion ? "UTF-8" : null;
        ServletInputStream inputStream = request.getInputStream();
        byte[] baBuff = new byte[4096];
        inputStream.readLine(baBuff, 0, baBuff.length);
        while (this.getEntry(inputStream, sEnc, sBoundary, mapParameters)) {
        }
        return mapParameters;
    }

    private String getMultiPartParameterBoundary(HttpServletRequest request) {
        String sContentType = request.getContentType();
        String sRet = sContentType.substring(sContentType.indexOf(TAG_MULTIPART_FORM_DATA_BOUNDARY) + TAG_MULTIPART_FORM_DATA_BOUNDARY.length());
        return sRet;
    }

    private boolean getEntry(ServletInputStream inputStream, String sEnc, String sBoundary, HashMap mapParameters) {
        boolean bRet = true;
        try {
            byte[] baBuff = new byte[4096];
            inputStream.readLine(baBuff, 0, baBuff.length);
            String sDescription = null;
            sDescription = sEnc != null ? new String(baBuff, sEnc) : new String(baBuff);
            int iIndexEntryName = sDescription.indexOf(TAG_ENTRY_NAME);
            String sKey = sDescription.substring(iIndexEntryName + TAG_ENTRY_NAME.length(), sDescription.indexOf(34, sDescription.indexOf(TAG_ENTRY_NAME) + TAG_ENTRY_NAME.length()));
            try {
                StringBuffer sbData = new StringBuffer();
                int iIndex = sDescription.indexOf(TAG_FILE_NAME);
                if (-1 != iIndex) {
                    String sFile = sDescription.substring(sDescription.indexOf(TAG_FILE_NAME) + TAG_FILE_NAME.length(), sDescription.indexOf(34, sDescription.indexOf(TAG_FILE_NAME) + TAG_FILE_NAME.length()));
                    if (0 < sFile.length()) {
                        sbData.append(this.uploadFile(sFile, inputStream, sBoundary, sEnc).getAbsolutePath());
                    } else {
                        int i = inputStream.readLine(baBuff, 0, baBuff.length);
                        String sLine = null;
                        sLine = sEnc != null ? new String(baBuff, 0, i, sEnc) : new String(baBuff, 0, i);
                        while (!sLine.startsWith(sBoundary)) {
                            i = inputStream.readLine(baBuff, 0, baBuff.length);
                            if (sEnc != null) {
                                sLine = new String(baBuff, 0, i, sEnc);
                                continue;
                            }
                            sLine = new String(baBuff, 0, i);
                        }
                    }
                } else {
                    int i = inputStream.readLine(baBuff, 0, baBuff.length);
                    String sLine = null;
                    sLine = sEnc != null ? new String(baBuff, 0, i, sEnc) : new String(baBuff, 0, i);
                    while (!sLine.startsWith(sBoundary)) {
                        if (sLine.endsWith("\r\n")) {
                            sLine = sLine.substring(0, sLine.length() - 2);
                        } else if (sLine.endsWith("\r") || sLine.endsWith("\n")) {
                            sLine = sLine.substring(0, sLine.length() - 1);
                        }
                        if (0 < sLine.length()) {
                            sbData.append(sLine);
                        }
                        i = inputStream.readLine(baBuff, 0, baBuff.length);
                        if (sEnc != null) {
                            sLine = new String(baBuff, 0, i, sEnc);
                            continue;
                        }
                        sLine = new String(baBuff, 0, i);
                    }
                }
                mapParameters.put(sKey, sbData.toString());
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
        catch (Exception e) {
            bRet = false;
        }
        return bRet;
    }

    private File uploadFile(String sFile, ServletInputStream inputStream, String sBoundary, String sEnc) throws IOException {
        int iLen;
        File fRet = null;
        String sFileName = sFile.substring(sFile.lastIndexOf(File.separatorChar) + 1);
        String sTempFolder = System.getProperty(SYSTEM_PROPERTY_TEMP_FOLDER);
        File fTempFolder = new File(sTempFolder);
        fRet = new File(fTempFolder, sFileName);
        if (fRet.exists()) {
            int iIndex = sFileName.lastIndexOf(46);
            String sSuffix = 0 < iIndex ? sFileName.substring(iIndex) : "";
            String sPrefix = 3 <= iIndex ? sFileName.substring(0, iIndex) : "dex";
            fRet = File.createTempFile(sPrefix, sSuffix, fTempFolder);
        }
        FileOutputStream outputStream = new FileOutputStream(fRet);
        byte[] baBuff = new byte[65536];
        inputStream.readLine(baBuff, 0, baBuff.length);
        inputStream.readLine(baBuff, 0, baBuff.length);
        boolean rnflag = false;
        while (-1 != (iLen = inputStream.readLine(baBuff, 0, baBuff.length))) {
            if (iLen > 2 && baBuff[0] == 45 && baBuff[1] == 45) {
                String sCheck = "";
                sCheck = sEnc != null ? new String(baBuff, 0, iLen, sEnc) : new String(baBuff, 0, iLen);
                if (sCheck.startsWith(sBoundary)) break;
            }
            if (rnflag) {
                ((OutputStream)outputStream).write(13);
                ((OutputStream)outputStream).write(10);
                rnflag = false;
            }
            if (2 <= iLen && 13 == baBuff[iLen - 2] && 10 == baBuff[iLen - 1]) {
                iLen -= 2;
                rnflag = true;
            }
            ((OutputStream)outputStream).write(baBuff, 0, iLen);
        }
        outputStream.flush();
        ((OutputStream)outputStream).close();
        return fRet;
    }

    public static void setSchemaDetails(String ip, String username, String password, boolean useSSL, String port) {
        schemaDetails.add(ip);
        schemaDetails.add(username);
        schemaDetails.add(password);
        schemaDetails.add(new Boolean(useSSL));
        schemaDetails.add(new Integer(port));
    }

    public static Vector getSchemaDetails() {
        Iterator it = schemaDetails.iterator();
        Vector clone = new Vector();
        while (it.hasNext()) {
            clone.add(it.next());
        }
        return clone;
    }

    public static class PortalModuleFilenameFilter
    implements FilenameFilter {
        public boolean accept(File fDir, String sFileName) {
            boolean bRet = false;
            if (sFileName.endsWith(".npm")) {
                File fFile = new File(fDir, sFileName);
                if (!fFile.isFile()) {
                    D.log((String)("Not a File: " + fFile.getAbsolutePath()));
                } else if (!fFile.canRead()) {
                    D.log((String)("Cannot read: " + fFile.getAbsolutePath()));
                } else {
                    bRet = true;
                }
            } else {
                D.log((String)("Not a Module: " + sFileName));
            }
            return bRet;
        }
    }
}

