/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.serviceProviders.web;

import com.novell.nps.debug.Debug;
import com.novell.nps.serviceProviders.BadDomainCache;
import com.novell.nps.serviceProviders.web.CookieEx;
import com.novell.nps.serviceProviders.web.PortalHostnameVerifier;
import com.novell.nps.serviceProviders.web.PortalURLException;
import com.novell.nps.serviceProviders.web.SecretStoreConnection;
import com.novell.nps.sessionManager.PortalSession;
import java.io.CharArrayWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;

public class PortalURL {
    protected URL url = null;
    private PortalSession currentSession;
    private String requestType = null;
    private Set gParams = null;
    private String gLanguages = null;
    private String gTag = null;
    private static final String DT = "PortalURL";

    public PortalURL() {
    }

    public PortalURL(PortalSession session, String spec) throws IOException, PortalURLException {
        this.currentSession = session;
        this.url = new URL(this.fixup(spec));
    }

    private String fixup(String spec) {
        int lastslash;
        int slashes = spec.indexOf("//");
        if (slashes > 0 && (lastslash = spec.indexOf("/", slashes + 2)) == -1) {
            return new String(spec + "/");
        }
        return spec;
    }

    public PortalURL(PortalSession session, String tag, String spec) throws IOException, PortalURLException {
        this.currentSession = session;
        this.url = new URL(this.fixup(spec));
        this.gTag = tag;
    }

    public PortalURL(PortalSession session, String tag, PortalURL context, String spec) throws IOException, PortalURLException {
        this.currentSession = session;
        this.url = new URL(context.getRealURL(), this.fixup(spec));
        this.gTag = tag;
    }

    public PortalURL(PortalSession session, String tag, String protocol, String host, int port, String file) throws IOException, PortalURLException {
        this.currentSession = session;
        this.url = new URL(protocol, host, port, file);
        this.gTag = tag;
    }

    public PortalURL(PortalSession session, String tag, String protocol, String host, String file) throws IOException, PortalURLException {
        this.currentSession = session;
        this.url = new URL(protocol, host, file);
        this.gTag = tag;
    }

    public int getPort() {
        return this.url.getPort();
    }

    public String getProtocol() {
        return this.url.getProtocol();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String getFile() {
        return this.url.getFile();
    }

    public String getRef() {
        return this.url.getRef();
    }

    public boolean equals(Object obj) {
        return this.url.equals(obj);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean sameFile(PortalURL other) {
        return this.url.sameFile(other.getRealURL());
    }

    public String toString() {
        return this.url.toString();
    }

    public String toExternalForm() {
        return this.url.toExternalForm();
    }

    public URLConnection openPost(Properties params) throws IOException, PortalURLException {
        return this.openPost(params, null);
    }

    public URLConnection openPost(Set params) throws IOException, PortalURLException {
        return this.openPost(params, null);
    }

    public URLConnection openGet(Set params) throws IOException, PortalURLException {
        return this.openGet(params, null);
    }

    public URLConnection openGet(Properties params) throws IOException, PortalURLException {
        return this.openGet(params, null);
    }

    public URLConnection openPost(Properties params, Properties header) throws IOException, PortalURLException {
        return this.openPost(this.convertPropertiesToSet(params), header);
    }

    public URLConnection openPost(Set params, Properties header) throws IOException, PortalURLException {
        this.requestType = "POST";
        this.gParams = params;
        return this.openConnection(header, true);
    }

    public static String convertParam(String param) throws IOException {
        char currentChar = '\u0000';
        CharArrayWriter newString = new CharArrayWriter();
        if (param != null) {
            block7: for (int i = 0; i < param.length(); ++i) {
                currentChar = param.charAt(i);
                switch (currentChar) {
                    case ':': {
                        newString.write("%3A");
                        continue block7;
                    }
                    case '=': {
                        newString.write("%3D");
                        continue block7;
                    }
                    case '/': {
                        newString.write("%2F");
                        continue block7;
                    }
                    case '?': {
                        newString.write("%26");
                        continue block7;
                    }
                    case '&': {
                        newString.write("%3F");
                        continue block7;
                    }
                    default: {
                        newString.write(currentChar);
                    }
                }
            }
        }
        String theString = newString.toString();
        newString.flush();
        newString.close();
        return theString;
    }

    public URLConnection openGet(Set params, Properties header) throws IOException, PortalURLException {
        this.requestType = "GET";
        this.gParams = params;
        StringBuffer urlStr = new StringBuffer(this.url.toString());
        if (params != null) {
            if (urlStr.indexOf("=") == -1) {
                urlStr.append('?');
            } else {
                urlStr.append('&');
            }
            urlStr.append(this.buildQueryString());
            this.url = new URL(urlStr.toString());
        }
        return this.openConnection(header, true);
    }

    public URLConnection openGet(Properties params, Properties header) throws IOException, PortalURLException {
        return this.openGet(this.convertPropertiesToSet(params), header);
    }

    private void setProperties(HttpURLConnection uc, Properties theInfo) {
        Enumeration<?> theNames = theInfo.propertyNames();
        String currentName = null;
        while (theNames.hasMoreElements()) {
            currentName = (String)theNames.nextElement();
            uc.setRequestProperty(currentName, theInfo.getProperty(currentName));
        }
    }

    private void setURLValues(HttpURLConnection uc, Properties header) {
        HttpURLConnection.setFollowRedirects(false);
        Properties sessionValues = (Properties)this.currentSession.getAttribute("REQUEST_HEADER");
        if (sessionValues != null) {
            this.setProperties(uc, sessionValues);
        }
        if (this.gLanguages != null) {
            uc.setRequestProperty("Accept-Language", this.gLanguages);
        }
        this.addCookies(this.currentSession, uc);
        if (header != null) {
            this.setProperties(uc, header);
        }
    }

    private void attachPostInfo(HttpURLConnection uc) {
        if (this.requestType != null && this.requestType.equals("POST")) {
            try {
                uc.setRequestMethod("POST");
            }
            catch (Exception e) {
                Debug.log(DT, 1, e);
            }
            StringBuffer parameterList = this.buildQueryString();
            if (parameterList.length() != 0) {
                try {
                    uc.setDoOutput(true);
                    DataOutputStream out = new DataOutputStream(uc.getOutputStream());
                    out.writeBytes(parameterList.toString());
                    out.flush();
                    out.close();
                }
                catch (IOException io) {
                    Debug.log(DT, 1, io);
                }
            }
        }
    }

    private void updateCookieValues(HttpURLConnection uc) {
        int i = 0;
        String hf = uc.getHeaderField(i);
        String hfk = uc.getHeaderFieldKey(i);
        int position = 0;
        int end = 0;
        while (hf != null) {
            if (hfk != null && hfk.equalsIgnoreCase("set-cookie")) {
                int start;
                Debug.log(3, DT, hf);
                end = hf.indexOf(";");
                if (end < 0) {
                    end = hf.length();
                }
                CookieEx tempCookie = new CookieEx(hf.substring(0, hf.indexOf("=")), hf.substring(hf.indexOf("=") + 1, end));
                position = hf.indexOf("domain");
                if (position > 0) {
                    start = hf.indexOf("=", position);
                    end = hf.indexOf(";", position);
                    if (end == -1) {
                        end = hf.length();
                    }
                    tempCookie.setDomain(hf.substring(start + 1, end));
                }
                if (-1 == (position = hf.indexOf("path"))) {
                    position = hf.indexOf("Path");
                }
                if (position > 0) {
                    start = hf.indexOf("=", position);
                    end = hf.indexOf(";", position);
                    if (end == -1) {
                        end = hf.length();
                    }
                    tempCookie.setPath(hf.substring(start + 1, end));
                } else {
                    String sPath = this.url.toString();
                    if (sPath != null && sPath.indexOf("/") != sPath.lastIndexOf("/")) {
                        tempCookie.setPath(sPath.substring(0, sPath.lastIndexOf("/")));
                    } else {
                        tempCookie.setPath("/");
                    }
                }
                position = hf.indexOf("expires");
                if (position == -1) {
                    position = hf.indexOf("Expires");
                }
                if (position > 0) {
                    start = hf.indexOf("=", position);
                    end = hf.indexOf(";", position);
                    if (end == -1) {
                        end = hf.length();
                    }
                    try {
                        Date newDate = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yyyy hh:mm:ss zzz").parse(hf.substring(start + 1, end));
                        tempCookie.setExpires(newDate.getTime());
                        if (Debug.isLoggable(3)) {
                            Debug.log(3, DT, "Date: " + newDate.toString());
                        }
                    }
                    catch (Exception e) {
                        Debug.log(DT, 3, e);
                    }
                }
                this.saveCookie(this.currentSession, uc, tempCookie);
            }
            hf = uc.getHeaderField(++i);
            hfk = uc.getHeaderFieldKey(i);
        }
    }

    public URLConnection openConnection() throws IOException, PortalURLException {
        return this.openConnection(null, false);
    }

    public URLConnection openConnection(Properties header) throws IOException, PortalURLException {
        return this.openConnection(header, false);
    }

    private HttpURLConnection getNewURLCon(Properties header) throws IOException {
        HttpURLConnection urlCon = (HttpURLConnection)this.url.openConnection();
        if (this.requestType != null) {
            urlCon.setRequestMethod(this.requestType);
        }
        this.setURLValues(urlCon, header);
        return urlCon;
    }

    private URLConnection openConnection(Properties header, boolean useParams) throws IOException, PortalURLException {
        SecretStoreConnection provider;
        StringBuffer sb = null;
        HttpURLConnection openCon = null;
        HttpURLConnection urlCon = null;
        if (BadDomainCache.isDomainBad(this.url.getHost())) {
            throw new PortalURLException(PortalURLException.SERVICE_UNAVAILABLE);
        }
        if (!useParams) {
            this.requestType = null;
            this.gParams = null;
        }
        if ((provider = new SecretStoreConnection()).doYouOwnThisURL(this.currentSession, this.url, this.gTag) && (openCon = (HttpURLConnection)provider.getConnection(this.currentSession, urlCon = this.getNewURLCon(header), this.gTag)) != null) {
            this.attachPostInfo(urlCon);
        }
        if (openCon == null) {
            if (urlCon != null) {
                urlCon.disconnect();
            }
            openCon = this.getNewURLCon(header);
            this.attachPostInfo(openCon);
        }
        int result = 0;
        String resp = openCon.getHeaderField(0);
        if (resp == null) {
            result = openCon.getResponseCode();
        } else {
            try {
                int ind = resp.indexOf(32);
                while (resp.charAt(ind) == ' ') {
                    ++ind;
                }
                result = Integer.parseInt(resp.substring(ind, ind + 3));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (result != 200 && result != -1) {
            switch (result) {
                case 301: 
                case 302: {
                    while (result == 302 || result == 301) {
                        this.updateCookieValues(openCon);
                        String newURL = openCon.getHeaderField("Location");
                        if (newURL.length() < 5 || !newURL.substring(0, 4).equals("http")) {
                            if (newURL.substring(0, 1).equals("/") || newURL.substring(0, 1).equals("\\")) {
                                sb = new StringBuffer();
                                sb.append(this.url.getProtocol());
                                sb.append("://");
                                sb.append(this.url.getHost());
                                if (newURL.length() > 1) {
                                    sb.append(newURL);
                                }
                                this.url = new URL(sb.toString());
                            } else if (this.url.getRef() != null) {
                                sb = new StringBuffer();
                                sb.append(this.url.getRef());
                                sb.append("/");
                                sb.append(newURL);
                                this.url = new URL(sb.toString());
                            } else if (this.url.getFile() != null) {
                                int index = this.url.getFile().lastIndexOf("/");
                                if (index != -1) {
                                    sb = new StringBuffer();
                                    sb.append(this.url.getProtocol());
                                    sb.append("://");
                                    sb.append(this.url.getHost());
                                    sb.append(this.url.getFile().substring(0, index));
                                    sb.append("/");
                                    sb.append(newURL);
                                    this.url = new URL(sb.toString());
                                } else {
                                    sb = new StringBuffer();
                                    sb.append(this.url.getProtocol());
                                    sb.append("://");
                                    sb.append(this.url.getHost());
                                    sb.append("/");
                                    sb.append(newURL);
                                    this.url = new URL(sb.toString());
                                }
                            } else {
                                sb = new StringBuffer();
                                sb.append(this.url.getProtocol());
                                sb.append("://");
                                sb.append(this.url.getHost());
                                sb.append("/");
                                sb.append(newURL);
                                this.url = new URL(sb.toString());
                            }
                        } else {
                            this.url = new URL(newURL);
                        }
                        if (BadDomainCache.isDomainBad(this.url.getHost())) {
                            throw new PortalURLException(PortalURLException.SERVICE_UNAVAILABLE);
                        }
                        if (provider.doYouOwnThisURL(this.currentSession, this.url, this.gTag)) {
                            Debug.log(DT, 3, "Adding BASIC during Redirect");
                            Debug.log(DT, 3, this.url.getHost() + this.url.getPath());
                            urlCon = this.getNewURLCon(header);
                            openCon = (HttpURLConnection)provider.getConnection(this.currentSession, urlCon, this.gTag);
                            if (openCon != null) {
                                this.attachPostInfo(urlCon);
                            }
                        } else {
                            openCon = (HttpURLConnection)this.url.openConnection();
                            this.setURLValues(openCon, header);
                        }
                        if ((result = openCon.getResponseCode()) != 401) continue;
                        Debug.log(DT, 3, "Throwing 401");
                        this.updateCookieValues(openCon);
                        throw new PortalURLException(PortalURLException.BASIC_REQUIRED);
                    }
                    break;
                }
                case 401: {
                    this.updateCookieValues(openCon);
                    throw new PortalURLException(PortalURLException.BASIC_REQUIRED);
                }
                case 304: {
                    this.updateCookieValues(openCon);
                    Debug.log(DT, 3, "Throwing 304");
                    throw new PortalURLException(PortalURLException.PAGE_NOT_MODIFIED);
                }
                default: {
                    BadDomainCache.addBadDomain(this.url.getHost());
                    Debug.log(DT, 1, "Connect to " + this.url.getHost() + " failed: " + result);
                    throw new PortalURLException(PortalURLException.UNKNOWN_CONNECTION_FAILURE + " :" + String.valueOf(result));
                }
            }
        }
        if (openCon != null) {
            this.updateCookieValues(openCon);
        }
        return openCon;
    }

    public InputStream openStream() throws IOException, PortalURLException {
        URLConnection openCon = this.openConnection();
        if (openCon != null) {
            return this.openConnection().getInputStream();
        }
        return null;
    }

    public Object getContent() throws IOException, PortalURLException {
        return this.openConnection().getContent();
    }

    public URL getRealURL() {
        return this.url;
    }

    public void setLanguages(String languages) {
        this.gLanguages = languages;
    }

    public Vector getCookies() {
        Vector<CookieEx> cookies = new Vector<CookieEx>();
        String url = this.getHost();
        Vector urlCookies = this.getUrlCookies(url);
        if (urlCookies == null) {
            return cookies;
        }
        int start = 0;
        int end = 0;
        CookieEx tmpCookie = null;
        Date rightNow = new Date(System.currentTimeMillis());
        long rightNowGMT = rightNow.getTime();
        while (true) {
            if (urlCookies != null) {
                Enumeration myenum = urlCookies.elements();
                while (myenum.hasMoreElements()) {
                    tmpCookie = (CookieEx)((Object)myenum.nextElement());
                    if (tmpCookie.getExpires() > 0L && rightNowGMT - tmpCookie.getExpires() > 0L) {
                        Debug.log(DT, 3, "Cookie Expired");
                        continue;
                    }
                    cookies.addElement(tmpCookie);
                }
            }
            if ((start = url.indexOf(".")) == 0) {
                start = url.indexOf(".", 1);
            }
            if (start == -1) break;
            end = url.length();
            url = url.substring(start, end);
            urlCookies = this.getUrlCookies(url);
        }
        return cookies;
    }

    public void removeURLCookies(PortalSession curSess, PortalURL theURL) {
        if (curSess == null || theURL == null) {
            return;
        }
        String domain = theURL.getHost();
        if (domain == null) {
            return;
        }
        Hashtable sessionCookies = (Hashtable)this.currentSession.getAttribute("SESSION_COOKIES");
        if (sessionCookies != null) {
            sessionCookies.remove(domain);
        }
    }

    private void saveCookie(PortalSession curSess, URLConnection uc, CookieEx curCookie) {
        if (Debug.isLoggable(3)) {
            Debug.log(3, DT, " Saving Cookie: " + curCookie.getName() + ":" + curCookie.getValue());
            Debug.log(3, DT, "        Domain: " + curCookie.getDomain());
            Debug.log(3, DT, "       Expires: " + curCookie.getExpires());
            Debug.log(3, DT, "          Path: " + curCookie.getPath());
        }
        String domain = null;
        domain = curCookie.getDomain();
        if (domain == null) {
            domain = this.url.getHost();
        } else if (uc.getURL().toString().indexOf(domain) < 0) {
            return;
        }
        Vector<CookieEx> urlCookies = this.getUrlCookies(domain);
        if (urlCookies != null) {
            Enumeration myenum = urlCookies.elements();
            while (myenum.hasMoreElements()) {
                CookieEx tmpCookie = (CookieEx)((Object)myenum.nextElement());
                Debug.log(DT, 3, "Comparing " + curCookie.getName() + " to " + tmpCookie.getName());
                if (!curCookie.getName().equalsIgnoreCase(tmpCookie.getName()) || !curCookie.getPath().equalsIgnoreCase(tmpCookie.getPath())) continue;
                Debug.log(DT, 3, "Updating Cookie Attributes");
                tmpCookie.setValue(curCookie.getValue());
                tmpCookie.setComment(curCookie.getComment());
                tmpCookie.setExpires(curCookie.getExpires());
                return;
            }
        }
        if (urlCookies != null) {
            urlCookies.addElement(curCookie);
        } else {
            urlCookies = new Vector<CookieEx>();
            urlCookies.addElement(curCookie);
            Hashtable<String, Vector<CookieEx>> sessionCookies = (Hashtable<String, Vector<CookieEx>>)curSess.getAttribute("SESSION_COOKIES");
            if (sessionCookies == null) {
                sessionCookies = new Hashtable<String, Vector<CookieEx>>();
                curSess.setAttribute("SESSION_COOKIES", sessionCookies);
            }
            sessionCookies.put(domain, urlCookies);
        }
    }

    private Vector getUrlCookies(String domain) {
        Vector domainCookies;
        Hashtable sessionCookies = (Hashtable)this.currentSession.getAttribute("SESSION_COOKIES");
        if (sessionCookies != null && (domainCookies = (Vector)sessionCookies.get(domain)) != null) {
            return domainCookies;
        }
        return null;
    }

    private void addCookies(PortalSession curSess, URLConnection uc) {
        StringBuffer sbCookie = new StringBuffer();
        URL newURL = this.url;
        StringBuffer sb = null;
        String url = newURL.getHost();
        Vector urlCookies = this.getUrlCookies(url);
        int start = 0;
        int end = 0;
        boolean firstCookie = true;
        long rightNowGMT = System.currentTimeMillis();
        while (true) {
            if (urlCookies != null) {
                Enumeration myenum = urlCookies.elements();
                while (myenum.hasMoreElements()) {
                    long lExpire;
                    CookieEx tmpCookie = (CookieEx)((Object)myenum.nextElement());
                    if (Debug.isLoggable(3)) {
                        Debug.log(3, DT, "Testing :Cookie: " + tmpCookie.getName() + ":" + tmpCookie.getValue());
                        Debug.log(3, DT, "        :Domain: " + tmpCookie.getDomain());
                        Debug.log(3, DT, "        :Expires: " + tmpCookie.getExpires());
                        Debug.log(3, DT, "        :Path: " + tmpCookie.getPath());
                    }
                    if ((lExpire = tmpCookie.getExpires()) != -1L && lExpire - rightNowGMT < 0L || tmpCookie.getPath() != null && uc.getURL().toString().indexOf(tmpCookie.getPath()) < 0) continue;
                    sb = new StringBuffer();
                    sb.append(tmpCookie.getName());
                    sb.append("=");
                    sb.append(tmpCookie.getValue());
                    if (firstCookie) {
                        sbCookie.append(sb.toString());
                        firstCookie = false;
                        continue;
                    }
                    sbCookie.append("; ");
                    sbCookie.append(sb.toString());
                }
            }
            if ((start = url.indexOf(".")) == 0) {
                start = url.indexOf(".", 1);
            }
            if (start == -1) break;
            end = url.length();
            url = url.substring(start, end);
            urlCookies = this.getUrlCookies(url);
        }
        if (sbCookie != null && sbCookie.length() > 1) {
            uc.setRequestProperty("Cookie", sbCookie.toString());
            if (Debug.isLoggable(3)) {
                Debug.log(3, DT, "Adding Cookies to PortalURL Request to " + url.toString());
                Debug.log(DT, 3, "Cookies added: " + sbCookie.toString());
            }
        }
    }

    private Set convertPropertiesToSet(Properties props) {
        if (props == null) {
            return null;
        }
        HashSet<String> returnSet = new HashSet<String>();
        Enumeration<?> myenum = props.propertyNames();
        while (myenum.hasMoreElements()) {
            String key = (String)myenum.nextElement();
            String value = props.getProperty(key);
            returnSet.add(key + '=' + value);
        }
        return returnSet;
    }

    private StringBuffer buildQueryString() {
        StringBuffer sb = new StringBuffer();
        if (this.gParams != null) {
            Iterator iter = this.gParams.iterator();
            while (iter.hasNext()) {
                String loopStr;
                int parseLocation;
                Object iterValue = iter.next();
                if (!(iterValue instanceof String) || (parseLocation = (loopStr = (String)iterValue).indexOf(61)) == -1) continue;
                sb.append(loopStr.substring(0, parseLocation));
                sb.append('=');
                try {
                    sb.append(URLEncoder.encode(loopStr.substring(parseLocation + 1, loopStr.length()), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    sb.append(URLEncoder.encode(loopStr.substring(parseLocation + 1, loopStr.length())));
                    Debug.log(DT, e);
                }
                if (!iter.hasNext()) continue;
                sb.append('&');
            }
        }
        return sb;
    }

    static {
        HttpsURLConnection.setDefaultHostnameVerifier(new PortalHostnameVerifier());
        try {
            URL initURL = new URL("http://127.0.0.1");
            HttpURLConnection openCon = (HttpURLConnection)initURL.openConnection();
            openCon.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

