/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.statistics;

import com.novell.nps.gadgetManager.XmlUtil;
import java.util.Properties;

public class StatWindow {
    long lifetime = 60000L;
    long total;
    long min = Long.MAX_VALUE;
    long max;
    long count;
    long birthTime = System.currentTimeMillis();
    long logins = 0L;
    long pagehits = 0L;
    long gadgethits = 0L;

    public StatWindow() {
    }

    public StatWindow(long WindowWidth) {
        if (WindowWidth > this.lifetime) {
            this.lifetime = WindowWidth;
        }
    }

    public boolean isExpired() {
        return this.lifetime < System.currentTimeMillis() - this.birthTime;
    }

    public synchronized void addlogins(long accessTime) {
        ++this.logins;
    }

    public synchronized void addpagehits(long accessTime) {
        ++this.pagehits;
    }

    public synchronized void addgadgethits(long accessTime) {
        ++this.gadgethits;
    }

    public synchronized void add(long accessTime) {
        this.total += accessTime;
        ++this.count;
        this.min = Math.min(this.min, accessTime);
        this.max = Math.max(this.max, accessTime);
    }

    public double getAverage() {
        return this.total / this.count;
    }

    public String getXMLData(String tag) {
        StringBuffer buffer = new StringBuffer();
        Properties props = new Properties();
        props.put("total", Long.toString(this.total));
        props.put("min", Long.toString(this.min));
        props.put("max", Long.toString(this.max));
        props.put("count", Long.toString(this.count));
        XmlUtil.writeTag(tag, props, "", buffer);
        return buffer.toString();
    }

    public String getLoginHitsXMLData(String tag) {
        StringBuffer buffer = new StringBuffer();
        Properties props = new Properties();
        props.put("logins", Long.toString(this.logins));
        props.put("pagehits", Long.toString(this.pagehits));
        props.put("gadgethits", Long.toString(this.gadgethits));
        XmlUtil.writeTag(tag, props, "", buffer);
        return buffer.toString();
    }

    public void incLogins(long incVal) {
        this.logins += incVal;
    }

    public void incPageHits(long incVal) {
        this.pagehits += incVal;
    }

    public void incGadgetHits(long incVal) {
        this.gadgethits += incVal;
    }

    public void incLogins() {
        ++this.logins;
    }

    public void incPageHits() {
        ++this.pagehits;
    }

    public void incGadgetHits() {
        ++this.gadgethits;
    }

    public long getLogins() {
        return this.logins;
    }

    public long getPageHits() {
        return this.pagehits;
    }

    public long getGadgetHits() {
        return this.gadgethits;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void incTotal(long incVal) {
        this.total += incVal;
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = Math.min(this.min, min);
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = Math.max(this.max, max);
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void incCount(long incVal) {
        this.count += incVal;
    }

    public long getBirthTime() {
        return this.birthTime;
    }

    public void setBirthTime(long birthTime) {
        this.birthTime = birthTime;
    }
}

