/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.statistics.statBeans;

import com.novell.nps.event.GadgetHitGadgetEvent;
import com.novell.nps.event.GadgetHitSchemeEvent;
import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventListener;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.event.PortalLoginEvent;
import com.novell.nps.event.PortalLogoutEvent;
import com.novell.nps.statistics.Stat;
import com.novell.nps.statistics.StatBean;
import com.novell.nps.statistics.StatLogFile;
import com.novell.nps.statistics.StatWindow;
import com.novell.nps.statistics.StatWindowSet;
import java.io.File;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;

public class PortalLoggedInUserStatBean
extends StatBean
implements PortalEventListener {
    private static String m_sFile = "portalstatlog.xml";
    private StatLogFile StatsFile = new StatLogFile();
    private static File m_fLog = null;
    private static PrintWriter m_p = null;
    private StatWindow current1hrWindow;
    private StatWindow current1dayWindow;
    private StatWindowSet last1hourSet = new StatWindowSet(3600000L);
    private StatWindowSet last1daySet = new StatWindowSet(86400000L);
    protected Stat loggedInUsersCount = null;
    protected Stat loggedInUsers = null;
    protected static int hashTableSize = 20;
    protected static float hashTableGrowThreshold = 0.75f;
    protected Hashtable theLoggedInUsers = new Hashtable(hashTableSize, hashTableGrowThreshold);
    protected static Stat portalStat1hourWindow = null;
    protected static Stat portalStat1dayWindow = null;

    public PortalLoggedInUserStatBean() {
        this.init();
        m_sFile = this.StatsFile.getLogFile();
        m_p = StatLogFile.getPrintWriter(m_sFile);
    }

    public void init() {
        PortalEventManager.registerEventListener((PortalEventListener)this, "com.novell.nps.event.PortalLogoutEvent");
        PortalEventManager.registerEventListener((PortalEventListener)this, "com.novell.nps.event.PortalLoginEvent");
        PortalEventManager.registerEventListener((PortalEventListener)this, "com.novell.nps.event.GadgetHitGadgetEvent");
        PortalEventManager.registerEventListener((PortalEventListener)this, "com.novell.nps.event.GadgetHitSchemeEvent");
        this.loggedInUsersCount = new Stat("loggedInUsersCount", new Integer(0));
        this.loggedInUsers = new Stat("loggedInUsers", new Hashtable());
        portalStat1hourWindow = new Stat("portalStat1hourWindow", new String());
        portalStat1dayWindow = new Stat("portalStat1dayWindow", new String());
    }

    public void shutdown() {
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, "com.novell.nps.event.PortalLogoutEvent");
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, "com.novell.nps.event.PortalLoginEvent");
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, "com.novell.nps.event.GadgetHitGadgetEvent");
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, "com.novell.nps.event.GadgetHitSchemeEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat getLoggedInUsersCount() {
        Stat stat = this.loggedInUsers;
        synchronized (stat) {
            this.loggedInUsersCount.value = new Integer(this.theLoggedInUsers.size());
        }
        return this.loggedInUsersCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat getLoggedInUsers() {
        Hashtable hashtable = this.theLoggedInUsers;
        synchronized (hashtable) {
            this.loggedInUsers.value = this.theLoggedInUsers;
        }
        return this.loggedInUsers;
    }

    public void onPortalEvent(PortalEvent event) {
        if (event instanceof PortalLoginEvent) {
            this.recordUserLogin((PortalLoginEvent)event);
        } else if (event instanceof PortalLogoutEvent) {
            this.recordUserLogout((PortalLogoutEvent)event);
        } else if (event instanceof GadgetHitGadgetEvent) {
            this.recordGadgetHit((GadgetHitGadgetEvent)event);
        } else if (event instanceof GadgetHitSchemeEvent) {
            this.recordSchemeHit((GadgetHitSchemeEvent)event);
        }
    }

    protected void recordGadgetHit(GadgetHitGadgetEvent gadgetHitEvent) {
        Date dt = new Date();
        Long currentDate = new Long(dt.getTime());
        if (null == this.current1hrWindow || this.current1hrWindow.isExpired()) {
            this.current1hrWindow = new StatWindow();
            this.last1hourSet.update(this.current1hrWindow);
        }
        this.current1hrWindow.incGadgetHits();
        if (null == this.current1dayWindow || this.current1dayWindow.isExpired()) {
            this.current1dayWindow = new StatWindow(3600000L);
            this.last1daySet.update(this.current1dayWindow);
        }
        this.current1dayWindow.incGadgetHits();
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        if (m_p != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<LogEntry>");
            sb.append("<DateString>");
            sb.append(df.format(dt));
            sb.append("</DateString>");
            sb.append("<UserName>");
            sb.append(gadgetHitEvent.getUserName());
            sb.append("</UserName>");
            sb.append("<GadgetAssingmentName>");
            sb.append(gadgetHitEvent.getAssignment().getAssignmentName());
            sb.append("</GadgetAssingmentName>");
            sb.append("<GadgetAssingmentDN>");
            sb.append(gadgetHitEvent.getAssignment().getGadgetDN());
            sb.append("</GadgetAssingmentDN>");
            sb.append("<Service>");
            sb.append(gadgetHitEvent.getAssignment().getServiceName());
            sb.append("</Service>");
            sb.append("<Event>");
            sb.append("GadgetHitEvent");
            sb.append("</Event>");
            sb.append("</LogEntry>");
            m_p = StatLogFile.writeToPrintWriter(m_p, sb.toString());
            m_p.flush();
        }
    }

    protected void recordSchemeHit(GadgetHitSchemeEvent gadgetHitSchemeEvent) {
        Date dt = new Date();
        Long currentDate = new Long(dt.getTime());
        if (null == this.current1hrWindow || this.current1hrWindow.isExpired()) {
            this.current1hrWindow = new StatWindow();
            this.last1hourSet.update(this.current1hrWindow);
        }
        this.current1hrWindow.incPageHits();
        if (null == this.current1dayWindow || this.current1dayWindow.isExpired()) {
            this.current1dayWindow = new StatWindow(3600000L);
            this.last1daySet.update(this.current1dayWindow);
        }
        this.current1dayWindow.incPageHits();
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        if (m_p != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<LogEntry>");
            sb.append("<DateString>");
            sb.append(df.format(dt));
            sb.append("</DateString>");
            sb.append("<UserName>");
            sb.append(gadgetHitSchemeEvent.getUserName());
            sb.append("</UserName>");
            sb.append("<GadgetAssingmentName>");
            sb.append(gadgetHitSchemeEvent.getAssignment().getAssignmentName());
            sb.append("</GadgetAssingmentName>");
            sb.append("<GadgetAssingmentDN>");
            sb.append(gadgetHitSchemeEvent.getAssignment().getGadgetDN());
            sb.append("</GadgetAssingmentDN>");
            sb.append("<PageName>");
            sb.append(gadgetHitSchemeEvent.getAssignment().getScheme().getName());
            sb.append("</PageName>");
            sb.append("<Service>");
            sb.append(gadgetHitSchemeEvent.getAssignment().getServiceName());
            sb.append("</Service>");
            sb.append("<Event>");
            sb.append("SchemeHitEvent");
            sb.append("</Event>");
            sb.append("</LogEntry>");
            m_p = StatLogFile.writeToPrintWriter(m_p, sb.toString());
            m_p.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordUserLogin(PortalLoginEvent loginEvent) {
        Hashtable hashtable = this.theLoggedInUsers;
        synchronized (hashtable) {
            this.theLoggedInUsers.put(loginEvent.getPortalSession().getId(), loginEvent.getPortalSession());
        }
        if (null == this.current1hrWindow || this.current1hrWindow.isExpired()) {
            this.current1hrWindow = new StatWindow();
            this.last1hourSet.update(this.current1hrWindow);
        }
        this.current1hrWindow.incLogins();
        if (null == this.current1dayWindow || this.current1dayWindow.isExpired()) {
            this.current1dayWindow = new StatWindow(3600000L);
            this.last1daySet.update(this.current1dayWindow);
        }
        this.current1dayWindow.incLogins();
        Date dt = new Date();
        Long currentDate = new Long(dt.getTime());
        String currentDateString = currentDate.toString();
        DateFormat df = DateFormat.getDateTimeInstance(3, 2);
        if (m_p != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<LogEntry>");
            sb.append("<DateString>");
            sb.append(df.format(dt));
            sb.append("</DateString>");
            sb.append("<UserName>");
            sb.append(loginEvent.getUserName());
            sb.append("</UserName>");
            sb.append("<OriginServerID>");
            sb.append(loginEvent.getOriginServerID());
            sb.append("</OriginServerID>");
            sb.append("<OriginBrowser>");
            sb.append(loginEvent.getBrowserAddr());
            sb.append("</OriginBrowser>");
            sb.append("<Event>");
            sb.append("PortalLoginEvent");
            sb.append("</Event>");
            sb.append("</LogEntry>");
            m_p = StatLogFile.writeToPrintWriter(m_p, sb.toString());
            m_p.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordUserLogout(PortalLogoutEvent logoutEvent) {
        Hashtable hashtable = this.theLoggedInUsers;
        synchronized (hashtable) {
            this.theLoggedInUsers.remove(logoutEvent.getPortalSession().getId());
        }
    }

    public Stat getLoginPageHit1hourWindow() {
        PortalLoggedInUserStatBean.portalStat1hourWindow.value = this.last1hourSet.getLoginPageHitStats().getLoginHitsXMLData("portalStat1hourWindow");
        return portalStat1hourWindow;
    }

    public Stat getLoginPageHit1dayWindow() {
        PortalLoggedInUserStatBean.portalStat1dayWindow.value = this.last1daySet.getLoginPageHitStats().getLoginHitsXMLData("portalStat1dayWindow");
        return portalStat1dayWindow;
    }
}

