/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.statistics.statBeans;

import com.novell.nps.debug.Debug;
import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventListener;
import com.novell.nps.event.PortalEventManager;
import com.novell.nps.statistics.Stat;
import com.novell.nps.statistics.StatBean;

public class PortalUptimeStatBean
extends StatBean
implements PortalEventListener {
    private static long portalStartupTime = 0L;
    protected Stat portalUptime = null;
    protected Stat portalUptimeString = null;

    public PortalUptimeStatBean() {
        this.init();
    }

    public void init() {
        PortalEventManager.registerEventListener((PortalEventListener)this, "com.novell.nps.event.PortalStartupEvent");
        this.portalUptime = new Stat("portalUptime", new Long(0L));
        this.portalUptimeString = new Stat("portalUptimeString", new String());
    }

    public void shutdown() {
        PortalEventManager.unRegisterEventListener((PortalEventListener)this, "com.novell.nps.event.PortalStartupEvent");
    }

    public Stat getPortalUptime() {
        if (portalStartupTime == 0L) {
            Debug.log("PortalUptimeStatBean", 2, "\n The Portal Startup Time is not available.");
            this.portalUptime.value = new Long(0L);
        }
        this.portalUptime.value = new Long(System.currentTimeMillis() - portalStartupTime);
        return this.portalUptime;
    }

    public Stat getPortalUptimeString() {
        if (portalStartupTime == 0L) {
            Debug.log("PortalUptimeStatBean", 2, "\n The Portal Startup Time is not available.");
            this.portalUptimeString.value = null;
        } else {
            long thePortalUptime = (Long)this.getPortalUptime().value;
            long days = thePortalUptime / 1000L / 60L / 60L / 24L % 24L;
            long hours = thePortalUptime / 1000L / 60L / 60L % 24L;
            long minutes = thePortalUptime / 1000L / 60L % 60L;
            long seconds = thePortalUptime / 1000L % 60L;
            String daysStr = String.valueOf(days);
            String hoursStr = String.valueOf(hours);
            String minutesStr = String.valueOf(minutes);
            String secondsStr = String.valueOf(seconds);
            if (daysStr.length() == 1) {
                daysStr = "0" + daysStr;
            }
            if (hoursStr.length() == 1) {
                hoursStr = "0" + hoursStr;
            }
            if (minutesStr.length() == 1) {
                minutesStr = "0" + minutesStr;
            }
            if (secondsStr.length() == 1) {
                secondsStr = "0" + secondsStr;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(daysStr);
            sb.append(":");
            sb.append(hoursStr);
            sb.append(":");
            sb.append(minutesStr);
            sb.append(":");
            sb.append(secondsStr);
            this.portalUptimeString.value = sb.toString();
        }
        return this.portalUptimeString;
    }

    public void onPortalEvent(PortalEvent event) {
        portalStartupTime = event.getTimeStamp();
    }
}

