/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nps.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtils {
    public static void extract(ZipFile zipFile, String sSrc, String sDest) throws IOException {
        ZipUtils.extract(zipFile, sSrc, new File(sDest));
    }

    public static void extract(ZipFile zipFile, String sSrc, File fDest) throws IOException {
        Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
        while (zipEnum.hasMoreElements()) {
            ZipEntry ze = zipEnum.nextElement();
            if (!ze.getName().startsWith(sSrc)) continue;
            if (ze.isDirectory()) {
                new File(fDest, ze.getName().substring(sSrc.length())).mkdirs();
                continue;
            }
            ZipUtils.extractFile(zipFile, ze, new File(fDest, ze.getName().substring(sSrc.length())));
        }
    }

    public static File extractFile(ZipFile zipFile, String sSrcFile, File fDestFile) throws IOException {
        return ZipUtils.extractFile(zipFile, zipFile.getEntry(sSrcFile), fDestFile);
    }

    public static File extractFile(ZipFile zipFile, ZipEntry ze, File fDestFile) throws IOException {
        File file = ZipUtils.writeFile(zipFile.getInputStream(ze), fDestFile);
        file.setLastModified(ze.getTime());
        return file;
    }

    public static String readEntry(ZipFile zipFile, ZipEntry ze) throws IOException {
        int i;
        StringBuffer sbData = new StringBuffer();
        InputStream inputStream = zipFile.getInputStream(ze);
        byte[] baBuf = new byte[4096];
        while (-1 != (i = inputStream.read(baBuf))) {
            sbData.append(new String(baBuf, 0, i, "UTF-8"));
        }
        return sbData.toString();
    }

    private static File writeFile(InputStream inputStream, File fDestFile) throws IOException {
        File rFile = null;
        if (!fDestFile.getParentFile().exists()) {
            fDestFile.getParentFile().mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(fDestFile);
        byte[] buf = new byte[4096];
        int i = inputStream.read(buf);
        while (i != -1) {
            outputStream.write(buf, 0, i);
            i = inputStream.read(buf);
        }
        outputStream.flush();
        outputStream.close();
        rFile = fDestFile;
        return rFile;
    }
}

