/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSFilterResultModifier;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.base.DGMembersPage;
import com.novell.emframe.base.DGUtilities;
import com.novell.emframe.base.NGUtilities;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBook;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.iManager;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public final class DGFilterPage
extends DirPropertyBookPage {
    public static final String JSP_BASEDN = "basednControl";
    public static final String JSP_SCOPE = "scopeControl";
    public static final String JSP_XCHAIN = "xchainControl";
    public static final String JSP_XSPARSE = "xsparseControl";
    public static final String JSP_FILTER = "filterControl";
    public static final String JSP_VALUES = "allValuesControl";
    public static final String JSP_ASRET_HIDDEN = "asRetHiddenField";
    public static final String JSP_AS_HIDDEN = "asHiddenField";
    public static final String JSP_ACTION_FIELD = "hiddenActionField";
    public static final String JSP_USE_DYNAMIC_SETTINGS = "useDynamicSettings";
    public static final String JSP_BASE_DN_PARAM = "basednParam";
    public static final String JSP_SCOPE_PARAM = "scopeParam";
    public static final String JSP_XCHAIN_PARAM = "xchainParam";
    public static final String JSP_XSPARSE_PARAM = "xsparseParam";
    public static final String JSP_FILTER_PARAM = "filterParam";
    public static final String JSP_FILTER_XML_PARAM = "filterParamXML";
    public static final String JSP_VALUES_PARAM = "valuesParam";
    public static final String JSP_SELECT_PARAM = "selectParam";
    public static final String JSP_HAS_ROLE_PARAM = "hasRoleAssignmentsParam";
    public static final String CACHE_SELECTED_VALUE_KEY = "SELECTED_VALUE";
    public static final String CACHE_BASEDN_KEY = "BASEDN";
    public static final String CACHE_SCOPE_KEY = "SCOPE";
    public static final String CACHE_XCHAIN_KEY = "XCHAIN";
    public static final String CACHE_XSPARSE_KEY = "XSPARSE";
    public static final String CACHE_FILTER_KEY = "FILTER";
    public static final String CACHE_FILTER_XML_KEY = "FILTER_XML";
    public static final String CACHE_VALUES_KEY = "QUERIES";
    public static final String CACHE_VALUE_KEY = "QUERY";
    public static final String CACHE_VALUE_1_KEY = "QUERY1";
    public static final String CACHE_HAS_ROLE_KEY = "HASROLE";
    public static final String HASHTABLE_BASEDN_KEY = "basedn";
    public static final String HASHTABLE_SCOPE_KEY = "scope";
    public static final String HASHTABLE_XCHAIN_KEY = "xchain";
    public static final String HASHTABLE_XSPARSE_KEY = "xsparse";
    public static final String HASHTABLE_FILTER_KEY = "filter";
    public static final String ACTION_MODIFY = "modify";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_REFRESH = "refresh";
    public static final String BASE_SCOPE_WIRE_FORM = "base";
    public static final String ONE_SCOPE_WIRE_FORM = "one";
    public static final String SUB_SCOPE_WIRE_FORM = "sub";
    public static final String X_CHAIN_WIRE_FORM = "x-chain";
    public static final String X_SPARSE_WIRE_FORM = "x-sparse";
    public static final int GOOD_DS_VERSION = 1055130;
    public static final String OP_EQ = "AS.Op.isEqual";
    public static final String OP_NEQ = "AS.Op.isNotEqual";
    public static final String OP_IA = "AS.Op.isAfter";
    public static final String OP_IB = "AS.Op.isBefore";
    public static final String OP_NEAR = "AS.Op.isNear";
    public static final String OP_IL = "AS.Op.isLessEqual";
    public static final String OP_IG = "AS.Op.isGreaterEqual";
    public static final String OP_I = "AS.Op.is";
    public static final String OP_IN = "AS.Op.isNot";
    public static final String OP_IP = "AS.Op.isPresent";
    public static final String OP_INP = "AS.Op.isNotPresent";
    public static final String OP_AND = "and";
    public static final String OP_OR = "or";
    public static final String AS_OP_IP = "AS.Op.isPresent";
    public static final String AS_OP_INP = "AS.Op.isNotPresent";
    ResourceBundle m_res = null;
    DirUtils m_dirUtils = null;
    int m_dsRevision = 0;
    static final Comparator queryCmp = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            String sub1 = s1.substring(5);
            String sub2 = s2.substring(5);
            int val1 = new Integer(sub1);
            int val2 = new Integer(sub2);
            return val1 - val2;
        }
    };

    public void show(PropertyPageContext context) throws PageException {
        this.m_dirUtils = context.getDirUtils();
        this.m_dsRevision = DGFilterPage.getNCPServerDSRevision(context);
        if (this.m_res == null) {
            this.m_res = ResourceBundle.getBundle("BaseResources", context.getLocale());
        }
        DGFilterPage.outputDynamicMembers(context, this.getDirPropertyBook());
    }

    private static void outputDynamicMembers(PropertyPageContext context, DirPropertyBook dirPropertyBook) {
        boolean bIsDynamic;
        if (dirPropertyBook.getCache().get("firstMembersLoad") == null || dirPropertyBook.getCache().get("firstMembersLoad").equals("true")) {
            bIsDynamic = DGFilterPage.readFromDS(context, dirPropertyBook);
            dirPropertyBook.getCache().put("firstMembersLoad", "false");
        } else {
            bIsDynamic = DGFilterPage.readFromCache(context, dirPropertyBook);
        }
        DGMembersPage.outputDynamicMembers(context, dirPropertyBook, bIsDynamic, NGUtilities.isGroupNested((DirPropertyBook)dirPropertyBook, (PropertyPageContext)context), true);
    }

    private boolean checkDynamicSetting(PropertyPageContext context, boolean bCurrentDynamicSetting) {
        HttpServletRequest req = context.getRequest();
        String dynamicValue = req.getParameter(JSP_USE_DYNAMIC_SETTINGS);
        if (dynamicValue == null) {
            return bCurrentDynamicSetting;
        }
        Boolean bDynamicState = dynamicValue.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false);
        NSObject nsObject = this.getDirPropertyBook().getNSObject();
        DirPropertyBook propertyBook = this.getDirPropertyBook();
        if (bCurrentDynamicSetting != bDynamicState) {
            DGUtilities.setGroupDynamic(context, propertyBook, bDynamicState);
            if (!bDynamicState.booleanValue()) {
                propertyBook.getCache().put("firstMembersLoad", "true");
            }
            if (!(bCurrentDynamicSetting = bDynamicState.booleanValue())) {
                DGMembersPage.resetMemberList(this.getDirPropertyBook(), context);
                DGMembersPage.clearRemoveStaticBacklinks(context, nsObject, this.getDirPropertyBook());
            } else {
                DGMembersPage.setRemoveStaticBacklinks(context, nsObject, this.getDirPropertyBook());
            }
        }
        return bCurrentDynamicSetting;
    }

    public void cache(PropertyPageContext context) throws PageException {
        boolean bIsDynamic = DGUtilities.isGroupDynamic(this.getDirPropertyBook(), this.getDirPropertyBook().getNSObject(), context);
        bIsDynamic = this.checkDynamicSetting(context, bIsDynamic);
        DGUtilities dgUtilities = new DGUtilities();
        this.writeToCache(context, this.getDirPropertyBook(), dgUtilities, this.m_res, bIsDynamic);
        DGFilterPage.outputDynamicMembers(context, this.getDirPropertyBook());
    }

    public void commit(PropertyPageContext context) throws PageException {
        boolean bIsDynamic = DGUtilities.isGroupDynamic(this.getDirPropertyBook(), this.getDirPropertyBook().getNSObject(), context);
        bIsDynamic = this.checkDynamicSetting(context, bIsDynamic);
        this.writeToDS(context, bIsDynamic);
    }

    private static boolean outputCommonSettings(PropertyPageContext context, DirPropertyBook dirPropertyBook) {
        return DGUtilities.outputCommonSettings(dirPropertyBook, context);
    }

    private static boolean readFromCache(PropertyPageContext context, DirPropertyBook dirPropertyBook) {
        Properties results = context.getResultStrings();
        boolean bIsDynamic = DGFilterPage.outputCommonSettings(context, dirPropertyBook);
        boolean bIsNested = NGUtilities.outputCommonSettings((DirPropertyBook)dirPropertyBook, (PropertyPageContext)context);
        String svalue = (String)dirPropertyBook.getCache().get(CACHE_SELECTED_VALUE_KEY);
        results.put(JSP_BASE_DN_PARAM, "");
        results.put(JSP_SCOPE_PARAM, "");
        results.put(JSP_XCHAIN_PARAM, "");
        results.put(JSP_XSPARSE_PARAM, "");
        results.put(JSP_FILTER_PARAM, "");
        results.put(JSP_FILTER_XML_PARAM, "");
        if (bIsDynamic && svalue != null) {
            try {
                String baseDN = eMFrameUtils.urlEncode((String)((String)dirPropertyBook.getCache().get(CACHE_BASEDN_KEY)), (MContext)context);
                String filter = eMFrameUtils.urlEncode((String)((String)dirPropertyBook.getCache().get(CACHE_FILTER_KEY)), (MContext)context);
                results.put(JSP_BASE_DN_PARAM, baseDN);
                results.put(JSP_SCOPE_PARAM, dirPropertyBook.getCache().get(CACHE_SCOPE_KEY));
                results.put(JSP_XCHAIN_PARAM, dirPropertyBook.getCache().get(CACHE_XCHAIN_KEY));
                results.put(JSP_XSPARSE_PARAM, dirPropertyBook.getCache().get(CACHE_XSPARSE_KEY));
                results.put(JSP_FILTER_PARAM, filter);
                results.put(JSP_FILTER_XML_PARAM, dirPropertyBook.getCache().get(CACHE_FILTER_XML_KEY));
                results.put(JSP_HAS_ROLE_PARAM, dirPropertyBook.getCache().get(CACHE_HAS_ROLE_KEY));
                Hashtable values = (Hashtable)dirPropertyBook.getCache().get(CACHE_VALUES_KEY);
                Enumeration e = values.keys();
                ArrayList<String> keys = new ArrayList<String>();
                while (e.hasMoreElements()) {
                    keys.add(e.nextElement().toString());
                }
                Collections.sort(keys, queryCmp);
                results.put(JSP_VALUES_PARAM, keys);
                results.put(JSP_SELECT_PARAM, svalue);
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        } else if (dirPropertyBook.getCache().get(CACHE_BASEDN_KEY) != null) {
            try {
                String baseDN = eMFrameUtils.urlEncode((String)((String)dirPropertyBook.getCache().get(CACHE_BASEDN_KEY)), (MContext)context);
                String filter = eMFrameUtils.urlEncode((String)((String)dirPropertyBook.getCache().get(CACHE_FILTER_KEY)), (MContext)context);
                results.put(JSP_BASE_DN_PARAM, baseDN);
                results.put(JSP_SCOPE_PARAM, dirPropertyBook.getCache().get(CACHE_SCOPE_KEY));
                results.put(JSP_XCHAIN_PARAM, dirPropertyBook.getCache().get(CACHE_XCHAIN_KEY));
                results.put(JSP_XSPARSE_PARAM, dirPropertyBook.getCache().get(CACHE_XSPARSE_KEY));
                results.put(JSP_FILTER_PARAM, filter);
                results.put(JSP_FILTER_XML_PARAM, dirPropertyBook.getCache().get(CACHE_FILTER_XML_KEY));
                results.put(JSP_HAS_ROLE_PARAM, dirPropertyBook.getCache().get(CACHE_HAS_ROLE_KEY));
                Hashtable values = (Hashtable)dirPropertyBook.getCache().get(CACHE_VALUES_KEY);
                Enumeration e = values.keys();
                ArrayList<String> keys = new ArrayList<String>();
                while (e.hasMoreElements()) {
                    keys.add(e.nextElement().toString());
                }
                Collections.sort(keys, queryCmp);
                results.put(JSP_VALUES_PARAM, keys);
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
        return bIsDynamic;
    }

    private static boolean readFromDS(PropertyPageContext context, DirPropertyBook dirPropertyBook) {
        String strXML;
        String key;
        boolean bIsDynamic = DGFilterPage.outputCommonSettings(context, dirPropertyBook);
        boolean bIsNested = NGUtilities.outputCommonSettings((DirPropertyBook)dirPropertyBook, (PropertyPageContext)context);
        Properties results = context.getResultStrings();
        Boolean bHasRoleAssignments = new Boolean(DGFilterPage.hasRoleAssignments(dirPropertyBook));
        Enumeration ldapEnum = DGFilterPage.ldapRead(context, dirPropertyBook, bIsDynamic);
        String ldapString = "";
        ArrayList<String> keys = new ArrayList<String>();
        Hashtable<String, String> values = new Hashtable<String, String>();
        Vector tempValues = new Vector();
        if (ldapEnum.hasMoreElements()) {
            int count = 1;
            int num = 1;
            while (ldapEnum.hasMoreElements()) {
                ++num;
                tempValues.add(ldapEnum.nextElement());
            }
            for (int i = tempValues.size() - 1; i > -1; --i) {
                Object obj = tempValues.get(i);
                key = CACHE_VALUE_KEY;
                key = key.concat(String.valueOf(count));
                if (count == 1) {
                    ldapString = obj.toString();
                    dirPropertyBook.getCache().put(CACHE_SELECTED_VALUE_KEY, key);
                }
                values.put(key, obj.toString());
                keys.add(key);
                ++count;
            }
        } else {
            int newSize = 1;
            key = CACHE_VALUE_KEY;
            key = key.concat(String.valueOf(newSize));
            keys.add(key);
            Collections.sort(keys, queryCmp);
            ldapString = DGFilterPage.constructMemberQueryURL(context, dirPropertyBook, "", BASE_SCOPE_WIRE_FORM, "", "");
            values.put(key, ldapString);
            dirPropertyBook.getCache().put(CACHE_SELECTED_VALUE_KEY, key);
        }
        dirPropertyBook.getCache().put(CACHE_VALUES_KEY, values);
        context.getResultStrings().put(JSP_VALUES_PARAM, keys);
        Hashtable ht = DGFilterPage.extractMemberQueryURL(ldapString, context, dirPropertyBook, true);
        try {
            DGUtilities dgUtilities = new DGUtilities();
            strXML = dgUtilities.convert2254StringToXML((String)ht.get(HASHTABLE_FILTER_KEY), (MContext)context, DGUtilities.getMappingObject(dirPropertyBook, context));
        }
        catch (Exception e) {
            strXML = "";
        }
        String baseDN = eMFrameUtils.urlEncode((String)((String)ht.get(HASHTABLE_BASEDN_KEY)), (MContext)context);
        String filter = eMFrameUtils.urlEncode((String)((String)ht.get(HASHTABLE_FILTER_KEY)), (MContext)context);
        results.put(JSP_BASE_DN_PARAM, baseDN);
        results.put(JSP_SCOPE_PARAM, ht.get(HASHTABLE_SCOPE_KEY));
        results.put(JSP_XCHAIN_PARAM, ht.get(HASHTABLE_XCHAIN_KEY));
        results.put(JSP_XSPARSE_PARAM, ht.get(HASHTABLE_XSPARSE_KEY));
        results.put(JSP_FILTER_PARAM, filter);
        results.put(JSP_FILTER_XML_PARAM, strXML);
        results.put(JSP_HAS_ROLE_PARAM, bHasRoleAssignments.toString());
        dirPropertyBook.getCache().put(CACHE_BASEDN_KEY, ht.get(HASHTABLE_BASEDN_KEY));
        dirPropertyBook.getCache().put(CACHE_SCOPE_KEY, ht.get(HASHTABLE_SCOPE_KEY));
        dirPropertyBook.getCache().put(CACHE_XCHAIN_KEY, ht.get(HASHTABLE_XCHAIN_KEY));
        dirPropertyBook.getCache().put(CACHE_XSPARSE_KEY, ht.get(HASHTABLE_XSPARSE_KEY));
        dirPropertyBook.getCache().put(CACHE_FILTER_KEY, ht.get(HASHTABLE_FILTER_KEY));
        dirPropertyBook.getCache().put(CACHE_FILTER_XML_KEY, strXML);
        dirPropertyBook.getCache().put(CACHE_HAS_ROLE_KEY, bHasRoleAssignments.toString());
        D.log((String)strXML);
        return bIsDynamic;
    }

    private static boolean hasRoleAssignments(DirPropertyBook dirPropertyBook) {
        try {
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(dirPropertyBook.getNSObject().getObjectEntry());
            RBSAssociation[] rbsAssociations = rbsAssociatedObject.getDirectRoleAssociations2();
            if (null != rbsAssociations && rbsAssociations.length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            D.log((String)"Could not read the RBSAssociationObject!");
            D.log((Throwable)e);
            return false;
        }
        return false;
    }

    private static Enumeration ldapRead(PropertyPageContext context, DirPropertyBook dirPropertyBook, boolean bIsDynamic) {
        Vector v = new Vector();
        if (bIsDynamic) {
            try {
                Attributes attrs;
                Attribute memberQueryURL;
                DirContext ldapCtx = DGUtilities.getLDAPContext(dirPropertyBook, context);
                MappingObject mapper = DGUtilities.getMappingObject(dirPropertyBook, context);
                if (ldapCtx != null && mapper != null && (memberQueryURL = (attrs = ldapCtx.getAttributes(mapper.NDSNameToLDAPName(dirPropertyBook.getNSObject().getObjectEntry()))).get("memberQueryURL")) != null) {
                    return memberQueryURL.getAll();
                }
            }
            catch (Exception e) {
                D.log((Throwable)e);
            }
        }
        return v.elements();
    }

    private void validateBaseDN(PropertyPageContext context, String baseDN) throws PageException {
        if (baseDN.equalsIgnoreCase("[root]") || this.m_dsRevision < 1055130) {
            return;
        }
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        NSObject nsObj = null;
        try {
            nsObj = ns.getDetails(ns.getObjectEntry(treeOE, baseDN));
        }
        catch (SPIException e) {
            throw new PageException((Exception)((Object)e));
        }
        if (!this.m_dirUtils.isContainer(nsObj.getObjectEntry().getObjectType().getName())) {
            String header = eMFrameUtils.getLocalizedString((String)"DevResources", (String)"GeneralMsg.Error", (MContext)context);
            String pattern = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"Common.NotAContainer", (MContext)context);
            String body = eMFrameUtils.formatMessage((String)pattern, (Object[])new String[]{baseDN});
            throw new PageException(header, body);
        }
    }

    private void writeToCache(PropertyPageContext context, DirPropertyBook dirPropertyBook, DGUtilities dgUtilities, ResourceBundle resBundle, boolean bIsDynamic) throws PageException {
        if (bIsDynamic) {
            HttpServletRequest req = context.getRequest();
            if (req.getParameter(JSP_ACTION_FIELD).equals(ACTION_MODIFY)) {
                String baseDN = eMFrameUtils.urlDecode((String)req.getParameter(JSP_BASEDN), (MContext)context);
                this.validateBaseDN(context, baseDN);
                String strXML = eMFrameUtils.urlDecode((String)req.getParameter(JSP_AS_HIDDEN), (MContext)context);
                String s = this.convertXMLTo2254String(strXML, context);
                dirPropertyBook.getCache().put(CACHE_FILTER_KEY, s);
                dirPropertyBook.getCache().put(CACHE_FILTER_XML_KEY, strXML);
                dirPropertyBook.getCache().put(CACHE_BASEDN_KEY, baseDN);
                dirPropertyBook.getCache().put(CACHE_SCOPE_KEY, DGFilterPage.convertScope(req.getParameter(JSP_SCOPE), resBundle));
                dirPropertyBook.getCache().put(CACHE_XCHAIN_KEY, DGFilterPage.convertXChain(req.getParameter(JSP_XCHAIN), resBundle));
                dirPropertyBook.getCache().put(CACHE_XSPARSE_KEY, DGFilterPage.convertXSparse(req.getParameter(JSP_XSPARSE), resBundle));
                dirPropertyBook.getCache().remove("DYNAMIC_MEMBERS");
                D.log((String)"Action:Modify - cached values from page");
            } else if (req.getParameter(JSP_ACTION_FIELD).equals(ACTION_ADD)) {
                String strXML;
                Hashtable values = (Hashtable)dirPropertyBook.getCache().get(CACHE_VALUES_KEY);
                if (values == null) {
                    values = new Hashtable();
                }
                if (dirPropertyBook.getCache().get(CACHE_SELECTED_VALUE_KEY) != null) {
                    String baseDN = eMFrameUtils.urlDecode((String)req.getParameter(JSP_BASEDN), (MContext)context);
                    this.validateBaseDN(context, baseDN);
                    String checkingchain = DGFilterPage.convertXChain(req.getParameter(JSP_XCHAIN), resBundle);
                    if (checkingchain == "") {
                        checkingchain = DGFilterPage.convertXSparse(req.getParameter(JSP_XSPARSE), resBundle);
                    }
                    values.put(dirPropertyBook.getCache().get(CACHE_SELECTED_VALUE_KEY), DGFilterPage.constructMemberQueryURL(context, dirPropertyBook, baseDN, DGFilterPage.convertScope(req.getParameter(JSP_SCOPE), resBundle), checkingchain, req.getParameter(JSP_FILTER)));
                }
                int newSize = 1;
                String key = CACHE_VALUE_KEY;
                key = key.concat(String.valueOf(newSize += values.size()));
                String value = DGFilterPage.constructMemberQueryURL(context, dirPropertyBook, "", BASE_SCOPE_WIRE_FORM, "", "");
                values.put(key, value);
                dirPropertyBook.getCache().put(CACHE_VALUES_KEY, values);
                dirPropertyBook.getCache().put(CACHE_SELECTED_VALUE_KEY, key);
                Hashtable ht = DGFilterPage.extractMemberQueryURL((String)values.get(key), context, dirPropertyBook, true);
                try {
                    strXML = dgUtilities.convert2254StringToXML((String)ht.get(HASHTABLE_FILTER_KEY), (MContext)context, DGUtilities.getMappingObject(dirPropertyBook, context));
                }
                catch (Exception e) {
                    strXML = "";
                }
                dirPropertyBook.getCache().put(CACHE_BASEDN_KEY, ht.get(HASHTABLE_BASEDN_KEY));
                dirPropertyBook.getCache().put(CACHE_SCOPE_KEY, ht.get(HASHTABLE_SCOPE_KEY));
                dirPropertyBook.getCache().put(CACHE_XCHAIN_KEY, ht.get(HASHTABLE_XCHAIN_KEY));
                dirPropertyBook.getCache().put(CACHE_XSPARSE_KEY, ht.get(HASHTABLE_XSPARSE_KEY));
                dirPropertyBook.getCache().put(CACHE_FILTER_KEY, ht.get(HASHTABLE_FILTER_KEY));
                dirPropertyBook.getCache().put(CACHE_FILTER_XML_KEY, strXML);
                dirPropertyBook.getCache().remove("DYNAMIC_MEMBERS");
                D.log((String)"Action:Add - cached values from page");
            } else if (req.getParameter(JSP_ACTION_FIELD).equals(ACTION_REMOVE)) {
                String strXML;
                Hashtable values = (Hashtable)dirPropertyBook.getCache().get(CACHE_VALUES_KEY);
                String selectedKey = req.getParameter(JSP_VALUES);
                values.remove(selectedKey);
                Enumeration e = values.keys();
                ArrayList<String> keys = new ArrayList<String>();
                int count = 1;
                while (e.hasMoreElements()) {
                    keys.add(e.nextElement().toString());
                }
                Collections.sort(keys, queryCmp);
                Hashtable<String, String> values2 = new Hashtable<String, String>();
                for (int i = 0; i < keys.size(); ++i) {
                    String key = CACHE_VALUE_KEY;
                    key = key.concat(String.valueOf(count));
                    values2.put(key, values.get(keys.get(i)).toString());
                    ++count;
                }
                dirPropertyBook.getCache().put(CACHE_VALUES_KEY, values2);
                dirPropertyBook.getCache().put(CACHE_SELECTED_VALUE_KEY, CACHE_VALUE_1_KEY);
                boolean urlDecode = false;
                if (((String)values2.get(CACHE_VALUE_1_KEY)).indexOf(37) > -1) {
                    urlDecode = true;
                }
                Hashtable ht = DGFilterPage.extractMemberQueryURL((String)values2.get(CACHE_VALUE_1_KEY), context, dirPropertyBook, urlDecode);
                try {
                    strXML = dgUtilities.convert2254StringToXML((String)ht.get(HASHTABLE_FILTER_KEY), (MContext)context, DGUtilities.getMappingObject(dirPropertyBook, context));
                }
                catch (Exception e1) {
                    strXML = "";
                }
                dirPropertyBook.getCache().put(CACHE_BASEDN_KEY, ht.get(HASHTABLE_BASEDN_KEY));
                dirPropertyBook.getCache().put(CACHE_SCOPE_KEY, ht.get(HASHTABLE_SCOPE_KEY));
                dirPropertyBook.getCache().put(CACHE_XCHAIN_KEY, ht.get(HASHTABLE_XCHAIN_KEY));
                dirPropertyBook.getCache().put(CACHE_XSPARSE_KEY, ht.get(HASHTABLE_XSPARSE_KEY));
                dirPropertyBook.getCache().put(CACHE_FILTER_KEY, ht.get(HASHTABLE_FILTER_KEY));
                dirPropertyBook.getCache().put(CACHE_FILTER_XML_KEY, strXML);
                dirPropertyBook.getCache().remove("DYNAMIC_MEMBERS");
                D.log((String)"Action:Remove - cached values from page");
            } else if (req.getParameter(JSP_ACTION_FIELD).equals(ACTION_REFRESH)) {
                String strXML;
                Hashtable values = (Hashtable)dirPropertyBook.getCache().get(CACHE_VALUES_KEY);
                String baseDN = eMFrameUtils.urlDecode((String)req.getParameter(JSP_BASEDN), (MContext)context);
                String checkingchain = DGFilterPage.convertXChain(req.getParameter(JSP_XCHAIN), resBundle);
                if (checkingchain == "") {
                    checkingchain = DGFilterPage.convertXSparse(req.getParameter(JSP_XSPARSE), resBundle);
                }
                values.put(dirPropertyBook.getCache().get(CACHE_SELECTED_VALUE_KEY), DGFilterPage.constructMemberQueryURL(context, dirPropertyBook, baseDN, DGFilterPage.convertScope(req.getParameter(JSP_SCOPE), resBundle), checkingchain, req.getParameter(JSP_FILTER)));
                String selectedKey = req.getParameter(JSP_VALUES);
                String ldapString = (String)values.get(selectedKey);
                boolean urlDecode = false;
                if (ldapString.indexOf(37) > -1) {
                    urlDecode = true;
                }
                Hashtable ht = DGFilterPage.extractMemberQueryURL((String)values.get(selectedKey), context, dirPropertyBook, urlDecode);
                try {
                    strXML = dgUtilities.convert2254StringToXML((String)ht.get(HASHTABLE_FILTER_KEY), (MContext)context, DGUtilities.getMappingObject(dirPropertyBook, context));
                }
                catch (Exception e) {
                    strXML = "";
                }
                dirPropertyBook.getCache().put(CACHE_BASEDN_KEY, ht.get(HASHTABLE_BASEDN_KEY));
                dirPropertyBook.getCache().put(CACHE_SCOPE_KEY, ht.get(HASHTABLE_SCOPE_KEY));
                dirPropertyBook.getCache().put(CACHE_XCHAIN_KEY, ht.get(HASHTABLE_XCHAIN_KEY));
                dirPropertyBook.getCache().put(CACHE_XSPARSE_KEY, ht.get(HASHTABLE_XSPARSE_KEY));
                dirPropertyBook.getCache().put(CACHE_FILTER_KEY, ht.get(HASHTABLE_FILTER_KEY));
                dirPropertyBook.getCache().put(CACHE_FILTER_XML_KEY, strXML);
                dirPropertyBook.getCache().put(CACHE_VALUES_KEY, values);
                dirPropertyBook.getCache().put(CACHE_SELECTED_VALUE_KEY, selectedKey);
                dirPropertyBook.getCache().remove("DYNAMIC_MEMBERS");
                D.log((String)"Action:Refresh - cached values from page");
            } else {
                Hashtable values = (Hashtable)dirPropertyBook.getCache().get(CACHE_VALUES_KEY);
                String selectedKey = req.getParameter(JSP_VALUES);
                if (selectedKey != null) {
                    String strXML;
                    String baseDN = eMFrameUtils.urlDecode((String)req.getParameter(JSP_BASEDN), (MContext)context);
                    String filter = eMFrameUtils.urlDecode((String)req.getParameter(JSP_AS_HIDDEN), (MContext)context);
                    D.log((String)("filter is " + filter));
                    this.validateBaseDN(context, baseDN);
                    String checkingchain = DGFilterPage.convertXChain(req.getParameter(JSP_XCHAIN), resBundle);
                    if (checkingchain == "") {
                        checkingchain = DGFilterPage.convertXSparse(req.getParameter(JSP_XSPARSE), resBundle);
                    }
                    values.put(selectedKey, DGFilterPage.constructMemberQueryURL(context, dirPropertyBook, baseDN, DGFilterPage.convertScope(req.getParameter(JSP_SCOPE), resBundle), checkingchain, filter));
                    Hashtable ht = DGFilterPage.extractMemberQueryURL((String)values.get(selectedKey), context, dirPropertyBook, false);
                    try {
                        strXML = dgUtilities.convert2254StringToXML((String)ht.get(HASHTABLE_FILTER_KEY), (MContext)context, DGUtilities.getMappingObject(dirPropertyBook, context));
                    }
                    catch (Exception e) {
                        strXML = "";
                    }
                    D.log((String)("filter is now: " + (String)ht.get(HASHTABLE_FILTER_KEY)));
                    String str = (String)ht.get(HASHTABLE_FILTER_KEY);
                    String sanitizedString = this.sanitizeString(str);
                    ht.put(HASHTABLE_FILTER_KEY, sanitizedString);
                    dirPropertyBook.getCache().put(CACHE_BASEDN_KEY, ht.get(HASHTABLE_BASEDN_KEY));
                    dirPropertyBook.getCache().put(CACHE_SCOPE_KEY, ht.get(HASHTABLE_SCOPE_KEY));
                    dirPropertyBook.getCache().put(CACHE_XCHAIN_KEY, ht.get(HASHTABLE_XCHAIN_KEY));
                    dirPropertyBook.getCache().put(CACHE_XSPARSE_KEY, ht.get(HASHTABLE_XSPARSE_KEY));
                    dirPropertyBook.getCache().put(CACHE_FILTER_KEY, ht.get(HASHTABLE_FILTER_KEY));
                    dirPropertyBook.getCache().put(CACHE_FILTER_XML_KEY, strXML);
                    dirPropertyBook.getCache().put(CACHE_VALUES_KEY, values);
                } else {
                    String strXML;
                    String baseDN = eMFrameUtils.urlDecode((String)req.getParameter(JSP_BASEDN), (MContext)context);
                    String filter = eMFrameUtils.urlDecode((String)req.getParameter(JSP_AS_HIDDEN), (MContext)context);
                    D.log((String)("filter is " + filter));
                    selectedKey = CACHE_VALUE_1_KEY;
                    String checkingchain = DGFilterPage.convertXChain(req.getParameter(JSP_XCHAIN), resBundle);
                    if (checkingchain == "") {
                        checkingchain = DGFilterPage.convertXSparse(req.getParameter(JSP_XSPARSE), resBundle);
                    }
                    values.put(selectedKey, DGFilterPage.constructMemberQueryURL(context, dirPropertyBook, baseDN, DGFilterPage.convertScope(req.getParameter(JSP_SCOPE), resBundle), checkingchain, filter));
                    Hashtable ht = DGFilterPage.extractMemberQueryURL((String)values.get(selectedKey), context, dirPropertyBook, true);
                    try {
                        strXML = dgUtilities.convert2254StringToXML((String)ht.get(HASHTABLE_FILTER_KEY), (MContext)context, DGUtilities.getMappingObject(dirPropertyBook, context));
                    }
                    catch (Exception e) {
                        strXML = "";
                    }
                    D.log((String)("filter is now: " + (String)ht.get(HASHTABLE_FILTER_KEY)));
                    String str = (String)ht.get(HASHTABLE_FILTER_KEY);
                    String sanitizedString = this.sanitizeString(str);
                    ht.put(HASHTABLE_FILTER_KEY, sanitizedString);
                    dirPropertyBook.getCache().put(CACHE_BASEDN_KEY, ht.get(HASHTABLE_BASEDN_KEY));
                    dirPropertyBook.getCache().put(CACHE_SCOPE_KEY, ht.get(HASHTABLE_SCOPE_KEY));
                    dirPropertyBook.getCache().put(CACHE_XCHAIN_KEY, ht.get(HASHTABLE_XCHAIN_KEY));
                    dirPropertyBook.getCache().put(CACHE_XSPARSE_KEY, ht.get(HASHTABLE_XSPARSE_KEY));
                    dirPropertyBook.getCache().put(CACHE_FILTER_KEY, ht.get(HASHTABLE_FILTER_KEY));
                    dirPropertyBook.getCache().put(CACHE_FILTER_XML_KEY, strXML);
                    dirPropertyBook.getCache().put(CACHE_VALUES_KEY, values);
                    dirPropertyBook.getCache().put(CACHE_SELECTED_VALUE_KEY, selectedKey);
                }
                dirPropertyBook.getCache().remove("DYNAMIC_MEMBERS");
            }
        }
    }

    private void writeToDS(PropertyPageContext context, boolean bIsDynamic) throws PageException {
        if (bIsDynamic) {
            Hashtable values = (Hashtable)this.getDirPropertyBook().getCache().get(CACHE_VALUES_KEY);
            String[] array = new String[values.size()];
            Enumeration e = values.elements();
            int count = 0;
            while (e.hasMoreElements()) {
                Hashtable ht = DGFilterPage.extractMemberQueryURL(e.nextElement().toString(), context, this.getDirPropertyBook(), false);
                String xchain = (String)ht.get(HASHTABLE_XCHAIN_KEY);
                if (xchain == "") {
                    xchain = (String)ht.get(HASHTABLE_XSPARSE_KEY);
                }
                array[count] = DGFilterPage.constructMemberQueryURL(context, this.getDirPropertyBook(), (String)ht.get(HASHTABLE_BASEDN_KEY), (String)ht.get(HASHTABLE_SCOPE_KEY), xchain, (String)ht.get(HASHTABLE_FILTER_KEY));
                ++count;
            }
            this.ldapWrite(array, context);
        }
    }

    private void ldapWrite(String[] memberQueryURLValues, PropertyPageContext context) throws PageException {
        BasicAttributes bas = new BasicAttributes();
        MappingObject mapper = DGUtilities.getMappingObject(this.getDirPropertyBook(), context);
        DirContext ldapCtx = DGUtilities.getLDAPContext(this.getDirPropertyBook(), context);
        if (ldapCtx != null && mapper != null) {
            try {
                BasicAttribute ba = new BasicAttribute("memberQueryURL");
                for (int i = 0; i < memberQueryURLValues.length; ++i) {
                    ba.add(memberQueryURLValues[i]);
                }
                bas.put(ba);
                ldapCtx.modifyAttributes(mapper.NDSNameToLDAPName(this.getDirPropertyBook().getNSObject().getObjectEntry()), 2, (Attributes)bas);
            }
            catch (InvalidAttributeValueException iave) {
                String header = eMFrameUtils.getLocalizedString((String)"DevResources", (String)"GeneralMsg.Error", (MContext)context);
                String body = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroup.InvalidFilterSyntax", (MContext)context);
                throw new PageException(header, body);
            }
            catch (InvalidNameException e) {
                String header = eMFrameUtils.getLocalizedString((String)"DevResources", (String)"GeneralMsg.Error", (MContext)context);
                String body = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroup.InvalidFilterSyntax", (MContext)context);
                throw new PageException(header, body);
            }
            catch (NamingException e) {
                String header = eMFrameUtils.getLocalizedString((String)"DevResources", (String)"GeneralMsg.Error", (MContext)context);
                String body = eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroup.LdapIsNullTitle", (MContext)context);
                throw new PageException(header, body);
            }
            catch (Exception e) {
                D.log((Throwable)e);
                eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
                throw new PageException(e);
            }
        }
    }

    private static String[] createUnencodedArray(String concatString, String delimiter) {
        StringTokenizer tokenIzer = new StringTokenizer(concatString, delimiter, false);
        String[] stringArray = new String[tokenIzer.countTokens()];
        int tokenCount = 0;
        while (tokenIzer.hasMoreTokens()) {
            String s;
            stringArray[tokenCount] = s = tokenIzer.nextToken();
            ++tokenCount;
        }
        return stringArray;
    }

    private static String constructMemberQueryURL(PropertyPageContext context, DirPropertyBook dirPropertyBook, String basedn, String scope, String xchain_xsparse, String filter) {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        MappingObject mapper = DGUtilities.getMappingObject(dirPropertyBook, context);
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        String memberQueryURL = "ldap:///";
        String basedn_ldap = "";
        try {
            if (!basedn.equals("") && !basedn.equals(treeOE.getName())) {
                basedn_ldap = mapper.NDSNameToLDAPName(ns.getObjectEntry(treeOE, basedn));
            }
        }
        catch (Exception e) {
            D.log((Throwable)e);
        }
        memberQueryURL = memberQueryURL + basedn_ldap + "??";
        memberQueryURL = memberQueryURL + scope + "?";
        memberQueryURL = memberQueryURL + filter;
        if (xchain_xsparse != null && xchain_xsparse != "") {
            memberQueryURL = memberQueryURL + "?" + xchain_xsparse;
        }
        if (memberQueryURL.endsWith("?")) {
            memberQueryURL = memberQueryURL.substring(0, memberQueryURL.length() - 1);
        }
        return memberQueryURL;
    }

    private static int hex2int(char c) {
        return c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
    }

    private static byte[] unescapeString(String string, boolean bStringIsFilter) {
        byte[] octets = new byte[string.length()];
        boolean escape = false;
        boolean escStart = false;
        int length = string.length();
        char temp = '\u0000';
        int iOctets = 0;
        for (int iString = 0; iString < length; ++iString) {
            char ch = string.charAt(iString);
            if (escape) {
                int ival = DGFilterPage.hex2int(ch);
                if (ival < 0) {
                    if (!escStart) continue;
                    escape = false;
                    escStart = false;
                    octets[iOctets++] = (byte)ch;
                    continue;
                }
                if (escStart) {
                    temp = (char)(ival << 4);
                    escStart = false;
                    continue;
                }
                temp = (char)(temp | (char)ival);
                octets[iOctets++] = (byte)temp;
                escape = false;
                escStart = false;
                continue;
            }
            if (ch == '\\') {
                escape = true;
                escStart = true;
                continue;
            }
            byte b = (byte)ch;
            if (!(b >= 1 && b <= 39 || b >= 43 && b <= 91 || bStringIsFilter && b >= 40 && b <= 42) && (b < 93 || b > 127)) continue;
            octets[iOctets++] = (byte)ch;
            escape = false;
        }
        if (escStart || escape) {
            // empty if block
        }
        byte[] toReturn = new byte[iOctets];
        System.arraycopy(octets, 0, toReturn, 0, iOctets);
        octets = null;
        return toReturn;
    }

    public static int getNCPServerDSRevision(PropertyPageContext context) {
        NDSObjectAttribute dsRevisionAttr = null;
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            String serverDN = ns.getDefaultServerDN(treeOE);
            ObjectEntry serverOE = ns.getObjectEntry(treeOE, serverDN);
            NSObject serverNSobj = ns.getDetails(serverOE);
            dsRevisionAttr = (NDSObjectAttribute)serverNSobj.getAttribute("DS Revision");
        }
        catch (SPIException e) {
            return -1;
        }
        return dsRevisionAttr == null ? -1 : new Integer(dsRevisionAttr.toString());
    }

    private static Hashtable extractMemberQueryURL(String ldapString, PropertyPageContext context, DirPropertyBook dirPropertyBook, boolean bUrlDecode) {
        String baseDN = "";
        String scope = "";
        String filter = "";
        String xchain_xsparse = "";
        Hashtable<String, String> ht = new Hashtable<String, String>();
        D.log((String)("extracting member query info from: " + ldapString));
        if (ldapString.indexOf("///") != -1 && ldapString.indexOf("??") != -1) {
            baseDN = ldapString.substring(ldapString.indexOf("///") + 3, ldapString.indexOf("??"));
            if (bUrlDecode) {
                try {
                    baseDN = eMFrameUtils.urlDecode((String)baseDN, (MContext)context);
                    try {
                        baseDN = new String(DGFilterPage.unescapeString(baseDN, false), "UTF-8");
                    }
                    catch (Exception e) {}
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            D.log((String)("   basedn: " + baseDN));
            String remains = ldapString.substring(ldapString.indexOf("??") + 1, ldapString.length());
            String[] tokens = DGFilterPage.createUnencodedArray(remains, "?");
            if (tokens.length >= 1) {
                scope = tokens[0];
                D.log((String)("   scope: " + scope));
                if (tokens.length >= 2) {
                    try {
                        if (bUrlDecode) {
                            D.log((String)("tokens[ 1 ] is " + tokens[1]));
                            filter = eMFrameUtils.urlDecode((String)tokens[1], (MContext)context);
                            D.log((String)("after urlDecode is " + filter));
                            D.log((String)("after unescapeString is " + DGFilterPage.unescapeString(filter, true)));
                            filter = new String(DGFilterPage.unescapeString(filter, true), "UTF-8");
                            D.log((String)("after conversion to UTF-8 is " + filter));
                        } else {
                            filter = tokens[1];
                        }
                    }
                    catch (Exception e) {
                        filter = tokens[1];
                    }
                    D.log((String)("   filter: " + filter));
                    if (tokens.length > 2) {
                        xchain_xsparse = tokens[2];
                        D.log((String)("  Is xchain or xsparse: " + xchain_xsparse));
                    }
                }
            }
        }
        if (baseDN.length() > 0) {
            MappingObject mapper = DGUtilities.getMappingObject(dirPropertyBook, context);
            if (bUrlDecode) {
                // empty if block
            }
            baseDN = mapper.LDAPNameToNDSName(baseDN, false, false);
            D.log((String)("baseDN converted to: " + baseDN));
            if (baseDN.startsWith(".")) {
                baseDN = baseDN.substring(1, baseDN.length());
                D.log((String)("baseDN converted to: " + baseDN));
            }
        } else {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            baseDN = treeOE.getName();
            D.log((String)("baseDN set to: " + baseDN));
        }
        ht.put(HASHTABLE_BASEDN_KEY, baseDN);
        ht.put(HASHTABLE_SCOPE_KEY, scope);
        ht.put(HASHTABLE_XCHAIN_KEY, xchain_xsparse);
        ht.put(HASHTABLE_XSPARSE_KEY, xchain_xsparse);
        if (filter.equals("")) {
            filter = "(&(objectClass=*))";
        }
        ht.put(HASHTABLE_FILTER_KEY, filter);
        return ht;
    }

    private String convertXMLTo2254String(String filterXML, PropertyPageContext context) {
        SelectionCriterion selectionCriterion = new SelectionCriterion();
        if (filterXML == null || filterXML.equals("")) {
            return "";
        }
        D.log((String)("get2254String converting xml: " + filterXML));
        try {
            Group group;
            StringReader r = new StringReader(filterXML);
            Document document = iManager.getSaxBuilder().build((Reader)r);
            FilterResultModifier.Filter filter = new FilterResultModifier.Filter();
            Element root = document.getRootElement();
            List rootChildren = root.getChildren("group");
            Iterator rootIterator = rootChildren.iterator();
            while (rootIterator.hasNext()) {
                Element groupElement = (Element)rootIterator.next();
                group = new Group(groupElement.getChildTextTrim("group-op"));
                List groupChildrenRows = groupElement.getChildren("row");
                Iterator groupIteratorRows = groupChildrenRows.iterator();
                while (groupIteratorRows.hasNext()) {
                    Element rowElement = (Element)groupIteratorRows.next();
                    Row row = new Row(rowElement.getChildTextTrim("attribute"), rowElement.getChildTextTrim("operation"), rowElement.getChildTextTrim("value"), rowElement.getChildTextTrim("row-op"));
                    group.addRow(row);
                }
                selectionCriterion.addGroup(group);
            }
            for (int i = 0; i < selectionCriterion.getGroups().size(); ++i) {
                group = (Group)selectionCriterion.getGroups().elementAt(i);
                FilterResultModifier.FilterItemGroup filterItem = new FilterResultModifier.FilterItemGroup();
                for (int j = 0; j < group.getRows().size(); ++j) {
                    Row row = (Row)group.getRows().elementAt(j);
                    filterItem.addFilterItem(row.getAttribute(), this.translateOp(row.getOperation()), row.getCriteria(), this.translateOp(row.getRowOp()));
                }
                if (i + 1 != selectionCriterion.getGroups().size()) {
                    filter.addFilterItemGroupPair(filterItem, this.translateOp(group.getOperator()));
                    continue;
                }
                filter.addFilterItemGroupPair(filterItem, null);
            }
            NDSFilterResultModifier modifier = new NDSFilterResultModifier("", filter, false);
            String result = modifier.getFilterString(DirUtils.getAdminNamespace((MContext)context));
            return result;
        }
        catch (Exception e) {
            D.log((Throwable)e);
            return "";
        }
    }

    private String translateOp(String op) {
        if (op.equals(OP_EQ) || op.equals(OP_I)) {
            return "=";
        }
        if (op.equals(OP_NEQ) || op.equals(OP_IN)) {
            return "!";
        }
        if (op.equals(OP_IB) || op.equals(OP_IL)) {
            return "<=";
        }
        if (op.equals(OP_IA) || op.equals(OP_IG)) {
            return ">=";
        }
        if (op.equals(OP_NEAR)) {
            return "~=";
        }
        if (op.equals("AS.Op.isPresent")) {
            return "=*";
        }
        if (op.equals("AS.Op.isNotPresent")) {
            return "!*";
        }
        if (op.equals(OP_AND)) {
            return "&";
        }
        if (op.equals(OP_OR)) {
            return "|";
        }
        return "";
    }

    private static String convertScope(String humanReadableName, ResourceBundle resBundle) {
        String wireName = BASE_SCOPE_WIRE_FORM;
        if (humanReadableName != null) {
            if (humanReadableName.equalsIgnoreCase(resBundle.getString("DynamicGroup.FilterScopeSub"))) {
                wireName = SUB_SCOPE_WIRE_FORM;
            } else if (humanReadableName.equalsIgnoreCase(resBundle.getString("DynamicGroup.FilterScopeOne"))) {
                wireName = ONE_SCOPE_WIRE_FORM;
            }
        }
        return wireName;
    }

    private static String convertXChain(String humanReadableName, ResourceBundle resBundle) {
        String wireName = "";
        if (humanReadableName != null && humanReadableName.equalsIgnoreCase(resBundle.getString("DynamicGroup.FilterXChainSet"))) {
            wireName = X_CHAIN_WIRE_FORM;
        }
        return wireName;
    }

    private static String convertXSparse(String humanReadableName, ResourceBundle resBundle) {
        String wireName = "";
        if (humanReadableName != null && humanReadableName.equalsIgnoreCase(resBundle.getString("DynamicGroup.FilterXChainSet"))) {
            wireName = X_SPARSE_WIRE_FORM;
        }
        return wireName;
    }

    private String sanitizeString(String input) {
        if (input == null || input.equals("")) {
            return "";
        }
        int len = input.length();
        StringBuffer sb = new StringBuffer(len);
        block7: for (int idx = 0; idx < len; ++idx) {
            char ch = input.charAt(idx);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\u001b': {
                    sb.append("&#27;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private class Row {
        private String attribute;
        private String operation;
        private String criteria;
        private String row_op;

        Row(String attribute, String operation, String criteria, String row_op) {
            this.attribute = attribute;
            this.operation = operation;
            this.criteria = criteria;
            this.row_op = row_op;
        }

        String getAttribute() {
            return this.attribute;
        }

        String getOperation() {
            return this.operation;
        }

        String getCriteria() {
            return this.criteria;
        }

        String getRowOp() {
            return this.row_op;
        }
    }

    private class Group {
        private Vector rows;
        private String group_op;

        Group(String group_op) {
            this.group_op = group_op;
            this.rows = new Vector();
        }

        void addRow(Row row) {
            this.rows.addElement(row);
        }

        Vector getRows() {
            return this.rows;
        }

        String getOperator() {
            return this.group_op;
        }
    }

    private class SelectionCriterion {
        private Vector groups = new Vector();

        private SelectionCriterion() {
        }

        void addGroup(Group group) {
            this.groups.addElement(group);
        }

        Vector getGroups() {
            return this.groups;
        }
    }
}

