/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AdvSelTypeInfo;
import com.novell.emframe.dev.AdvSelTypeInfoCallback;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.FwConsts;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DGMemberQueryCallback
extends AdvSelTypeInfoCallback {
    private Hashtable m_attribSyntaxPairs = new Hashtable();
    private Hashtable m_syntaxOps = new Hashtable();
    private static final String[] m_defaultOps = FwConsts.AS_NDS_defaultOps;
    private static final String[] m_integerOps = FwConsts.AS_NDS_integerOps;
    private static final String[] m_booleanOps = FwConsts.AS_NDS_booleanOps;
    private static final String[] m_useDefaultOps = new String[0];
    private static final String[] m_booleanValues = new String[]{"true", "false"};

    public DGMemberQueryCallback() {
        this.m_syntaxOps.put(NDSSyntax.SYN_CE_STRING, m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_CI_STRING, m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_CLASS_NAME, m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_DIST_NAME, m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_EMAIL_ADDRESS, m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_NU_STRING, m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_PR_STRING, m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_TEL_NUMBER, m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_COUNTER, m_integerOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_INTEGER, m_integerOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_INTERVAL, m_integerOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_BOOLEAN, m_booleanOps);
    }

    public AdvSelTypeInfo getInfo(TaskContext context, String[] types, String[] auxTypes) {
        AdvSelTypeInfo typeInfo = new AdvSelTypeInfo(m_defaultOps);
        AttributeDefinition[] allAttrDefs = null;
        try {
            int i;
            ObjectEntry oeRoot = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)oeRoot.getNamespace();
            SchemaDefinition sd = ns.getSchemaDefinition(oeRoot);
            AttributeDefinition[] ads = sd.getAttributeDefinitions();
            Vector<AttributeDefinition> v = new Vector<AttributeDefinition>();
            for (i = 0; i < ads.length; ++i) {
                if (ads[i].isHidden() || ads[i].getName().equals("[Nothing]") || ads[i].getName().equals("[Anything]")) continue;
                v.add(ads[i]);
            }
            allAttrDefs = new AttributeDefinition[v.size()];
            for (i = 0; i < v.size(); ++i) {
                allAttrDefs[i] = (AttributeDefinition)v.elementAt(i);
            }
        }
        catch (Exception e) {
            D.log((String)("DGMemberQueryCallback.getInfo: exception getting schema class definitions. e = " + e.toString()));
            return null;
        }
        this.getNameSyntaxPairs(allAttrDefs, this.m_attribSyntaxPairs);
        if (this.m_attribSyntaxPairs != null && this.m_syntaxOps != null) {
            String ndapAttribName = null;
            NDSSyntax syntax = NDSSyntax.SYN_UNKNOWN;
            Enumeration myenum = this.m_attribSyntaxPairs.keys();
            MappingObject mappingObject = context.getDirUtils().getMappingObject();
            while (myenum.hasMoreElements()) {
                ndapAttribName = (String)myenum.nextElement();
                if (ndapAttribName == null || ndapAttribName.length() <= 0) continue;
                syntax = (Syntax)this.m_attribSyntaxPairs.get(ndapAttribName);
                String[] ldapAttribName = mappingObject.NDSAttributeToLDAP(ndapAttribName);
                if (syntax != null && ldapAttribName.length != 0) {
                    String[] ops = (String[])this.m_syntaxOps.get(syntax);
                    if (ops != null && ops.length == 0) {
                        ops = null;
                    }
                    if (syntax == NDSSyntax.SYN_BOOLEAN) {
                        typeInfo.addAttribute(ldapAttribName[0], ops, m_booleanValues);
                        continue;
                    }
                    typeInfo.addAttribute(ldapAttribName[0], ops);
                    continue;
                }
                D.log((String)("getInfo:  skipping attrib=" + ndapAttribName + ". syntax is null..."));
            }
        }
        return typeInfo;
    }

    private void getNameSyntaxPairs(AttributeDefinition[] ad, Hashtable asp) {
        if (ad != null && asp != null) {
            String attrib = null;
            NDSSyntax syntax = NDSSyntax.SYN_UNKNOWN;
            for (int i = 0; i < ad.length; ++i) {
                try {
                    attrib = ad[i].getName();
                    syntax = ad[i].getSyntax();
                    if (syntax == null || this.m_syntaxOps.get(syntax) == null) continue;
                    asp.put(attrib, syntax);
                    continue;
                }
                catch (Exception e) {
                    D.log((String)("NDSTypeInfoCallback.getNameSyntaxPairs: exception getting attribute name/syntax. e = " + e.toString()));
                }
            }
        }
    }
}

