/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.base;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBook;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.directory.DirContext;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public final class DGUtilities {
    private static final String IS_DYNAMIC_KEY = "IS_DYNAMIC";
    private static final String CAN_CHANGE_KEY = "CAN_CHANGE";
    private static final String LDAP_CONTEXT_KEY = "LDAP_CONTEXT";
    private static final String MAPPING_OBJECT_KEY = "MAPPING_OBJECT";
    public static final String GROUP_CLASS = "Group";
    public static final String DYNAMIC_GROUP_CLASS = "dynamicGroup";
    public static final String DYNAMIC_GROUP_AUX_CLASS = "dynamicGroupAux";
    private static final String LDAP_IS_NULL_TITLE = "DynamicGroup.LdapIsNullTitle";
    private static final String LDAP_IS_NULL_MSG = "DynamicGroup.LdapIsNullMsg";
    public static final String JSP_IS_DYNAMIC_PARAM = "IsDynamicParam";
    public static final String JSP_CAN_CHANGE_DYNAMIC_PARAM = "CanChangeDynamicParam";
    public static final String DEFAULT_GROUP_FILTER = "(&(objectClass=*))";

    public static boolean isGroupObjectDynamic(NSObject nsObj, PropertyPageContext context) {
        Enumeration myenum;
        ObjectAttribute oa = nsObj.getAttribute("Object Class");
        boolean bFound = false;
        if (oa != null && (myenum = oa.getValueComponents()) != null) {
            while (myenum.hasMoreElements()) {
                String value = myenum.nextElement().toString();
                if (!value.equals(DYNAMIC_GROUP_AUX_CLASS) && !value.equals(DYNAMIC_GROUP_CLASS)) continue;
                bFound = true;
                break;
            }
        }
        return bFound;
    }

    public static boolean isGroupDynamic(DirPropertyBook propertyBook, NSObject nsObj, PropertyPageContext context) {
        Boolean bIsDynamic = (Boolean)propertyBook.getCache().get(IS_DYNAMIC_KEY);
        if (bIsDynamic == null) {
            bIsDynamic = new Boolean(DGUtilities.isGroupObjectDynamic(nsObj, context));
            propertyBook.getCache().put(IS_DYNAMIC_KEY, bIsDynamic);
        }
        D.log((String)("querying dynamic group: " + bIsDynamic.toString()));
        return bIsDynamic;
    }

    public static void setGroupDynamic(PropertyPageContext context, DirPropertyBook propertyBook, Boolean bState) {
        D.log((String)("setting dynamic group to " + bState.toString()));
        if (bState.booleanValue()) {
            DGUtilities.addAuxClassToObject(context, propertyBook.getNSObject());
        } else {
            DGUtilities.removeAuxClassFromObject(context, propertyBook.getNSObject());
        }
        propertyBook.getCache().put(IS_DYNAMIC_KEY, bState);
    }

    private static void addAuxClassToObject(PropertyPageContext context, NSObject nsObject) {
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            SchemaDefinition sd = ns.getSchemaDefinition(nsObject.getObjectEntry());
            ClassDefinition cd = sd.getClassDefinition(DYNAMIC_GROUP_AUX_CLASS);
            nsObject.addAuxiliaryClassDefinition(cd, null);
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
        }
    }

    private static void removeAuxClassFromObject(PropertyPageContext context, NSObject nsObject) {
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            SchemaDefinition sd = ns.getSchemaDefinition(nsObject.getObjectEntry());
            ClassDefinition cd = sd.getClassDefinition(DYNAMIC_GROUP_AUX_CLASS);
            nsObject.deleteAuxiliaryClassDefinition(cd);
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage((Throwable)e, (MContext)context);
        }
    }

    public static boolean isDynamicGroupSchemaInstalled(MContext context) {
        boolean bSchemaInstalled = false;
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry oeRoot = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)oeRoot.getNamespace();
            NDSSchemaDefinition schema = (NDSSchemaDefinition)ns.getSchemaDefinition(oeRoot);
            schema.getClassDefinition(DYNAMIC_GROUP_AUX_CLASS);
            bSchemaInstalled = true;
        }
        catch (SPIException e) {
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return bSchemaInstalled;
    }

    public static void outputCanChangeDynamicSetting(MContext context, I18NServletRequest req) {
        boolean bCanChange = DGUtilities.isDynamicGroupSchemaInstalled(context);
        req.setAttribute(JSP_CAN_CHANGE_DYNAMIC_PARAM, (Object)new Boolean(bCanChange).toString());
    }

    public static boolean outputCommonSettings(DirPropertyBook propertyBook, PropertyPageContext context) {
        Properties properties = context.getResultStrings();
        boolean bIsDynamic = DGUtilities.isGroupDynamic(propertyBook, propertyBook.getNSObject(), context);
        properties.put(JSP_IS_DYNAMIC_PARAM, new Boolean(bIsDynamic).toString());
        properties.put(JSP_CAN_CHANGE_DYNAMIC_PARAM, new Boolean(DGUtilities.canToggleDynamic(propertyBook, propertyBook.getNSObject(), context)).toString());
        return bIsDynamic;
    }

    private static boolean doesClassExist(PropertyPageContext context, NSObject nsObj, String strClassName) {
        ClassDefinition cd = null;
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
            SchemaDefinition sd = namespace.getSchemaDefinition(nsObj.getObjectEntry());
            cd = sd.getClassDefinition(strClassName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return cd != null;
    }

    public static boolean canToggleDynamic(DirPropertyBook propertyBook, NSObject nsObj, PropertyPageContext context) {
        Boolean bCanChange = (Boolean)propertyBook.getCache().get(CAN_CHANGE_KEY);
        if (bCanChange == null) {
            DirUtils dirUtils = context.getDirUtils();
            bCanChange = new Boolean(DGUtilities.isDynamicGroupSchemaInstalled((MContext)context) && (DirUtils.isOfType((ObjectType)nsObj.getObjectEntry().getObjectType(), (String)GROUP_CLASS, (boolean)false) || dirUtils.isOfAuxClass(nsObj.getObjectEntry(), DYNAMIC_GROUP_AUX_CLASS)) && DGUtilities.doesClassExist(context, nsObj, DYNAMIC_GROUP_AUX_CLASS));
            propertyBook.getCache().put(CAN_CHANGE_KEY, bCanChange);
        }
        return bCanChange;
    }

    public static DirContext getLDAPContext(DirPropertyBook propertyBook, PropertyPageContext context) {
        DirContext ldapContext;
        block4: {
            ldapContext = (DirContext)propertyBook.getCache().get(LDAP_CONTEXT_KEY);
            if (ldapContext == null) {
                AuthenticationBroker broker = context.getAuthenticationBroker();
                try {
                    ldapContext = (DirContext)broker.getAPIObject("JndiLdap", (Properties)null);
                    MappingObject mappingObject = context.getDirUtils().getMappingObject();
                    propertyBook.getCache().put(LDAP_CONTEXT_KEY, ldapContext);
                    propertyBook.getCache().put(MAPPING_OBJECT_KEY, mappingObject);
                    if (ldapContext == null) {
                        ResourceBundle res = ResourceBundle.getBundle("BaseResources", context.getLocale());
                        String sTitle = res.getString(LDAP_IS_NULL_TITLE);
                        String sMsg = res.getString(LDAP_IS_NULL_MSG);
                        eMFrameUtils.setMessage((String)"error", (String)sTitle, (String)sMsg, (MContext)context);
                    }
                }
                catch (Exception e) {
                    D.log((Throwable)e);
                    if (!(e instanceof AuthBrokerException)) break block4;
                    ResourceBundle res = ResourceBundle.getBundle("BaseResources", context.getLocale());
                    String sTitle = res.getString(LDAP_IS_NULL_TITLE);
                    String sMsg = res.getString(LDAP_IS_NULL_MSG) + "\n\n" + e.getLocalizedMessage();
                    eMFrameUtils.setMessage((String)"error", (String)sTitle, (String)sMsg, (MContext)context);
                }
            }
        }
        return ldapContext;
    }

    public static MappingObject getMappingObject(DirPropertyBook propertyBook, PropertyPageContext context) {
        MappingObject mappingObject = (MappingObject)propertyBook.getCache().get(MAPPING_OBJECT_KEY);
        if (mappingObject == null) {
            DGUtilities.getLDAPContext(propertyBook, context);
            mappingObject = (MappingObject)propertyBook.getCache().get(MAPPING_OBJECT_KEY);
        }
        return mappingObject;
    }

    public String convert2254StringToXML(String filter2254, MContext context, MappingObject mapper) throws Exception {
        RfcFilter filter = new RfcFilter();
        if (filter2254 == null || filter2254.equals("")) {
            return "";
        }
        if (filter2254.equalsIgnoreCase("(objectClass=*)")) {
            filter2254 = DEFAULT_GROUP_FILTER;
        } else if (filter2254.indexOf("&") == -1 && filter2254.indexOf("|") == -1) {
            filter2254 = "(|".concat(filter2254).concat(")");
        }
        D.log((String)("convert2254StringToXML converting filter: " + filter2254));
        return filter.convert2254StringToXML(filter2254, mapper, context);
    }

    class FilterTokenizer {
        private String filter;
        private String attr;
        private int i;
        private int len;

        public FilterTokenizer(String filter) {
            this.filter = filter;
            this.i = 0;
            this.len = filter.length();
        }

        public void getLeftParen(MContext context) throws PluginException {
            if (this.i >= this.len && context != null) {
                throw new PluginException("", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroupError.UnexpectedEndOfFilter", (MContext)context));
            }
            if (this.filter.charAt(this.i++) != '(' && context != null) {
                throw new PluginException("", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroupError.MissingLeftParen", (MContext)context));
            }
        }

        public void getRightParen(MContext context) throws PluginException {
            if (this.i >= this.len && context != null) {
                throw new PluginException("", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroupError.UnexpectedEndOfFilter", (MContext)context));
            }
            if (this.filter.charAt(this.i++) != ')' && context != null) {
                throw new PluginException("", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroupError.MissingRightParen", (MContext)context));
            }
        }

        public int getOpOrAttr(MContext context) throws PluginException {
            if (this.i >= this.len && context != null) {
                throw new PluginException("", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroupError.UnexpectedEndOfFilter", (MContext)context));
            }
            if (this.filter.charAt(this.i) == '&') {
                ++this.i;
                return 0;
            }
            if (this.filter.charAt(this.i) == '|') {
                ++this.i;
                return 1;
            }
            if (this.filter.charAt(this.i) == '!') {
                ++this.i;
                return 2;
            }
            String delims = "=~<>()";
            StringBuffer sb = new StringBuffer();
            while (delims.indexOf(this.filter.charAt(this.i)) == -1 && !this.filter.startsWith(":=", this.i)) {
                sb.append(this.filter.charAt(this.i++));
            }
            this.attr = sb.toString().trim();
            return -1;
        }

        public int getFilterType(MContext context) throws PluginException {
            if (this.i >= this.len && context != null) {
                throw new PluginException("", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroupError.UnexpectedEndOfFilter", (MContext)context));
            }
            if (this.filter.startsWith(">=", this.i)) {
                this.i += 2;
                return 5;
            }
            if (this.filter.startsWith("<=", this.i)) {
                this.i += 2;
                return 6;
            }
            if (this.filter.startsWith("~=", this.i)) {
                this.i += 2;
                return 8;
            }
            if (this.filter.startsWith(":=", this.i)) {
                this.i += 2;
                return 9;
            }
            if (this.filter.charAt(this.i) == '=') {
                ++this.i;
                return 3;
            }
            return 0;
        }

        public String getValue(MContext context) throws PluginException {
            if (this.i >= this.len && context != null) {
                throw new PluginException("", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroupError.UnexpectedEndOfFilter", (MContext)context));
            }
            StringBuffer sb = new StringBuffer();
            while (this.i < this.len && this.filter.charAt(this.i) != ')') {
                sb.append(this.filter.charAt(this.i++));
            }
            return sb.toString().trim();
        }

        public String getAttr() {
            return this.attr;
        }

        public char peekChar(MContext context) throws PluginException {
            if (this.i >= this.len && context != null) {
                throw new PluginException("", eMFrameUtils.getLocalizedString((String)"BaseResources", (String)"DynamicGroupError.UnexpectedEndOfFilter", (MContext)context));
            }
            return this.filter.charAt(this.i);
        }
    }

    private class RfcFilter {
        public static final int AND = 0;
        public static final int OR = 1;
        public static final int NOT = 2;
        public static final int EQUALITY_MATCH = 3;
        public static final int SUBSTRINGS = 4;
        public static final int GREATER_OR_EQUAL = 5;
        public static final int LESS_OR_EQUAL = 6;
        public static final int PRESENT = 7;
        public static final int APPROX_MATCH = 8;
        public static final int EXTENSIBLE_MATCH = 9;
        public static final int INITIAL = 0;
        public static final int ANY = 1;
        public static final int FINAL = 2;
        private FilterTokenizer ft;
        private String m_result = "";

        private void checkNestedGroup() {
            try {
                SAXBuilder saxBuilder = new SAXBuilder(false);
                StringReader r = new StringReader(this.m_result);
                Document document = saxBuilder.build((Reader)r);
                Element root = document.getRootElement();
                List rootChildren = root.getChildren("group");
                Iterator rootIterator = rootChildren.iterator();
                if (rootChildren.size() == 1) {
                    Element groupElement = (Element)rootIterator.next();
                    List groupChildren = groupElement.getChildren("group");
                    List rowChildren = groupElement.getChildren("row");
                    List groupopchildren = groupElement.getChildren("group-op");
                    Iterator groupIterator = groupChildren.iterator();
                    Iterator rowIterator = rowChildren.iterator();
                    Iterator groupopiterator = groupopchildren.iterator();
                    XMLOutputter outputter = new XMLOutputter();
                    if (groupChildren != null && groupChildren.size() > 0) {
                        this.m_result = "<selection-criterion><types><id>*</id></types>";
                        while (groupIterator.hasNext()) {
                            Element groupElement2 = (Element)groupIterator.next();
                            this.m_result = this.m_result.concat(outputter.outputString(groupElement2));
                        }
                        if (rowChildren != null && rowChildren.size() > 0) {
                            this.m_result = this.m_result.concat("<group>");
                            while (rowIterator.hasNext()) {
                                Element rowElement = (Element)rowIterator.next();
                                this.m_result = this.m_result.concat(outputter.outputString(rowElement));
                            }
                            if (groupopchildren != null && groupopchildren.size() > 0) {
                                Element groupopElement = (Element)groupopiterator.next();
                                this.m_result = this.m_result.concat(outputter.outputString(groupopElement));
                            }
                            this.m_result = this.m_result.concat("</group>");
                        }
                        this.m_result = this.m_result.concat("</selection-criterion>");
                    }
                }
            }
            catch (JDOMException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String convert2254StringToXML(String filter, MappingObject mapper, MContext context) throws PluginException {
            this.m_result = "<selection-criterion><types><id>*</id></types>";
            this.parse(filter, mapper, context);
            this.m_result = this.m_result.concat("</selection-criterion>");
            this.checkNestedGroup();
            return this.m_result;
        }

        private void parse(String filterExpr, MappingObject mapper, MContext context) throws PluginException {
            if (filterExpr == null || filterExpr.equals("")) {
                filterExpr = new String("(objectclass=*)");
            }
            if (filterExpr.charAt(0) != '(') {
                filterExpr = "(" + filterExpr + ")";
            }
            this.ft = new FilterTokenizer(filterExpr);
            this.parseFilter("or", mapper, context);
        }

        private void parseFilter(String strOp, MappingObject mapper, MContext context) throws PluginException {
            this.ft.getLeftParen(context);
            this.parseFilterComp(strOp, mapper, context);
            this.ft.getRightParen(context);
        }

        private void parseFilterComp(String strOp, MappingObject mapper, MContext context) throws PluginException {
            int filterComp = this.ft.getOpOrAttr(context);
            switch (filterComp) {
                case 0: {
                    this.parseFilterList("and", mapper, context);
                    break;
                }
                case 1: {
                    this.parseFilterList("or", mapper, context);
                    break;
                }
                case 2: {
                    this.parseFilter("not", mapper, context);
                    break;
                }
                default: {
                    int filterType = this.ft.getFilterType(context);
                    String value = this.ft.getValue(context);
                    String ndsAttr = this.ft.getAttr();
                    if (mapper != null) {
                        // empty if block
                    }
                    this.m_result = this.m_result.concat("<row>");
                    switch (filterType) {
                        case 5: {
                            this.m_result = this.m_result.concat("<attribute>" + ndsAttr + "</attribute>");
                            this.m_result = this.m_result.concat("<operation>AS.Op.isGreaterEqual</operation>");
                            this.m_result = this.m_result.concat("<value>" + value + "</value>");
                            break;
                        }
                        case 6: {
                            this.m_result = this.m_result.concat("<attribute>" + ndsAttr + "</attribute>");
                            this.m_result = this.m_result.concat("<operation>AS.Op.isLessEqual</operation>");
                            this.m_result = this.m_result.concat("<value>" + value + "</value>");
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 3: {
                            if (value.equals("*")) {
                                this.m_result = this.m_result.concat("<attribute>" + ndsAttr + "</attribute>");
                                this.m_result = this.m_result.concat("<operation>AS.Op.isPresent</operation>");
                                this.m_result = this.m_result.concat("<value></value>");
                                break;
                            }
                            if (value.equals("!*")) {
                                this.m_result = this.m_result.concat("<attribute>" + ndsAttr + "</attribute>");
                                this.m_result = this.m_result.concat("<operation>AS.Op.isNotPresent</operation>");
                                this.m_result = this.m_result.concat("<value></value>");
                                break;
                            }
                            this.m_result = this.m_result.concat("<attribute>" + ndsAttr + "</attribute>");
                            if (strOp.equals("not")) {
                                this.m_result = this.m_result.concat("<operation>AS.Op.isNotEqual</operation>");
                                strOp = "and";
                            } else {
                                this.m_result = this.m_result.concat("<operation>AS.Op.isEqual</operation>");
                            }
                            this.m_result = this.m_result.concat("<value>" + value + "</value>");
                            break;
                        }
                    }
                    this.m_result = this.m_result.concat("<row-op>" + strOp + "</row-op>");
                    this.m_result = this.m_result.concat("</row>");
                }
            }
        }

        private void parseFilterList(String strOp, MappingObject mapper, MContext context) throws PluginException {
            this.m_result = this.m_result.concat("<group>");
            this.parseFilter(strOp, mapper, context);
            while (this.ft.peekChar(context) == '(') {
                this.parseFilter(strOp, mapper, context);
            }
            this.m_result = this.m_result.concat("<group-op>" + strOp + "</group-op>");
            this.m_result = this.m_result.concat("</group>");
        }
    }
}

