/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.Syntax;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class AttributeDefinition
implements Serializable {
    protected String name;
    protected Syntax syntax;
    protected boolean sized;
    protected long lowerBound;
    protected long upperBound;
    protected ArrayList aliasNames;

    public AttributeDefinition(String attrName, Syntax syntax) {
        this(attrName, syntax, false, 0L, 0L, null);
    }

    public AttributeDefinition(String attrName, Syntax syntax, long lowerBound, long upperBound) {
        this(attrName, syntax, true, lowerBound, upperBound, null);
    }

    public AttributeDefinition(String attrName, Syntax syntax, boolean sized, long lowerBound, long upperBound, String[] aliasArray) {
        this.name = attrName;
        this.syntax = syntax;
        this.sized = sized;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.aliasNames = new ArrayList(3);
        if (aliasArray != null) {
            for (int i = 0; i < aliasArray.length; ++i) {
                if (aliasArray[i].equalsIgnoreCase(this.name)) continue;
                this.aliasNames.add(aliasArray[i]);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliasNames() {
        return this.aliasNames.toArray(new String[0]);
    }

    public String toString() {
        return this.name;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public boolean isSized() {
        return this.sized;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public abstract ObjectAttribute createAttribute();

    public boolean equals(Object obj) {
        boolean retVal = false;
        if (obj == this) {
            retVal = true;
        } else if (obj instanceof AttributeDefinition) {
            AttributeDefinition other = (AttributeDefinition)obj;
            if (this.syntax == other.syntax && this.name.equals(other.name) && this.sized == other.sized) {
                if (this.sized) {
                    if (this.lowerBound == other.lowerBound && this.upperBound == other.upperBound) {
                        retVal = true;
                    }
                } else {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    public abstract boolean isHidden();

    public abstract boolean isReadOnly();

    public abstract boolean isSingleValued();

    public boolean isAberrant() {
        return false;
    }

    public boolean isOperational() {
        return false;
    }
}

