/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.SchemaDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class ClassDefinition
implements Serializable {
    protected String className;
    protected ArrayList aliasNames;
    protected HashMap mandatoryAttributeTable;
    protected HashMap optionalAttributeTable;
    protected HashMap namingAttributeTable = null;
    protected ArrayList classContainmentNameList = null;
    protected ArrayList superClassNameList = null;
    protected ArrayList validAuxClassesList = null;
    protected boolean container = true;
    protected boolean effective = true;
    protected boolean nonRemove = false;
    protected boolean auxiliary = false;
    protected boolean expanded = false;
    protected SchemaDefinition schemaDef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDefinition(String name, String[] aliasArray, String[] classContainmentNames, String[] superClassNames, AttributeDefinition[] mandatoryAttributes, AttributeDefinition[] namingAttributes, AttributeDefinition[] optionalAttributes, boolean container, boolean effective, boolean nonRemove, boolean auxiliary, SchemaDefinition schemaDef) {
        AttributeDefinition attrDef;
        int i;
        int i2;
        this.className = name;
        this.aliasNames = new ArrayList(3);
        if (aliasArray != null) {
            for (i2 = 0; i2 < aliasArray.length; ++i2) {
                if (aliasArray[i2].equalsIgnoreCase(name)) continue;
                this.aliasNames.add(aliasArray[i2]);
            }
        }
        if (classContainmentNames != null) {
            this.classContainmentNameList = new ArrayList(classContainmentNames.length);
            for (i2 = 0; i2 < classContainmentNames.length; ++i2) {
                this.classContainmentNameList.add(classContainmentNames[i2]);
            }
        } else {
            this.classContainmentNameList = new ArrayList(4);
        }
        if (superClassNames != null) {
            this.superClassNameList = new ArrayList(superClassNames.length);
            for (i2 = 0; i2 < superClassNames.length; ++i2) {
                this.superClassNameList.add(superClassNames[i2]);
            }
        } else {
            this.superClassNameList = new ArrayList(3);
        }
        if (mandatoryAttributes != null) {
            AttributeDefinition[] i3 = mandatoryAttributes;
            synchronized (mandatoryAttributes) {
                this.mandatoryAttributeTable = new HashMap(2 * mandatoryAttributes.length);
                for (i = 0; i < mandatoryAttributes.length; ++i) {
                    attrDef = mandatoryAttributes[i];
                    this.mandatoryAttributeTable.put(attrDef.getName().toLowerCase(), attrDef);
                }
                // ** MonitorExit[i] (shouldn't be in output)
            }
        } else {
            this.mandatoryAttributeTable = new HashMap(1);
        }
        {
            if (optionalAttributes != null) {
                AttributeDefinition[] i3 = optionalAttributes;
                synchronized (optionalAttributes) {
                    this.optionalAttributeTable = new HashMap(2 * optionalAttributes.length);
                    for (i = 0; i < optionalAttributes.length; ++i) {
                        attrDef = optionalAttributes[i];
                        this.optionalAttributeTable.put(attrDef.getName().toLowerCase(), attrDef);
                    }
                    // ** MonitorExit[i] (shouldn't be in output)
                }
            } else {
                this.optionalAttributeTable = new HashMap(1);
            }
            {
                if (namingAttributes == null) {
                    this.namingAttributeTable = new HashMap(1);
                } else {
                    this.namingAttributeTable = new HashMap(2 * namingAttributes.length);
                    for (i2 = 0; i2 < namingAttributes.length; ++i2) {
                        AttributeDefinition attrDef2 = namingAttributes[i2];
                        this.namingAttributeTable.put(attrDef2.getName().toLowerCase(), attrDef2);
                    }
                }
                this.container = container;
                this.effective = effective;
                this.nonRemove = nonRemove;
                this.auxiliary = auxiliary;
                this.schemaDef = schemaDef;
                return;
            }
        }
    }

    public ClassDefinition(String name, String[] classContainmentNames, AttributeDefinition[] mandatoryAttributes, AttributeDefinition[] namingAttributes, AttributeDefinition[] optionalAttributes, boolean container, boolean effective, boolean nonRemove, boolean auxiliary) {
        this(name, null, classContainmentNames, null, mandatoryAttributes, namingAttributes, optionalAttributes, container, effective, nonRemove, auxiliary, null);
    }

    public ClassDefinition(String name, String[] classContainmentNames, AttributeDefinition[] mandatoryAttributes, AttributeDefinition[] namingAttributes, AttributeDefinition[] optionalAttributes) {
        this(name, null, classContainmentNames, null, mandatoryAttributes, namingAttributes, optionalAttributes, false, true, false, false, null);
    }

    public String getName() {
        return this.className;
    }

    public String[] getAliasNames() {
        return this.aliasNames.toArray(new String[0]);
    }

    public AttributeDefinition[] getMandatoryAttributes() {
        AttributeDefinition[] attrDefs = this.mandatoryAttributeTable.values().toArray(new AttributeDefinition[0]);
        return attrDefs;
    }

    public AttributeDefinition[] getOptionalAttributes() {
        AttributeDefinition[] attrDefs = this.optionalAttributeTable.values().toArray(new AttributeDefinition[0]);
        return attrDefs;
    }

    public AttributeDefinition[] getNamingAttributes() {
        AttributeDefinition[] attrDefs = this.namingAttributeTable != null ? this.namingAttributeTable.values().toArray(new AttributeDefinition[0]) : new AttributeDefinition[]{};
        return attrDefs;
    }

    public void addNamingAttribute(AttributeDefinition attrDef) {
        if (attrDef == null) {
            return;
        }
        if (this.namingAttributeTable == null) {
            this.namingAttributeTable = new HashMap();
        }
        this.namingAttributeTable.put(attrDef.getName(), attrDef);
    }

    public String[] getContainmentClasses() {
        if (this.classContainmentNameList != null) {
            return this.classContainmentNameList.toArray(new String[0]);
        }
        return new String[0];
    }

    public void addContainmentClass(String className) {
        if (className == null) {
            return;
        }
        if (this.classContainmentNameList == null) {
            this.classContainmentNameList = new ArrayList();
        }
        if (!this.classContainmentNameList.contains(className)) {
            this.classContainmentNameList.add(className);
        }
    }

    public String[] getSuperClasses() {
        return this.superClassNameList.toArray(new String[0]);
    }

    public void initAuxClasses() {
        this.validAuxClassesList = new ArrayList();
    }

    public String[] getValidAuxClasses() {
        if (this.validAuxClassesList == null) {
            return null;
        }
        return this.validAuxClassesList.toArray(new String[0]);
    }

    public void addValidAuxClasses(String[] auxClasses) {
        if (auxClasses != null) {
            for (int i = 0; i < auxClasses.length; ++i) {
                if (this.validAuxClassesList == null) {
                    this.validAuxClassesList = new ArrayList();
                }
                this.validAuxClassesList.add(auxClasses[i]);
            }
        }
    }

    public boolean isAttributeMandatory(String attrName) {
        if (this.schemaDef != null) {
            attrName = this.schemaDef.translateAliasAttributeName(attrName);
        }
        return this.mandatoryAttributeTable.containsKey(attrName.toLowerCase());
    }

    public boolean isAttributeOptional(String attrName) {
        if (this.schemaDef != null) {
            attrName = this.schemaDef.translateAliasAttributeName(attrName);
        }
        return this.optionalAttributeTable.containsKey(attrName.toLowerCase());
    }

    public boolean isClassUsingAttribute(String attrName) {
        if (this.schemaDef != null) {
            attrName = this.schemaDef.translateAliasAttributeName(attrName);
        }
        return this.optionalAttributeTable.containsKey(attrName.toLowerCase()) || this.mandatoryAttributeTable.containsKey(attrName.toLowerCase());
    }

    public boolean isNamedBy(String attrName) {
        if (this.schemaDef != null) {
            attrName = this.schemaDef.translateAliasAttributeName(attrName);
        }
        return this.namingAttributeTable.containsKey(attrName.toLowerCase());
    }

    public boolean isInheritedFrom(String className) {
        if (this.schemaDef != null) {
            className = this.schemaDef.translateAliasClassName(className);
        }
        String classLower = className.toLowerCase();
        Iterator iter = this.superClassNameList.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).toLowerCase().equals(classLower)) continue;
            return true;
        }
        return false;
    }

    public boolean canBeContainedBy(String parentClass) {
        if (this.classContainmentNameList.size() == 0) {
            return true;
        }
        if (this.schemaDef != null) {
            parentClass = this.schemaDef.translateAliasClassName(parentClass);
        }
        String parentClassLower = parentClass.toLowerCase();
        Iterator iter = this.classContainmentNameList.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).toLowerCase().equals(parentClassLower)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainer() {
        return this.container;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public boolean isNonRemovable() {
        return this.nonRemove;
    }

    public boolean isNonRemoveable() {
        return this.nonRemove;
    }

    public boolean isAuxiliary() {
        return this.auxiliary;
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public String toString() {
        return this.className;
    }
}

