/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.Value;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public final class DateValue
extends Value {
    private long time;

    public DateValue(Syntax syntax, Date date) {
        super(syntax);
        this.time = date.getTime();
    }

    public DateValue(Syntax syntax, long millis) {
        super(syntax);
        this.time = millis;
    }

    public DateValue(Syntax syntax, String genTime) {
        super(syntax);
        this.time = DateValue.generalizedTimeToMs(genTime);
    }

    public Date getValue() {
        return new Date(this.time);
    }

    public Object getObjectValue() {
        return new Date(this.time);
    }

    public long getMillis() {
        return this.time;
    }

    public String getGeneralizedTime() {
        return DateValue.msToGeneralizedTime(this.time);
    }

    public static String msToGeneralizedTime(long ms) {
        GregorianCalendar cal = new GregorianCalendar(new SimpleTimeZone(0, "GMT"));
        cal.setTimeInMillis(ms);
        int yr = cal.get(1);
        int mon = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        StringBuffer s = new StringBuffer();
        if (yr < 1000) {
            s.append("0");
        }
        if (yr < 100) {
            s.append("0");
        }
        if (yr < 10) {
            s.append("0");
        }
        s.append(yr);
        if (mon < 10) {
            s.append("0");
        }
        s.append(mon);
        if (day < 10) {
            s.append("0");
        }
        s.append(day);
        if (hour < 10) {
            s.append("0");
        }
        s.append(hour);
        if (min < 10) {
            s.append("0");
        }
        s.append(min);
        if (sec < 10) {
            s.append("0");
        }
        s.append(sec);
        s.append("Z");
        return s.toString();
    }

    public static long generalizedTimeToMs(String gen) {
        if (gen.length() != 15) {
            return 0L;
        }
        GregorianCalendar cal = new GregorianCalendar(Integer.parseInt(gen.substring(0, 4)), Integer.parseInt(gen.substring(4, 6)) - 1, Integer.parseInt(gen.substring(6, 8)), Integer.parseInt(gen.substring(8, 10)), Integer.parseInt(gen.substring(10, 12)), Integer.parseInt(gen.substring(12, 14)));
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        return cal.getTimeInMillis();
    }
}

