/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.ObjectEntry;
import java.util.Enumeration;
import java.util.Hashtable;

public final class NSObjectCache {
    private Hashtable nsObjectLookupTable = new Hashtable(10, 10.0f);

    public synchronized void setDetails(Object key, NSObject obj) {
        if (this.nsObjectLookupTable.containsKey(key)) {
            Hashtable nsObjectTable = (Hashtable)this.nsObjectLookupTable.get(key);
            if (!nsObjectTable.containsKey(obj.getObjectEntry().getFullName())) {
                nsObjectTable.put(obj.getObjectEntry().getFullName(), obj);
            }
        } else {
            this.nsObjectLookupTable.put(key, new Hashtable());
            this.setDetails(key, obj);
        }
    }

    public NSObject getDetails(Object key, ObjectEntry obj) {
        return this.getCacheNSObject(key, obj);
    }

    public synchronized void freeDetails(Object key) {
        this.nsObjectLookupTable.remove(key);
    }

    public synchronized void freeDetails(Object key, ObjectEntry obj) {
        if (this.nsObjectLookupTable.containsKey(key)) {
            Hashtable nsObjectTable = (Hashtable)this.nsObjectLookupTable.get(key);
            nsObjectTable.remove(obj.getFullName());
        }
    }

    private NSObject getCacheNSObject(Object key, ObjectEntry obj) {
        NSObject nsObject = null;
        Enumeration tableEnum = this.nsObjectLookupTable.elements();
        while (tableEnum.hasMoreElements()) {
            Hashtable nsObjectTable = (Hashtable)tableEnum.nextElement();
            if (!nsObjectTable.containsKey(obj.getFullName())) continue;
            nsObject = (NSObject)nsObjectTable.get(obj.getFullName());
            if (this.nsObjectLookupTable.containsKey(key)) break;
            this.setDetails(key, nsObject);
            break;
        }
        return nsObject;
    }
}

