/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListPropertyChangeEvent;
import com.novell.application.console.snapin.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ObjectAttribute
implements Cloneable,
PropertyChangeListener,
Serializable {
    protected AttributeDefinition attrDefinition;
    private Vector propertyListeners = new Vector(10);
    protected Vector values = new Vector();
    private Vector beginningValues = new Vector();
    protected Vector addedValues = new Vector();
    protected Vector deletedValues = new Vector();
    protected Vector modifiedValues = new Vector();
    private static final int MAX_TOSTRING_LENGTH = 256;
    private static final int CLONE = 1;

    public ObjectAttribute(AttributeDefinition attrDef) {
        this.attrDefinition = attrDef;
        this.beginningValues = new Vector();
    }

    public ObjectAttribute(AttributeDefinition attrDef, ValueComponent comp) throws NamespaceException {
        this.attrDefinition = attrDef;
        if (comp.getSyntax() != attrDef.getSyntax()) {
            throw NamespaceException.WRONG_SYNTAX;
        }
        if (attrDef.isSized() && !comp.isWithinBounds(attrDef.getLowerBound(), attrDef.getUpperBound())) {
            throw NamespaceException.VALUE_NOT_WITHIN_BOUNDS;
        }
        this.initValues(comp);
        this.resetBeginningAttributeValues();
    }

    public ObjectAttribute(AttributeDefinition attrDef, ValueComponent[] comps) throws NamespaceException {
        this.attrDefinition = attrDef;
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i].getSyntax() != attrDef.getSyntax()) {
                throw NamespaceException.WRONG_SYNTAX;
            }
            if (!this.values.isEmpty() && attrDef.isSingleValued()) {
                Debug.out(NamespaceException.SINGLE_VALUED_ATTRIBUTE.toString() + ": " + this.attrDefinition.getName(), 1);
                throw NamespaceException.SINGLE_VALUED_ATTRIBUTE;
            }
            if (attrDef.isSized() && !comps[i].isWithinBounds(attrDef.getLowerBound(), attrDef.getUpperBound())) {
                throw NamespaceException.VALUE_NOT_WITHIN_BOUNDS;
            }
            this.initValues(comps[i]);
        }
        this.resetBeginningAttributeValues();
    }

    public final void clearAddedAttributeValues() {
        this.addedValues.removeAllElements();
    }

    public final void clearDeletedAttributeValues() {
        this.deletedValues.removeAllElements();
    }

    public final void clearModifiedAttributeValues() {
        this.modifiedValues.removeAllElements();
    }

    public final void resetBeginningAttributeValues() {
        Enumeration myenum = this.values.elements();
        this.beginningValues = new Vector(this.values.size());
        while (myenum.hasMoreElements()) {
            Object item = myenum.nextElement();
            if (item instanceof ValueList) {
                this.beginningValues.addElement(((ValueList)item).clone());
                continue;
            }
            this.beginningValues.addElement(item);
        }
    }

    public final void resetBeginingAttributeValues() {
        this.resetBeginningAttributeValues();
    }

    public synchronized boolean contains(ValueComponent comp) {
        return this.contains(this.values, comp);
    }

    public final AttributeDefinition getAttributeDefinition() {
        return this.attrDefinition;
    }

    public synchronized void addComponent(ValueComponent comp) throws NamespaceException {
        if (this.attrDefinition.isReadOnly()) {
            throw NamespaceException.READONLY_ATTRIBUTE;
        }
        if (comp.getSyntax() != this.attrDefinition.getSyntax()) {
            throw NamespaceException.WRONG_SYNTAX;
        }
        if (!this.values.isEmpty() && this.attrDefinition.isSingleValued()) {
            Debug.out(NamespaceException.SINGLE_VALUED_ATTRIBUTE.toString() + ": " + this.attrDefinition.getName(), 1);
            throw NamespaceException.SINGLE_VALUED_ATTRIBUTE;
        }
        if (this.attrDefinition.isSized() && !comp.isWithinBounds(this.attrDefinition.getLowerBound(), this.attrDefinition.getUpperBound())) {
            throw NamespaceException.VALUE_NOT_WITHIN_BOUNDS;
        }
        this.doAdd(comp);
    }

    public synchronized void addComponents(ValueComponent[] comp) throws NamespaceException {
        for (int i = 0; i < comp.length; ++i) {
            this.addComponent(comp[i]);
        }
    }

    public synchronized void replaceComponent(ValueComponent oldComp, ValueComponent newComp) throws NamespaceException {
        if (this.attrDefinition.isReadOnly()) {
            throw NamespaceException.READONLY_ATTRIBUTE;
        }
        if (newComp.getSyntax() != this.attrDefinition.getSyntax()) {
            throw NamespaceException.WRONG_SYNTAX;
        }
        if (this.attrDefinition.isSized() && !newComp.isWithinBounds(this.attrDefinition.getLowerBound(), this.attrDefinition.getUpperBound())) {
            throw NamespaceException.VALUE_NOT_WITHIN_BOUNDS;
        }
        this.doReplace(oldComp, newComp);
    }

    public synchronized void replaceComponent(ValueComponent newComp) throws NamespaceException {
        this.removeAllComponents();
        this.addComponent(newComp);
    }

    public synchronized void replaceComponents(ValueComponent[] newComps) throws NamespaceException {
        this.removeAllComponents();
        this.addComponents(newComps);
    }

    public final ValueComponent[] getAddedComponents() {
        Object[] comps = new ValueComponent[this.addedValues.size()];
        this.addedValues.copyInto(comps);
        return comps;
    }

    public final ValueComponent[] getBeginningComponents() {
        Object[] comps = new ValueComponent[this.beginningValues.size()];
        this.beginningValues.copyInto(comps);
        return comps;
    }

    public final ValueComponent[] getBeginingComponents() {
        return this.getBeginningComponents();
    }

    public final ValueComponent[] getDeletedComponents() {
        Object[] comps = new ValueComponent[this.deletedValues.size()];
        this.deletedValues.copyInto(comps);
        return comps;
    }

    public final ModifyValue[] getModifiedComponents() {
        Object[] comps = new ModifyValue[this.modifiedValues.size()];
        this.modifiedValues.copyInto(comps);
        return comps;
    }

    public Enumeration getValueComponents() {
        return this.values.elements();
    }

    public Object[] getValueComponentsAsArray() {
        return this.values.toArray();
    }

    public int getComponentCount() {
        return this.values.size();
    }

    public synchronized String toString() {
        StringBuffer sbuf = new StringBuffer();
        Enumeration e = this.values.elements();
        while (e.hasMoreElements()) {
            sbuf.append(e.nextElement().toString());
            if (sbuf.length() < 256) continue;
        }
        return new String(sbuf);
    }

    public synchronized void removeAllComponents() {
        if (!this.attrDefinition.isReadOnly()) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, null, null, null);
            for (int i = this.values.size() - 1; i >= 0; --i) {
                ValueComponent comp = (ValueComponent)this.values.elementAt(i);
                if (comp instanceof ValueList) {
                    ((ValueList)comp).removePropertyChangeListener(this);
                }
                this.values.removeElementAt(i);
            }
            this.addedValues.removeAllElements();
            this.modifiedValues.removeAllElements();
            this.deletedValues = (Vector)this.beginningValues.clone();
            this.notifyPropertyChangeListeners(event);
        }
    }

    public synchronized boolean removeComponent(ValueComponent comp) {
        int index = this.values.indexOf(comp);
        if (index >= 0 && !this.attrDefinition.isReadOnly()) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, null, comp, null);
            this.values.removeElementAt(index);
            if (this.contains(this.beginningValues, comp)) {
                this.deletedValues.addElement(comp);
            } else if (!this.addedValues.removeElement(comp)) {
                this.removeModifyRequest(comp);
            }
            if (comp instanceof ValueList) {
                ((ValueList)comp).removePropertyChangeListener(this);
            }
            this.notifyPropertyChangeListeners(event);
            return true;
        }
        return false;
    }

    public final String getName() {
        return this.attrDefinition.getName();
    }

    public synchronized Object clone() {
        try {
            ObjectAttribute newAttr = (ObjectAttribute)super.clone();
            newAttr.values = (Vector)this.values.clone();
            newAttr.propertyListeners = new Vector();
            this.beginningValues = (Vector)this.beginningValues.clone();
            this.addedValues = (Vector)this.addedValues.clone();
            this.deletedValues = (Vector)this.deletedValues.clone();
            this.modifiedValues = (Vector)this.modifiedValues.clone();
            return newAttr;
        }
        catch (CloneNotSupportedException e) {
            throw new AdminError(1, this.getClass());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event instanceof ValueListPropertyChangeEvent) {
            PropertyChangeEvent changeEvent = new PropertyChangeEvent(this, null, event.getOldValue(), event.getNewValue());
            ValueList rootComp = ((ValueListPropertyChangeEvent)event).getRootValueList();
            ValueList clonedComp = rootComp.getRootListClone();
            boolean clonedIsOriginal = this.contains(this.beginningValues, clonedComp);
            if (clonedIsOriginal && !this.isModifyRequest(clonedComp)) {
                this.modifiedValues.addElement(new ModifyValue(clonedComp, rootComp));
            }
            this.notifyPropertyChangeListeners(changeEvent);
        }
    }

    protected void notifyPropertyChangeListeners(PropertyChangeEvent event) {
        Vector listeners = (Vector)this.propertyListeners.clone();
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            PropertyChangeListener pl = (PropertyChangeListener)e.nextElement();
            pl.propertyChange(event);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyListeners.contains(listener)) {
            this.propertyListeners.addElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.removeElement(listener);
    }

    private boolean contains(Vector vectorToInquire, ValueComponent value) {
        for (int i = 0; i < vectorToInquire.size(); ++i) {
            if (!value.equals(vectorToInquire.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    private void doAdd(ValueComponent comp) {
        if (!this.contains(this.values, comp)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, null, null, comp);
            this.values.addElement(comp);
            if (!this.contains(this.beginningValues, comp)) {
                this.addedValues.addElement(comp);
                if (comp instanceof ValueList) {
                    ((ValueList)comp).setListAsRoot();
                }
            }
            this.deletedValues.removeElement(comp);
            this.notifyPropertyChangeListeners(event);
            if (comp instanceof ValueList) {
                ((ValueList)comp).addPropertyChangeListener(this);
            }
        }
    }

    private void doReplace(ValueComponent oldComp, ValueComponent newComp) throws NamespaceException {
        int index = this.values.indexOf(oldComp);
        if (index < 0) {
            throw NamespaceException.VALUE_NOT_FOUND;
        }
        if (this.contains(this.values, newComp)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, null, oldComp, newComp);
        this.values.setElementAt(newComp, index);
        boolean oldIsOriginal = this.contains(this.beginningValues, oldComp);
        boolean newIsOriginal = this.contains(this.beginningValues, newComp);
        if (oldIsOriginal && !newIsOriginal) {
            this.modifiedValues.addElement(new ModifyValue(oldComp, newComp));
            if (newComp instanceof ValueList) {
                ((ValueList)newComp).setListAsRoot();
            }
        } else if (!oldIsOriginal && !newIsOriginal) {
            int oldIndex = this.addedValues.indexOf(oldComp);
            if (oldIndex > -1) {
                this.addedValues.setElementAt(newComp, oldIndex);
            } else {
                this.changeModifyRequest(oldComp, newComp);
            }
            if (newComp instanceof ValueList) {
                ((ValueList)newComp).setListAsRoot();
            }
        } else if (!oldIsOriginal && newIsOriginal) {
            int oldIndex = this.addedValues.indexOf(oldComp);
            if (oldIndex > -1) {
                this.addedValues.removeElement(oldComp);
            } else {
                oldComp = this.removeModifyRequest(oldComp);
                this.deletedValues.addElement(oldComp);
            }
            this.deletedValues.removeElement(newComp);
        } else {
            this.deletedValues.removeElement(newComp);
            this.deletedValues.addElement(oldComp);
        }
        if (oldComp instanceof ValueList) {
            ((ValueList)oldComp).removePropertyChangeListener(this);
            ((ValueList)newComp).addPropertyChangeListener(this);
        }
        this.notifyPropertyChangeListeners(event);
    }

    private void changeModifyRequest(ValueComponent oldComp, ValueComponent newComp) {
        Enumeration myenum = this.modifiedValues.elements();
        while (myenum.hasMoreElements()) {
            ModifyValue modVal = (ModifyValue)myenum.nextElement();
            if (!modVal.getNewValue().equals(oldComp)) continue;
            modVal.setNewComp(newComp);
            return;
        }
    }

    private ValueComponent removeModifyRequest(ValueComponent oldComp) {
        Enumeration myenum = this.modifiedValues.elements();
        ValueComponent original = null;
        while (myenum.hasMoreElements()) {
            ModifyValue modVal = (ModifyValue)myenum.nextElement();
            if (!modVal.getNewValue().equals(oldComp)) continue;
            original = modVal.getOldValue();
            this.modifiedValues.removeElement(modVal);
            break;
        }
        return original;
    }

    private boolean isModifyRequest(ValueComponent originalComp) {
        Enumeration myenum = this.modifiedValues.elements();
        while (myenum.hasMoreElements()) {
            ModifyValue modVal = (ModifyValue)myenum.nextElement();
            if (!modVal.getOriginalComp().equals(originalComp)) continue;
            return true;
        }
        return false;
    }

    private void initValues(ValueComponent comp) {
        this.values.addElement(comp);
        if (comp instanceof ValueList) {
            ((ValueList)comp).addPropertyChangeListener(this);
            ((ValueList)comp).setListAsRoot();
        }
    }

    public class ModifyValue {
        private ValueComponent originalComp;
        private ValueComponent newComp;

        ModifyValue(ValueComponent original, ValueComponent newComp) {
            this.originalComp = original;
            this.newComp = newComp;
        }

        public ValueComponent getOriginalComp() {
            return this.originalComp;
        }

        public ValueComponent getOldValue() {
            return this.originalComp;
        }

        public void setNewComp(ValueComponent newComp) {
            this.newComp = newComp;
        }

        public ValueComponent getNewValue() {
            return this.newComp;
        }

        public ValueComponent getNewComp() {
            return this.newComp;
        }
    }
}

