/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import java.util.HashMap;
import java.util.LinkedHashSet;

public class SchemaUtil {
    private static HashMap ndapToLdapClassMap = new HashMap();
    private static HashMap ndapToLdapAttrMap = new HashMap();

    public static String translateNDAPClass(ObjectEntry oe, String ndapClass) {
        AdminNamespace ns2 = oe.getAdminNamespace();
        if (ns2.getUniqueID().equals("NDS")) {
            return ndapClass;
        }
        if (ndapClass == null) {
            return ndapClass;
        }
        SchemaDefinition schemaDef = null;
        try {
            schemaDef = ns2.getSchemaDefinition(oe);
            try {
                return schemaDef.getClassDefinition(ndapClass).getName();
            }
            catch (NamespaceException nse) {
            }
        }
        catch (SPIException e) {
            // empty catch block
        }
        String newClass = (String)ndapToLdapClassMap.get(ndapClass.toLowerCase());
        if (newClass != null) {
            return newClass;
        }
        newClass = SchemaUtil.removeColonsAndSpaces(ndapClass);
        if (ndapClass.length() != newClass.length() && schemaDef != null) {
            try {
                newClass = schemaDef.getClassDefinition(newClass).getName();
                ndapToLdapClassMap.put(ndapClass.toLowerCase(), newClass);
            }
            catch (NamespaceException nse) {
                // empty catch block
            }
        }
        return newClass;
    }

    public static String translateNDAPAttr(ObjectEntry oe, String ndapAttr) {
        AdminNamespace ns2 = oe.getAdminNamespace();
        if (ns2.getUniqueID().equals("NDS")) {
            return ndapAttr;
        }
        if (ndapAttr == null) {
            return ndapAttr;
        }
        SchemaDefinition schemaDef = null;
        try {
            schemaDef = ns2.getSchemaDefinition(oe);
            try {
                return schemaDef.getAttributeDefinition(ndapAttr).getName();
            }
            catch (NamespaceException nse) {
            }
        }
        catch (SPIException e) {
            // empty catch block
        }
        String newAttr = (String)ndapToLdapAttrMap.get(ndapAttr.toLowerCase());
        if (newAttr != null) {
            return newAttr;
        }
        newAttr = SchemaUtil.removeColonsAndSpaces(ndapAttr);
        if (ndapAttr.length() != newAttr.length() && schemaDef != null) {
            try {
                newAttr = schemaDef.getAttributeDefinition(newAttr).getName();
                ndapToLdapAttrMap.put(ndapAttr.toLowerCase(), newAttr);
            }
            catch (NamespaceException nse) {
                // empty catch block
            }
        }
        return newAttr;
    }

    private static String removeColonsAndSpaces(String name) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ':' || c == ' ') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static void putThisClassAndSubClassesIntoSet(String className, LinkedHashSet classSet, SchemaDefinition classSchemaDef) {
        ClassDefinition[] subClassDefs;
        classSet.add(className);
        if (!className.equalsIgnoreCase("Top") && (subClassDefs = classSchemaDef.getSubClasses(className)) != null && subClassDefs.length > 0) {
            for (int ii = 0; ii < subClassDefs.length; ++ii) {
                SchemaUtil.putThisClassAndSubClassesIntoSet(subClassDefs[ii].getName(), classSet, classSchemaDef);
            }
        }
    }

    public static int FindUnescapedChar(char target, String str) {
        if (str == null) {
            return -1;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                ++i;
                continue;
            }
            if (ch != target) continue;
            return i;
        }
        return -1;
    }

    static {
        ndapToLdapClassMap.put("Application (DOS)".toLowerCase(), "applicationDOS");
        ndapToLdapClassMap.put("certificationAuthorityVer2".toLowerCase(), "certificationAuthority-V2");
        ndapToLdapClassMap.put("IPXGW:IPX/IP Gateway Server".toLowerCase(), "iPXGWIPXIPGatewayServer");
        ndapToLdapClassMap.put("3x Client Config Policy".toLowerCase(), "xClientConfigPolicy");
        ndapToLdapClassMap.put("3x Computer System Policy".toLowerCase(), "xComputerSystemPolicy");
        ndapToLdapClassMap.put("Application (Windows NT)".toLowerCase(), "applicationWindowsNT");
        ndapToLdapClassMap.put("95 Computer System Policies".toLowerCase(), "computerSystemPolicies");
        ndapToLdapClassMap.put("Group".toLowerCase(), "groupOfNames");
        ndapToLdapClassMap.put("95 User System Policies".toLowerCase(), "userSystemPolicies");
        ndapToLdapClassMap.put("95 Computer Printer".toLowerCase(), "computerPrinter");
        ndapToLdapClassMap.put("Application (Windows 95)".toLowerCase(), "applicationWindows95");
        ndapToLdapClassMap.put("95 Client Config Policy".toLowerCase(), "clientConfigPolicy");
        ndapToLdapClassMap.put("95 Desktop Preferences".toLowerCase(), "desktopPreferences");
        ndapToLdapClassMap.put("95 RAS Config Policy".toLowerCase(), "rASConfigPolicy");
        ndapToLdapClassMap.put("User".toLowerCase(), "inetOrgPerson");
        ndapToLdapAttrMap.put("New Object\u0017s FS Rights".toLowerCase(), "newObjectSFSRights");
        ndapToLdapAttrMap.put("Postal Office Box".toLowerCase(), "postOfficeBox");
        ndapToLdapAttrMap.put("Surname".toLowerCase(), "sn");
        ndapToLdapAttrMap.put("LDAP Attribute Map v11".toLowerCase(), "ldapAttributeMap");
        ndapToLdapAttrMap.put("Cross Certificate Pair".toLowerCase(), "ndsCrossCertificatePair");
        ndapToLdapAttrMap.put("NSCP:memberCertificateDesc".toLowerCase(), "memberCertificateDescription");
        ndapToLdapAttrMap.put("Generational Qualifier".toLowerCase(), "generationQualifier");
        ndapToLdapAttrMap.put("New Object\u0017s DS Rights".toLowerCase(), "newObjectSDSRights");
        ndapToLdapAttrMap.put("SA".toLowerCase(), "street");
        ndapToLdapAttrMap.put("uniqueID".toLowerCase(), "uid");
        ndapToLdapAttrMap.put("NSCP:employeeNumber".toLowerCase(), "employeeNumber");
        ndapToLdapAttrMap.put("IPXGW:IPX/IP Gateway Access".toLowerCase(), "iPXGWIPXIPGatewayAccess");
        ndapToLdapAttrMap.put("LDAP Group".toLowerCase(), "ldapGroupDN");
        ndapToLdapAttrMap.put("New Object\u0017s Self Rights".toLowerCase(), "newObjectSSelfRights");
        ndapToLdapAttrMap.put("S".toLowerCase(), "st");
        ndapToLdapAttrMap.put("LDAP Screen Level".toLowerCase(), "ldapTraceLevel");
        ndapToLdapAttrMap.put("Home Directory".toLowerCase(), "ndsHomeDirectory");
        ndapToLdapAttrMap.put("LDAP Class Map v11".toLowerCase(), "ldapClassMap");
        ndapToLdapAttrMap.put("GID".toLowerCase(), "groupID");
        ndapToLdapAttrMap.put("memberQuery".toLowerCase(), "memberQueryURL");
        ndapToLdapAttrMap.put("LDAP Server".toLowerCase(), "ldapServerDN");
        ndapToLdapAttrMap.put("Internet EMail Address".toLowerCase(), "mail");
        ndapToLdapAttrMap.put("UID".toLowerCase(), "uidNumber");
        ndapToLdapAttrMap.put("Login Disabled".toLowerCase(), "accountDisabled");
        ndapToLdapAttrMap.put("Login Expiration Time".toLowerCase(), "accountDisabledUntil");
        ndapToLdapAttrMap.put("[All Attributes Rights]".toLowerCase(), "[All Attributes Rights]");
        ndapToLdapAttrMap.put("[Entry Rights]".toLowerCase(), "[Entry Rights]");
        ndapToLdapAttrMap.put("BaseClass".toLowerCase(), "objectClass");
    }
}

