/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.NSUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;
import com.novell.admin.ns.ldap.LDAPSyntax;

class BinaryStrategy
implements ValueStrategy {
    private static final int BAD_COMPARE_OBJ = 1;
    private static final int WITHIN_BOUNDS = 2;
    private static final int BAD_TOSTRING_OBJ = 3;

    BinaryStrategy() {
    }

    public boolean canCreateValue(Object obj) {
        return obj instanceof byte[];
    }

    public ValueComponent createValueComponent() {
        return new HexValue(this.getSyntax(), new byte[1]);
    }

    public ValueComponent createValueComponent(Object obj) throws ComponentCreationException {
        if (obj instanceof byte[]) {
            return new HexValue(this.getSyntax(), (byte[])obj);
        }
        throw new ComponentCreationException();
    }

    public boolean equals(ValueComponent obj1, ValueComponent obj2) {
        return this.compare(obj1, obj2) == 0L;
    }

    public long compare(ValueComponent obj1, ValueComponent obj2) {
        byte[] bv2;
        if (!(obj1 instanceof HexValue) || !(obj2 instanceof HexValue)) {
            throw new AdminError(1, this.getClass());
        }
        if (obj1.getSyntax() != obj2.getSyntax()) {
            return obj1.getSyntax().getId() - obj2.getSyntax().getId();
        }
        byte[] bv1 = ((HexValue)obj1).getValue();
        int minLen = bv1.length < (bv2 = ((HexValue)obj2).getValue()).length ? bv1.length : bv2.length;
        for (int i = 0; i < minLen; ++i) {
            if (bv1[i] == bv2[i]) continue;
            return bv1[i] - bv2[i];
        }
        return bv1.length - bv2.length;
    }

    public String toString(ValueComponent obj) {
        if (obj instanceof HexValue) {
            byte[] value = ((HexValue)obj).getValue();
            return NSUtil.toHexString(value);
        }
        throw new AdminError(3, this.getClass());
    }

    public Syntax getSyntax() {
        return LDAPSyntax.SYN_BINARY;
    }

    public boolean isWithinBounds(ValueComponent comp, long lowerBound, long upperBound) {
        if (comp instanceof HexValue) {
            HexValue val = (HexValue)comp;
            long i = val.getLength();
            return i >= lowerBound && i <= upperBound;
        }
        throw new AdminError(2, this.getClass());
    }
}

