/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import java.util.Vector;

public class ConvertACL {
    public static Vector toNDSACL(Vector vec) throws ComponentCreationException {
        if (vec.size() == 3) {
            return vec;
        }
        if (vec.size() != 7) {
            throw new ComponentCreationException();
        }
        long kPrivs = (Long)vec.get(0);
        long kModifier = (Long)vec.get(1);
        String kEntryID = (String)vec.get(2);
        String kScope = (String)vec.get(4);
        String kAttrID = (String)vec.get(6);
        long nPrivs = 0L;
        String nSubjectName = null;
        String nAttrName = null;
        if ((kModifier & 1L) != 0L) {
            nPrivs = kPrivs & 0x1FL;
            if (kScope.equalsIgnoreCase("baseObject")) {
                nPrivs |= 0x40L;
            }
            if ((kModifier & 2L) != 0L) {
                nPrivs |= 0x20000000L;
            }
            nAttrName = "[Entry Rights]";
        } else {
            nPrivs = kPrivs & 3L;
            if ((kPrivs & 0xCL) != 0L) {
                nPrivs |= 4L;
            }
            if ((kPrivs & 0x20L) != 0L) {
                nPrivs |= 8L;
            }
            if ((kPrivs & 0x10L) != 0L) {
                nPrivs |= 0x20L;
            }
            if (kAttrID.equalsIgnoreCase("any")) {
                nAttrName = "[All Attributes Rights]";
                if (kScope.equalsIgnoreCase("baseObject")) {
                    nPrivs |= 0x40L;
                }
            } else {
                nAttrName = kAttrID;
                if (!kScope.equalsIgnoreCase("baseObject")) {
                    nPrivs |= 0x40L;
                }
            }
            if ((kModifier & 2L) != 0L) {
                nPrivs |= 0x20000000L;
            }
        }
        String kEntryLower = kEntryID.toLowerCase();
        nSubjectName = kEntryLower.startsWith("si=unauthenticated") || kEntryLower.startsWith("si=anonymous") ? "[Public]" : (kEntryLower.startsWith("si=authenticated") ? "[Root]" : (kEntryLower.startsWith("si=creator") ? "[Creator]" : (kEntryLower.startsWith("si=this") ? "[Self]" : kEntryID)));
        Vector<Object> newVec = new Vector<Object>(7);
        newVec.add(nAttrName);
        newVec.add(nSubjectName);
        newVec.add(new Long(nPrivs));
        return newVec;
    }

    public static Vector toNVDSACL(Vector vec) throws ComponentCreationException {
        if (vec.size() == 7) {
            return vec;
        }
        if (vec.size() != 3) {
            throw new ComponentCreationException();
        }
        String nAttrName = (String)vec.get(0);
        String nSubjectName = (String)vec.get(1);
        long nPrivs = (Long)vec.get(2);
        long kPrivs = 0L;
        long kModifier = 0L;
        String kEntryID = "";
        String kFilterID = "";
        String kScope = "";
        String kClassID = "";
        String kAttrID = "";
        if (nAttrName.equalsIgnoreCase("[Entry Rights]")) {
            kModifier = 1L;
            if ((nPrivs & 0x20000000L) != 0L) {
                kModifier |= 2L;
            }
            kScope = (nPrivs & 0x40L) != 0L ? "baseObject" : "wholeSubtree";
            kPrivs = nPrivs & 0x1FL;
        } else {
            if ((nPrivs & 0x20000000L) != 0L) {
                kModifier = 2L;
            }
            if (nAttrName.equalsIgnoreCase("[All Attributes Rights]")) {
                kAttrID = "any";
                kScope = (nPrivs & 0x40L) != 0L ? "baseObject" : "wholeSubtree";
            } else {
                kAttrID = nAttrName;
                kScope = (nPrivs & 0x40L) != 0L ? "wholeSubtree" : "baseObject";
            }
            kPrivs = nPrivs & 7L;
            if ((nPrivs & 4L) != 0L) {
                kPrivs |= 8L;
            }
            if ((nPrivs & 8L) != 0L) {
                kPrivs |= 0x20L;
            }
            if ((nPrivs & 0x20L) != 0L) {
                kPrivs |= 0x10L;
            }
        }
        kEntryID = nSubjectName.equalsIgnoreCase("[Public]") ? "si=unauthenticated,sc=system,sc=local" : (nSubjectName.equalsIgnoreCase("[Root]") ? "si=authenticated,sc=system,sc=local" : (nSubjectName.equalsIgnoreCase("[Creator]") ? "si=creator,sc=system,sc=local" : (nSubjectName.equalsIgnoreCase("[Self]") ? "si=this,sc=system,sc=local" : nSubjectName)));
        Vector<Object> newVec = new Vector<Object>(7);
        newVec.add(new Long(kPrivs));
        newVec.add(new Long(kModifier));
        newVec.add(kEntryID);
        newVec.add(kFilterID);
        newVec.add(kScope);
        newVec.add(kClassID);
        newVec.add(kAttrID);
        return newVec;
    }
}

