/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.Schema;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ldap.LDAPAttributeDefinition;
import com.novell.admin.ns.ldap.LDAPClassDefinition;
import com.novell.admin.ns.ldap.LDAPschema;
import com.novell.admin.ns.ldap.jndi.LDAPSchemaImpl;
import com.novell.application.console.snapin.NamespaceSnapin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public final class LDAPSchemaDefinition
extends SchemaDefinition {
    private Schema schema = null;

    public LDAPSchemaDefinition(LDAPschema schema, NamespaceSnapin ns2) {
        super(ns2);
        this.schema = schema;
    }

    public void putAttributeDefinition(LDAPAttributeDefinition attributeDef) throws SPIException {
        if (this.schema != null) {
            this.schema.writeAttributeDefinition(attributeDef);
        }
        this.addAttributeDefinition(attributeDef);
    }

    public void putClassDefinition(LDAPClassDefinition classDef) throws NamespaceException, SPIException {
        String keyLower = classDef.getName().toLowerCase();
        LDAPClassDefinition oldClass = (LDAPClassDefinition)this.classes.get(keyLower);
        if (this.schema != null) {
            if (oldClass != null) {
                this.schema.modifyClassDefinition(classDef);
            } else {
                this.schema.writeClassDefinition(classDef);
            }
        }
        this.addClassDefinition(classDef);
        this.generateExpandedDefinition(classDef);
    }

    public void removeAttributeDefinition(String attrName) throws NamespaceException, SPIException {
        LDAPAttributeDefinition attrDef = (LDAPAttributeDefinition)this.getAttributeDefinition(attrName);
        if (this.schema != null) {
            this.schema.deleteAttributeDefinition(attrDef);
        }
        this.attributes.remove(attrName.toLowerCase());
        String[] aliases = attrDef.getAliasNames();
        for (int i = 0; i < aliases.length; ++i) {
            this.aliasAttributeNames.remove(aliases[i]);
        }
    }

    public void removeClassDefinition(String className) throws NamespaceException, SPIException {
        LDAPClassDefinition oldClass = (LDAPClassDefinition)this.getRawClassDefinition(className);
        if (this.schema != null) {
            this.schema.deleteClassDefinition(oldClass);
        }
        this.classes.remove(className);
        this.expandedClasses.remove(className);
        String[] aliases = oldClass.getAliasNames();
        for (int i = 0; i < aliases.length; ++i) {
            this.aliasClassNames.remove(aliases[i]);
        }
    }

    public void addAttributeDefinition(AttributeDefinition attrDef) {
        String attrName = attrDef.getName();
        this.attributes.put(attrName.toLowerCase(), attrDef);
        String[] aliasArray = attrDef.getAliasNames();
        for (int i = 0; i < aliasArray.length; ++i) {
            this.aliasAttributeNames.put(aliasArray[i].toLowerCase(), attrName);
        }
    }

    public void addClassDefinition(ClassDefinition classDef) {
        String className = classDef.getName();
        this.classes.put(className.toLowerCase(), classDef);
        String[] aliasArray = classDef.getAliasNames();
        for (int i = 0; i < aliasArray.length; ++i) {
            this.aliasClassNames.put(aliasArray[i].toLowerCase(), className);
        }
    }

    public void generateExpandedDefinitions() throws NamespaceException {
        this.expandedClasses.clear();
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            LDAPClassDefinition classDef = (LDAPClassDefinition)iter.next();
            this.generateExpandedDefinition(classDef);
        }
    }

    public String[] aclScopes() {
        return ((LDAPSchemaImpl)this.schema).getACLScopes();
    }

    public void reconfigureContainerClasses(HashSet hs) {
        if (hs.size() == 0) {
            return;
        }
        Iterator iter = this.classes.keySet().iterator();
        while (iter.hasNext()) {
            try {
                String className = (String)iter.next();
                LDAPClassDefinition cd = (LDAPClassDefinition)this.classes.get(className);
                cd.setContainerFlag(hs.contains(className));
            }
            catch (Exception exception) {}
        }
    }

    void generateExpandedDefinition(LDAPClassDefinition classDef) throws NamespaceException {
        String className = classDef.getName();
        ArrayList allSuperClasses = this.getInheritedSuperClasses(classDef);
        allSuperClasses.add(className);
        AttributeDefinition[] mandatory = this.getInheritedMandatoryAttributes(allSuperClasses);
        AttributeDefinition[] optional = this.getInheritedOptionalAttributes(allSuperClasses);
        allSuperClasses.remove(className);
        String[] containmentClasses = this.getInheritedContainmentClasses(classDef);
        AttributeDefinition[] naming = this.getInheritedNamingAttributes(classDef);
        String[] s = allSuperClasses.toArray(new String[0]);
        LDAPClassDefinition newClassDef = new LDAPClassDefinition(className, classDef.getAliasNames(), classDef.getClassFlags(), containmentClasses, s, mandatory, naming, optional, classDef.getOID(), classDef.getNDAPName(), this);
        String[] validAuxClasses = classDef.getValidAuxClasses();
        newClassDef.addValidAuxClasses(validAuxClasses);
        newClassDef.setExpanded(true);
        this.expandedClasses.put(className.toLowerCase(), newClassDef);
    }

    private ArrayList getInheritedSuperClasses(LDAPClassDefinition classDef) {
        ArrayList classList = new ArrayList(3);
        this.getAllSuperClassesOf(classDef, classList);
        return classList;
    }

    private void getAllSuperClassesOf(LDAPClassDefinition classDef, ArrayList classList) {
        String[] superClassNames = classDef.getSuperClasses();
        for (int i = 0; i < superClassNames.length; ++i) {
            try {
                LDAPClassDefinition superClassDef = (LDAPClassDefinition)this.getRawClassDefinition(superClassNames[i]);
                if (classList.contains(superClassNames[i])) continue;
                classList.add(superClassNames[i]);
                this.getAllSuperClassesOf(superClassDef, classList);
                continue;
            }
            catch (NamespaceException e) {
                // empty catch block
            }
        }
    }

    private AttributeDefinition[] getInheritedMandatoryAttributes(ArrayList allClasses) throws NamespaceException {
        ArrayList<AttributeDefinition> attrs = new ArrayList<AttributeDefinition>();
        Iterator iter = allClasses.iterator();
        while (iter.hasNext()) {
            String superName = (String)iter.next();
            ClassDefinition superDef = this.getRawClassDefinition(superName);
            AttributeDefinition[] attrDefs = superDef.getMandatoryAttributes();
            for (int i = 0; i < attrDefs.length; ++i) {
                attrs.add(attrDefs[i]);
            }
        }
        return attrs.toArray(new AttributeDefinition[0]);
    }

    private AttributeDefinition[] getInheritedOptionalAttributes(ArrayList allClasses) throws NamespaceException {
        ArrayList<AttributeDefinition> attrs = new ArrayList<AttributeDefinition>();
        Iterator iter = allClasses.iterator();
        while (iter.hasNext()) {
            String superName = (String)iter.next();
            ClassDefinition superDef = this.getRawClassDefinition(superName);
            AttributeDefinition[] attrDefs = superDef.getOptionalAttributes();
            for (int i = 0; i < attrDefs.length; ++i) {
                attrs.add(attrDefs[i]);
            }
        }
        return attrs.toArray(new AttributeDefinition[0]);
    }

    private String[] getInheritedContainmentClasses(ClassDefinition classDef) {
        try {
            if (classDef.isAuxiliary()) {
                return new String[0];
            }
            String[] classDefStrings = classDef.getContainmentClasses();
            if (classDefStrings.length != 0) {
                return classDefStrings;
            }
            String[] superNames = classDef.getSuperClasses();
            if (superNames.length == 0) {
                return new String[0];
            }
            for (int i = 0; i < superNames.length; ++i) {
                ClassDefinition superDef = this.getRawClassDefinition(superNames[i]);
                classDefStrings = this.getInheritedContainmentClasses(superDef);
                if (classDefStrings.length == 0) continue;
                return classDefStrings;
            }
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return new String[0];
    }

    private AttributeDefinition[] getInheritedNamingAttributes(ClassDefinition classDef) {
        try {
            AttributeDefinition[] attrDefs = classDef.getNamingAttributes();
            if (attrDefs.length != 0) {
                return attrDefs;
            }
            if (classDef.isAuxiliary()) {
                return new AttributeDefinition[0];
            }
            String[] superNames = classDef.getSuperClasses();
            if (superNames.length == 0) {
                return new AttributeDefinition[0];
            }
            for (int i = 0; i < superNames.length; ++i) {
                ClassDefinition superDef = this.getRawClassDefinition(superNames[i]);
                attrDefs = this.getInheritedNamingAttributes(superDef);
                if (attrDefs.length == 0) continue;
                return attrDefs;
            }
        }
        catch (NamespaceException ex) {
            // empty catch block
        }
        return new AttributeDefinition[0];
    }

    public synchronized Object clone() {
        LDAPSchemaDefinition sd = (LDAPSchemaDefinition)super.clone();
        sd.schema = null;
        return sd;
    }
}

