/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.ConvertACL;
import com.novell.admin.ns.ldap.GSERValue;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.ObjectACLFacade;
import java.util.Vector;

final class NVDSACLStrategy
extends ListStrategy {
    NVDSACLStrategy() {
    }

    public ValueComponent createValueComponent() {
        ValueList list = new ValueList(LDAPSyntax.SYN_NVDS_ACL);
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        list.initList(LDAPSyntax.SYN_DN.createValueComponent());
        list.initList(LDAPSyntax.SYN_DN.createValueComponent());
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent());
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent());
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent());
        return list;
    }

    public ValueComponent createValueComponent(Object paramObj) throws ComponentCreationException {
        String attrID;
        String classID;
        String scope;
        String filterID;
        String entryID;
        Long modifier;
        Long privs;
        if (paramObj instanceof String) {
            GSERValue gval = new GSERValue((String)paramObj);
            privs = new Long((String)gval.get("tag"));
            modifier = new Long((String)gval.get("tag2"));
            entryID = (String)gval.get("dn");
            filterID = (String)gval.get("dn2");
            scope = (String)gval.get("schemaName");
            classID = (String)gval.get("schemaName2");
            attrID = (String)gval.get("schemaName3");
        } else if (paramObj instanceof Vector) {
            Vector vec = null;
            vec = (Vector)paramObj;
            if (vec.size() == 3) {
                vec = ConvertACL.toNVDSACL(vec);
            }
            privs = (Long)vec.get(0);
            modifier = (Long)vec.get(1);
            entryID = (String)vec.get(2);
            filterID = (String)vec.get(3);
            scope = (String)vec.get(4);
            classID = (String)vec.get(5);
            attrID = (String)vec.get(6);
        } else {
            throw new ComponentCreationException();
        }
        if (privs == null) {
            privs = new Long(0L);
        }
        if (modifier == null) {
            modifier = new Long(0L);
        }
        if (entryID == null) {
            entryID = "";
        }
        if (filterID == null) {
            filterID = "";
        }
        if (scope == null) {
            scope = "";
        }
        if (classID == null) {
            classID = "";
        }
        if (attrID == null) {
            attrID = "";
        }
        ValueList list = new ValueList(LDAPSyntax.SYN_NVDS_ACL);
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(privs));
        list.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(modifier));
        list.initList(LDAPSyntax.SYN_DN.createValueComponent(entryID));
        list.initList(LDAPSyntax.SYN_DN.createValueComponent(filterID));
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent(scope));
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent(classID));
        list.initList(LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent(attrID));
        return list;
    }

    public Object createFacade(ValueComponent comp) throws IncompatibleComponentException {
        return new ObjectACLFacade((ValueList)comp);
    }

    public String toString(ValueComponent vc) {
        if (vc instanceof ValueList) {
            ValueList list = (ValueList)vc;
            long privs = ((LongValue)list.getElementAt(0)).getValue();
            long modifier = ((LongValue)list.getElementAt(1)).getValue();
            String entryID = ((StringValue)list.getElementAt(2)).getValue().replaceAll("\"", "\"\"");
            String filterID = ((StringValue)list.getElementAt(3)).getValue().replaceAll("\"", "\"\"");
            String scope = ((StringValue)list.getElementAt(4)).getValue();
            String classID = ((StringValue)list.getElementAt(5)).getValue();
            String attrID = ((StringValue)list.getElementAt(6)).getValue();
            StringBuffer sb = new StringBuffer("{ tag " + privs);
            sb.append(", tag2 " + modifier);
            sb.append(", dn \"" + entryID + "\"");
            if (filterID.length() > 0) {
                sb.append(", dn2 \"" + filterID + "\"");
            }
            if (scope.length() > 0) {
                sb.append(", schemaName \"" + scope + "\"");
            }
            if (classID.length() > 0) {
                sb.append(", schemaName2 \"" + classID + "\"");
            }
            if (attrID.length() > 0) {
                sb.append(", schemaName3 \"" + attrID + "\"");
            }
            sb.append(" }");
            return sb.toString();
        }
        return vc.toString();
    }
}

