/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap.jndi;

import com.novell.admin.ns.ldap.jndi.XMLPayloadResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class XMLPayloadRequest
implements ExtendedRequest {
    public static final String XML_PAYLOAD_OID = "2.16.840.1.113719.1.27.100.96";
    private String servicePath;
    private String xmlRequest;

    public XMLPayloadRequest() {
    }

    public XMLPayloadRequest(String servicePath, String xmlRequest) {
        this.servicePath = servicePath;
        this.xmlRequest = xmlRequest;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        return new XMLPayloadResponse(id, berValue, offset, length);
    }

    public String getID() {
        return XML_PAYLOAD_OID;
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            int tag = 48;
            ber.beginSeq(tag);
            ber.encodeString(this.servicePath, true);
            ber.encodeString(this.xmlRequest, true);
            ber.endSeq();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("XMLPayload Encoding error: " + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public void setXMLRequest(String xmlRequest) {
        this.xmlRequest = xmlRequest;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public String getXMLRequest() {
        return this.xmlRequest;
    }
}

