/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import java.util.Vector;

public final class CaseIgnoreListFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;
    private static final int ADD_STRING_1 = 2;
    private static final int ADD_STRING_2 = 3;
    private static final int REMOVE_STRING = 4;

    public CaseIgnoreListFacade(ValueList comp) throws IncompatibleComponentException {
        super(comp);
        String name = comp.getSyntax().getName();
        if (!name.equals("Case Ignore List")) {
            throw new IncompatibleComponentException();
        }
    }

    public static ValueList createValueList(String[] strings, Syntax syn) {
        try {
            Vector<String> list = new Vector<String>();
            int len = strings.length;
            for (int i = 0; i < len; ++i) {
                list.addElement(strings[i]);
            }
            ValueComponent vc = syn.createValueComponent(list);
            return (ValueList)vc;
        }
        catch (ComponentCreationException e) {
            throw new AdminError(1, "com.novell.admin.ns.nds.CaseIgnoreListFacade");
        }
    }

    public static ValueList createValueList(String[] strings) {
        return CaseIgnoreListFacade.createValueList(strings, NDSSyntax.SYN_CI_LIST);
    }

    public String[] getStrings() {
        int count = this.valueList.getComponentCount();
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            StringValue v = (StringValue)this.valueList.getElementAt(i);
            strings[i] = v.getValue();
        }
        return strings;
    }

    public String getString(int index) throws ArrayIndexOutOfBoundsException {
        StringValue v = (StringValue)this.valueList.getElementAt(index);
        return v.getValue();
    }

    public void addString(String str) {
        try {
            Syntax syn = this.valueList.getElementAt(0).getSyntax();
            ValueComponent vc = syn.createValueComponent(str);
            if (!this.valueList.insertComponent(vc)) {
                throw new AdminError(2, this.getClass());
            }
        }
        catch (ComponentCreationException e) {
            throw new AdminError(3, this.getClass());
        }
    }

    public void removeString(int index) throws ArrayIndexOutOfBoundsException {
        ValueComponent vc = this.valueList.getElementAt(index);
        if (!this.valueList.removeComponent(vc)) {
            throw new AdminError(4, this.getClass());
        }
    }

    public void replaceString(String newStr, int index) throws ArrayIndexOutOfBoundsException {
        this.replaceStringValue(newStr, index);
    }
}

