/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.DefaultClassDefinition;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSClassFlags;

public final class NDSClassDefinition
extends DefaultClassDefinition {
    private NDSClassFlags classFlags = null;
    private byte[] asn1Data;

    public NDSClassDefinition(String name, NDSClassFlags flags, String[] classContainmentNames, String[] superClassNames, AttributeDefinition[] mandatoryAttributes, AttributeDefinition[] namingAttributes, AttributeDefinition[] optionalAttributes, byte[] asn1) {
        super(name, null, classContainmentNames, superClassNames, mandatoryAttributes, namingAttributes, optionalAttributes, flags.isFlagSet(1), flags.isFlagSet(2), flags.isFlagSet(4), flags.isFlagSet(32), null);
        this.classFlags = (NDSClassFlags)flags.clone();
        if (asn1 != null) {
            if (asn1.length != 32) {
                this.asn1Data = new byte[32];
                if (asn1.length > 32) {
                    for (int i = 0; i < 32; ++i) {
                        this.asn1Data[i] = asn1[i];
                    }
                } else {
                    for (int i = 0; i < asn1.length; ++i) {
                        this.asn1Data[i] = asn1[i];
                    }
                    for (int j = 0; j < 32 - asn1.length; ++j) {
                        this.asn1Data[i++] = 0;
                    }
                }
            } else {
                this.asn1Data = asn1;
            }
        } else {
            this.asn1Data = new byte[32];
            for (int i = 0; i < 32; ++i) {
                this.asn1Data[i] = 0;
            }
        }
    }

    public NDSClassFlags getClassFlags() {
        return (NDSClassFlags)this.classFlags.clone();
    }

    public byte[] getASN1Data() {
        byte[] data = new byte[this.asn1Data.length];
        System.arraycopy(this.asn1Data, 0, data, 0, data.length);
        return data;
    }

    public void setASN1Data(byte[] modifiedASN1) {
        this.asn1Data = modifiedASN1;
    }

    public AttributeDefinition[] getMandatoryAttributes() {
        AttributeDefinition[] attrDefs = this.mandatoryAttributeTable.values().toArray(new NDSAttributeDefinition[0]);
        return attrDefs;
    }

    public AttributeDefinition[] getOptionalAttributes() {
        AttributeDefinition[] attrDefs = this.optionalAttributeTable.values().toArray(new NDSAttributeDefinition[0]);
        return attrDefs;
    }

    public AttributeDefinition[] getNamingAttributes() {
        AttributeDefinition[] attrDefs = this.namingAttributeTable.values().toArray(new NDSAttributeDefinition[0]);
        return attrDefs;
    }
}

