/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.util.NarrayList;

public class FloatingCache {
    private NarrayList narrCache = new NarrayList(40);
    private int firstIndex = 0;
    private int lastIndex;
    private int firstPos;
    private int lastPos;
    private int bestSpanSize = 0;
    private int estimatedSize = 0;
    private float scaleFactor;

    public FloatingCache(Object[] stuff, int firstPosition, int lastPosition) {
        this.reset(stuff, firstPosition, lastPosition);
    }

    public void reset(Object[] stuff, int firstPosition, int lastPosition) {
        this.narrCache.clear();
        this.narrCache.ensureCapacity(stuff.length);
        for (int i = 0; i < stuff.length; ++i) {
            this.narrCache.add(stuff[i]);
        }
        this.firstIndex = 0;
        this.lastIndex = stuff.length - 1;
        this.firstPos = firstPosition;
        this.lastPos = lastPosition;
        this.makeGuess(this.lastPos - this.firstPos, stuff.length);
    }

    private void makeGuess(int spanSize, int spanCount) {
        if (spanSize > this.bestSpanSize) {
            this.bestSpanSize = spanSize;
            this.scaleFactor = (float)spanSize / (float)spanCount;
            this.estimatedSize = spanSize > 0 ? (int)(1000.0 / (double)spanSize * (double)spanCount) : -1;
        }
    }

    public int getFirstPosition() {
        return this.firstPos;
    }

    public int getLastPosition() {
        return this.lastPos;
    }

    public void setFirstPosition(int fPos) {
        this.firstPos = fPos;
        this.makeGuess(this.lastPos - this.firstPos, this.narrCache.size());
    }

    public void setLastPosition(int lPos) {
        this.lastPos = lPos;
        this.makeGuess(this.lastPos - this.firstPos, this.narrCache.size());
    }

    public int getPosition(int index) {
        float tempPos = (float)(index - this.firstIndex) * this.scaleFactor;
        if (tempPos - (float)((int)tempPos) > 0.0f) {
            tempPos += 1.0f;
        }
        return (int)tempPos + this.firstPos;
    }

    public int getApproximateCount() {
        return this.estimatedSize;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public int getSize() {
        return this.narrCache.size();
    }

    public void append(Object[] stuff, int firstPosition, int lastPosition) {
        this.makeGuess(lastPosition - this.firstPos, this.narrCache.size() + stuff.length);
        if (stuff.length == 0) {
            return;
        }
        int removeUpToButNotIncluding = Math.min(stuff.length, this.narrCache.size());
        this.narrCache.replaceToBack(stuff);
        this.lastPos = lastPosition;
        if (stuff.length == this.narrCache.size()) {
            this.firstPos = firstPosition;
        } else {
            int cacheSpan = (int)((float)this.narrCache.size() * this.scaleFactor);
            this.firstPos = Math.max(0, lastPosition - cacheSpan);
        }
        this.firstIndex += removeUpToButNotIncluding;
        this.lastIndex = this.firstIndex + this.narrCache.size() - 1;
    }

    public void prepend(Object[] stuff, int firstPosition, int lastPosition) {
        this.makeGuess(lastPosition - this.firstPos, this.narrCache.size() + stuff.length);
        if (stuff.length == 0) {
            return;
        }
        this.narrCache.replaceToFront(stuff);
        this.firstPos = firstPosition;
        if (stuff.length == this.narrCache.size()) {
            this.lastPos = lastPosition;
        } else {
            int cacheSpan = (int)((float)this.narrCache.size() * this.scaleFactor);
            this.lastPos = Math.min(1000, firstPosition + cacheSpan);
        }
        this.firstIndex -= stuff.length;
        this.lastIndex = this.narrCache.size() + this.firstIndex - 1;
    }

    public FloatingCacheIterator getObjects(int startIndex, int count) {
        if (startIndex < this.firstIndex) {
            count -= this.firstIndex - startIndex;
        }
        startIndex = Math.max(startIndex, this.firstIndex);
        int normalFirst = startIndex - this.firstIndex;
        count = Math.min(count, this.narrCache.size() - normalFirst);
        FloatingCacheIterator fci = new FloatingCacheIterator(startIndex, normalFirst, count, this.narrCache);
        return fci;
    }

    public boolean isContained(int index) {
        return index >= this.firstIndex && index <= this.lastIndex;
    }

    public static void main(String[] s) {
        FloatingCache fc = new FloatingCache(FloatingCache.someStuff(0, 1000), 990, 1000);
    }

    private void status() {
        System.out.println("First Index: " + this.getFirstIndex());
        System.out.println("Last Index: " + this.getLastIndex());
        System.out.println("Cache Size: " + this.getSize());
    }

    private static void status(FloatingCacheIterator fi) {
        System.out.println("Starting Index = " + fi.getStartingIndex());
        System.out.println("Count = " + fi.getCount());
        while (fi.hasMoreElements()) {
            System.out.println(fi.nextElement());
        }
    }

    private static Object[] someStuff(int start, int count) {
        Object[] stuff = new Object[count];
        for (int i = 0; i < count; ++i) {
            stuff[i] = new Integer(start + i);
        }
        return stuff;
    }

    class FloatingCacheIterator {
        private int count;
        private int currentIndex;
        private int start;
        private NarrayList arrCache;
        private int lastIndex;

        public FloatingCacheIterator(int floatingIndex, int firstIndex, int count, NarrayList arrCache) {
            this.count = count;
            this.currentIndex = firstIndex;
            this.arrCache = arrCache;
            this.start = floatingIndex;
            this.lastIndex = firstIndex + count;
        }

        public int getStartingIndex() {
            return this.start;
        }

        public int getCount() {
            return this.count;
        }

        public boolean hasMoreElements() {
            boolean rval = this.currentIndex < this.lastIndex;
            return rval;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                return this.arrCache.get(this.currentIndex++);
            }
            return null;
        }
    }
}

