/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.nds.NDSInputStreamFactory;
import com.novell.admin.ns.nds.jclient.NDSNamespaceImpl;
import com.novell.application.console.snapin.ObjectEntry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JCStreamValue;
import novell.jclient.JCValue;
import novell.jclient.JClient;

public class NDSInputStreamFactoryImpl
implements NDSInputStreamFactory {
    private ObjectEntry oe;
    private ObjectEntry serverOE;
    private JCValue streamValue;
    private AttributeDefinition attrDef;
    private NDSNamespaceImpl namespace;

    public NDSInputStreamFactoryImpl(ObjectEntry obj, JCStreamValue streamValue, AttributeDefinition attrDef, ObjectEntry serverOE) {
        this.oe = obj;
        this.streamValue = streamValue;
        this.attrDef = attrDef;
        this.namespace = (NDSNamespaceImpl)obj.getObjectType().getNamespace();
        this.serverOE = serverOE;
    }

    public InputStream getInputStream(ObjectEntry serverObj) throws SPIException, IOException {
        this.serverOE = serverObj;
        return this.getInputStream();
    }

    public InputStream getInputStream() throws SPIException, IOException {
        String attrName = this.attrDef.getName();
        JCContext context = null;
        try {
            long saveStreamSize;
            context = this.serverOE == null ? this.namespace.getContext(this.oe, 68) : this.namespace.getContext(this.oe, 68, this.serverOE);
            try {
                saveStreamSize = JClient.openStream((JCContext)context, (String)attrName, (int)1);
            }
            catch (JCException jce) {
                saveStreamSize = this.namespace.secureRetryOpenStream(context, jce, attrName, 1);
            }
            byte[] saveStreamBuffer = new byte[(int)saveStreamSize];
            try {
                JClient.readStream((JCContext)context, (long)0L, (long)saveStreamSize, (byte[])saveStreamBuffer);
            }
            catch (JCException jce) {
                this.namespace.secureRetryReadStream(context, jce, 0L, saveStreamSize, saveStreamBuffer);
            }
            try {
                JClient.closeStream((JCContext)context);
            }
            catch (JCException jce) {
                this.namespace.secureRetryCloseStream(context, jce);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(saveStreamBuffer);
            return byteArrayInputStream;
        }
        catch (JCException e) {
            throw this.namespace.resolveSPIException((Exception)((Object)e), "");
        }
        finally {
            if (context != null) {
                context.free();
            }
        }
    }
}

