/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds.jclient;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NSFileRights;
import novell.jclient.JCException;

public final class NSFileRightsImpl
implements NSFileRights {
    private int normalizedFileRights = 0;

    void setRawFileRights(short rawFileRightBitMask) throws JCException {
        this.normalizedFileRights = this.getNormalizedFromRaw(rawFileRightBitMask);
    }

    short getRawFileRights() throws SPIException {
        return this.getRawFromNormalized(this.normalizedFileRights);
    }

    public int getRights() throws SPIException {
        return this.normalizedFileRights;
    }

    public void setRights(int newRights) throws SPIException {
        this.normalizedFileRights = newRights;
    }

    public boolean hasRights(int checkRights) throws SPIException {
        return (this.normalizedFileRights & checkRights) > 0;
    }

    public int addRights(int addRights) throws SPIException {
        this.normalizedFileRights |= addRights;
        return this.normalizedFileRights;
    }

    public int removeRights(int removeRights) throws SPIException {
        this.normalizedFileRights &= ~removeRights;
        return this.normalizedFileRights;
    }

    private short getRawFromNormalized(int inNormalized) {
        short outRaw = 0;
        if ((inNormalized & 1) > 0) {
            outRaw = (short)(outRaw | 1);
        }
        if ((inNormalized & 2) > 0) {
            outRaw = (short)(outRaw | 2);
        }
        if ((inNormalized & 8) > 0) {
            outRaw = (short)(outRaw | 8);
        }
        if ((inNormalized & 0x10) > 0) {
            outRaw = (short)(outRaw | 0x10);
        }
        if ((inNormalized & 0x20) > 0) {
            outRaw = (short)(outRaw | 0x20);
        }
        if ((inNormalized & 0x40) > 0) {
            outRaw = (short)(outRaw | 0x40);
        }
        if ((inNormalized & 0x80) > 0) {
            outRaw = (short)(outRaw | 0x80);
        }
        if ((inNormalized & 0x100) > 0) {
            outRaw = (short)(outRaw | 0x100);
        }
        return outRaw;
    }

    private int getNormalizedFromRaw(short inRaw) {
        int outNormalized = 0;
        if ((inRaw & 1) > 0) {
            outNormalized |= 1;
        }
        if ((inRaw & 2) > 0) {
            outNormalized |= 2;
        }
        if ((inRaw & 8) > 0) {
            outNormalized |= 8;
        }
        if ((inRaw & 0x10) > 0) {
            outNormalized |= 0x10;
        }
        if ((inRaw & 0x20) > 0) {
            outNormalized |= 0x20;
        }
        if ((inRaw & 0x40) > 0) {
            outNormalized |= 0x40;
        }
        if ((inRaw & 0x80) > 0) {
            outNormalized |= 0x80;
        }
        if ((inRaw & 0x100) > 0) {
            outNormalized |= 0x100;
        }
        return outNormalized;
    }
}

