/*
 * Decompiled with CFR 0.152.
 */
package com.novell.application.console.snapin;

import com.novell.application.console.snapin.BaseDefaultVirtualEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.VirtualObjectEntryEnumeration;

public class DefaultVirtualObjectEntryEnumeration
extends BaseDefaultVirtualEnumeration
implements VirtualObjectEntryEnumeration {
    private static final int POS_LASTENTRY = 1000;

    public DefaultVirtualObjectEntryEnumeration(ObjectEntryEnumeration oee, Shell shell) {
        super(oee, shell);
    }

    public boolean hasMoreElements() {
        return -2 != this.m_iEnumerationIndex && this.m_iEnumerationIndex < this.m_enumerationData.size();
    }

    public Object nextElement() {
        ObjectEntry next = null;
        ObjectEntry[] arNext = this.getNext(1);
        if (0 != arNext.length) {
            next = arNext[0];
        }
        return next;
    }

    public ObjectEntry next() {
        return (ObjectEntry)this.nextElement();
    }

    public ObjectEntry previous() {
        ObjectEntry prev = null;
        ObjectEntry[] arPrev = this.getPrev(1);
        if (0 != arPrev.length) {
            prev = arPrev[0];
        }
        return prev;
    }

    public int moveFirst() {
        this.m_iEnumerationIndex = 0;
        return 0;
    }

    public int moveLast() {
        this.m_iEnumerationIndex = this.m_enumerationData.size() - 1;
        return 1000;
    }

    public int moveTo(int iPercent) {
        if (0 <= iPercent && 1000 >= iPercent) {
            if (0 == iPercent || 1 >= this.m_enumerationData.size()) {
                this.moveFirst();
                return 0;
            }
            if (1000 == iPercent) {
                this.moveLast();
                return 1000;
            }
            if (2 == this.m_enumerationData.size()) {
                if (iPercent > 500) {
                    this.moveLast();
                    return 1000;
                }
                this.moveFirst();
                return 0;
            }
            this.m_iEnumerationIndex = (this.m_enumerationData.size() - 1) * iPercent / 1000;
            return this.getCurrentPosition();
        }
        return this.getCurrentPosition();
    }

    public int moveTo(String target) {
        int iEntryIndex = this.findEntry(target);
        if (-1 != iEntryIndex) {
            this.m_iEnumerationIndex = iEntryIndex;
            return this.getCurrentPosition();
        }
        return this.getCurrentPosition();
    }

    public ObjectEntry[] getNext(int iCount) {
        if (-2 == this.m_iEnumerationIndex || 0 == iCount) {
            return new ObjectEntry[0];
        }
        if (-1 == this.m_iEnumerationIndex) {
            this.m_iEnumerationIndex = 0;
        }
        if (this.m_iEnumerationIndex + iCount > this.m_enumerationData.size()) {
            iCount = this.m_enumerationData.size() - this.m_iEnumerationIndex;
        }
        ObjectEntry[] oes = new ObjectEntry[iCount];
        for (int i = 0; i < iCount; ++i) {
            oes[i] = null;
            if (this.m_iEnumerationIndex >= this.m_enumerationData.size()) continue;
            oes[i] = (ObjectEntry)this.m_enumerationData.elementAt(this.m_iEnumerationIndex);
            ++this.m_iEnumerationIndex;
        }
        if (this.m_iEnumerationIndex >= this.m_enumerationData.size()) {
            this.m_iEnumerationIndex = -2;
        }
        return oes;
    }

    public ObjectEntry[] getPrev(int iCount) {
        boolean bResultIndexIsBeforeList = false;
        if (-1 == this.m_iEnumerationIndex || 0 == iCount) {
            return new ObjectEntry[0];
        }
        if (0 == this.m_iEnumerationIndex) {
            this.m_iEnumerationIndex = -1;
            return new ObjectEntry[0];
        }
        if (-2 == this.m_iEnumerationIndex) {
            this.m_iEnumerationIndex = this.m_enumerationData.size();
        }
        if (this.m_iEnumerationIndex - iCount < 0) {
            iCount += this.m_iEnumerationIndex - iCount;
            bResultIndexIsBeforeList = true;
            this.m_iEnumerationIndex = 0;
        } else {
            this.m_iEnumerationIndex -= iCount;
        }
        int iNewIndex = this.m_iEnumerationIndex;
        ObjectEntry[] oes = this.getNext(iCount);
        this.m_iEnumerationIndex = iNewIndex;
        if (bResultIndexIsBeforeList) {
            this.m_iEnumerationIndex = -1;
        }
        return oes;
    }

    public int moveLeft(int iCount) {
        if (this.m_iEnumerationIndex == -1) {
            return 0;
        }
        if (-2 == this.m_iEnumerationIndex) {
            this.m_iEnumerationIndex = this.m_enumerationData.size();
        }
        int baseIndex = this.m_iEnumerationIndex;
        this.m_iEnumerationIndex -= iCount;
        if (this.m_iEnumerationIndex < 0) {
            this.m_iEnumerationIndex = -1;
            return baseIndex;
        }
        return iCount;
    }

    public int moveRight(int iCount) {
        int savedIndex = this.m_iEnumerationIndex;
        if (this.m_iEnumerationIndex == -2) {
            return 0;
        }
        if (-1 == this.m_iEnumerationIndex) {
            this.m_iEnumerationIndex = 0;
        }
        this.m_iEnumerationIndex += iCount;
        if (this.m_iEnumerationIndex >= this.m_enumerationData.size()) {
            this.m_iEnumerationIndex = -2;
            return this.m_enumerationData.size() - savedIndex;
        }
        return iCount;
    }

    public int getCurrentPosition() {
        if (0 == this.m_enumerationData.size() || -1 == this.m_iEnumerationIndex) {
            return -1;
        }
        if (-2 == this.m_iEnumerationIndex) {
            return -2;
        }
        if (this.m_iEnumerationIndex == this.m_enumerationData.size() - 1) {
            return 1000;
        }
        int curPos = this.m_iEnumerationIndex * 1000 / (this.m_enumerationData.size() - 1);
        return curPos;
    }

    public int getLastEntryPosition() {
        return 1000;
    }

    public int getCount() {
        return this.m_enumerationData.size();
    }
}

