/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.lang.reference;

import com.novell.java.lang.reference.FinalReference;
import com.novell.java.lang.reference.ReferenceQueue;
import com.novell.service.jncpv2.misc.finalizerJNI;

final class Finalizer
extends FinalReference {
    private static ReferenceQueue queue;
    private static Finalizer unfinalized;
    private static Object lock;
    private Finalizer next;
    private Finalizer prev;
    private static boolean runOnExit;

    static void invokeFinalizeMethod(Object object) throws Throwable {
        finalizerJNI.invokeFinalizeMethod(object);
    }

    private boolean hasBeenFinalized() {
        return this.next == this;
    }

    private void add() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized != null) {
                this.next = unfinalized;
                Finalizer.unfinalized.prev = this;
            }
            unfinalized = this;
            return;
        }
    }

    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized == this) {
                unfinalized = this.next != null ? this.next : this.prev;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this;
            this.prev = this;
            return;
        }
    }

    private Finalizer(Object object) {
        super(object, queue);
        this.add();
    }

    static void register(Object object) {
        new Finalizer(object);
    }

    private void runFinalizer() {
        Object object = this;
        synchronized (object) {
            if (this.hasBeenFinalized()) {
                Object var2_2 = null;
                return;
            }
            this.remove();
        }
        try {
            object = this.get();
            if (object != null) {
                Finalizer.invokeFinalizeMethod(object);
                object = null;
            }
        }
        catch (Throwable throwable) {}
        super.clear();
    }

    private static void forkSecondaryFinalizer(Runnable runnable) {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        Thread thread = new Thread(threadGroup, runnable, "Secondary finalizer");
        thread.start();
        try {
            thread.join();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    static void runFinalization() {
        Finalizer.forkSecondaryFinalizer(new 1());
    }

    static void setRunFinalizersOnExit(boolean bl) {
        runOnExit = bl;
    }

    static void runFinalizersOnExit() {
        if (!runOnExit) {
            return;
        }
        Finalizer.forkSecondaryFinalizer(new 2());
    }

    static {
        ThreadGroup threadGroup;
        queue = new ReferenceQueue();
        unfinalized = null;
        lock = new Object();
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        FinalizerThread finalizerThread = new FinalizerThread(threadGroup);
        finalizerThread.setPriority(8);
        finalizerThread.setDaemon(true);
        finalizerThread.start();
    }

    private final class 1
    implements Runnable {
        public void run() {
            Finalizer finalizer;
            while ((finalizer = (Finalizer)queue.poll()) != null) {
                finalizer.runFinalizer();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements Runnable {
        public void run() {
            while (true) {
                Finalizer finalizer;
                Object object = lock;
                synchronized (object) {
                    finalizer = unfinalized;
                    if (finalizer == null) {
                        Object var3_3 = null;
                        return;
                    }
                    unfinalized = finalizer.next;
                }
                finalizer.runFinalizer();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private static class FinalizerThread
    extends Thread {
        FinalizerThread(ThreadGroup threadGroup) {
            super(threadGroup, "Finalizer");
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Finalizer finalizer = (Finalizer)queue.remove();
                        finalizer.runFinalizer();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

