/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.security;

import com.novell.java.security.MessageDigest;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DigestOutputStream
extends FilterOutputStream {
    private boolean on = true;
    protected MessageDigest digest;

    public DigestOutputStream(OutputStream outputStream, MessageDigest messageDigest) {
        super(outputStream);
        this.setMessageDigest(messageDigest);
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    public void write(int n) throws IOException {
        if (this.on) {
            this.digest.update((byte)n);
        }
        this.out.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.on) {
            this.digest.update(byArray, n, n2);
        }
        this.out.write(byArray, n, n2);
    }

    public void on(boolean bl) {
        this.on = bl;
    }

    public String toString() {
        return "[Digest Output Stream] " + this.digest.toString();
    }
}

