/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.security;

import com.novell.java.security.IdentityScope;
import com.novell.java.security.Key;
import com.novell.java.security.KeyManagementException;
import com.novell.java.security.MessageDigest;
import com.novell.java.security.Principal;
import com.novell.java.security.PublicKey;
import com.novell.java.security.cert.Certificate;
import com.novell.java.security.cert.X509Certificate;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Identity
implements Principal,
Serializable {
    private String name;
    private PublicKey publicKey;
    private static final long serialVersionUID = 3609922007826600659L;
    String info = "No further information available.";
    IdentityScope scope;
    Vector certificates;

    protected Identity() {
        this("restoring...");
    }

    public Identity(String string, IdentityScope identityScope) throws KeyManagementException {
        this(string);
        this.scope = identityScope;
    }

    public Identity(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final IdentityScope getScope() {
        return this.scope;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) throws KeyManagementException {
        Identity.check("Identity.setPublicKey");
        this.publicKey = publicKey;
    }

    public void setInfo(String string) {
        Identity.check("Identity.setInfo");
        this.info = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void addCertificate(Certificate certificate) throws KeyManagementException {
        Identity.check("Identity.addCertificate");
        if (this.certificates == null) {
            this.certificates = new Vector();
        }
        PublicKey publicKey = certificate.getPublicKey();
        if (this.publicKey != null && publicKey != null) {
            if (!this.keyEquals(this.publicKey, publicKey)) {
                throw new KeyManagementException("public key different from cert public key");
            }
        } else {
            this.publicKey = publicKey;
        }
        this.certificates.addElement(certificate);
    }

    private boolean keyEquals(Key key, Key key2) {
        if (key.getFormat().equalsIgnoreCase(key2.getFormat())) {
            return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
        }
        return false;
    }

    public void removeCertificate(Certificate certificate) throws KeyManagementException {
        Identity.check("Identity.removeCertificate");
        if (this.certificates != null) {
            this.certificates.removeElement(certificate);
        }
    }

    public Certificate[] getCertificates() {
        if (this.certificates == null) {
            return new Certificate[0];
        }
        int n = this.certificates.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.certificates.elementAt(n3) instanceof Certificate) {
                ++n2;
            }
            ++n3;
        }
        Certificate[] certificateArray = new Certificate[n2];
        n2 = 0;
        n3 = 0;
        while (n3 < n) {
            Object e = this.certificates.elementAt(n3);
            if (e instanceof Certificate) {
                certificateArray[n2] = (Certificate)e;
                ++n2;
            }
            ++n3;
        }
        return certificateArray;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Identity) {
            Identity identity = (Identity)object;
            if (identity.getScope() == this.scope && identity.getName().equals(this.name)) {
                return true;
            }
            return this.identityEquals(identity);
        }
        return false;
    }

    protected boolean identityEquals(Identity identity) {
        return this.name.equals(identity.name) && this.publicKey.equals(identity.publicKey);
    }

    String fullName() {
        String string = this.name;
        if (this.scope != null) {
            string = String.valueOf(string) + "." + this.scope.getName();
        }
        return string;
    }

    public String toString() {
        String string = this.name;
        if (this.scope != null) {
            string = String.valueOf(string) + "[" + this.scope.getName() + "]";
        }
        return string;
    }

    public String toString(boolean bl) {
        String string = this.toString();
        if (bl) {
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + this.printKeys();
            string = String.valueOf(string) + "\n" + this.printCertificates();
            string = this.info != null ? String.valueOf(string) + "\n\t" + this.info : String.valueOf(string) + "\n\tno additional information available.";
        }
        return string;
    }

    String printKeys() {
        String string = "";
        string = this.publicKey != null ? "\tpublic key initialized" : "\tno public key";
        return string;
    }

    String printCertificates() {
        String string = "";
        if (this.certificates == null) {
            return "\tno certificates";
        }
        string = String.valueOf(string) + "\tcertificates: \n";
        Enumeration enumeration = this.certificates.elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)e;
                string = String.valueOf(string) + "\tcertificate " + n++ + "\tfor  : " + x509Certificate.getSubjectDN() + "\n";
                string = String.valueOf(string) + "\t\t\tfrom : " + x509Certificate.getIssuerDN() + "\n";
                continue;
            }
            string = String.valueOf(string) + e.toString();
        }
        return string;
    }

    public int hashCode() {
        String string = this.name;
        if (this.scope != null) {
            string = String.valueOf(string) + this.scope.getName();
        }
        return string.hashCode();
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }
}

