/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.security;

import com.novell.java.security.Identity;
import com.novell.java.security.KeyManagementException;
import com.novell.java.security.Principal;
import com.novell.java.security.PublicKey;
import java.util.Enumeration;

public abstract class IdentityScope
extends Identity {
    private static IdentityScope scope;

    private static void initializeSystemScope() {
        String string = "com.novell.service.session.xplat.XplatIdentityScope";
        if (string == null) {
            return;
        }
        try {
            Class.forName(string);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return;
        }
    }

    protected IdentityScope() {
        this("restoring...");
    }

    public IdentityScope(String string) {
        super(string);
    }

    public IdentityScope(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    public static IdentityScope getSystemScope() {
        if (scope == null) {
            IdentityScope.initializeSystemScope();
        }
        return scope;
    }

    protected static void setSystemScope(IdentityScope identityScope) {
        IdentityScope.check("IdentityScope.setSystemScope");
        scope = identityScope;
    }

    public abstract int size();

    public abstract Identity getIdentity(String var1);

    public Identity getIdentity(Principal principal) {
        return this.getIdentity(principal.getName());
    }

    public abstract Identity getIdentity(PublicKey var1);

    public abstract void addIdentity(Identity var1) throws KeyManagementException;

    public abstract void removeIdentity(Identity var1) throws KeyManagementException;

    public abstract Enumeration identities();

    public String toString() {
        if (scope != null) {
            return String.valueOf(super.toString()) + "[" + this.size() + "](" + scope.getName() + ")";
        }
        return String.valueOf(super.toString()) + "[" + this.size() + "]";
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }
}

