/*
 * Decompiled with CFR 0.152.
 */
package com.novell.java.security;

import com.novell.java.security.AuthenticatorChannel;
import com.novell.java.security.AuthenticatorProtocol;
import com.novell.java.security.ConfigurationException;
import com.novell.java.security.I2L;
import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.java.security.PublicKey;
import com.novell.service.security.NdsServiceIdentity;
import com.novell.service.security.protocols.ServiceAuthProtocolProxy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class Vault {
    static final boolean DEBUG = false;
    static final boolean USE_OLD_PROTOCOL = false;
    private static final String PROPERTY_FILE_SEPARATOR = "file.separator";
    private static final String PROPERTY_FILENAME_DEFAULT = "security.properties";
    private static final String PROPERTY_FILENAME_KEY = "osa.security.file.name";
    private static final String PROPERTY_FILE_PATH_DEFAULT = ".";
    private static final String PROPERTY_FILE_PATH_KEY = "osa.security.file.path";
    private static final String VAULT_IDENTITY_SCOPE = "VAULT_IDENTITY_SCOPE";
    private static final String PROPERTY_BLANK = "";
    private static final String PROPERTY_DEFAULT = "default.";
    private static final String PROPERTY_IDENTITY = "identity.";
    private static final String PROPERTY_IDENTITYSCOPE = "identityscope.";
    private static final String PROPERTY_CHANNEL = "channel.";
    private static final String PROPERTY_PROTOCOL = "protocol.";
    private static final String PROPERTY_CLASS = "class";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_SCOPE = "scope";
    private Properties configuration = new Properties();
    private IdentityScope configuredIdentities = new VaultIdentityScope();
    private static AuthenticatorProtocol ServiceAuthenticator = new ServiceAuthProtocolProxy();

    Vault() {
        try {
            String string = System.getProperty(PROPERTY_FILENAME_KEY, PROPERTY_FILENAME_DEFAULT);
            String string2 = System.getProperty(PROPERTY_FILE_PATH_KEY, PROPERTY_FILE_PATH_DEFAULT);
            File file = new File(String.valueOf(string2) + System.getProperty(PROPERTY_FILE_SEPARATOR) + string);
            this.configuration.load(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (Throwable throwable) {
            ((Hashtable)this.configuration).put("default.identityscope.1.class", "com.novell.service.security.XplatIdentity");
            ((Hashtable)this.configuration).put("default.identityscope.1.name", "DEFAULT_NAME");
            ((Hashtable)this.configuration).put("default.identityscope.1.channel.1.class", "com.novell.java.security.channels.NativeCodeChannelProxy");
            ((Hashtable)this.configuration).put("default.identityscope.1.channel.1.protocol.1.class", "com.novell.service.security.protocols.XplatProtocolProxy");
        }
        this.parseIdentityScopes(PROPERTY_DEFAULT, this.configuredIdentities);
        this.parseIdentityScopes(PROPERTY_BLANK, this.configuredIdentities);
        this.parseIdentities(PROPERTY_DEFAULT, this.configuredIdentities);
        this.parseIdentities(PROPERTY_BLANK, this.configuredIdentities);
    }

    Identity[] getConfiguredIdentities() {
        return this.getIdentities(this.configuredIdentities);
    }

    Identity[] getIdentities(IdentityScope identityScope) {
        Vector vector = new Vector();
        this.getIdentities(identityScope, vector);
        Object[] objectArray = new Identity[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void getIdentities(IdentityScope identityScope, Vector vector) {
        Enumeration enumeration = identityScope.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            vector.addElement(identity);
            if (!(identity instanceof IdentityScope)) continue;
            this.getIdentities((IdentityScope)identity, vector);
        }
    }

    private VaultIdentityScope getIdentityScope(Identity identity) {
        Identity identity2 = this.configuredIdentities.getIdentity(identity);
        if (identity2 == null) {
            Identity[] identityArray = this.getConfiguredIdentities();
            if (identityArray.length == 0) {
                throw new ConfigurationException(I2L.getString("NO_DEFAULT_SCOPE_EXISTS"));
            }
            identity2 = identityArray[0];
        }
        if (!(identity2 instanceof IdentityScope)) {
            identity2 = identity2.getScope();
        }
        while (!(identity2 instanceof VaultIdentityScope)) {
            if ((identity2 = (VaultIdentityScope)identity2.getScope()) != this.configuredIdentities) continue;
            throw new ConfigurationException(I2L.getString("NO_SCOPE_EXISTS"));
        }
        return (VaultIdentityScope)identity2;
    }

    AuthenticatorProtocol[] getProtocols(Identity identity) {
        Object[] objectArray;
        if (identity instanceof NdsServiceIdentity && System.getProperty("os.name").toLowerCase().indexOf("netware") != -1) {
            return new AuthenticatorProtocol[]{ServiceAuthenticator};
        }
        AuthenticatorChannel[] authenticatorChannelArray = this.getChannels(identity);
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < authenticatorChannelArray.length) {
            objectArray = authenticatorChannelArray[n].getProtocols();
            int n2 = 0;
            while (n2 < objectArray.length) {
                vector.addElement(objectArray[n2]);
                ++n2;
            }
            ++n;
        }
        objectArray = new AuthenticatorProtocol[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    AuthenticatorChannel[] getChannels(Identity identity) {
        return this.getIdentityScope((Identity)identity).channels;
    }

    private void parseIdentityScopes(String string, IdentityScope identityScope) {
        String string2;
        String string3;
        int n = 0;
        while ((string3 = this.configuration.getProperty(String.valueOf(string2 = String.valueOf(string) + PROPERTY_IDENTITYSCOPE + ++n) + ".name")) != null) {
            this.configuration.getProperty(String.valueOf(string2) + ".class");
            try {
                AuthenticatorChannel[] authenticatorChannelArray = this.parseChannels(string2);
                VaultIdentityScope vaultIdentityScope = new VaultIdentityScope(string3, identityScope, authenticatorChannelArray);
                identityScope.addIdentity(vaultIdentityScope);
            }
            catch (Throwable throwable) {
                throw new ConfigurationException(I2L.getString("SCOPE_PARSING"), throwable);
            }
        }
    }

    private void parseIdentities(String string, IdentityScope identityScope) {
        String string2;
        String string3;
        int n = 0;
        while ((string3 = this.configuration.getProperty(String.valueOf(string2 = String.valueOf(string) + PROPERTY_IDENTITY + ++n) + ".name")) != null) {
            String string4 = this.configuration.getProperty(String.valueOf(string2) + ".class");
            String string5 = this.configuration.getProperty(String.valueOf(string2) + ".scope");
            Identity identity = identityScope.getIdentity(string5);
            if (identity == null || !(identity instanceof IdentityScope)) {
                throw new ConfigurationException(I2L.getString("NO_ASSOCIATED_SCOPE"));
            }
            Class[] classArray = new Class[]{string3.getClass(), identity.getClass().getSuperclass()};
            Object[] objectArray = new Object[]{string3, (IdentityScope)identity};
            try {
                Identity identity2 = (Identity)Class.forName(string4).getDeclaredConstructor(classArray).newInstance(objectArray);
                identity2.getScope().addIdentity(identity2);
            }
            catch (Throwable throwable) {
                throw new ConfigurationException(I2L.getString("IDENTITY_PARSING"), throwable);
            }
        }
    }

    private AuthenticatorChannel[] parseChannels(String string) {
        Object[] objectArray;
        String string2;
        Vector<AuthenticatorChannel> vector = new Vector<AuthenticatorChannel>();
        int n = 0;
        while ((string2 = this.configuration.getProperty(String.valueOf(objectArray = String.valueOf(string) + ".channel." + ++n) + ".class")) != null) {
            try {
                AuthenticatorChannel authenticatorChannel = (AuthenticatorChannel)Class.forName(string2).newInstance();
                authenticatorChannel.configure(this.configuration, (String)objectArray);
                vector.addElement(this.parseProtocol((String)objectArray, authenticatorChannel));
            }
            catch (Throwable throwable) {
                throw new ConfigurationException(I2L.getString("CHANNEL_PARSING"), throwable);
            }
        }
        objectArray = new AuthenticatorChannel[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private AuthenticatorChannel parseProtocol(String string, AuthenticatorChannel authenticatorChannel) {
        Object[] objectArray;
        String string2;
        Vector<AuthenticatorProtocol> vector = new Vector<AuthenticatorProtocol>();
        int n = 0;
        while ((string2 = this.configuration.getProperty(String.valueOf(objectArray = String.valueOf(string) + ".protocol." + ++n) + ".class")) != null) {
            try {
                AuthenticatorProtocol authenticatorProtocol = (AuthenticatorProtocol)Class.forName(string2).newInstance();
                authenticatorProtocol.configure(this.configuration, (String)objectArray);
                vector.addElement(authenticatorProtocol);
            }
            catch (Throwable throwable) {
                throw new ConfigurationException(I2L.getString("PROTOCOL_PARSING"), throwable);
            }
        }
        objectArray = new AuthenticatorProtocol[vector.size()];
        vector.copyInto(objectArray);
        authenticatorChannel.init((AuthenticatorProtocol[])objectArray);
        return authenticatorChannel;
    }

    private class VaultIdentityScope
    extends IdentityScope {
        AuthenticatorChannel[] channels;
        Vector identities = new Vector();

        VaultIdentityScope() {
            super(VAULT_IDENTITY_SCOPE);
            Vault.this = Vault.this;
        }

        VaultIdentityScope(String string, IdentityScope identityScope, AuthenticatorChannel[] authenticatorChannelArray) throws KeyManagementException {
            super(string, identityScope);
            Vault.this = Vault.this;
            this.channels = authenticatorChannelArray;
        }

        public void addIdentity(Identity identity) {
            this.identities.addElement(identity);
        }

        public void removeIdentity(Identity identity) {
            int n = this.identities.indexOf(identity);
            if (n == -1) {
                return;
            }
            this.identities.removeElementAt(n);
        }

        public Identity getIdentity(String string) {
            Enumeration enumeration = this.identities();
            while (enumeration.hasMoreElements()) {
                Identity identity;
                Identity identity2 = (Identity)enumeration.nextElement();
                if (identity2.getName().equals(string)) {
                    return identity2;
                }
                if (!(identity2 instanceof IdentityScope) || (identity = ((IdentityScope)identity2).getIdentity(string)) == null) continue;
                return identity;
            }
            return null;
        }

        public Identity getIdentity(PublicKey publicKey) {
            return null;
        }

        public Enumeration identities() {
            return this.identities.elements();
        }

        public int size() {
            return this.identities.size();
        }
    }
}

