/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.bindery;

import com.novell.java.lang.IntegerBuffer;
import com.novell.service.bindery.BinderyEnvironment;
import com.novell.service.bindery.BinderyUtil;
import com.novell.service.jncp.NSIException;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class BinderyObjectNCEnumerator
implements NamingEnumeration {
    private BinderyEnvironment environment;
    private boolean moreElements;
    private NameClassPair nextPair;
    private IntegerBuffer objID;

    public BinderyObjectNCEnumerator(BinderyEnvironment binderyEnvironment) {
        this.environment = binderyEnvironment;
        this.moreElements = true;
        this.objID = new IntegerBuffer(-1);
        this.nextElement();
    }

    public boolean hasMoreElements() {
        return this.moreElements;
    }

    public boolean hasMore() {
        return this.moreElements;
    }

    public Object next() {
        return this.nextElement();
    }

    private NameClassPair nextNameClassPair() throws NSIException, NamingException {
        String string;
        StringBuffer stringBuffer = new StringBuffer(48);
        IntegerBuffer integerBuffer = new IntegerBuffer();
        try {
            this.environment.getCallsService().scanObject("*", -1, this.objID, stringBuffer, integerBuffer, null, null, null);
        }
        catch (NSIException nSIException) {
            if (nSIException.getCCode() == 35324) {
                this.moreElements = false;
                return null;
            }
            this.moreElements = false;
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            nameNotFoundException.setRootCause(nSIException);
            throw nameNotFoundException;
        }
        catch (Exception exception) {
            this.moreElements = false;
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
        switch (integerBuffer.intValue()) {
            case 768: 
            case 2048: 
            case 2560: {
                string = new String("com.novell.service.bindery.QueueBinderyObjectDirContext");
                break;
            }
            case 1024: {
                string = new String("com.novell.service.bindery.ServerBinderyObjectDirContext");
                break;
            }
            case 30722: {
                string = new String("com.novell.service.bindery.TreeBinderyObjectDirContext");
                break;
            }
            default: {
                string = new String("com.novell.service.bindery.BinderyObjectDirContext");
            }
        }
        int n = BinderyUtil.byteswapID(integerBuffer.intValue());
        return new NameClassPair(String.valueOf(stringBuffer.toString()) + "+" + Integer.toHexString(n), string);
    }

    public Object nextElement() {
        if (!this.moreElements) {
            throw new NoSuchElementException();
        }
        NameClassPair nameClassPair = this.nextPair;
        try {
            this.nextPair = this.nextNameClassPair();
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException(nSIException.toString());
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException(namingException.toString());
        }
        return nameClassPair;
    }

    public void close() throws NamingException {
    }
}

