/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.bindery;

import com.novell.service.jncp.NSIException;
import java.util.Vector;

public class BinderyPropertyDataSegment {
    public static final int SEGMENT_LENGTH = 128;
    byte[] segment = new byte[128];
    int segNum;
    int segFlag;

    public BinderyPropertyDataSegment(byte[] byArray, int n, int n2) throws NSIException {
        if (byArray.length > 128) {
            throw new NSIException();
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            this.segment[n3] = byArray[n3];
            ++n3;
        }
        this.segNum = n;
        this.segFlag = n2;
    }

    public BinderyPropertyDataSegment(Vector vector, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n3 < 128 && n4 < vector.size()) {
            int n5 = (Integer)vector.elementAt(n4);
            this.segment[n3++] = (byte)n5;
            this.segment[n3++] = (byte)(n5 >> 8);
            this.segment[n3++] = (byte)(n5 >> 16);
            this.segment[n3++] = (byte)(n5 >> 24);
            ++n4;
        }
        this.segNum = n;
        this.segFlag = n2;
    }

    public byte[] getByteData() {
        return (byte[])this.segment.clone();
    }

    public int getSegNum() {
        return this.segNum;
    }

    public int getSegFlag() {
        return this.segFlag;
    }

    public boolean isSet() {
        return (2 & this.segFlag) == 2;
    }

    public Vector getSetData() {
        Vector<Integer> vector = new Vector<Integer>();
        if (this.isSet()) {
            int n = 0;
            int n2 = 0;
            do {
                n2 = 0xFF & this.segment[n];
                n2 += 0xFF00 & this.segment[n + 1] << 8;
                n2 += 0xFF0000 & this.segment[n + 2] << 16;
                if ((n2 += this.segment[n + 3] << 24) == 0) continue;
                Integer n3 = new Integer(n2);
                vector.addElement(n3);
            } while (n2 != 0 && (n += 4) < 128);
        }
        vector.trimToSize();
        return vector;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BinderyPropertyDataSegment)) {
            return false;
        }
        BinderyPropertyDataSegment binderyPropertyDataSegment = (BinderyPropertyDataSegment)object;
        if (this.isSet()) {
            Vector vector = this.getSetData();
            Vector vector2 = binderyPropertyDataSegment.getSetData();
            if (vector2 == null) {
                return false;
            }
            int n = 0;
            while (n < vector2.size()) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (vector2.elementAt(n).equals(vector.elementAt(n2))) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
        } else {
            byte[] byArray = binderyPropertyDataSegment.getByteData();
            int n = 0;
            while (n < 128) {
                if (this.segment[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public String toString() {
        if (this.isSet()) {
            StringBuffer stringBuffer = new StringBuffer();
            Vector vector = this.getSetData();
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                Integer n3 = (Integer)vector.elementAt(n);
                stringBuffer.append(" " + Integer.toHexString(n3));
                ++n;
            }
            return stringBuffer.toString();
        }
        boolean bl = true;
        int n = 32;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[384];
        char[] cArray3 = new char[128];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < 128) {
            if (n7 > 0 && this.segment[n7] == 0 && bl) break;
            if (bl && this.segment[n7] >= 32 && this.segment[n7] < 127) {
                cArray3[n4++] = (char)this.segment[n7];
            } else {
                if (bl && n7 > 0) {
                    int n8 = 0;
                    while (n8 < n7) {
                        cArray2[n5++] = n;
                        cArray2[n5++] = cArray[this.segment[n8] >>> 4 & 0xF];
                        cArray2[n5++] = cArray[this.segment[n8] & 0xF];
                        ++n8;
                    }
                }
                cArray2[n5++] = n;
                cArray2[n5++] = cArray[this.segment[n7] >>> 4 & 0xF];
                cArray2[n5++] = cArray[this.segment[n7] & 0xF];
                bl = false;
                if (this.segment[n7] == 0) {
                    if (++n6 == 8) {
                        break;
                    }
                } else {
                    n6 = 0;
                }
            }
            ++n7;
        }
        if (bl) {
            return new String(cArray3, 0, n4);
        }
        return new String(cArray2, 0, n5);
    }
}

