/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.java.lang.IntegerBuffer;
import com.novell.service.bindery.BinderyUtil;
import com.novell.service.file.nw.calls.BinderyName;
import com.novell.service.jncp.NSIException;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;

public class BinderyNameImpl
extends BinderyName {
    private CallsService callsService;

    public BinderyNameImpl(CallsService callsService) {
        this(null, -1, -1, callsService);
    }

    public BinderyNameImpl(String string, CallsService callsService) {
        this(string, -1, -1, callsService);
    }

    public BinderyNameImpl(int n, CallsService callsService) {
        this(null, n, -1, callsService);
    }

    public BinderyNameImpl(String string, int n, CallsService callsService) {
        this(string, n, -1, callsService);
    }

    public BinderyNameImpl(String string, int n, int n2, CallsService callsService) {
        super(string, n, n2);
        this.callsService = callsService;
    }

    public String getName() {
        return this.getNameType();
    }

    public void setName(String string) {
        super.setName(string);
        if (string != null && this.getType() != -1 && this.callsService != null) {
            try {
                this.setObjectId(BinderyNameImpl.nameToObjectId(string, this.getType(), this.callsService));
                return;
            }
            catch (NSIException nSIException) {
                this.setObjectId(-1);
                return;
            }
        }
        this.setObjectId(-1);
    }

    public void setType(int n) {
        super.setType(n);
        if (this.getName() != null) {
            try {
                this.setObjectId(BinderyNameImpl.nameToObjectId(this.getName(), n, this.callsService));
                return;
            }
            catch (NSIException nSIException) {
                this.setObjectId(-1);
                return;
            }
        }
        this.setObjectId(-1);
    }

    public static int nameToObjectId(String string, int n, CallsService callsService) throws NSIException {
        n = BinderyUtil.byteswapID(n);
        IntegerBuffer integerBuffer = new IntegerBuffer();
        try {
            callsService.getObjectID(string, n, integerBuffer);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        return integerBuffer.intValue();
    }

    public static BinderyNameImpl objectIdToBinderyName(int n, CallsService callsService) throws NSIException {
        String string;
        IntegerBuffer integerBuffer = new IntegerBuffer();
        try {
            string = callsService.getObjectName(n, integerBuffer);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        return new BinderyNameImpl(string.toString(), BinderyUtil.byteswapID(integerBuffer.intValue()), n, callsService);
    }
}

