/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.service.file.nw.NameSpace;
import com.novell.service.file.nw.TrusteePathEnumerator;
import com.novell.service.file.nw.calls.ObjectNameImpl;
import com.novell.service.file.nw.naming.FSAttribute;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.SchemaAttrDef;
import com.novell.service.file.nw.naming.SchemaSyntaxDef;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.InvalidSearchFilterException;

public class TrusteePathEnumeratorImpl
implements TrusteePathEnumerator,
StaticAttributeValue {
    private FSEnvironment environment;
    private String volumeName;
    private String nameSpace;
    private CallsService callsService;
    private NetService netService;
    private boolean sessionIsNDS;
    private int objID;
    private int volumeNumber;
    private int iterHandle = -1;
    private boolean finished = false;
    private String nextPath;
    private String user;
    private boolean userIsSet = false;
    private String pathForSearch;
    private TrusteePathEnumeratorImpl attributeValue;

    public TrusteePathEnumeratorImpl(FSEnvironment fSEnvironment, boolean bl) throws NSIException {
        this.environment = fSEnvironment;
        this.volumeName = fSEnvironment.getVolumeName();
        this.nameSpace = fSEnvironment.getNameSpace();
        int[] nArray = new int[1];
        try {
            this.callsService = fSEnvironment.getCallsService();
            this.netService = fSEnvironment.getNetService();
            this.sessionIsNDS = fSEnvironment.sessionIsNDS();
            this.callsService.getVolumeNumber(this.volumeName, nArray);
        }
        catch (NamingException namingException) {
            throw new NSIException(namingException.getMessage(), namingException);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), sessionException);
        }
        this.volumeNumber = nArray[0];
        if (bl) {
            this.finished = !this.scanNextTrusteePath();
            return;
        }
        this.finished = true;
    }

    public TrusteePathEnumeratorImpl(FSEnvironment fSEnvironment) throws NSIException {
        this(fSEnvironment, false);
    }

    public String getPath() {
        return this.pathForSearch;
    }

    public void setPath(String string) {
        this.pathForSearch = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) throws NSIException {
        this.user = string;
        this.userIsSet = true;
        this.iterHandle = -1;
        this.objID = ObjectNameImpl.nameToObjectId(string, this.callsService, this.netService, this.sessionIsNDS);
        this.finished = !this.scanNextTrusteePath();
    }

    public boolean hasMoreElements() {
        return !this.finished;
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public Object nextElement() {
        return this.next();
    }

    public String next() {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        String string = this.nextPath;
        this.finished = !this.scanNextTrusteePath();
        return string;
    }

    public Attribute buildAttribute() throws NamingException {
        TrusteePathEnumeratorImpl trusteePathEnumeratorImpl = null;
        try {
            trusteePathEnumeratorImpl = new TrusteePathEnumeratorImpl(this.environment, true);
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(nSIException);
            throw namingException;
        }
        return new FSAttribute("Trustee Paths", trusteePathEnumeratorImpl, new SchemaAttrDef(2, this.environment), new SchemaSyntaxDef(2, this.environment));
    }

    public void addAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void deleteAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public String getID() {
        return "Trustee Paths";
    }

    public boolean compare(SearchStringComponent searchStringComponent) throws NamingException {
        try {
            return this.equals(searchStringComponent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(illegalArgumentException);
            throw invalidSearchFilterException;
        }
    }

    public boolean equals(SearchStringComponent searchStringComponent) {
        if (searchStringComponent == null) {
            return false;
        }
        int n = searchStringComponent.getOperationType();
        if (n == 4) {
            return true;
        }
        if (n != 0 && n != 5) {
            return false;
        }
        TrusteePathEnumeratorImpl trusteePathEnumeratorImpl = null;
        String string = null;
        boolean bl = true;
        if (searchStringComponent.operandReplacement()) {
            trusteePathEnumeratorImpl = (TrusteePathEnumeratorImpl)searchStringComponent.getReplacementObject();
            bl = false;
            if (string == null) {
                throw new IllegalArgumentException(searchStringComponent.getOperation());
            }
        } else {
            string = searchStringComponent.getOperand();
        }
        TrusteePathEnumeratorImpl trusteePathEnumeratorImpl2 = null;
        trusteePathEnumeratorImpl2 = new TrusteePathEnumeratorImpl(this.environment, true);
        while (trusteePathEnumeratorImpl2.hasMoreElements()) {
            String string2 = trusteePathEnumeratorImpl2.next();
            if (n == 0) {
                if (bl && string2.equalsIgnoreCase(string)) {
                    return true;
                }
                try {
                    return trusteePathEnumeratorImpl.equals(string2);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (!bl) {
                string = trusteePathEnumeratorImpl.getPath();
            }
            if (!SearchStringComponent.compareSubString(string, string2, true)) continue;
            return true;
        }
        return false;
    }

    public Object getStaticInterface() {
        TrusteePathEnumeratorImpl trusteePathEnumeratorImpl = new TrusteePathEnumeratorImpl(this.environment, true);
        return trusteePathEnumeratorImpl;
    }

    private boolean scanNextTrusteePath() {
        String[] stringArray = new String[1];
        int[] nArray = new int[]{this.iterHandle};
        if (!this.userIsSet) {
            this.finished = true;
            return false;
        }
        try {
            this.callsService.scanObjectTrusteePaths(this.objID, this.volumeNumber, NameSpace.nameToNumber(this.nameSpace), nArray, null, stringArray);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        this.iterHandle = nArray[0];
        this.nextPath = stringArray[0];
        return this.nextPath.length() > 0;
    }
}

