/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.service.file.nw.DirectorySpaceInformation;
import com.novell.service.file.nw.VolumeInformation;
import com.novell.service.file.nw.calls.ObjectName;
import com.novell.service.file.nw.calls.ObjectNameImpl;
import com.novell.service.file.nw.naming.FSAttribute;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.SchemaAttrDef;
import com.novell.service.file.nw.naming.SchemaSyntaxDef;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.InvalidSearchFilterException;

public class VolumeInfoImpl
extends VolumeInformation
implements StaticAttributeValue,
Enumeration {
    private FSEnvironment environment;
    private String fullNodeName;
    private String nameSpace;
    private String volumeName;
    private CallsService callsService;
    private NetService netService;
    private boolean sessionIsNDS;
    private boolean hasMoreElements = true;

    public VolumeInfoImpl(FSEnvironment fSEnvironment) throws NSIException {
        this.environment = fSEnvironment;
        this.fullNodeName = fSEnvironment.getFullNodeName();
        this.nameSpace = fSEnvironment.getNameSpace();
        this.volumeName = fSEnvironment.getVolumeName();
        try {
            this.callsService = fSEnvironment.getCallsService();
            this.netService = fSEnvironment.getNetService();
            this.sessionIsNDS = fSEnvironment.sessionIsNDS();
            return;
        }
        catch (NamingException namingException) {
            throw new NSIException(String.valueOf(namingException), namingException);
        }
    }

    public boolean hasMoreElements() {
        return this.hasMoreElements;
    }

    public Object nextElement() {
        if (!this.hasMoreElements) {
            throw new NoSuchElementException();
        }
        this.hasMoreElements = false;
        this.refresh();
        return this;
    }

    public Attribute buildAttribute() throws NamingException {
        VolumeInfoImpl volumeInfoImpl = null;
        try {
            volumeInfoImpl = new VolumeInfoImpl(this.environment);
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException(nSIException.getMessage());
            namingException.setRootCause(nSIException);
            throw namingException;
        }
        return new FSAttribute("Volume Information", volumeInfoImpl, new SchemaAttrDef(4, this.environment), new SchemaSyntaxDef(4, this.environment));
    }

    public void addAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void deleteAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public String getID() {
        return "Volume Information";
    }

    public boolean compare(SearchStringComponent searchStringComponent) throws NamingException {
        try {
            return this.equals(searchStringComponent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
            invalidSearchFilterException.setRootCause(illegalArgumentException);
            throw invalidSearchFilterException;
        }
    }

    public boolean equals(SearchStringComponent searchStringComponent) {
        if (searchStringComponent == null) {
            return false;
        }
        int n = searchStringComponent.getOperationType();
        if (n == 4) {
            return true;
        }
        if (n != 0 && n != 5) {
            return false;
        }
        VolumeInformation volumeInformation = null;
        String string = null;
        boolean bl = true;
        if (searchStringComponent.operandReplacement()) {
            volumeInformation = (VolumeInformation)searchStringComponent.getReplacementObject();
            if (volumeInformation == null) {
                throw new IllegalArgumentException(searchStringComponent.getOperation());
            }
            VolumeInformation volumeInformation2 = volumeInformation;
            synchronized (volumeInformation2) {
                string = volumeInformation.getVolName();
            }
            bl = false;
        } else {
            string = searchStringComponent.getOperand();
        }
        this.refresh();
        if (n == 0) {
            if (bl) {
                return string.equals(this.getVolName());
            }
            try {
                VolumeInformation volumeInformation3 = volumeInformation;
                synchronized (volumeInformation3) {
                    boolean bl2 = volumeInformation.equals(this);
                    Object var8_9 = null;
                    return bl2;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (n == 5) {
            return SearchStringComponent.compareSubString(string, this.getVolName(), true);
        }
        return false;
    }

    public Object getStaticInterface() {
        VolumeInfoImpl volumeInfoImpl = new VolumeInfoImpl(this.environment);
        volumeInfoImpl.refresh();
        return volumeInfoImpl;
    }

    public void refresh() throws NSIException {
        int[] nArray = new int[1];
        try {
            this.callsService.getVolumeNumber(this.volumeName, nArray);
            this.callsService.getVolumeInfoWithNumber(nArray[0], this);
            this.callsService.getExtendedVolumeInfo(nArray[0], this);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        ObjectName objectName = null;
        try {
            objectName = ObjectNameImpl.objectIdToObjectName(this.directoryServicesObjectId, this.callsService, this.netService, this.sessionIsNDS);
            this.setDirectoryServicesName(objectName.getName());
        }
        catch (NSIException nSIException) {
            this.setDirectoryServicesName("");
        }
        DirectorySpaceInformation directorySpaceInformation = new DirectorySpaceInformation();
        try {
            this.callsService.getDirSpaceInfo(nArray[0], null, 0, directorySpaceInformation);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        this.setTotalBlocks(directorySpaceInformation.getTotalBlocks());
        this.setAvailableBlocks(directorySpaceInformation.getAvailableBlocks());
        this.setPurgeableBlocks(directorySpaceInformation.getPurgeableBlocks());
        this.setNotYetPurgeableBlocks(directorySpaceInformation.getNotYetPurgeableBlocks());
        this.setReserved(directorySpaceInformation.getReserved());
        this.setSectorsPerBlock(directorySpaceInformation.getSectorsPerBlock());
    }
}

