/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.file.nw.calls;

import com.novell.service.file.nw.VolumeUtilization;
import com.novell.service.file.nw.calls.BinderyName;
import com.novell.service.file.nw.calls.ObjectName;
import com.novell.service.file.nw.calls.ObjectNameImpl;
import com.novell.service.file.nw.naming.FSAttribute;
import com.novell.service.file.nw.naming.FSEnvironment;
import com.novell.service.file.nw.naming.SchemaAttrDef;
import com.novell.service.file.nw.naming.SchemaSyntaxDef;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;

public class VolumeUtilizationImpl
extends VolumeUtilization
implements StaticAttributeValue {
    private FSEnvironment environment;
    private String fullNodeName;
    private String nameSpace;
    private String volumeName;
    private NetService netService;
    private CallsService callsService;
    private boolean sessionIsNDS;
    private boolean hasMoreElements = true;

    public VolumeUtilizationImpl(FSEnvironment fSEnvironment) throws NSIException {
        this.environment = fSEnvironment;
        this.fullNodeName = fSEnvironment.getFullNodeName();
        this.nameSpace = fSEnvironment.getNameSpace();
        this.volumeName = fSEnvironment.getVolumeName();
        try {
            this.callsService = fSEnvironment.getCallsService();
            this.netService = fSEnvironment.getNetService();
            this.sessionIsNDS = fSEnvironment.sessionIsNDS();
            return;
        }
        catch (NamingException namingException) {
            throw new NSIException(String.valueOf(namingException), namingException);
        }
    }

    public boolean hasMoreElements() {
        return this.hasMoreElements;
    }

    public Object nextElement() {
        return this.next();
    }

    public VolumeUtilization next() {
        if (!this.hasMoreElements) {
            throw new NoSuchElementException();
        }
        this.hasMoreElements = false;
        return this;
    }

    public Attribute buildAttribute() throws NamingException {
        VolumeUtilizationImpl volumeUtilizationImpl = null;
        try {
            volumeUtilizationImpl = new VolumeUtilizationImpl(this.environment);
        }
        catch (NSIException nSIException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(nSIException);
            throw namingException;
        }
        return new FSAttribute("Volume Utilization", volumeUtilizationImpl, new SchemaAttrDef(5, this.environment), new SchemaSyntaxDef(5, this.environment));
    }

    public void addAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void deleteAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public String getID() {
        return "Volume Utilization";
    }

    public boolean compare(SearchStringComponent searchStringComponent) throws NamingException {
        return false;
    }

    public boolean equals(SearchStringComponent searchStringComponent) {
        if (searchStringComponent == null) {
            return false;
        }
        int n = searchStringComponent.getOperationType();
        if (n == 4) {
            return true;
        }
        if (n != 0 && n != 5) {
            return false;
        }
        VolumeUtilization volumeUtilization = null;
        boolean bl = true;
        if (searchStringComponent.operandReplacement()) {
            volumeUtilization = (VolumeUtilization)searchStringComponent.getReplacementObject();
            bl = false;
            if (volumeUtilization == null) {
                throw new IllegalArgumentException(searchStringComponent.getOperation());
            }
        } else {
            volumeUtilization = new VolumeUtilization(searchStringComponent.getOperand());
        }
        VolumeUtilizationImpl volumeUtilizationImpl = null;
        volumeUtilizationImpl = new VolumeUtilizationImpl(this.environment);
        while (volumeUtilizationImpl.hasMoreElements()) {
            VolumeUtilization volumeUtilization2;
            VolumeUtilization volumeUtilization3 = volumeUtilizationImpl.next();
            if (n == 0) {
                if (bl) {
                    volumeUtilization2 = volumeUtilization;
                    synchronized (volumeUtilization2) {
                        if (volumeUtilization3.getName().equalsIgnoreCase(volumeUtilization.getName())) {
                            boolean bl2 = false;
                            Object var9_11 = null;
                            return bl2;
                        }
                    }
                }
                try {
                    volumeUtilization2 = volumeUtilization;
                    synchronized (volumeUtilization2) {
                        if (volumeUtilization3.equals(volumeUtilization)) {
                            boolean bl3 = true;
                            Object var9_12 = null;
                            return bl3;
                        }
                        continue;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (n == 5) {
                volumeUtilization2 = volumeUtilization;
                synchronized (volumeUtilization2) {
                    if (SearchStringComponent.compareSubString(volumeUtilization.getName(), volumeUtilization3.getName(), true)) {
                        boolean bl4 = false;
                        Object var9_13 = null;
                        return bl4;
                    }
                    continue;
                }
            }
            return false;
        }
        return false;
    }

    public Object getStaticInterface() {
        VolumeUtilizationImpl volumeUtilizationImpl = new VolumeUtilizationImpl(this.environment);
        return volumeUtilizationImpl;
    }

    public void setName(String string) {
        ObjectName objectName = null;
        objectName = BinderyName.isNameType(string) ? new BinderyName(string, true) : new ObjectName(string);
        int n = ObjectNameImpl.nameToObjectId(objectName, this.callsService, this.netService, this.sessionIsNDS);
        int[] nArray = new int[1];
        try {
            this.callsService.getVolumeNumber(this.volumeName, nArray);
        }
        catch (SessionException sessionException) {
            throw new NSIException(sessionException.getMessage(), 0, sessionException);
        }
        VolumeUtilizationImpl volumeUtilizationImpl = this;
        synchronized (volumeUtilizationImpl) {
            try {
                this.callsService.getDiskUtilization(n, nArray[0], this);
            }
            catch (SessionException sessionException) {
                throw new NSIException(sessionException.getMessage(), 0, sessionException);
            }
        }
        this.objectIdSet = true;
        super.setName(string);
    }
}

